\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : View conventional, expanded and extended memory
\ CATEGORY    : DOS utilities
\ AUTHOR      : Coos Haak
\ LAST CHANGE : October 27, 1994, Coos Haak
\ ----------------------------------------------------------------------



internal also forth

here  limit  #5000 - dp  !
lhere llimit #5000 - ldp !
        NEEDS -assembler
ldp !
dp !

previous forth

code memsize            ( -- x )        \ Total conventional memory in Kb
                push    bx
                int     $12
                mov     bx, ax
                next
end-code

: emspresent            ( -- flag )     \ Is expanded memory present
        push srcseg                             \ Save register
        s" EMMXXXX0"                            \ Near string
        $67 get-interrupt drop srcseg !
        #10 8                                   \ Far string
        compare                                 \ Equal is zero
        pop srcseg
        0=                                      \ Positive logic
    ;

code emssize            ( -- x1 x2 )    \ x1 is free, x2 is total expanded
                push    bx                      \ In Kb
                mov     ah, # $42
                int     $67
$if386
                shl     bx, # 4
                shl     dx, # 4
$else
                mov     cl, # 4
                shl     bx, cl
                shl     dx, cl
$then
                push    bx
                mov     bx, dx
                next
end-code

code xmspresent         ( -- flag )     \ Is extended memory present
                push    bx
                mov     ax, # $4300
                int     $2F
                xor     bx, bx
                cmp     al, # $80
        0= if
                dec     bx
        then
                next
end-code

code xmssize            ( -- x )        \ x1 is free, x2 is total extended
                push    bx                      \ in Kb's
                push    es
                mov     ax, # $4310
                int     $2F
                mov     ah, # 8
                push    es
                push    bx
                push    bp
                mov     bp, sp
                call    far 2 [bp]
                pop     bp
                add     sp, # 4
                pop     es
                push    ax
                mov     bx, dx
                next
end-code

\ u1 is current value, u2 is maximum value
: bar       ( u1 u2 -- )
        c/l #40 - swap */ dup>r 0
        ?do     '' emit
        loop
        c/l #40 - r>
        ?do     '' emit
        loop
        ;  private

: print         ( d -- )
        5 .r ."  Kb"
        ;

: display
        2dup bar swap print ."  of" print cr
    ;

: go
        memsize local conventional
        ms-dos-io
        ." DOS memory      " cseg 6 rshift conventional display
        ." Expanded memory " emspresent
        if      emssize dup +to conventional dup rot - swap display
        else    ." is not present" cr
        then
        ." Extended memory " xmspresent
        if      xmssize conventional #64 + max dup rot - swap display
        else    ." is not present" cr
        then
    ;


turnkey go see


                            \ (* End of Source *) /
