\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Print in two columns, 88 lines of 160 characters 
\ CATEGORY    : Turnkey programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



?def assembler [if]

code prn?
                push    bx
                xor     dx, dx
                mov     ah, # 2
                int     $17
                xor     bx, bx
                test    ah, # 8
        0<> if
                dec     bx
        then
                next
end-code

[else]

create prn?     prn? body> internal dp ! forth

$53 C, $33 C, $D2 C, $B4 C, $02 C, $CD C, $17 C, $33 C, $DB C, $F6 C, $C4 C,
$08 C, $74 C, $01 C, $4B C, $26 C, $AD C, $FF C, $E0 C,

[then]

: ?prn
        prn? abort" Printer niet gereed"
        ;

#80 constant c/l
#88 constant l/p

variable buffer
variable page

c/l l/p * 2* constant bufsize

: .page
        video page incr page @ .dec printer
        ;

variable linecounter

: clearbuffer
        linecounter off buffer @ bufsize bl fill
        ;

: flushbuffer
        linecounter @
        if      l/p 0
                do      buffer @ c/l 2* i * + c/l 2* -trailing type cr
                loop
                ^L emit
                clearbuffer
        then
        .page
        ;

: processline
        temporary count pad expand c/l min linecounter @ l/p 2* =
        if      flushbuffer
        then
        linecounter @ dup l/p <
        if      2*
        else    l/p - 2* 1+
        then
        c/l * buffer @ + swap cmove
        ;

create initial
        9 c,
        ^[ c, '0' c,                    -- 1/8"
        ^[ c, 'M' c,                    -- elite
        ^O  c,                          -- condensed
        ^[ c, 'C' c, 0 c, #12 c,        -- inches per page

create final
        2 c,
        ^[ c, '@' c,            -- reset

: (llist)
        local len local adr
        ?prn ." Bezig met " adr len type space
        printer initial count type
        clearbuffer page off linecounter off
        adr len r/o open-file throw local handle
        begin   temporary 1+ /line handle read-line throw swap temporary c!
        while   processline linecounter incr
        repeat
        flushbuffer handle close-file throw
        final count type video cr
        ;

: .help
        cr ." Afdrukken van bestanden in twee kolommen." cr
        cr ."      LPRINT <filenaam>.."
        ;

: main
        $80 count set-source
        bl word count 0=
        if      .help exit
        then
        count dup '-' = swap '/' = or
        if      count '?' =
                if       .help exit
                then
        then
        drop >in off here buffer ! bufsize allot cr
        begin   bl word c@
        while   here count (llist)
        repeat
        ;

bufsize reserve

turnkey main lprint
                            \ (* End of Source *) /
