\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Aquarium Simulation, VGA 320x200x256
\ CATEGORY    : Games 
\ AUTHOR      : Kees Moerman in: Vijgeblad 30
\ LAST CHANGE : November 12, 1994, Coos Haak, Loadhigh for Assembler
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -screensv

        NEEDS -loadhigh

        LOADHIGH -assembler

code plot
$if386
                imul#   bx, bx #20
                add     bx, # $A000
                mov     ds, bx
$else
                mov     ax, # #20
                imul    bx
                add     ax, # $A000
                mov     ds, ax
$then
                pop     bx
                pop     ax
                mov     0 [bx], al
                push    cs
                pop     ds
                pop     bx
                next
end-code

mark plot

code get-dot
$if386
                imul#   bx, bx #20
                add     bx, # $A000
                mov     ds, bx
$else
                mov     ax, # #20
                imul    bx
                add     ax, # $A000
                mov     ds, ax
$then
                pop     di
$if386
                imul#   di, di 5
$else
                mov     ax, # 5
                imul    di
                mov     di, ax
$then
                mov     cx, # 5
                xor     bx, bx
        do
                shl     bl, # 1
                test    0 [di], # $FF byte
        0<> if
                inc     bl
        then
                inc     di
        loop
                push    cs
                pop     ds
                next
end-code

#320 5 / 1- constant xmax
#38 constant ymax

cr .( Do you want sound [Y,n] ) key dup emit cr >upc 'N' <> [if]

: squeak
        #50 #50 tone
        ;

: happy
        #5 swap #100 * tone
        ;

: tick
        #2 #8000 tone
        ;

[else]

' noop alias squeak immediate
' drop alias happy
' noop alias tick immediate

[then]

#50 constant maxlen

variable foods  2 foods !

variable stepon 5 stepon !

doer: doshape
        count local color local array local y local x
        y 5 * to y x 5 * to x
        5 0
        do      array c@ 5 0
                do      dup $10 and 0<> color and x i + y plot cells
                loop
                drop 1 +to array 1 +to y
        loop
        ;

: shape:
        create  c, c, c, c, c, c, doshape
    ;

%01110
%10001
%10001
%10001
%01110
#12 shape: kop

%00100
%01010
%10001
%01010
%00100
#15 shape: lijf

%00100
%01110
%11111
%01110
%00100
#9 shape: staart

%00100
%11111
%11011
%11111 dup constant _gray
%00100
#6 shape: gray

%00100
%00100
%01110
%10101 dup constant _food
%00100
#10 shape: food

%11111
%11111
%11111
%00000
%11111
#1 shape: void

: v@
        5 * 1+ get-dot
        ;

: food?
        v@ _food =
        ;

: food|gray?
        v@ dup _food = swap _gray = or
        ;

: empty?
        v@ 0=
        ;

variable init?

: initialize
        init? on
        ;

: array
        create  1+ cells ,
        does>   init? @
                if      init? off here over @ allot swap ! exit
                then
                @ []cell
        ;

maxlen array fish0      variable len0
maxlen array fish1      variable len1
maxlen array fish2      variable len2
maxlen array fish3      variable len3
maxlen array fish4      variable len4
maxlen array fish5      variable len5
maxlen array fish6      variable len6
maxlen array fish7      variable len7

variable thefish

: >fish
        thefish !
        ;

: fish
        thefish @
        exec: fish0 fish1 fish2 fish3 fish4 fish5 fish6 fish7
        ;

: len
        thefish @
        exec: len0  len1  len2  len3  len4  len5  len6  len7 
        ;

: fish@[]
        fish @ split
        ;

: fish![]
        >r join r> fish !
        ;

: fish@
        0 fish@[]
        ;

: fish!
        len @ 1- fish@[] void len @ 4 >
        if      len @ 3 / dup fish@[] lijf 2* fish@[] staart
        then
        2dup kop 0 fish dup 2 + maxlen 1- cells cmove> 0 fish![]
        ;

: fish+!
        len @ maxlen 2 - =
        if      fish! $10 choose 2 + happy exit
        then
        tick
        2dup kop len @ 4 >
        if      len @ 3 / dup fish@[] lijf 2* fish@[] staart
        then
        0 fish dup 2 + maxlen 1- cells cmove> 0 fish![] len incr
        ;

: fish-!
        len @ 1 >
        if      len decr len @ 1 =
                if      squeak
                then
                len @ fish@[] void
        then
        ;

: newfood
        xmax 1+ choose local x:
        ymax 2/ choose 5 / 5 * local y:
        begin   x:      y: 1+   food|gray?
                x: 1-   y:      food|gray?      or
                x: 1+   y:      food|gray?      or
                x:      y:      empty?          and
                y:      ymax =                  or
                1 +to y:
        until
        x: y: 1- food
        ;

: x++
        swap 1+ xmax min swap
        ;

: x--
        swap 1- 0 max swap
        ;

: y++
        1+ ymax min
        ;

: y--
        1- 0 max
        ;

: ?step
        2dup empty?
        if      fish! true
        else    2drop false
        then
        ;

: step?
        >r fish@ r> 3 and
        case
                0 of x-- endof
                1 of y-- endof
                2 of x++ endof
                3 of y++ endof
        endcase
        ?step
        ;

: stepon?
        fish@ 2dup 1 fish@[] rot - 2 + -rot - 2 + 2 lshift or
        case
                %1011 of y-- endof
                %1110 of x++ endof
                %1001 of y++ endof
                %0110 of x-- endof
        endcase
        ?step
        ;

: eat?
        >r fish@ r> 3 and
        case
                0 of x-- endof
                1 of y-- endof
                2 of x++ endof
                3 of y++ endof
        endcase
        2dup food?
        if      fish+! true
        else    2drop false
        then
        ;

: step
        #10 ms
        false 4 choose 7 0
        do      dup eat?
                if      nip true swap leave
                then
                1+
        loop
        drop
        if      exit
        then
        stepon @ choose
        if      stepon?
                if      exit
                then
        then
        false 4 choose 7 0
        do      dup step?
                if      nip true swap leave
                then
                1+
        loop
        drop 0=
        if      fish-!
        then
        ;

: graphics                                      \ 320 x 200 x 256
        $13 setmode
        ;

: init
        initialize fish0 initialize fish1 initialize fish2 initialize fish3
        initialize fish4 initialize fish5 initialize fish6 initialize fish7
        graphics $100 0
        do      newfood
        loop
        xmax 1+ 0
        do      ymax 1+ ymax 9 -
                do      j i food?
                        if      j i gray
                        then
                loop
        loop
        xmax 1+ 0
        do      i ymax 1+ gray
        loop
        $40 0
        do      newfood
        loop
        8 0
        do      i >fish len off
                1 xmax 2/ + 1 fish+!
                1 xmax 2/ + 0 fish+!
        loop
        ;

: go
        0
        begin   1+ dup 3 and 4 + >fish step
                4 choose >fish step
                foods @ choose 0=
                if      newfood
                then
                dup $3FF and 0=
                if      6 choose 1+ foods !
                then
                dup $70 and 0=
                        if      5 choose 0=
                                if      fish-!
                        then
                then
                key?
        until
        drop
        ;

create at'      2 cells allot

: exit>
        ;

: main
        save-screen ?at at' 2!
        init go
        text restore-screen at' 2@ at-xy
        ;

dispose

turnkey main aquavga
                            \ (* End of Source *) /
