\ -----------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Tracing the stack 
\ CATEGORY    : Programmer's utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : March 15, 1994, Coos Haak. Separate listsegment 
\ LAST CHANGE : February 26, 1994, Coos Haak 
\ -----------------------------------------



        ?DEF -stacktrc [IF] -stacktrc [THEN]

        MARKER -stacktrc


internal

privates

$1000 segment mrkseg    private

( Sets pointers to name. Found by scanning down in the listspace.)
: mark
        mrkseg 2@ swap 0 fillp voc-link
        begin   dup voc@
                begin   dup
                while   dup head> >call [ ' quit >call ] literal =
                        if      dup dup head> >body @ mrkseg @ swap !x
                        then
                        h@
                repeat
                drop @ ?dup 0=
        until
        ;

0 value ptr     private
0 value items   private

: @s        ( offset -- item )
        stkseg @ swap @x
        ;  private

: +s        ( index -- item )
        cells ptr + @s
    ;  private

: .name
        @s dup local s 100 swap
        do      mrkseg @ i @x
                if      s i - #cells 1- 3 .r space
                        mrkseg @ i @x .head
                        #30 htab
                        ." calling " mrkseg @ i @x head> >body @
                        s i - + cell- l@ >head .head
                        unloop exit
                then
                -1 cells
        +loop
        true abort" Niet gevonden"
        ;  private

: .item
        cr 20 spaces count type +s h.
        ;  private

: switch
        0 +s [ ' catch >body @ #13 cells + ] literal =
        if      ."      Catch"
                1 c" Frame " .item
                2 c" LSP   " .item lsp0 2 +s - #cells .
                3 c" SP    " .item sp0  3 +s - #cells 1- .
                4 to items
                exit
        then
        2 +s 2 cells - l@ [ ' do >body @ cell+ l@ ] literal =
        if      ."      Do-Loop"
                0 c" Index " .item space 0 +s 1 +s + h.
                1 c" Limit " .item
                2 c" Loop  " .item
                3 to items
                exit
        then
        2 +s 2 cells - l@ [ ' ?do >body @ cell+ l@ ] literal =
        if      ."      ?Do-Loop"
                0 c" Index " .item space 0 +s 1 +s + h.
                1 c" Limit " .item
                2 c" Loop  " .item
                3 to items
                exit
        then
        0 +s [ ' push-local 3 + c@ ] literal =      \ push byte instruction
        if      ."      Local" exit
        then
[ ?def dlocal ] [if]
        0 +s [ ' push-dlocal 3 + @ ] literal =
        if      ."      DLocal" exit
        then
[then]
        0 +s h. ptr .name
        ;  private

0 value speedy  private

: fast
        true to speedy
        ;

: slow
        clear speedy
        ;

: .rp
        rp0 rp@
        do      cr i h. i to ptr 1 to items switch
                speedy
                if      stop? abort" Interrupted"
                else    key ^[ =
                        if      leave
                        then
                then
        items cells +loop
        cr ." ---"
        ;

deprive

forth

: do-it
        .rp 2 choose throw
        ;

: test
        ['] do-it catch
        if      click
        then
        ;

: do-it2
        local vier local vijf test 2 choose throw
        ;

: test2
        44 local nul 22 33 ['] do-it2 catch
        if      2drop beep
        then
        ;

: veel
        begin   ['] do-it catch
        until
        ;

: lus
        10 0
        do      .rp
        loop
        ;

: first
        .rp
        ;

: second
        first first
        ;

: third
        second second
        ;

: fourth
        third third
        ;

mark

: .help
        CR
        CR ."      .RP   displays an annotated picture of the returnstack."
        CR ."            stackposition, value, offset into word, name, calling"
        CR ."      SLOW  wait every time for a keypress, ESC stops."
        CR ."      FAST  any keypress stops, doesn't wait for it."
        CR ."      MARK  use this after any compile, it updates the information"
        CR ."            for the tracer."
        CR
        ;

.help

                            \ (* End of Source *) /
