\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Spelling checker 
\ CATEGORY    : Miscellaneous
\ AUTHOR      : Lennart Benschop 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


cr
cr .( This file does not work, READP and WRITEP are not defined)
cr .( anymore in this CHForth version!)
cr abort

        MARKER -spelling


base @ hex

create dic$     ", .dic"

1000 segment uitvoer
1000 segment invoer

: merge
        dic$ count bl word append here count w/o bin create-file
        abort" Kan geen samenvoegbestand maken" >r
        dic$ count bl word append here count r/o bin open-file
        abort" Kan eerste leesbestand niet openen" >r
        uitvoer 2@ swap r@ readp abort" Kan eerste bestand niet lezen"
        r> close-file abort" Kan eerste bestand niet sluiten"
        dic$ count bl word append here count r/o bin open-file
        abort" Kan tweede leesbestand niet openen" >r
        invoer 2@ swap r@ readp abort" Kan tweede bestand niet lezen"
        r> close-file abort" Kan tweede bestand niet sluiten"
        0 0
        do      invoer @ i @x uitvoer @ i @x or uitvoer @ i !x 1 cells
        +loop
        uitvoer 2@ swap r@ writep abort" Kan samenvoegbestand niet schrijven"
        r> close-file abort" Kan samenvoegbestand niet sluiten" ;

variable invoer
variable uitvoer

: openfiles
        bl parse-word r/o open-file throw invoer !
        bl parse-word w/o create-file throw uitvoer ! ;

create outbuffer        here /line 1+ dup allot erase

: flush
        outbuffer count uitvoer @ write-file throw outbuffer c0! ;

: putch
        outbuffer c@ /line =
        if      flush
        then
        outbuffer count + c! 1 outbuffer c+! ;

: closefiles
        flush
        uitvoer @ close-file throw
        invoer @ close-file throw ;

: getch
        here 1 invoer @ read-file throw 1 =
        if      here c@
        else    true
        then ;

create wordbuf  here 100 dup allot erase

variable wordlen

: alpha
        >upc 'A' '[' within ;

: copynonword
        begin   getch dup 0< invert over alpha invert and
        while   putch
        repeat ;

: readword
        wordbuf c! wordlen off
        begin   wordlen incr getch dup alpha
        while   wordbuf wordlen @ + c!
        repeat ;

: writeword
        wordbuf wordlen @ bounds
        ?do     i c@ putch
        loop ;

vector checkword

: (processfile)
        begin   copynonword dup 0< invert
        while   readword checkword writeword dup 0< invert
        while   putch
        repeat  then
        drop ;

: processfile
        openfiles (processfile) closefiles ;

: show
        cr wordbuf wordlen @ type
        ;  ' show is checkword

1000 segment dictseg

variable dict?  dict? off

: newdict
        dictseg 2@ swap 0 fillp dict? on ;

: loaddict
        newdict dic$ count bl word append
        here count r/o bin open-file abort" Kan woordenboek niet openen"
        >r dictseg @ 1000 r@ readp abort" Kan woordenboek niet lezen"
        r> close-file abort" Kan woordenboek niet afsluiten" ;

: savedict
        dic$ count bl word append
        here count w/o bin create-file abort" Kan woordenboek niet maken"
        >r dictseg @ 1000 r@ writep abort" Kan woordenboek niet schrijven"
        r> close-file abort" Kan woordenboek niet afsluiten" dict? off ;

create setmask  001 c, 002 c, 004 c, 008 c, 010 c, 020 c, 040 c, 080 c,
create clrmask  0FE c, 0FD c, 0FB c, 0F7 c, 0EF c, 0DF c, 0BF c, 07F c,

: testdict
        setmask + c@ swap dictseg @ swap c@x and ;

: setdict
        setmask + c@ >r dictseg @ swap 2dup c@x r> or -rot c!x ;

: clrdict
        clrmask + c@ >r dictseg @ swap 2dup c@x r> and -rot c!x ;

vector hash

: hash1
        tuck 0 -rot bounds
        do      d2* d2* d2* d2* swap i c@ 1F and xor over >< dup 1F and
                swap 4 rshift 1F and xor xor swap
        loop
        7 and ;

: hash2
        tuck #3333 -rot bounds
        do      i c@ 1F and >< 2/ 2/ 1+ #201 + tuck * >r um* 0 r> d+
                #6001 s>d d+
        loop
        tuck xor swap 7 and ;

: hash3
        2dup hash1 2swap hash2 rot xor swap rot xor swap
        ;  ' hash3 is hash

: addword
        bl parse-word hash setdict ;

: removeword
        bl parse-word hash clrdict ;

: testword
        bl parse-word hash testdict
        if      ." Present"
        else    ." Absent"
        then ;

: showcase
        bl parse-word hash h. h. ;

: spellword
        show
        begin   wordbuf wordlen @ hash testdict 0=
        while   20 htab ." (S)kip (A)dd (C)hange" key >upc
                dup 'A' =
                if      drop wordbuf wordlen @ hash setdict exit
                then
                dup 'C' <>
                if      exit
                then
                drop cr wordbuf 80 accept wordlen !
        repeat
        ;  ' spellword is checkword

: (spell)
        dict? @ invert abort" Eerst NEWDICT of LOADDICT" (processfile) ;

: spell
        openfiles (spell) closefiles ;

create bitcounts        here 100 dup allot erase

: makebitcounts
        100 0
        do      0 i 8 0
                do      dup 1 and
                        if      swap 1+ swap
                        then
                        2/
                loop
                drop bitcounts i + c!
        loop ;

makebitcounts

: countdict
        0 0 0 0
        do      dictseg @ i c@x bitcounts + c@ 0 d+
        loop
        push base decimal d. pop base
        ;

: checkdouble
        wordbuf wordlen @ hash 2dup testdict
        if      cr wordbuf wordlen @ type
        then
        setdict ;

: addnewword
        wordbuf wordlen @ hash 2dup testdict 0=
        if      cr wordbuf wordlen @ bounds
                do      i c@ 20 or emit
                loop
        then
        setdict ;

: spell-all
        bl word count dup 0=
        if      2drop s" *.frt"
        then
        find-first-file
        if      exit
        then
        begin   found-file r/o open-file throw invoer !
                s" nul" w/o create-file throw uitvoer !
                (spell) closefiles find-next-file stop? or
        until ;

base !


                            \ (* End of Source *) /
