\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Speed of variables, values, locals 
\ CATEGORY    : Benchmarks 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------






        NEEDS -dlocals
        NEEDS -double


        MARKER -valtest



decimal

code dovar
                pop     ax
                push    bx
                mov     bx, ax
                inc     bx
                next
end-code  private

code (newlit)
                push    bx
                mov     bx, es: 0 [si]
                inc     si
                inc     si
                next
end-code

: makenewvar
        bl word count head, reveal ['] dovar call, 0 ,
        ;

deprive

: .hz
        ."  Hz "
        ;

: <<
        s" timer-reset 1000.000.000 gettime 1000 0 do 1000 0 do" evaluate
        ;  immediate

: >>
        s" loop loop gettime 2swap d- 1. dmax d/ 7 d.r .hz .ms"
        evaluate
        ;  immediate

variable var
2variable 2var
0 value val
makenewvar nvar

: looptest
        << >>
        ;
cr looptest     .(  Do nothing)

: vartest
        << var @ var ! i var +! >>
        ;
cr vartest      .(  Var @ Var ! i Var +!)

: 2vartest
        << 2var 2@ 2var 2! i dup 2var d+! >>
        ;
cr 2vartest     .(  2Var 2@ 2Var 2! i dup 2Var d+!)

: nvartest
        << nvar @ nvar ! i nvar +! >>
        ;
cr nvartest     .(  Idem, called variable)

: fromvartest
        << from var to var i +to var >>
        ;
cr fromvartest  .(  FROM Var TO Var i +TO Var)

: valtest
        << val to val i +to val >>
        ;
cr valtest      .(  Val TO Val i +TO Val)

: loctest
        0 local loc << loc to loc i +to loc >>
        ;
cr loctest      .(  Loc TO Loc i +TO Loc )

: dloctest
        0. dlocal dloc << dloc to dloc i dup +to dloc >>
        ;
cr dloctest     .(  dLoc TO dLoc i dup +TO dLoc )

create getal    0 ,

: littest
        << (newlit) [ getal l, ] @ (newlit) [ getal l, ] ! i (newlit) [ getal l, ] +! >>
        ;
cr littest      .(  Special literal )

: vartest2
        << ['] var >body @ ['] var >body ! i ['] var >body +! >>
        ;
cr vartest2     .(  ['] Var >body , etc.)

: vartest3
        << [ ' var >body ] literal @
        [ ' var >body ] literal !
        i [ ' var >body ] literal +! >>
        ;
cr vartest3     .(  [ ' Var >body ] LITERAL etc.)

: valtest2
        << adr val @ adr val ! i adr val +! >>
        ;
cr valtest2     .(  ADR Val @ ADR Val ! i ADR Val +!)

                            \ (* End of Source *) /
