\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : The Famous Sieve of Eratosthanes
\ CATEGORY    : Benchmarks
\ AUTHOR      : Marcel Hendrix
\ LAST CHANGE : October 5th, 1991 MHX
\ ----------------------------------------------------------------------



        MARKER -sieve


#100  constant #times   
#8192 constant size     

CREATE flags    size ALLOT

: DO-PRIME      flags size 1 FILL
                0  size 0 DO flags I + 
                             C@ IF I DUP +  3 +  
                                   DUP  I +
                                    BEGIN  DUP size <
                                    WHILE  0 OVER flags + C! 
                                           OVER + 
                                    REPEAT
                                   2DROP 1+  
                             THEN  
                        LOOP ;


: PRIMES        CR #times .DEC ." iterations."  TIMER-RESET
                0 #times 0 DO  
                             DROP  DO-PRIME  
                         LOOP 
                CR .  ." primes found." 
                CR .ELAPSED ;


: .help
                CR ." Sieve"
                CR ."             Compile time   Run time    Primes"
                CR ."   Par.C         38.19       8.732       1899"
                CR ."   Inmos ICC     83.98       9.578       1899"
                CR ."   3L C          45.25       5.955       1899"
                CR ."   tForth (WS)    1.00       8.830       1899" 
                CR ."   tForth (main)  1.00      10.273       1899"
                CR ."   CHForth 16     0.44      55.440       1899"
                CR ."   CHForth 40     0.11      11.153       1899"
                CR ."   iForth         ?.??       3.226       1899"
                CR CR ." Enter PRIMES to run the benchmark." ;

.help

                            \ (* End of Source *) /
