\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Sorting in F4TH 
\ CATEGORY    : Benchmarks 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------





        NEEDS -quicksort


        MARKER -f4thsort



: carray
        create  allot
        does>   +
        ;

1023 constant len
10 constant aantal

len 1+ carray data

variable cpd

: _cpd
        cpd @
        ;  ' _cpd is qs_comparand

: _set
        cpd !
        ;  ' _set is qs_save

: _get
        data c@
        ;  ' _get is qs_get

: _put
        data c!
        ;  ' _put is qs_put

: _cmp
        <
        ;  ' _cmp is qs_compare

: fill_array
        len 1+ 0
        do      random i data c!
        loop
        ;

: show
        cr 0
        do      i data c@ 8 .r
        loop
        ;

: qsort
        2dup >r >r 2r@ + 2/ data c@
        begin   r>
                begin   2dup data c@ swap <
                while   1+
                repeat
                r> swap >r
                begin   2dup data c@ <
                while   1-
                repeat
                r> swap >r >r r@ r' > invert
                if      r@ data c@ r' data c@ r@ data c! r' data c!
                        r> 1+ r> 1- >r >r
                then
                r@ r' >
        until
        drop r> swap rot r> 2dup <
        if      recurse
        then
        2over <
        if      2swap recurse
        then
        2drop
        ;

: test1
        cr ." CHForth QUICK" cr ." Testing overhead " gettime aantal 0
        do      fill_array 0 len 2drop '.' emit
        loop
        gettime 2swap d- cr ." Doing 10 QuickSorts "
        gettime aantal 0
        do      fill_array 0 len quick '.' emit
        loop
        gettime 2swap d- 2swap d- cr aantal um/mod nip
        ." A Quicksort takes " .dec ." milliseconds per iteration."
        ;

: test2
        cr ." F4TH QSORT" cr ." Testing overhead " gettime aantal 0
        do      fill_array 0 len 2drop '.' emit
        loop
        gettime 2swap d- cr ." Doing 10 QuickSorts "
        gettime aantal 0
        do      fill_array 0 len qsort 2drop '.' emit
        loop
        gettime 2swap d- 2swap d- cr aantal um/mod nip
        ." A Quicksort takes " .dec ." milliseconds per iteration."
        ;

: .help
        cr
        cr ."                         TEST1    TEST2"
        cr ."      V30, 8 MHz        3120 ms  1450 ms
        cr ."      386SX, 16 Mhz     1090 ms   630 ms
        cr ."      idem, aligned     1020 ms   630 ms
        cr ."      486DLC, 40 Mhz     208 ms   131 ms
        cr
        cr ."        TEST1 and TEST2 do the test."
        cr
        ;

.help

                            \ (* End of Source *) /
