\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : Meta compiler for CHForth version 1.2.3
\ FILENAME    : STARTUP.FRT
\ DESCRIPTION : The first Meta Forth routines
\ AUTHOR      : Coos Haak, Utrecht
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



\ (C) J.J.Haak 8 augustus 1989,1990,1991,1992,1993,1994

FFFE ORG        \ Top of CSEG, LSEG and HSEG
LABEL 'MEMTOP   \ End of physical memory
LABEL 'LMEMTOP
LABEL 'HMEMTOP

FAFE ORG        \ Top of dictionary, low boundary of FLYER areas
LABEL 'LIMIT    \ End of dictionary for CSEG
LABEL 'LLIMIT   \ End of dictionary for LSEG
LABEL 'HLIMIT   \ End of dictionary for HSEG

100 ORG         \ Start of dictionary

LABEL origin            TH> T.ORIGIN
\ cells en 2cells
LABEL segstart 2 ALLOT
LABEL segsize  2 ALLOT
LABEL fullsize 2 ALLOT
LABEL catcher  2 ALLOT \ Bovenste CATCHniveau
LABEL ^VECT    2 ALLOT
LABEL SYS-DIV  4 ALLOT \ INT 00 Old divide vector
LABEL SYS-OPC  4 ALLOT \ INT 06 Opcode exception
LABEL SYS-BRK  4 ALLOT \ INT 1B Old BIOS break vector
LABEL SYS-CLK  4 ALLOT \ INT 1C Old BIOS clock vector
LABEL SAVE-SP   2 ALLOT \ Tijdens shell
LABEL SEED     2 CELLS ALLOT \ Random
LABEL _csp      1 CELLS ALLOT \ colon definitions
LABEL HLD      2 ALLOT
LABEL ENDHEADS 2 ALLOT
LABEL _crlf     ^M C, ^J C,
LABEL OLDKEY    0 ,
LABEL vpos      0 ,
LABEL prslen    0 ,
LABEL parsed    0 ,
LABEL notport   0 ,     \ is the last number standard?
LABEL flycode   'LIMIT  ,   \ FLYER dictionary pointers
LABEL flylist   'LLIMIT ,
LABEL flyhead   'HLIMIT ,
LABEL lsp       0 ,         \ Local stack pointer

\ bytes
LABEL C.SIZ     UL.C ,
LABEL mode      1 ALLOT \ Current display mode
LABEL CNCH      1 ALLOT \ Console char
LABEL PCHBUF    1 ALLOT \ One character printer buffer
LABEL dftm      1 ALLOT \ The default mode
LABEL SBRK      1 ALLOT \ DOS break flag
LABEL cold      1 ALLOT \ Copy of byte at $80

ALIGN

                0 , 0 ,
ORPHAN DOCOL                    TH> T.DOCOL
                XCHG    SP, BP
                PUSH    SI
                XCHG    SP, BP
                MOV     SI, AX
                MOV     SI, 4 [SI]
LABEL !_doc
                NEXT
                JMP     __brk
                $EVEN
END-CODE

ORPHAN DODOES                   TH> T.DODOES
                ADD     AX, # 4
                XCHG    SP, BP
                PUSH    SI
                XCHG    SP, BP
                POP     SI
                MOV     SI, 1 [SI]
                PUSH    BX
                MOV     BX, AX
LABEL !_doe
                NEXT
                JMP     __brk
END-CODE

INTERNAL:

ALIGN

HERE-H HERE CNHASH !-H

: DOCREATE
        MODIFY T[ HERE-T ,-L 0 , 0 , COMPILE-ONLY
ORPHAN (CREATE)                 TH> T.DOCREATE
                ADD     AX, # 4
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE

: DOVAR
        MODIFY T[ HERE-T ,-L 0 , 0 , COMPILE-ONLY
ORPHAN (VARIABLE)               TH> T.DOVAR
                ADD     AX, # 4
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE

: DOCON
        MODIFY T[ HERE-T ,-L 0 , 0 , COMPILE-ONLY
ORPHAN (CONSTANT)               TH> T.DOCON
                MOV     DI, AX
                PUSH    BX
                MOV     BX, 4 [DI]
                NEXT
END-CODE

: DOVAL
        MODIFY T[ HERE-T ,-L 0 , 0 , COMPILE-ONLY
ORPHAN (VALUE)                  TH> T.DOVAL
                MOV     DI, AX
                PUSH    BX
                MOV     BX, 4 [DI]
                NEXT
END-CODE

: DOVECTOR
        MODIFY T[ HERE-T ,-L 0 , 0 , COMPILE-ONLY
ORPHAN (VECTOR)                 TH> T.DOVECTOR
                MOV     DI, AX
                MOV     AX, 4 [DI]
                JMP     AX
END-CODE

: DOSEG
        MODIFY T[ HERE-T ,-L 0 , 0 , COMPILE-ONLY
ORPHAN (SEGMENT)                TH> T.DOSEG
                ADD     AX, # 4
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE

FORTH:

\G char is the character value for a space.
20 CONSTANT BL          ANS ( -- char )             \ FORTH "b-l"

\G Return a false flag.
FALSE CONSTANT FALSE    ANS ( -- false )            \ FORTH

\G Return a true flag, a single-cell value with all bits set.
TRUE CONSTANT TRUE      ANS ( -- true )             \ FORTH

EXTRA:

\G n is the three decimal digit version number of this CHForth
\G system.
#125 CONSTANT VERSION       ( -- n )                \ EXTRA

INTERNAL:

\ A constant containing the default top of the returnstack.
RPTOP CONSTANT RP0          ( -- x )                \ EXTRA "r-p-zero"

\ A constant containing the default top of the datastack.
SPTOP CONSTANT SP0          ( -- x )                \ EXTRA "s-p-zero"

\ A constant containing the default top of the local stack.
LSTOP CONSTANT LSP0         ( -- x )                \ EXTRA "l-s-p-zero"

\ A constant containing the maximal number of word lists in the
\ search order.
MVOCS CONSTANT #VOCS        ( -- x )                \ EXTRA "number-vocs"

\ A constant.
=ANSI-T CONSTANT =ANSI      ( -- x )                \ EXTRA "equals-ansi"

\ A constant.
=COMP-T CONSTANT =COMP      ( -- x )                \ EXTRA "equals-comp"

\ A constant.
=HIDDEN-T CONSTANT =HIDDEN  ( -- x )                \ EXTRA "equals-hidden"

\ A constant.
=IMMEDIATE-T CONSTANT =IMMEDIATE    ( -- x )        \ EXTRA "equals-immediate"

\ A constant.
=PRIVATE-T CONSTANT =PRIVATE        ( -- x )        \ EXTRA "equals-private"

\ A constant.
=LOCAL-T CONSTANT =LOCAL    ( -- x )                \ EXTRA "equals-local"

EXTRA:

\G n is the maximum number of characters on an input line.
T/LINE CONSTANT /LINE       ( -- n )                \ EXTRA "per-line"

\G x is the segment number of the text screen.
B800 CONSTANT SBASE         ( -- x )                \ EXTRA "s-base"

\G Return the address after the last usable in the dictionary.
'LIMIT VALUE LIMIT          ( -- addr )             \ EXTRA

\G Return the address after the last usable in the list segment.
'LLIMIT VALUE LLIMIT        ( -- l-addr )           \ EXTRA

\G Return the address after the last usable in the head segment.
'HLIMIT VALUE HLIMIT        ( -- h-addr )           \ EXTRA

\G Return the address after the last physical address in memory.
'MEMTOP VALUE MEMTOP        ( -- addr )             \ EXTRA

\G Return the address after the last physical address in the list
\G segment.
'LMEMTOP VALUE LMEMTOP      ( -- addr )             \ EXTRA

\G Return the address after the last physical address in the header
\G segment.
'HMEMTOP VALUE HMEMTOP      ( -- addr )             \ EXTRA

FORTH:

\G a-addr is the address of a cell containing the number of
\G characters in the terminal input buffer.
\G
\G Note: this word is obsolescent and is included as a concession
\G to existing implementations.
VARIABLE #TIB           ANS ( -- a-addr )           \ FORTH "number-t-i-b"
        0 ,                                         \ value of TIB

\G a-addr is the address of a cell containing the offset in
\G characters from the start of the input buffer to the start of
\G the parse area.
VARIABLE >IN            ANS ( -- a-addr )           \ FORTH "to-in"

\G a-addr is the address of a cell containing the current number
\G conversion radix {{2..36}}.
VARIABLE BASE           ANS ( -- a-addr )           \ FORTH

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- a-addr )
\G a-addr is the address of a cell containing the compilation state
\G flag. STATE is true when in compilation state, false otherwise.
\G The true value in STATE is non-zero, but is otherwise
\G implementation-defined. Only the following standard words alter
\G the value in STATE : : (colon), ; (semicolon), ABORT , QUIT ,
\G :NONAME , [ (left-bracket), ] (right-bracket) and ;CODE .
\G
\G Note: A Standard Program may not directly alter the contents of
\G STATE .
\G See also: : :NONAME ; ABORT QUIT [ ]
VARIABLE STATE ANS COMPILE-ONLY                     \ FORTH

INTERNAL:

\ a-addr is the address of a cell.
VARIABLE _DP            ( -- a-addr )           \ EXTRA "underscore-d-p"

\ a-addr is the address of a cell.
VARIABLE _HDP           ( -- a-addr )           \ EXTRA "underscore-h-d-p"

EXTRA:

\G a-addr is the address of a cell containing the dictionary
\G pointer at the last execution of SAVE or EXTEND .
VARIABLE BYTES          ( -- a-addr )           \ EXTRA

\G a-addr is the address of a cell containing the list dictionary
\G pointer at the last execution of SAVE or EXTEND .
VARIABLE LBYTES         ( -- a-addr )           \ EXTRA "l-bytes"

\G a-addr is the address of a cell containing the header
\G dictionary pointer at the last execution SAVE or EXTEND .
VARIABLE HBYTES         ( -- a-addr )           \ EXTRA "h-bytes"

\G a-addr is the address of a cell containing the number of file
\G lines read since loading the configuration file at the start
\G of the program.
VARIABLE LINESREAD      ( -- a-addr )           \ EXTRA

INTERNAL:

\ a-addr is the address of a cell containing the dictionary pointer.
VARIABLE DP             ( -- a-addr )           \ EXTRA "d-p"

\ a-addr is the address of a cell containing the list dictionary pointer.
VARIABLE LDP            ( -- a-addr )           \ EXTRA "l-d-p"

\ a-addr is the address of a cell containing the header dictionary pointer.
VARIABLE HDP            ( -- a-addr )           \ EXTRA "h-d-p"

EXTRA:

\G a-addr is the address of a cell. When the last interpreted number
\G contained a decimal point, it will contain the number of digits
\G after the decimal point in that number; otherwise the contents
\G are -1.
VARIABLE DPL            ( -- a-addr )           \ EXTRA "d-p-l"

\G a-addr is the adress of a cell containing the dictionary pointer
\G since the last SAVE or EXTEND . Forgetting of words created when
\G the dictionary pointer was less than this value is not possible.
VARIABLE FENCE          ( -- a-addr )           \ EXTRA

\G A value containing the file identification fileid of the print
\G file; otherwise zero.
0 VALUE PHANDLE         ( -- fileid )           \ EXTRA "p-handle"

EXTRA:

\G a-addr is the address of a cell containing the segment address of
\G the first string in COMPARE and SEARCH . The user is reponsible
\G to restore the default value ( CSEG ) after using an alternative
\G value in COMPARE and SEARCH .
VARIABLE SRCSEG         ( -- a-addr )           \ EXTRA "source-segment"

\G a-addr is the address of a cell containing false when the case of
\G characters is to be ignored and true when case is significant.
VARIABLE CASESENSITIVE  ( -- a-addr )           \ EXTRA

\G a-addr is the address of a cell containing true when the program
\G will warn the user when redefinitions are encountered and false
\G otherwise.
VARIABLE WARNING        ( -- a-addr )           \ EXTRA

\G a-addr is the address of a cell containing true to display the
\G signon message at startup and false otherwise.
VARIABLE SIGNON         ( -- a-addr )           \ EXTRA
TRUE T' SIGNON !-T

\G a-addr is the address of a cell used to count exceptions when the
\G file ERRORLOG is loaded. RETCODE @ HALT gives a return code that
\G can be handled in DOS with ERRORLEVEL.
VARIABLE RETCODE        ( -- a-addr )           \ EXTRA "return-code"

\G Return the number of characters on a screen line.
0 VALUE C/L             ( -- n )                \ EXTRA "c-per-l"

\G Return the number of lines on the screen.
0 VALUE L/SCR           ( -- n )                \ EXTRA "l-per-s-c-r"

\G a-addr is the address of a cell containing the current attribute
\G of the characters on the screen.
VARIABLE ATTR           ( -- a-addr )           \ EXTRA "attribute"

\G a-addr is the address of a cell containing the default attribute
\G of the characters on the screen.
VARIABLE ATT0           ( -- a-addr )           \ EXTRA "attribute-zero"

\G a-addr is the address of a cell containing the attribute of the
\G characters on the status line.
VARIABLE STATUSATTR     ( -- a-addr )           \ EXTRA "status-attribute"
     12 T' STATUSATTR !-T

\G a-addr is the address of a cell containing the address of the
\G counted string representing the name of the file where an
\G exception occurred.
VARIABLE ERRNAME        ( -- a-addr )           \ EXTRA "error-name"

\G a-addr is the address of a cell containing the line number of the
\G file where an exception occurred.
VARIABLE ERRLINE        ( -- a-addr )           \ EXTRA "error-line"

\G a-addr is the address of a cell containing true when messages
\G will be given if non-standard words are encountered and false
\G otherwise.
VARIABLE ANSI           ( -- a-addr )           \ EXTRA

\G a-addr is the address of a cell containing the processor type,
\G allowed values are 86 and 386.
VARIABLE #CPU           ( -- a-addr )           \ EXTRA "number-c-p-u"
         #CPU @ T' #CPU !-T

INTERNAL:

\ a-addr is the address of a cell.
VARIABLE CHARFLAG       ( -- a-addr )           \ EXTRA "char-flag"

EXTRA:

\G A value that is true when screen output is enabled.
0 VALUE CONSOLE?        ( -- x )                \ EXTRA "console-query"

\G A value that is true when printer output is enabled.
0 VALUE PRINTING?       ( -- x )                \ EXTRA "printing-query"

\G A value that is true when output goes via fast BIOS and not
\G via slow DOS.
0 VALUE BIOS?           ( -- x )                \ EXTRA "bios-query"

\G A value that is true when logging is currently active.
0 VALUE LOGGING?        ( -- x )                \ EXTRA "logging-query"

\G A value that is true when characters are echoed during loading a
\G textfile.
0 VALUE ECHO?           ( -- x )                \ EXTRA "echo-query"

\G A value that is true when the statusline is enabled.
0 VALUE STATUS?         ( -- x )                \ EXTRA "status-query"

\G a-addr is the address of a cell that contains the execution
\G token of the routine that is executed by ACCEPT .
VARIABLE 'ACCEPT        ( -- a-addr )           \ EXTRA

\G a-addr is the address of a cell containing the duration in
\G milliseconds of BEEP.
VARIABLE BEEPL          ( -- a-addr )           \ EXTRA
        #100 T' BEEPL !-T

\G a-addr is the address of a cell containing the frequency in Hertz
\G of BEEP.
VARIABLE BEEPH          ( -- a-addr )           \ EXTRA
        #440 T' BEEPH !-T

-- Pseudo segmenten: niet ingelinkt

INTERNAL:

\ A three cell array. The first cell contains the value of the
\ Forth code and data segment. The second cell contains its size
\ in paragraphs and the third cell is always zero.
LABEL frtseg    0 ,
LABEL frtmax    1000 ,
                0 ,

\ A three cell array. The first cell contains the value of the
\ programs's environment segment. The second cell contains its
\ size in paragraphs and the third cell is always zero.
LABEL envseg    0 ,
LABEL envmax    0 ,
                0 ,

-- Echte segmenten: wel ingelinkt

\ A three cell array. The first cell contains the value of the
\ list segment. The second cell contains its size in paragraphs
\ and the third cell contains the count of paragraphs to save.
LABEL lstseg            2 ALLOT
LABEL lstmax            TH> T.LSTMAX    2 ALLOT
LABEL lstlen            TH> T.LSTLEN    2 ALLOT
LABEL thelst            0 , 0 ,

\ A three cell array. The first cell contains the value of the
\ header segment. The second cell contains its size in
\ paragraphs and the third cell contains the count of paragraphs
\ to save.
LABEL hdrseg            2 ALLOT
LABEL hdrmax            TH> T.HDRMAX    2 ALLOT
LABEL hdrlen            TH> T.HDRLEN    2 ALLOT
LABEL thehdr            thelst , HERE thelst CELL+ !-T 0 ,

\ A three cell array. The first cell contains the value of the
\ stack segment. The second cell contains its size in paragraphs
\ and the third cell always contains zero.
TSEGMENT STKSEG         ( -- a-addr )           \ EXTRA "stack-segment"
LABEL stkseg            2 ALLOT
LABEL stkmax            TH> T.STKMAX    2 ALLOT
                        0 ,
LABEL thestk            thehdr , HERE thehdr CELL+ !-T 0 ,

LABEL ^SEGS             thestk , thelst CELL+ ,

FORTH:

\G Receive one character char, a member of the implementation
\G defined character set. Keyboard events that do not correspond to
\G such characters are discarded until a valid character is
\G received, and those events are subsequently unavailabele.
\G
\G All standard characters can be received. Characters received by
\G KEY are not displayed.
\G
\G Standard programs that require the ability to receive control
\G characters have an environmental dependency.
\G See also: EKEY KEY?
VECTOR KEY          ANS ( -- char )             \ FORTH

\G If x is a graphic character in the implementation-defined
\G character set, display x. The effect of EMIT for all other values
\G of x is implementation-defined.
\G
\G Standard programs that use control characters to perform specific
\G functions have an environmental dependency. Each EMIT deals with
\G one character.
\G See also: TYPE
VECTOR EMIT         ANS ( x -- )                \ FORTH

INTERNAL:

\ A type of EMIT used during logging.
VECTOR LOG-EMIT         ( char -- )             \ EXTRA

\ Display the statusline.
VECTOR STATUS           ( -- )                  \ EXTRA

EXTRA:

\G Restart the system. This is always done when a program starts
\G executing from DOS when it was saved by SAVE . The first time it
\G will process the command tail. Otherwise QUIT is performed.
VECTOR COLD             ( -- )                  \ EXTRA

\G Display some information over the compiled bytes since processing
\G the command tail.
VECTOR DIAGNOSE         ( -- )                  \ EXTRA

INTERNAL:

\ A word used in FORGET .
VECTOR DOFORGET         ( -- )                  \ EXTRA

EXTRA:

\G A word that is executed at the start of the program before
\G executing COLD .
VECTOR START            ( -- )                  \ EXTRA

\G A word that is executed when the program is terminated.
VECTOR ATEXIT           ( -- )                  \ EXTRA

\G A word that normally executes $INTERPRET .
VECTOR 'INTERPRET       ( c-addr u -- )         \ EXTRA "tick-interpret"

\G A word that normally executes $COMPILE .
VECTOR 'COMPILE         ( c-addr u -- )         \ EXTRA "tick-compile"

\G A word that normally executes (NUMBER?) .
VECTOR NUMBER?  ( c-addr u -- 0 | n 1 | d 2 )   \ EXTRA "number-question"

\G A word that displays the prompt.
VECTOR PROMPT           ( -- )                  \ EXTRA

\G Make an alarm sound on the speaker. As this is sometimes
\G irritating, try CLICK .
VECTOR BEEP             ( -- )                  \ EXTRA

\G A word that normally contains NOOP . Used in EKEY only.
VECTOR PAUSE            ( -- )                  \ EXTRA

INTERNAL:

\ A word that handles words that can not be found during
\ compilation. x is the exception number.
VECTOR ?CRASH           ( x -- )                \ EXTRA

\ A word used to log exceptions in a file.
VECTOR LOG-ERROR        ( -- )                  \ EXTRA

\ A word executed at the end of accept to toggle the logfile
VECTOR LOG-TOGGLE       ( -- )                  \ INTERNAL

FORTH:

\G Identifies the source of the non-block input stream (i.e., when
\G BLK is zero) as follows:
\G
\G            SOURCE-ID       Input stream source
\G            -----------     -------------------
\G               0            Keyboard
\G              -1            String (via EVALUATE )
\G            fileid          Text file "fileid"
\G
\G An ambiguous condition exists if SOURCE-ID is used when BLK
\G contains a non-zero value.
0 VALUE SOURCE-ID   ANS ( -- x )                \ FORTH

EXTRA:

\G A value that links all word lists and vocabularies.
0 VALUE VOC-LINK        ( -- x )                \ EXTRA

INTERNAL:

\ A value that links all messages.
0 VALUE MESS-LINK       ( -- x )                \ EXTRA

\ A value that is true when the last word has a header.
0 VALUE HEAD?           ( -- x )                \ EXTRA "head-question"

\ A value that contains the flags of the last found word.
0 VALUE HEADFLAGS       ( -- x )                \ EXTRA

\ A value containing the count of locals in the current
\ definitions.
0 VALUE LOCALS          ( -- x )                \ EXTRA

\ A value containing the vocabulary stack pointer.
0 VALUE VSP             ( -- x )                \ EXTRA

EXTRA:

\G A value that is true when HEADER wants the name on the stack.
\G Normally false as HEADER wants the name in the inputstream.
0 VALUE POSTFIX         ( -- x )                \ EXTRA

\G A value that is true when the display is in textmode.
TRUE VALUE TEXT?        ( -- x )                \ EXTRA "text-query"

\G A value that contains the number of characters printed on the
\G current screen line.
0 VALUE OUT             ( -- x )                \ EXTRA

\G A value that prohibits restarting of the initialisation of a
\G program. When the program is started its value is false. When
\G Ctrl-Break is pressed, it is set to true.
0 VALUE RESTART?        ( -- x )                \ EXTRA

\G Return the address of the count of the last exception string.
0 VALUE ERR$            ( -- c-addr )           \ EXTRA "error-string"

\G Return the number of the last exception.
0 VALUE ERR#            ( -- x )                \ EXTRA "error-number"

\G a-addr the the address of a double cell used by TIMER-RESET to
\G store the current value of the timer.
CREATE TIMESAVE         ( -- a-addr )           \ EXTRA
                4 CELLS ALLOT

INTERNAL:

\ An array containing the search order
CREATE CONTEXT          ( -- a-addr )           \ EXTRA
        MVOCS CELLS ALLOT
LABEL current
                0 ,

EXTRA:

\G a-addr is the address of a double cell containing the last
\G dictionary entry address and its word list identification.
CREATE LAST             ( -- a-addr )           \ EXTRA
                0 , 0 ,

\G c-addr is the address of a counted string containing the name of
\G the configuration file.
CREATE CFG              ( -- c-addr )           \ EXTRA "c-f-g"
                S" chforth.cfg" DUP C, S,-T     0 ,

\G c-addr is the address of a counted string containing the default
\G extension of Forth text files.
CREATE FEXT$            ( -- c-addr )           \ EXTRA "f-ext-string"
                S" .frt"        DUP C, S,-T     0 C,

\G c-addr is the address of a counted string containing the default
\G extension of Forth help files.
CREATE HEXT$            ( -- c-addr )           \ EXTRA "h-ext-string"
                S" .hlp"        DUP C, S,-T     0 C,

\G c-addr is the address of a counted string containing the path and
\G name of the command interpreter of DOS.
CREATE COMSPEC          ( -- c-addr )           \ EXTRA
        40 ALLOT

HERE-T ^MMESS @ ,-T ^MMESS !
0 ,-T
(DATE) S" (C) Coos Haak, Utrecht. "
PAD PACK APPEND '.' PAD APPEND-CHAR
PAD COUNT DUP C,-T S,-T ALIGN-T

\G c-addr is the address of a counted string containing the name of
\G the current file.
CREATE THEFILE          ( -- c-addr )           \ EXTRA
        40 ALLOT

\G c-addr is the address of a counted string containing the name of
\G the current DOS directory.
CREATE CURRENT-DIRECTORY        ( -- c-addr )   \ EXTRA
        40 ALLOT

LABEL dta       02B ALLOT

LABEL filename  80 ALLOT

ORPHAN ((BYE))
                STI
                MOV     DL, SBRK []
                MOV     AX, # 3301
                INT     21
                IN      AL, # 61
                AND     AL, # 0FC
                OUT     #, 61 AL
                LDS     DX, SYS-DIV             \ divide trap
                MOV     AX, # 2500
                INT     21
                LDS     DX, CS: SYS-OPC         \ opcode trap
                MOV     AL, # 6
                INT     21
                LDS     DX, CS: SYS-BRK         \ BIOS break
                MOV     AL, # 1B
                INT     21
                LDS     DX, CS: SYS-CLK         \ system clock
                MOV     AL, # 1C
                INT     21
                MOV     AL, CS: T' RETCODE []
                MOV     AH, # 4C
                INT     21
END-CODE

\G Jump back the debugger program, use it when you want to step
\G through Forth.
CODE TRAP               ( -- )                  \ EXTRA
                INT     3
                NEXT
END-CODE

FORTH:

\G Interpretation:
\G Does nothing.
\G
\G Execution: ( -- ) ( R: nest-sys -- )
\G Return control to the calling definition specified by nest-sys.
\G Before executing EXIT within do-loops, the loop-control
\G parameters for each loop shall be discarded.
\G See also: UNLOOP
CODE EXIT                                       \ FORTH
                CLD
END-CODE  ANS

INTERNAL:

TH> T.EXIT

\G ( -- ) ( R: nest-sys -- )
\G End the current definition, an alias for EXIT compiled by ; .
CODE (EXIT)                                     \ EXTRA "paren-exit"
                XCHG    SP, BP
                POP     SI
                XCHG    SP, BP
                NEXT
END-CODE

FORTH:

                            \ (* End of Source *) /
