\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : LOGIC.FRT 
\ DESCRIPTION : Logic routines 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



\G flag is true if and only if n is less than zero.
CODE 0<                 ( n -- flag )           \ FORTH "zero-less"
                ADD     BX, BX
                SBB     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if x is not equal to zero.
CODE 0<>                ( x -- flag )           \ FORTH "zero-not-equals"
                NEG     BX
                SBB     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if x is equal to zero.
CODE 0=                 ( x -- flag )           \ FORTH "zero-equals"
                SUB     BX, # 1
                SBB     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if n is greater than zero.
CODE 0>                 ( n -- flag )           \ FORTH "zero-greater"
                AND     BX, BX
                JG      _tru
                XOR     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if n1 is less than n2.
\G See also: U<
CODE <                  ( n1 n2 -- flag )       \ FORTH "less-than"
                POP     AX
                CMP     AX, BX
                JL      _tru
                XOR     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if x1 is not bit-for-bit the same as x2.
CODE <>                 ( x1 x2 -- flag )       \ FORTH "not-equals"
                POP     AX
                SUB     BX, AX
                JNZ     _tru
                NEXT
END-CODE  ANS

\G flag is true if and only if x1 is bit-for-bit the same as x2.
CODE =                  ( x1 x2 -- flag )       \ FORTH "equals"
                POP     AX
                SUB     BX, AX
                SUB     BX, # 1
                SBB     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if n1 is greater than n2.
\G See also: U>
CODE >                  ( n1 n2 -- flag )       \ FORTH "greater-than"
                POP     AX
                CMP     AX, BX
                JG      _tru
                XOR     BX, BX
                NEXT
LABEL _tru
                MOV     BX, # TRUE
                NEXT
END-CODE  ANS

\G flag is true if and only if u1 is less than u2.
\G See also: <
CODE U<                 ( u1 u2 -- flag )       \ FORTH "u-less-than"
                POP     AX
                SUB     AX, BX
                SBB     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if u1 is greater than u2.
\G See also: >
CODE U>                 ( u1 u2 -- flag )       \ FORTH "u-greater-than"
                POP     AX
                SUB     BX, AX
                SBB     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if d is less than zero.
CODE D0<                ( d -- flag )           \ FORTH "d-zero-less"
                POP     AX
                ADD     BX, BX
                SBB     BX, BX
                NEXT
END-CODE  ANS

\G flag is true if and only if xd is equal to zero.
CODE D0=                ( xd -- flag )          \ FORTH "d-zero-equals"
                POP     AX
                OR      AX, BX
        0= IF
                MOV     BX, # TRUE
        ELSE
                XOR     BX, BX
        THEN
                NEXT
END-CODE  ANS

\G flag is true if and only if ud1 is less than ud2.
CODE DU<                ( ud1 ud2 -- flag )     \ FORTH "d-u-less"
                POP     AX
                POP     DX
                POP     CX
                SUB     CX, AX
                SBB     DX, BX
                SBB     BX, BX
                NEXT
END-CODE  ANS

EXTRA:

\G flag is true if and only if ud1 is greater than ud2.
CODE DU>                ( ud1 ud2 -- flag )     \ EXTRA "d-u-greater"
                POP     AX
                POP     DX
                POP     CX
                SUB     AX, CX
                SBB     BX, DX
                SBB     BX, BX
                NEXT
END-CODE

FORTH:

\G flag is true if and only if d1 is less than d2.
CODE D<                 ( d1 d2 -- flag )       \ FORTH "d-less-than"
                POP     AX
                POP     DX
                POP     CX
                SUB     CX, AX
                SBB     DX, BX
        < IF
                MOV     BX, # TRUE
        ELSE
                XOR     BX, BX
        THEN
                NEXT
END-CODE  ANS

\G flag is true if and only if xd1 is equal to xd2.
CODE D=                 ( xd1 xd2 -- flag )     \ FORTH "d-equals"
                POP     AX
                POP     DX
                POP     CX
                SUB     CX, AX
                SBB     DX, BX
                XOR     BX, BX
                OR      CX, DX
        0= IF
                DEC     BX
        THEN
                NEXT
END-CODE  ANS

EXTRA:

\G flag is true if and only if d1 is greater than d2.
: D>            ( d1 d2 -- flag )               \ EXTRA "d-greater-than"
        2SWAP D<
        ;

FORTH:

\G d3 is the greater of d1 and d2.
: DMAX          ( d1 d2 -- d3 )                 \ FORTH "d-max"
        2OVER 2OVER D<
        IF      2NIP
        ELSE    2DROP
        THEN
        ;  ANS

\G d3 is the lesser of d1 and d2.
: DMIN          ( d1 d2 -- d3 )                 \ FORTH "d-min"
        2OVER 2OVER D>
        IF      2NIP
        ELSE    2DROP
        THEN
        ;  ANS

\G Invert all bits of x1, giving its logical inverse x2.
\G See also: 0= NEGATE
CODE INVERT             ( x1 -- x2 )            \ FORTH
                NOT     BX
                NEXT
END-CODE  ANS

\G x3 is the bit-by-bit logical "and" of x1 with x2.
CODE AND                ( x1 x2 -- x3 )         \ FORTH
                POP     AX
                AND     BX, AX
                NEXT
END-CODE  ANS

\G x3 is the bit-by-bit logical inclusive-or of x1 with x2.
CODE OR                 ( x1 x2 -- x3 )         \ FORTH
                POP     AX
                OR      BX, AX
                NEXT
END-CODE  ANS

\G x3 is the bit-by-bit logical exclusive-or of x1 with x2.
CODE XOR                ( x1 x2 -- x3 )         \ FORTH "x-or"
                POP     AX
                XOR     BX, AX
                NEXT
END-CODE  ANS

\G n3 is the greater if n1 and n2
CODE MAX                ( n1 n2 -- n3 )         \ FORTH
                POP     AX
                CMP     AX, BX
        > IF
                MOV     BX, AX
        THEN
                NEXT
END-CODE  ANS

\G n3 is the lesser if n1 and n2
CODE MIN                ( n1 n2 -- n3 )         \ FORTH
                POP     AX
                CMP     AX, BX
        < IF
                MOV     BX, AX
        THEN
                NEXT
END-CODE  ANS

EXTRA:

\G u3 is the greater if u1 and u2
CODE UMAX               ( u1 u2 -- u3 )         \ EXTRA "u-max"
                POP     AX
                CMP     AX, BX
        U> IF
                MOV     BX, AX
        THEN
                NEXT
END-CODE

\G u3 is the lesser if u1 and u2
CODE UMIN               ( u1 u2 -- u3 )         \ EXTRA "u-min"
                POP     AX
                CMP     AX, BX
        U< IF
                MOV     BX, AX
        THEN
                NEXT
END-CODE

FORTH:

\G Perform a logical left shift of u bit-places on x1, giving x2.
\G Put zero in the least significant bits vacated by the shift.
CODE LSHIFT             ( x1 u -- x2 )          \ FORTH "l-shift"
                MOV     CX, BX
                POP     BX
        CNZ IF
                SHL     BX, CL
        THEN
                NEXT
END-CODE  ANS

\G Perform a logical right shift of u bit-places on x1, giving x2.
\G Put zero in the most significant bits vacated by the shift.
CODE RSHIFT             ( x1 u -- x2 )          \ FORTH "r-shift"
                MOV     CX, BX
                POP     BX
        CNZ IF
                SHR     BX, CL
        THEN
                NEXT
END-CODE  ANS

EXTRA:

\G Exchange the high and low bytes of x1 giving x2.
HEADER FLIP             ( x1 -- x2 )            \ EXTRA

\G See: FLIP
CODE ><                 ( x1 -- x2 )            \ EXTRA "flip"
                XCHG    BH, BL
                NEXT
END-CODE

\G char1 is the low byte of x and char2 is the high byte of x.
CODE SPLIT              ( x -- char1 char2 )    \ EXTRA
$IF386
                MOVZX   AX, BL
                MOVZX   BX, BH
$ELSE
                MOV     AL, BL
                XOR     AH, AH
                MOV     BL, BH
                XOR     BH, BH
$THEN
                PUSH    AX
                NEXT
END-CODE

\G char1 is the low byte of x and char2 is the high byte of x.
CODE JOIN               ( char1 char2 -- x )    \ EXTRA
                POP     AX
                MOV     BH, BL
                MOV     BL, AL
                NEXT
END-CODE

FORTH:

\G Perform a comparison of a test value n1|u1 with a lower limit
\G n2|u2 and an upper limit n3|u3, returning true if either
\G (n2|u2<n3|u3 and (n2|u2<=n1|u1 and n1|u1<n3|u3)) or (n2|u2>n3|u3
\G and (n2|u2<=n1|u1 or n1|u1<n3|u3)) are true, returning false
\G otherwise. An ambiguous condition exists if n1|u1, n2|u2, and
\G n3|u3 are not all the same type.
CODE WITHIN             ( n1|u1 n2|u2 n3|u3 -- flag )   \ FORTH
                POP     DX
                POP     AX
                SUB     BX, DX
                SUB     AX, DX
                SUB     AX, BX
                SBB     BX, BX
                NEXT
END-CODE  ANS

                            \ (* End of Source *) /
