\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : DOS.FRT
\ DESCRIPTION : Interfacing with MS-DOS, reading and writing files 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



EXTRA:

ALIGN
:ORPHAN (NAME)  ( c-addr1 u1 -- c-addr2 )               \ make ASCIIZ name
        (LIT) filename DUP 40 ERASE PACK 1+
        ;

\G Write char to the standard output file.
CODE CONSOLE!           ( char -- )                     \ EXTRA "console-store"
                MOV     DX, BX
                MOV     AH, # 6
                INT     21
                POP     BX
                NEXT
END-CODE

\G Set the current drive to n1. n2 is the the total number of
\G available drives.
CODE SETDISK            ( n1 -- n2 )                    \ EXTRA
                MOV     DL, BL
                MOV     AH, # E
        AHEAD
END-CODE

\G n is the current drive number.
CODE GETDISK            ( -- n )                        \ EXTRA
                PUSH    BX
                MOV     AH, # 19
        THEN
                INT     21
                CBW
                MOV     BX, AX
                NEXT
END-CODE

\ set disk transfer area
ORPHAN SET-DTA          ( x-addr -- )
                MOV     DX, BX
                MOV     AH, # 1A
        AHEAD
END-CODE

\G Set interrupt vector n to extended address x-addr.
CODE SET-INTERRUPT      ( x-addr n -- )                 \ EXTRA
                MOV     AL, BL
                POP     DX
                MOV     AH, # 25
        THEN
                POP     DS
                INT     21
                PUSH    CS
                POP     DS
                POP     BX
                NEXT
END-CODE

ORPHAN GET-DTA          ( -- x-addr )                   \ get full DTA
                PUSH    BX
                MOV     AH, # 2F
        AHEAD
END-CODE

\G Return the extended address x-addr of the interrupt vector n.
CODE GET-INTERRUPT      ( n -- x-addr )                 \ EXTRA
                MOV     AL, BL
                MOV     AH, # 35
        THEN
                MOV     CX, ES
                INT     21
                PUSH    ES
                MOV     ES, CX
                NEXT
END-CODE

ORPHAN SETDIR           ( c-addr -- ior )
                MOV     DX, BX
                MOV     AH, # 3B
                INT     21
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

\G Set the current directory to the string specified by c-addr u. As
\G an extension to DOS, the default drive can also be changed if a
\G drive letter and a colon are present at the beginning of the
\G string. If no exception occurs, ior is zero. Otherwise ior is the
\G I/O result code.
: SET-DIRECTORY         ( c-addr u -- ior )             \ EXTRA
        OVER CHAR+ C@ ':' =                             \ another drive?
        IF      OVER C@ >UPC 'A' - SETDISK DROP         \ select it
                2 /STRING                               \ skip drive now
        THEN
        DUP
        IF      (NAME) SETDIR                           \ rest of path
        ELSE    2DROP FALSE                             \ no path: ok
        THEN
        ;

ORPHAN FCREATE          ( fid -- ior )
$IF386
                MOVZX   CX, BL
$ELSE
                MOV     CL, BL
                XOR     CH, CH
$THEN
                MOV     AH, # 3C
        AHEAD
END-CODE

ORPHAN FOPEN            ( c-addr fam -- fid ior )
                MOV     AL, BL
                MOV     AH, # 3D
        THEN
                POP     DX
                INT     21
                PUSH    AX
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

ORPHAN FCLOSE           ( fid -- ior )
                MOV     AH, # 3E
                INT     21
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

\G Read u1 consecutive characters to extended address x-addr from
\G the file specified by fileid. If no exception occurs, u2 is the
\G number of characters read and ior is zero. Otherwise u2 is
\G unspecified and ior is the I/O result code.
CODE READX-FILE         ( x-addr u1 fileid -- u2 ior )  \ EXTRA "read-x-file"
                MOV     AH, # 3F
                POP     CX
                POP     DX
                POP     DS
                INT     21
                PUSH    AX
                PUSH    CS
                POP     DS
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

\G Write u characters from extended address x-addr to the file
\G specified by fileid. If no exception occurs, ior is zero.
\G Otherwise ior is the I/O result code.
CODE WRITEX-FILE        ( x-addr u fileid -- ior )      \ EXTRA "write-x-file"
                POP     CX
                POP     DX
                POP     DS
                MOV     AH, # 40
                INT     21
        U>= IF
                SUB     AX, CX
                SBB     BX, BX
        ELSE
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                PUSH    CS
                POP     DS
                NEXT
END-CODE

INTERNAL:

CODE WRITEP             ( seg u fileid -- ior )         \ INTERNAL
                MOV     AH, # 40
                POP     CX
                POP     DI
        BEGIN
                CMP     CX, # 800
        U>= WHILE
                PUSH    AX
                PUSH    CX
                MOV     CX, # 8000
                XOR     DX, DX
                MOV     DS, DI
                INT     21
                POP     CX
                POP     AX
                JB      0 $
                ADD     DI, # 800
                SUB     CX, # 800
        REPEAT
$IF386
                SHL     CX, # 4
$ELSE
                ADD     CX, CX
                ADD     CX, CX
                ADD     CX, CX
                ADD     CX, CX
$THEN
                XOR     DX, DX
                MOV     DS, DI
                INT     21
        0 $:    MOV     CX, CS
                MOV     DS, CX
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT    END-CODE

EXTRA:

\G Read character char from the standard input file. If the end of
\G the file is reached, return -1.
CODE CONSOLE@           ( -- char | -1 )                \ EXTRA "console-fetch"
                PUSH    BX
                XOR     BX, BX
                MOV     CX, # 1
                MOV     DX, # CNCH
                MOV     AH, # 3F
                INT     21
                JAE     1 $
        0 $:    MOV     BX, # TRUE
                NEXT
        1 $:    TEST    AX, AX
                JZ      0 $
$IF386
                MOVZX   BX, CNCH
$ELSE
                MOV     BL, CNCH []
                XOR     BH, BH
$THEN
                NEXT
END-CODE

ORPHAN FDEL             ( c-addr -- ior )
                MOV     DX, BX
                MOV     AH, # 41
                INT     21
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

ORPHAN MOVE-FILE-POINTER
                POP     AX
                POP     CX
                POP     DX
                MOV     AH, # 42
                INT     21
                PUSH    AX
                PUSH    DX
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

ORPHAN FEXIST
                MOV     DX, BX
                MOV     AX, # 4300
                INT     21
                PUSH    CX
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

ORPHAN GETDIR           ( c-addr -- ior )
                MOV     CX, SI
                MOV     SI, BX
                XOR     DL, DL
                MOV     AH, # 47
                INT     21
                MOV     SI, CX
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

\G Get the current directory as a character string specified by
\G c-addr u. The path is preceded by the drive letter and a colon.
\G If no exception occurs, ior is zero. Otherwise c-addr and u are
\G unspecified and ior is the I/O result code.
: GET-DIRECTORY         ( -- c-addr u ior )             \ EXTRA
        S" A:\" (NAME)                                  \ prepare path
        GETDISK 'A' + OVER C!                           \ current drive
        DUP 3 + GETDIR                                  \ get directory
        SWAP                                            \ save ior
        DUP                                             \ duplicate address
        BEGIN   DUP C@                                  \ scan for NULL
        WHILE   1+
        REPEAT
        OVER -                                          \ now a string
        ROT                                             \ get ior
        ;

\G Allocate u1 paragraphs of memory outside the data space. The
\G initial content of the allocated space is undefined. If no
\G exception occurs u2 is the starting segment address of the
\G allocated space and ior is zero. Otherwise u2 is unspecified and
\G ior is the I/O result code.
CODE ALLOC              ( u1 -- u2 ior )                \ EXTRA
                MOV     AH, # 48                        \ x is segments
                INT     21                              \ addr is segment
                PUSH    AX
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

\G Return the contiguous region of memory outside the data space
\G indicated by the segment address u to the system for later
\G allocation. u shall indicate a region of memory outside the data
\G space that was previously obtained by ALLOC or REALLOC . If no
\G exception occurs ior is zero. Othewise ior is the I/O result
\G code.
CODE DEALLOC            ( u -- ior )                    \ EXTRA
                MOV     DX, ES                          \ addr is segment
                MOV     ES, BX
                MOV     AH, # 49
        AHEAD
END-CODE

\G Change the allocation of the contiguous region of memory outside
\G the data space starting at the segment address u1, previously
\G allocated by ALLOC or REALLOC , to u2 paragraphs. u2 may be
\G either larger or smaller than the current size of the region. The
\G starting segment address u1 is not changed. If no exception
\G occurs, ior is zero. Otherwise ior is the I/O result code.
CODE REALLOC            ( u1 u2 -- ior )                \ EXTRA
                MOV     DX, ES                          \ u is segments
                MOV     ES, BX                          \ addr is segment
                POP     BX
                MOV     AH, # 4A
        THEN
                INT     21
                MOV     ES, DX
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

ORPHAN FFIRST
                MOV     CX, BX
                POP     DX
                MOV     AH, # 4E
                INT     21
        AHEAD
END-CODE

ORPHAN FNEXT
                MOV     DX, BX
                POP     DS
                MOV     AH, # 4F
                INT     21
                PUSH    CS
                POP     DS
        THEN
                XOR     BX, BX
                TEST    AL, AL
        0<> IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

\G A value containing the attribute of files to find with
\G FIND-FIRST-FILE . It is reset to zero after execution of
\G FIND-FIRST-FILE .
0 VALUE FIND-ATTRIBUTE  ( -- x )                        \ EXTRA

\G Return the file attribute of the last file found.
: FOUND-ATTRIBUTE       ( -- char )                     \ EXTRA
        (LIT) T[ dta 15 + ,-L T] C@                     \ of the last file
        ;  

\G Find the first file name matching the string specified by c-addr
\G u. Reset the value in FILE-ATTRIBUTE to zero. The name of the
\G file will be returned by FOUND-FILE . If no exception occurs, ior
\G is zero. Otherwise ior is the I/O result code.
: FIND-FIRST-FILE       ( c-addr u -- ior )             \ EXTRA
        CSEG (LIT) dta SET-DTA                  \ set disk transfer area
        (NAME) FIND-ATTRIBUTE FFIRST            \ find first matching file
        CLEAR FIND-ATTRIBUTE                    \ reset every time
        ;

\G Find the next file name matching the string given to
\G FIND-FIRST-FILE . The name of the file will be returned by
\G FOUND-FILE . If no exception occurs, ior is zero. Otherwise ior
\G is the I/O result code.
: FIND-NEXT-FILE        ( -- ior )                      \ EXTRA
        GET-DTA FNEXT ;

\G c-addr u specifies a character string containing the file name
\G found by the last execution of FIND-FIRST-FILE or FIND-NEXT-FILE .
: FOUND-FILE            ( -- c-addr u )                 \ EXTRA
        (LIT) T[ dta 1E + ,-L T] DUP
        BEGIN   DUP C@
        WHILE   1+
        REPEAT
        OVER -
        ;

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compiling: ( -- )
\G Append the execution semantics below to the current definition.
\G
\G Executing: ( c-addr a-addr -- )
\G Load and execute the file with name specified as a zero
\G terminated string at c-addr and a parameter block at a-addr.
CODE EXEC                                               \ EXTRA
                MOV     CX, ES
                PUSH    CS
                POP     ES
                POP     DX
                PUSH    CX
                PUSH    BP
                PUSH    SI
                MOV     SAVE-SP SP
                MOV     AX, # 4B00
                INT     21
                CLI
                MOV     SP, CS: SAVE-SP
                MOV     SS, CS: stkseg
                STI
                POP     SI
                POP     BP
                POP     ES
                PUSH    CS
                POP     DS
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

\G Return the time n1 and date n2 of creation of the file identified
\G by fileid. If no exception occurs, ior is zero. Othewise n1 and
\G n2 are unspecified and ior is the I/O result code.
CODE GET-FILE-TIME      ( fileid -- n1 n2 ior )         \ EXTRA
                MOV     AX, # 5700
                INT     21
                PUSH    CX
                PUSH    DX
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

\G Set the time n1 and date n2 of creation of the file identified by
\G fileid. If no exception occurs, ior is zero. Otherwise ior is the
\G I/O result code.
CODE SET-FILE-TIME      ( n1 n2 fileid -- ior )         \ EXTRA
                POP     DX
                POP     CX
                MOV     AX, # 5701
                INT     21
                SBB     BX, BX
        U< IF
                MOV     BL, AL
                MOV     BH, # FE
        THEN
                NEXT
END-CODE

\G Search the DOS environment strings for the string specified by
\G c-addr1 u1. Return the character string after the first string as
\G a character string specified by c-addr2 u2. If the string is not
\G found, u2 is zero and c-addr2 is unspecified.
: SEARCH-ENVIRONMENT    ( c-addr1 u1 -- c-addr2 u2 )    \ EXTRA
        LOCAL Len LOCAL Addr                    \ look in environment strings
        TEMPORARY C0!                           \ create a zero-length string
        PUSH SRCSEG                             \ save
        ESEG SRCSEG !                           \ store segment
        0 ELEN PARAGRAPHS Addr Len SEARCH       \ look for the string
        POP SRCSEG                              \ restore
        IF      NIP                             \ keep only length
                ELEN PARAGRAPHS                 \ get length in bytes
                SWAP - Len +                    \ skip found string
                ESEG SWAP                       \ make extended address
                BEGIN   COUNTX ?DUP             \ not a null character
                WHILE   TEMPORARY APPEND-CHAR   \ store it and increment
                REPEAT
        THEN
        2DROP                                   \ address and length
        TEMPORARY COUNT                         \ this is the copied string
        ;

LABEL (my-name) 0 , 1 ,                 \ MS-DOS 3.2, 5.0 and 6.0 do this

\G Display the full path and name of the Forth program.
: .ME           ( -- )                  \ EXTRA "dot-me"
        CR (LIT) (my-name) 4 SEARCH-ENVIRONMENT TYPE
        ;

ORPHAN FRENAME
                MOV     DI, BX                          \ new name
                POP     DX                              \ old name
                PUSH    ES                              \ save LSTSEG
                PUSH    CS                              \ copy CS
                POP     ES                              \ into ES
                MOV     AH, # 56
                INT     21
                POP     ES                              \ restore LSEG
                SBB     BX, BX                          \ clear or set BX
        U< IF
                MOV     BL, AL                          \ copy error number
                MOV     BH, # FE                        \ make throw flag
        THEN
                NEXT
END-CODE

\G Turn the speaker on.
: SOUND         ( -- )                                  \ EXTRA
        61 PC@ 3 OR 61 PC!
        ;

\G Turn the speaker off.
: NOSOUND       ( -- )                                  \ EXTRA
        61 PC@ 0FC AND 61 PC!
        ;

\G Set the frequency of the speaker to n.
: PITCH         ( n -- )                                \ EXTRA
        B6 43 PC!                                       \ prepare timer
        3540 12 ROT UM/MOD NIP SPLIT                    \ -- lo hi
        SWAP 42 PC! 42 PC!                              \ set timer
        ;

\G Make a sound for the duration of n1 milliseconds with a
\G frequency of n2.
: TONE          ( n1 n2 -- )                            \ EXTRA
        PITCH                                           \ SET FREQUENCY
        SOUND                                           \ TONE ON
        MS                                              \ WAIT A TIME
        NOSOUND                                         \ TONE OFF
        ;

INTERNAL:

: STDBEEP       ( -- )                                  \ standard beep
        BEEPL @ BEEPH @ TONE
        ;

EXTRA:

\G Make a more pleasant sort of BEEP.
: CLICK         ( -- )                                  \ EXTRA
        BEEPL @ 2 RSHIFT BEEPH @ 2 LSHIFT TONE
        ;

FORTH:

                            \ (* End of Source *) /
