\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : Meta compiler for CHForth version 1.1.0
\ FILENAME    : COMPILER.FRT
\ DESCRIPTION : Compiler routines
\ AUTHOR      : Coos Haak, Utrecht
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



INTERNAL:

ALIGN
TH> T.(S")
: (S")          ( -- c-addr u )
        INLINE# COUNT
        ;  COMPILE-ONLY

: (C")          ( -- c-addr )
        INLINE#
        ;  COMPILE-ONLY

TH> T.(.")
: (.")          ( -- )
        INLINE$ TYPESTRING
        ;  COMPILE-ONLY

: (ABORT")      ( x -- )
        INLINE# SWAP
        IF      TO ERR$ -2 THROW
        THEN
        DROP
        ;  COMPILE-ONLY

TH> T.POSTPONE
: (POSTPONE)    ( -- )
        INLINE# COMPILE,
        ;  COMPILE-ONLY

FORTH:

\G addr is the data-space pointer.
CODE HERE               ( -- addr )             \ FORTH
                PUSH    BX
                MOV     BX, T' DP
                NEXT
END-CODE  ANS

EXTRA:

\G l-addr is the list-space pointer.
CODE LHERE              ( -- l-addr )           \ EXTRA "l-here"
                PUSH    BX
                MOV     BX, T' LDP
                NEXT
END-CODE

\G h-addr is the header-space pointer.
CODE HHERE              ( -- h-addr )           \ EXTRA "h-here"
                PUSH    BX
                MOV     BX, T' HDP
                NEXT
END-CODE

FORTH:

\G Reserve n address units of data space.
\G
\G If the data space pointer is aligned and n is a multiple of the
\G size of a cell when ALLOT begins execution, it will remain
\G aligned when ALLOT finishes execution.
CODE ALLOT              ( n -- )                \ FORTH
                ADD     T' DP BX
                POP     BX
                NEXT
END-CODE  ANS

EXTRA:

ORPHAN LALLOT           ( x -- )
                ADD     T' LDP BX
                POP     BX
                NEXT
END-CODE

ORPHAN HALLOT           ( x -- )
                ADD     T' HDP BX
                POP     BX
                NEXT
END-CODE

FORTH:

\G Reserve one cell of data space and store x in the cell. If the
\G data space pointer is aligned when , begins execution, it will
\G remain aligned when , finishes execution.
CODE ,                  ( x -- )                \ FORTH "comma"
                MOV     DI, T' DP
                MOV     0 [DI], BX
                INC     DI
                INC     DI
                MOV     T' DP DI
                POP     BX
                NEXT
END-CODE  ANS

\G Reserve space for one character in the data space and store char
\G in the space.
CODE C,                 ( char -- )             \ FORTH "c-comma"
                MOV     DI, T' DP
                MOV     0 [DI], BL
                INC     DI
                MOV     T' DP DI
                POP     BX
                NEXT
                $EVEN
END-CODE  ANS

EXTRA:

\G Reserve one cell of list space and store x in the cell.
: L,            ( x -- )                        \ EXTRA "l-comma"
        LHERE 1 CELLS LALLOT L!
        ;

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Execution: ( xt -- )
\G Append the execution semantics of the definition represented by
\G xt to the execution semantics of the current word definition.
: COMPILE,                                      \ FORTH "compile-comma"
        L,
        ;  ANS  COMPILE-ONLY

EXTRA:

\G Reserve one cell of header space and store x in the cell.
: H,            ( x -- )                        \ EXTRA "h-comma"
        HHERE 1 CELLS HALLOT H!
        ;

\G Reserve space for one character in the list space and store
\G char in the space.
: LC,           ( char -- )                     \ EXTRA "l-c-comma"
        LHERE 1 LALLOT LC!
        ;

\G Reserve space for two cells in the data space and store x2 in
\G the first cell and x1 in the second.
: 2,            ( x1 x2 -- )                    \ EXTRA "two-comma"
        , ,
        ;

\G Compile an assembler language call in the dictionary at the
\G data-space pointer to the address on the stack and increment the
\G data-space pointer to an aligned address after the instruction.
: CALL,         ( a-addr -- )                   \ EXTRA "call-comma"
        E8 C, HERE CELL+ - , ALIGN
        ;

\G Compile an assembler language jump in the dictionary at the
\G data-space pointer to the address on the stack and increment the
\G data-space pointer to an aligned address after the instruction.
: JUMP,         ( addr -- )                     \ EXTRA "jump-comma"
        E9 C, HERE CELL+ - , ALIGN
        ;

FORTH:

\G If the address of the next available data space location is not
\G aligned, reserve enough space to align it.
: ALIGN         ( -- )                          \ FORTH
        HERE 1 AND
        IF      $FC C,
        THEN
        ;  ANS

INTERNAL:

: >MARK         ( x -- addr x )
        LHERE 0 L,                                      \ mark branch
        SWAP                                            \ control number on top
        ;  COMPILE-ONLY

: >RESOLVE      ( addr x1 x2 -- )
        ?PAIRS                                          \ check control number
        LHERE SWAP L!                                   \ resolve branch
        ;  COMPILE-ONLY

: <MARK         ( x -- addr x )
        LHERE                                           \ mark branch
        SWAP                                            \ control number on top
        ;  COMPILE-ONLY

: <RESOLVE      ( addr x1 x2 -- )
        ?PAIRS                                          \ check control number
        L,                                              \ resolve branch
        ;  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( -- )
\G Append the execution semantics of the current definition to the
\G current definition. The same description is valid if RECURSE is
\G used in a definition after DOES> .
\G See also: DOES>
: RECURSE                                       \ FORTH
        LAST @ HEAD> COMPILE,           \ compile current definition's xt
        ;  IMMEDIATE  COMPILE-ONLY  ANS

EXTRA:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G **** ( Dit woord kan waarschijnlijk in MISCUTIL staan )
\G Compilation: ( -- )
\G Makes the current definition available to the system. Normally
\G this happens automatically when executing ; . When the current
\G word is available to the system a reference to its name
\G produces a recursive call to the definition. If RECURSIVE is
\G not executed a reference to that name will result in calling a
\G previous definition with the same name, if one exists.
: RECURSIVE     ( -- )                          \ EXTRA
        REVEAL                                  \ now recursion is possible
        ;  IMMEDIATE  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the compilation semantics of name to the current
\G definition. Exception -13 occurs if name is not found.
\G
\G **** Dit ontbreekt bij 8051
\G Execution: ( -- )
\G Perform the compilation semantics of name.
: POSTPONE                                              \ FORTH
        BL WORD FIND DUP 0= #-13 ?ERROR 0<
        IF      POSTPONE (POSTPONE)
        THEN
        COMPILE,
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G **** Dit is iets anders in dpANS 6
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G If name has compilation semantics specified, append them to the
\G current definition; otherwise append the execution semantics of
\G name. Exception -13 occurs if name is not found.
: [COMPILE]                                 \ FORTH "bracket-compile"
        ' COMPILE,
        ;  IMMEDIATE  COMPILE-ONLY  ANS

INTERNAL:

TH> T.MODIFY
: MODIFY        ( -- )
        HERE R> L@ @+ LAST @ HEAD>FORGET H!
        CELL+ LAST @ HEAD> DP ! JUMP, DP !
        ;  COMPILE-ONLY

EXTRA:

\G ( "name" -- ) ( C: -- colon-sys )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the run-time symantics defined
\G below. Enter compilation state, and start current definition.
\G
\G Run-time: ( -- ) ( R: nest-sys1 -- )
\G Replace the execution semantics of the most recent definition,
\G referred to as name, with the name execution semantics given
\G below. Return control to the calling definition specified by
\G nest-sys1. Code may be damaged if the most recently defined word
\G was not defined with CREATE or a user-defined word that calls
\G CREATE .
\G
\G Initiation: ( i*x -- i*x a-addr )  ( R: -- nest-sys2 )
\G Save implementation-dependant information nest-sys2 about the
\G calling definition. Place name's data field address on the stack.
\G the stack effects i*x represents the arguments to name.
\G
\G name Execution: ( i*x -- j*x )
\G Execute the portion of the definition that begins with the
\G initiation semantics appended by the DOES> which modifies name.
\G The stack effects i*x and j*x represent arguments to and results
\G from name, respectively.
\G See also: CREATE  DOES>
: DOER:                                         \ EXTRA
        : DOES> COMPILE-ONLY
        ;

FORTH:

\G ( C: -- colon-sys ) ( S: -- xt )
\G Create an execution token xt, enter compilation state and start
\G the current definition, producing colon-sys. Append the execution
\G semantics below to the current definition.
\G
\G The execution semantics of xt will be determined by the words
\G compiled into the body of the definition. The definition can be
\G executed later by xt EXECUTE .
\G colon-sys is the topmost item on the data stack.
\G
\G Initiation: ( i*x -- i*x ) ( R: -- nest-sys )
\G Save nest-sys (a single cell address) of the calling definition.
\G The stack effects i*x represent arguments to xt.
\G
\G xt Execution: ( i*x -- j*x )
\G Execute the definition specified by xt. The stack effects i*x and
\G j*x represent arguments to and results from xt, respectively.
\G
\G **** Nodig?
\G See also: : DOES> ; ;CODE ] [
: :NONAME                                       \ FORTH "colon-no-name"
        ALIGN HERE (LIT) DOCOL JUMP, LHERE , !CSP ]
        CLEAR HEAD?                             \ signal for ';' and IMMEDIATE
        ;  ANS

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. If the data-space pointer is not aligned, reserve enough
\G data space to align it. The new data-space pointer defines name's
\G data field. CREATE does not allocate data space in name's data
\G field.
\G
\G name Execution: ( -- a-addr )
\G a-addr is the address of name's data field. The execution
\G semantics of name may be extended by using DOES> or ;CODE .
\G See also: DOES>
: CREATE        ( "name" -- )                   \ FORTH
        HEADER REVEAL 0 JUMP, DOCREATE
        ;  ANS

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. Reserve one cell of data space at an aligned address. name
\G is referred to as a "variable."
\G
\G name Execution: ( -- a-addr )
\G a-addr is the address of the reserved cell. A program is
\G responsible for initializing the contents of the reserved cell.
: VARIABLE      ( "name" -- )                   \ FORTH
        CREATE  1 CELLS ALLOT DOVAR
        ;  ANS

INTERNAL:

DOERCODE DO2VAR (DO2VAR)
                ADD     AX, # 4
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE

FORTH:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. Reserve two consecutive cells in data space at an aligned
\G address. name is referred to as a "two-variable."
\G
\G name Execution: ( -- a-addr )
\G a-addr is the address of the first (lowest address) cell of
\G two consecutive reserved cells in data space. A program is
\G responsible for initializing the contents of the reserved cells.
\G See also: VARIABLE
: 2VARIABLE     ( "name" -- )                   \ FORTH "two-variable"
        CREATE  2 CELLS ALLOT DO2VAR
        ;
        ANS

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a defimition for name with the execution semantics defined
\G below with an initial value equal to x. name is referred to as a
\G "value".
\G
\G name Execution: ( -- x )
\G Place x on the stack. The value of x is that given when name was
\G is created, until the phrase x TO name is executed, causing a new
\G value of x to be associated with name.
\G See also +TO ADR CLEAR POP PUSH
: VALUE         ( x "name" -- )                 \ FORTH
        CREATE  , DOVAL
        ;  ANS

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. name is referred to as a "constant."
\G
\G name Execution: ( -- x )
\G Place x on the stack.
: CONSTANT      ( x "name" -- )                 \ FORTH
        CREATE  , DOCON
        ;
        ANS

INTERNAL:

DOERCODE DO2CON (DO2CON)
                MOV     DI, AX
                PUSH    BX
                PUSH    6 [DI]
                MOV     BX, 4 [DI]
                NEXT
END-CODE

FORTH:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. name is referred to as a "two-constant."
\G
\G name Execution: ( -- x1 x2 )
\G Place cell pair x1 x2 on the stack.
: 2CONSTANT     ( x1 x2 "name" -- )             \ FORTH "two-constant"
        CREATE  2, DO2CON
        ;
        ANS

EXTRA:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. name is referred to as a "vector".
\G
\G name Execution: ( i*x -- j*x )
\G Execute the execution token stored in the entry. The execution
\G token can be manipulated by IS . Exception -525 occurs if no
\G execution token is assigned to name.
\G See also CHAIN POP PUSH
: VECTOR        ( "name" -- )                   \ EXTRA
        CREATE  (LIT) UNRES , HERE (LIT) ^VECT DUP @ , !
        DOVECTOR
        ;

INTERNAL:

: F:SEG         ( addr -- )             \ forget routine for SEGMENT
        @+ DEALLOC THROW 2 CELLS + @ DUP (LIT) ^SEGS ! CELL+ OFF
        ;  COMPILE-ONLY

PTR F:SEG T.DOSEG 2 CELLS - !-T

EXTRA:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. Leave the dictionary pointer at an aligned address.
\G Allocate space for 3 cells. Ask DOS for an allocation of x
\G paragraphs and store the segment number of that allocation in the
\G first cell. Store x in the second cell and zero in the third. The
\G user may change the value of the third cell to a value less than
\G or equal to x in order to save the allocated area with the
\G program.
\G
\G name Execution: ( -- a-addr )
\G a-addr is the address of the first reserved cell of name.
: SEGMENT       ( x "name" -- )                 \ EXTRA
        DUP ALLOC THROW
        CREATE  2, 0 ,
                HERE (LIT) ^SEGS DUP @ DUP>R , HERE 0 , R> CELL+ ! !
        DOSEG
        ;

INTERNAL:

: F:VOC         ( addr -- )             \ forget routine for VOCABULARY
        @ TO VOC-LINK -2 SET-ORDER DEFINITIONS
        ;  COMPILE-ONLY

DOER: DOVOC (DOVOC)
        SET-CONTEXT
        ;

PTR F:VOC T' DOVOC CELL+ !-T

DOC:

0 TARGET VOC!

: GET
        POSTPONE (GET) L,
        ;

TARGET VOC@ T' DOVOC 2 CELLS + !-T

0 TARGET VOC!

EXTRA:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. Create a new word list and store the word list identifier
\G with the definition for name. name is referred to as a
\G "vocabulary".
\G
\G name Execution: ( -- )
\G Make the above created word list the current word list.
: VOCABULARY    ( "name" -- )                   \ EXTRA
        CREATE  HERE VOC-LINK , TO VOC-LINK
                0 ,
        DOVOC
        ;

\G Fetch the dictionary entry address dea of the last definition
\G from the word list described by the word list identifier wid.
: VOC@          ( wid -- dea )                  \ EXTRA
        CELL+ @
        ;

\G Store the dictionary entry address dea in the word list described
\G by the word list identifier wid.
: VOC!          ( dea wid -- )                  \ FORTH
        CELL+ !
        ;

FORTH:

\G **** Wat wordt er bedoeld met dynamisch ?
\G Creates a new empty word list, returning its word list identifier
\G wid. The new word list is dynamically allocated in data space.
\G Note that other ANS systems may create the new word list in
\G another place.
: WORDLIST      ( -- wid )                      \ FORTH
        PUSH POSTFIX TRUE TO POSTFIX
        S" " VOCABULARY HIDDEN
        POP POSTFIX
        VOC-LINK
        ;  ANS

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name called a "colon definition". Enter
\G compilation state and start the current definition, producing
\G colon-sys. Append the execution semantics given below to the
\G current definition.
\G
\G The execution semantics of name will be determined by the words
\G compiled into the body of the definition. The current definition
\G definition for name is not findable in the dictionary until it is
\G ended. If the contents of the variable POSTFIX is true, name is
\G not parsed from the input buffer but it is taken from the
\G c-addr/u combination on the stack. Note that this is not an ANSI
\G required feature and is thus not portable.
\G
\G Initiation: ( i*x -- i*x ) ( R: -- nest-sys )
\G Save nest-sys (a single-cell address) of the calling definition.
\G The stack effects i*x represent arguments to name.
\G
\G name Execution: ( i*x -- j*x )
\G Execute the definition name. The stack effects i*x and j*x
\G represent arguments to and results from name, respectively.
\G See also: DOER: DOES> [ ] ;CODE
: :             ( C: "name" -- colon-sys )      \ FORTH "colon"
        HEADER 0 JUMP, LHERE , !CSP ]
        MODIFY  T[ DOCOL CELL- CELL- ,-L
        ANS

INTERNAL:

: F::           ( addr -- )             \ forget routine for :
        @ TO LDP                        \ Reset list dictionary pointer
        ;  COMPILE-ONLY

PTR F:: DOCOL 2 CELLS - !-T

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: -- orig )
\G Put the location of a new unresolved forward reference orig onto
\G the control flow stack. Append the execution semantics given
\G below to the current definition. The semantics are incomplete
\G until orig is resolved, e.g., by THEN or ELSE .
\G
\G Execution: ( x -- )
\G If all bits of x are zero, continue execution at the location
\G specified by the resolution of orig.
\G See also: ELSE THEN
: IF                                                    \ FORTH
        POSTPONE (IF) 1 >MARK
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: orig1 -- orig2 )
\G Put the location of a new unresolved forward reference orig2 onto
\G the control flow stack. Append the execution semantics given
\G below to the current definition. The semantics will be incomplete
\G until orig2 is resolved (e.g. by THEN ). Resolve the forward
\G reference orig1 using the location following the appended
\G execution semantics.
\G
\G Execution: ( -- )
\G Continue execution at the location given by the resolution of
\G orig2.
\G See also: IF THEN
: ELSE                                                  \ FORTH
        POSTPONE (ELSE) 1 >MARK 1 CS-ROLL 1 >RESOLVE
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: orig -- )
\G Resolve the forward reference orig using the location of the
\G execution semantics.
\G
\G Execution: ( -- )
\G Continue execution.
\G See also: ELSE IF
CODE THEN                                               \ FORTH
END-CODE  IMMEDIATE  COMPILE-ONLY  ANS

EXTRA:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: orig -- )
\G Resolve the forward reference orig using the location of the
\G execution semantics.
\G
\G Execution: ( -- )
\G Continue execution.
\G See also: ELSE IF THEN
: ENDIF         ( orig -- )                             \ EXTRA
        POSTPONE (THEN) 1 >RESOLVE
        ;  IMMEDIATE  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: -- orig )
\G Put the location of a new unresolved forward reference orig onto
\G the control flow stack. Append the execution semantics given
\G below to the current definition. The semantics are incomplete
\G until orig is resolved (e.g., by THEN ).
\G
\G Execution: ( -- )
\G Continue execution at the location specified by the resolution of
\G orig.
: AHEAD                                                 \ FORTH
        POSTPONE (AHEAD) 1 >MARK
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: -- dest )
\G Put the next location for a transfer of control, dest, onto the
\G control flow stack.
\G
\G Execution: ( -- )
\G Continue execution.
\G See also: REPEAT UNTIL WHILE
: BEGIN                                                 \ FORTH
        POSTPONE (BEGIN) 2 <MARK
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: dest -- )
\G Append the execution semantics given below to the current
\G definition, resolving the backward reference dest.
\G
\G Execution: ( -- )
\G Continue execution at the location specified by dest. If no other
\G control flow words are used, any program code after AGAIN will
\G not be executed.
\G See also: BEGIN
: AGAIN                                                 \ FORTH
        POSTPONE (AGAIN) 2 <RESOLVE
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: dest -- )
\G Append the execution semantics given below to the current
\G definition, resolving the backward reference dest.
\G
\G Execution: ( x -- )
\G If all bits of x are zero, continue execution at the location
\G specified by dest.
\G See also: BEGIN
: UNTIL                                                 \ FORTH
        POSTPONE (UNTIL) 2 <RESOLVE
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: dest -- orig dest )
\G Put the location of a new unresolved forward reference orig onto
\G the control flow stack, under the existing dest. Append the
\G execution semantics given below to the current definition. The
\G semantics are incomplete until orig and dest are resolved (e.g.,
\G by REPEAT ).
\G
\G Execution: ( x -- )
\G If all bits of x are zero, continue execution at the location
\G specified by the resolution of orig.
: WHILE                                                 \ FORTH
        POSTPONE (WHILE) 1 >MARK 1 CS-ROLL
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: orig dest -- )
\G Append the execution semantics given below to the current
\G definition, resolving the backward reference dest. Resolve the
\G forward reference orig using the location following the appended
\G execution semantics.
\G
\G Execution: ( -- )
\G Continue execution at the location given by dest.
\G See also: BEGIN WHILE
: REPEAT                                                \ FORTH
        POSTPONE (REPEAT) 2 <RESOLVE 1 >RESOLVE
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: -- case-sys )
\G Mark the start of the CASE ... OF ... ENDOF ... ENDCASE
\G structure.
\G
\G Execution: ( -- )
\G Continue execution.
\G See also: ENDCASE ENDOF OF
: CASE                                                  \ FORTH
        POSTPONE (CASE) 3 DUP
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: -- of-sys )
\G Put of-sys on the compilation stack. Append the execution
\G semantics given below to the current definition. The semantics
\G are incomplete uitil resolved by a consumer of of-sys such as
\G ENDOF .
\G
\G Execution: ( x1 x2 -- | x1 )
\G If the two values on the stack are not equal, discard the top
\G value and continue execution at the location specified by the
\G consumer of of-sys (e.g., following the next ENDOF ). Otherwise,
\G discard both values and continue execution in line.
\G See also: CASE ENDCASE ENDOF
: OF                                                \ FORTH
        POSTPONE (OF) 1 >MARK
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: case-sys1 of-sys -- case-sys2 )
\G Mark the end of the ... OF ... ENDOF ... part of the CASE
\G structure. The next location for a transfer of control resolves
\G the reference given by of-sys. Append the execution semantics
\G given below to the current definition. Replace case-sys1 with
\G case-sys2 on the control flow stack, to be resolved by ENDCASE .
\G
\G Execution: ( -- )
\G Continue execution at the location specified by the consumer of
\G case-sys2.
\G See also: CASE ENDCASE OF
: ENDOF                                                 \ FORTH
        POSTPONE (ENDOF) 1 >MARK 1 CS-ROLL 1 >RESOLVE
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: case-sys -- )
\G Mark the end of the CASE ... OF ... ENDOF ... ENDCASE structure.
\G Use case-sys to resolve the entire structure. Append the
\G execution semantics given below to the current definition.
\G
\G Execution: ( x -- )
\G Discard the case selector x and continue execution.
\G See also: CASE ENDOF OF
: ENDCASE                                               \ FORTH
        POSTPONE (ENDCASE)
        BEGIN   DUP 3 <>
        WHILE   1 >RESOLVE
        REPEAT
        AND 3 ?PAIRS
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: -- do-sys )
\G Place do-sys on the control flow stack. Append the execution
\G semantics given below the current definition. The semantics are
\G incomplete until resolved by a consumer of do-sys such as LOOP .
\G
\G Execution: ( n1|u1 n2|u2 -- ) ( R: -- loop-sys )
\G Set up loop control parameters with index n2|u2 and limit n1|u1.
\G An ambiguous condition exists if n1|u1 and n2|u2 are not both the
\G same type. Anything already on the return stack becomes
\G unavailable until the loop control parameters are discarded.
\G See also: +LOOP LOOP
: DO                                                    \ FORTH
        POSTPONE (DO) 4 >MARK
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: -- do-sys )
\G Place do-sys on the control flow stack. Append the execution
\G semantics given below the current definition. The semantics are
\G incomplete until resolved by a consumer of do-sys such as LOOP .
\G
\G Execution: ( n1|u1 n2|u2 -- ) ( R: -- loop-sys )
\G If n1|u1 is equal to n2|u2, continue execution at the location
\G given by the consumer of do-sys. Otherwise set up loop control
\G parameters with index n2|u2 and limit n1|u1 and continue
\G executing immediately following ?DO . Anything already on the
\G return stack becomes unavailable until the loop control
\G parameters are discarded. An ambiguous condition exists if n1|u1
\G and n2|u2 are not both of the same type.
\G See also: +LOOP DO I LEAVE LOOP UNLOOP
: ?DO                                                   \ FORTH "question-do"
        POSTPONE (?DO) 4 >MARK
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: do-sys -- )
\G Append the execution semantics given below to the current
\G definition. Resolve the destination of all unresolved occurrences
\G of LEAVE between the location given by do-sys and the next
\G location for a transfer of control, to execute the words
\G following LOOP.
\G
\G Execution: ( -- ) ( R: loop-sys1 -- | loop-sys2 )
\G Loop control parameters must be available. Add one to the loop
\G index. If the loop index is then equal to the loop limit, discard
\G the loop parameters and continue execution immediately following
\G the loop. Otherwise continue execution at the beginning of the
\G loop.
\G See also: DO I LEAVE
: LOOP                                                  \ FORTH
        POSTPONE (LOOP) 4 >RESOLVE
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: do-sys -- )
\G Append the execution semantics given below to the current
\G definition. Resolve the destination of all unresolved occurrences
\G of LEAVE between the location given by do-sys and the next
\G location for a transfer of control, to execute the words
\G following +LOOP.
\G
\G Execution: ( n -- ) ( R: loop-sys1 -- | loop-sys2 )
\G Loop control parameters must be available. Add n to the loop
\G index. If the loop index was did not cross the boundary between
\G the loop limit minus one and the loop limit, continue execution
\G at beginning of the loop. Otherwise discard the current loop
\G control parameters and continue execution immediately following
\G the loop.
\G See also: DO I LEAVE
: +LOOP                                                 \ FORTH "plus-loop"
        POSTPONE (+LOOP) 4 >RESOLVE
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: colon-sys -- )
\G Append the execution semantics defined below to the current
\G definition. End the current definition, allow it to be found in
\G the dictionary and enter interpretation state, consuming
\G colon-sys. The data space pointer is left aligned.
\G
\G Execution: ( -- ) ( R: nest-sys -- )
\G Return to the calling definition specified by nest-sys.
: ;                                                     \ FORTH "semicolon"
        POSTPONE (EXIT) CLEAR LOCALS ?CSP [ REVEAL
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( C: colon-sys1 -- colon-sys2 )
\G Append the run-time semantics below to the current definition.
\G The current definition is not made findable by DOES> . Consume
\G colon-sys1 and produce colon-sys2. Append the initiation
\G semantics defined below to the current definition.
\G
\G Run-time: ( -- ) ( R: nest-sys1 -- )
\G Replace the execution semantics of the most recently definition,
\G referred to as name, with the name execution semantics given
\G below. Return control to calling definition specified by
\G nest-sys1. Code may be damaged if the most recently defined word
\G was not defined with CREATE or a user-defined word that calls
\G CREATE .
\G
\G Initiation: ( i*x -- i*x a-addr ) ( R: -- nest-sys2 )
\G Save implementation-dependant information nest-sys2 about the
\G calling definition. Place name's data field address on the stack.
\G The stack effects i*x represent arguments to name.
\G
\G name Execution: ( i*x -- j*x )
\G Execute the portion of the definition that begins with the
\G initiation semantics appended by DOES> which modified name. The
\G stack effects i*x and j*x represent arguments to and results from
\G name, respectively.
\G See also: CREATE DOER:
: DOES>                                                 \ FORTH "does"
        ?CSP POSTPONE MODIFY HERE L, 0 , 0 ,
        (LIT) DODOES CALL, LHERE , CLEAR LOCALS
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( x -- )
\G Compile x as a literal. Append the run-time syntax given below
\G to the current definition.
\G
\G Run-time: ( -- x )
\G Place x on the stack.
: LITERAL                                               \ FORTH
        CHARFLAG @ CHARFLAG OFF
        IF      POSTPONE (CHR)
        ELSE    POSTPONE (LIT)
        THEN
        L,
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics below to the current definition.
\G Exception -13 occurs if name is not found.
\G
\G Run-time: ( -- xt )
\G Place name's execution token xt on the stack. The execution token
\G compiled by the phrase " ['] X " is the same value returned by
\G " ' X " outside of compilation state.
\G See also: ' POSTPONE
: [']                                                   \ FORTH "bracket-tick"
        ' POSTPONE (TIC) L,
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition.
\G
\G Run-time: ( -- char )
\G Place char char, the value of the first character of name, on the
\G stack.
\G See also: CHAR
: [CHAR]                                            \ FORTH "bracket-char"
        CHARFLAG ON CHAR LITERAL
        ;  IMMEDIATE  COMPILE-ONLY  ANS

EXTRA:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -531 occurs when the character is not in
\G the range {'@'..'_'}.
\G
\G Run-time: ( -- char )
\G Place char, the value of the first character of name, after
\G conversion to a control character, on the stack.
\G See also: CTRL [CHAR]
: [CTRL]                                            \ EXTRA "bracket-control"
        CHARFLAG ON CTRL LITERAL
        ;  IMMEDIATE  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( x1 x2 -- )
\G Append the run-time semantics defined below to the current
\G definition.
\G
\G Run-time: ( -- x1 x2 )
\G Place cell pair x1 x2 on the stack.
: 2LITERAL                                              \ FORTH "two-literal"
        SWAP LITERAL LITERAL
        ;  IMMEDIATE  COMPILE-ONLY  ANS

EXTRA:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( x1 .. xn n -- )
\G Append the execution semantics defined below to the current
\G definition.
\G
\G Executing:
\G ( -- x1 .. xn )
\G Place x1 to xn on the stack.
: LITERALS                                              \ EXTRA
        1 OF    LITERAL EXIT    THEN
        2 OF    2LITERAL EXIT   THEN
        DUP
        BEGIN   ROT >R 1- ?DUP 0=
        UNTIL
        BEGIN   R> LITERAL 1- ?DUP 0=
        UNTIL
        ;  IMMEDIATE  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( c-addr1 u -- )
\G Append the run-time semantics given below to the current
\G definition.
\G
\G Run-time: ( -- c-addr2 u )
\G Return c-addr2 u describing a string consisting of the characters
\G specified by c-addr1 u during compilation. A Standard Program
\G shall not alter the returned string.
: SLITERAL                                      \ FORTH
        POSTPONE (S") HERE L,                   \ Compile routine and pointer
        HERE PACK C@ 1+ ALLOT ALIGN             \ Strore in code segment
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( "ccc<quote>" -- c-addr u )
\G Parse ccc delimited by " (double quote). Store the resulting
\G string ccc at a temporary location. The maximum length of the
\G temporary buffer is 255 characters. CHForth allows for the
\G storing of more such strings before new strings start to
\G overwrite the buffer. A standard program shall not alter the
\G returned string.
\G
\G Compilation: ( "ccc<quote>" -- )
\G Parse ccc delimited by " (double quote). Append the run-time
\G semantics given below to the current definition.
\G
\G Run-time: ( -- c-addr u )
\G Return c-addr and u describing a string consisting of the
\G characters ccc. A standard program shall not alter the returned
\G string.
\G See also: C"
: S"                                                    \ FORTH "s-quote"
        FLYER '"' PARSE SLITERAL
        ;  IMMEDIATE  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "ccc<quote>" -- )
\G Parse ccc delimited by " (double-quote). Append the run-time
\G semantics given below to the current definition.
\G
\G Run-time: ( -- c-addr )
\G Return c-addr, a counted string consisting of the characters ccc.
\G A standard program shall not alter the returned string.
\G See also: S"
: C"                                                    \ FORTH "c-quote"
        POSTPONE (C") HERE L,                   \ Compile routine and pointer
        ",                                      \ Store string in code segment
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "ccc<quote>" -- )
\G Parse characters ccc delimited by " (double-quote). Append the
\G run-time semantics specified below to the current definition.
\G
\G Run-time: ( -- )
\G Display ccc.
\G See also: .(
: ."                                            \ FORTH "dot-quote"
        POSTPONE (.") L",                       \ String is in list segment
        ;  IMMEDIATE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "ccc<quote>" -- )
\G Parse characters ccc delimited by " (double-quote). Append the
\G run-time semantics specified below to the current definition.
\G
\G Run-time: ( i*x x1 -- | i*x ) ( R: j*x -- | j*x )
\G Remove x1 from the stack. If any bit of x1 is not zero, perform
\G the function of -2 THROW . The default interpreter will display
\G ccc. The address of the counted string ccc can be found in ERR$ ,
\G but is only valid for a limited time.
: ABORT"                                        \ FORTH "abort-quote"
        POSTPONE (ABORT") HERE L, ",            \ String is in code segment
        ;  IMMEDIATE  COMPILE-ONLY  ANS

EXTRA:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the interpretation and
\G compilation semantics defined below. name is referred to as a
\G "prefix".
\G
\G Interpretation: ( i*x "name1" -- j*x )
\G Skip leading space delimiters. Parse name1 delimited by a space.
\G Execute the prefix action of name1. Exception -32 occurs if this
\G prefix is not valid for this word or datatype.
\G
\G Compilation: ( "name2" -- )
\G Skip leading space delimiters. Parse name2 delimited by a space.
\G Compile the prefix action of name1. Exception -32 occurs if this
\G prefix is not valid for this word or datatype.
: PREFIX        ( "name" -- )                           \ EXTRA
        >IN @
        CREATE  >IN ! BL WORD CASESENSITIVE @ INVERT
        IF      DUP COUNT UPPER
        THEN
        C@ 1+ ALLOT IMMEDIATE
        MODIFY T[ HERE ,-L 0 , 0 ,
        TH> T.PREFIX
        TDO> DOPREFIX
        BL PARSE-WORD SEARCH-CONTEXT 0= #-32 ?ERROR
        DUP >BODY SWAP >CALL CELL- DUP @ 0= #-32 ?ERROR
        ROT COUNT ROT CELL- SEARCH-WORDLIST 0= #-32 ?ERROR
        FLYER EXECUTE
        ;

FORTH:

\G Interpretation: ( x "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Store x in name. Exception -32 occurs if name was not defined by
\G VALUE or VARIABLE .
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by VALUE
\G , VARIABLE or (LOCAL).
\G
\G Run-time: ( x -- )
\G Store x in name.
\G See also: (LOCAL) VALUE
PREFIX TO                                               \ FORTH
ANS

EXTRA:

\G Interpretation: ( n|u "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Add n|u to name. Exception -32 occurs if name was not defined by
\G VALUE or VARIABLE .
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by VALUE
\G , VARIABLE or (LOCAL).
\G
\G Run-time: ( x -- )
\G Add n|u to name.
PREFIX +TO                                      \ EXTRA "plus-to"

\G Interpretation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Store zero in name. Exception -32 occurs if name was not defined
\G by VALUE or VARIABLE .
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by VALUE
\G , VARIABLE or (LOCAL).
\G
\G Run-time: ( -- )
\G Store zero in name.
PREFIX CLEAR                                    \ EXTRA

\G Interpretation: ( "name" -- x )
\G Skip leading space delimiters. Parse name delimited by a space.
\G x is the value of name. Exception -32 occurs if name was not
\G defined by VARIABLE .
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by
\G VARIABLE .
\G
\G Run-time: ( -- x )
\G x is the value of name.
PREFIX FROM                                     \ EXTRA

\G Interpretation: ( "name" -- a-addr )
\G Skip leading space delimiters. Parse name delimited by a space.
\G a-addr is the data field address of name. Exception -32 occurs if
\G name was not defined by VALUE .
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by VALUE
\G
\G Run-time: ( -- a-addr )
\G a-addr is the data field address of name.
PREFIX ADR                                      \ EXTRA "a-d-r"

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the current execution semantics of name to the current
\G definition. Exception -32 occurs if name was not defined by
\G VECTOR .
PREFIX CHAIN                                    \ EXTRA
        COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by VALUE
\G , VARIABLE or VECTOR .
\G
\G Run-time: ( -- ) ( R: -- x )
\G Push x associated with name on the return stack.
PREFIX PUSH                                     \ EXTRA
        COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by VALUE
\G , VARIABLE or VECTOR .
\G
\G Run-time: ( -- ) ( R: x -- )
\G Pop x associated with name from the return stack.
PREFIX POP                                      \ EXTRA
        COMPILE-ONLY

\G Interpretation: ( "name" -- wid )
\G Skip leading space delimiters. Parse name delimited by a space.
\G wid is the word list identification associated with name.
\G Exception -32 occurs if name was not defined by VOCABULARY .
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by
\G VOCABULARY .
\G
\G Run-time: ( -- wid )
\G wid is the word list identification associated with name.
PREFIX GET      ( "name" -- )                   \ EXTRA

\G Interpretation: ( xt "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Store execution token xt in name. Exception -32 occurs if name
\G was not defined by VECTOR .
\G
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Append the run-time semantics given below to the current
\G definition. Exception -32 occurs if name was not defined by
\G VECTOR .
\G
\G Run-time: ( xt -- )
\G Store execution token xt in name.
PREFIX IS                                       \ EXTRA

VALUE:

: TO
        POSTPONE (TO) L,
        ;

: +TO
        POSTPONE (+TO) L,
        ;

: CLEAR
        POSTPONE (CLEAR) L,
        ;

: PUSH
        POSTPONE (PUSH) L,
        ;

: POP
        POSTPONE (POP) L,
        ;

TARGET VOC@ <VARIABLE> VOC!

: ADR
        POSTPONE (ADR) L,
        ;

TARGET VOC@ T.DOVAL CELL- !-T

EXTRA:

VARIABLE:

: FROM
        POSTPONE (VAL) L,
        ;

TARGET VOC@ T.DOVAR CELL- !-T

VECTOR:

: IS
        POSTPONE (IS) L,
        ;

: CHAIN
        @ COMPILE,
        ;

: PUSH
        POSTPONE (PUSH) L,
        ;

: POP
        POSTPONE (POP) L,
        ;

TARGET VOC@ T.DOVECTOR CELL- !-T

LOCAL:

: TO
        POSTPONE (TOLOC) >LOCAL L,
        ;

: +TO
        POSTPONE (+TOLOC) >LOCAL L,
        ;

: CLEAR
        POSTPONE (CLEARLOC) >LOCAL L,
        ;

TARGET VOC@

INTERNAL:

DOER: DOLOCAL (DOLOCAL)
        POSTPONE (LOC) >LOCAL L,
        ;

PTR (DOLOCAL) CELL- !-T

\ Find the offset of a particular local value.
: >LOCAL        ( addr -- x )                   \ EXTRA "to-local"
        @ LOCALS SWAP - 1- CELLS
        ;  COMPILE-ONLY

\ Create a type of local value with run-time semantics xt and
\ the string c-addr u as its name.
\
\ Run-time:
\ ( x -- )
\ Set the initial value to x.
\
\ Executing:
\ ( -- x )
\ Place the value on the stack. The value may be manipulated by
\ TO +TO and CLEAR .
: ((LOCAL))     ( c-addr u xt -- )              \ EXTRA "paren-paren-local"
        >R 2>R LOCALS 0=
        IF      0 LOCAL-WORDLIST VOC!
        THEN
        WARNING @ WARNING OFF
        LAST 2@ GET-CURRENT VOC@ GET-CURRENT
        LOCAL-WORDLIST SET-CURRENT
        DPSWAP CIRCULATE
        ALIGN 2R> HEAD, =IMMEDIATE =LOCAL OR SET-HEADER-FLAGS
        REVEAL R> JUMP,
        LOCALS ,
        DPSWAP
        SET-CURRENT GET-CURRENT VOC! LAST 2!
        WARNING !
        ;  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G **** Dit zal in dpANS 6 hopelijk anders luiden
\G Compilation: ( c-addr u -- )
\G When executed during compilation, (LOCAL) passes a message to
\G the Forth system that has one of two meanings. If u is
\G non-zero, the message identifies a new local whose word name
\G is given by the string of characters identified by c-addr u.
\G If u is zero, the message is 'last local' and c-addr has no
\G significance. The result of executing (LOCAL) during
\G compilation of a definition is to create a set of named local
\G identifiers, each of which is a word name, that have execution
\G semantics within the scope of that definition's source only.
\G
\G local Execution: ( -- x )
\G Push the local's value, x, onto the stack. An ambiguous
\G condition exists when (LOCAL) is executed while in interpret
\G state.
\G
\G Note: This word is not intended for direct use in a definition
\G to declare that definition's locals. It is instead used by
\G system or user compiling words. These compiling words in turn
\G define their own syntax, and may be used directly in
\G definitions to declare locals.
: (LOCAL)                                       \ FORTH "paren-local-paren"
        DUP
        IF      (LIT) (DOLOCAL) ((LOCAL)) 1 +TO LOCALS
                POSTPONE PUSH-LOCAL EXIT
        THEN
        2DROP
        ;  COMPILE-ONLY  ANS

EXTRA:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G **** Is dit goed?
\G Compilation: ( "name" -- )
\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution and run-time
\G semantics defined below.
\G
\G Execution: ( x -- )
\G Store x in name.
\G
\G name Execution: ( -- x )
\G Place x on the stack. The value can be manipulated by TO +TO and
\G CLEAR .
: LOCAL                                         \ EXTRA
        BL PARSE-WORD (LOCAL)
        ;  IMMEDIATE  COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( -- )
\G Terminate creation of local values.
: END-LOCAL                                     \ EXTRA
        ;  COMPILE-ONLY  IMMEDIATE

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( "namen" .. "name2" "name1" "|" -- )
\G Define up to 8 local variables with "name1" to "namen". The list
\G of locals to be defined is terminated with "|". The actual number
\G in CHForth may be greater, depending on the length of the input
\G line. Append the run-time semantics for name given below.
\G
\G name Run-time: ( -- x )
\G Place x on the stack. The value can be manipulated by TO +TO and
\G CLEAR .
: LOCALS|                                               \ FORTH "locals-bar"
        BEGIN   BL PARSE-WORD S" |" COMPARE
        WHILE   PARSED-WORD (LOCAL)
        REPEAT
        ;  IMMEDIATE  COMPILE-ONLY  ANS

INTERNAL:

\ Keep the dictionary pointer and list dictionary pointers
\ within an area that is used for temporary compiling
\ definitions.
: CIRCULATE     ( -- )                          \ EXTRA
        HERE LIMIT TUCK - 3FF AND + DP !
        LHERE LLIMIT TUCK - 3FF AND + LDP !
        HHERE HLIMIT TUCK - 3FF AND + HDP !
        ;  COMPILE-ONLY

EXTRA:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G Compilation: ( -- )
\G Append the run-time semantics given below to the current
\G definition.
\G
\G Run-time: ( i*x -- j*x )
\G If STATE contains not zero, continue. Change the dictionary
\G pointer and list dictionary pointer to a temporary area and
\G compile the next words. Reset the dictionary pointers to their
\G prior values and execute the routine just compiled.
: FLYER                                         \ EXTRA
        FROM STATE
        IF      EXIT
        THEN
        DPSWAP CIRCULATE
        LHERE R> 2>R ] DIVE POSTPONE EXIT [
        DPSWAP
        ;  COMPILE-ONLY

FORTH:

                            \ (* End of Source *) /
