\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Profile of a program 
\ CATEGORY    : Debugging 
\ AUTHOR      : Marcel Hendrix 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -arrays

        MARKER -lprofile



DOC
(* Dit deel werkt niet*)

0 value ^&*

create nowbuf   #257 allot

: clear.nb
        nowbuf c0! ;

: c>now
        nowbuf c@+ + c!
        nowbuf 1 over c+!
        c@ #254 >= abort" NOW buffer vol" ;

: $>now
        0
        ?do     c@+ c>now
        loop    drop ;

: timer-stop
        (.t0) 2drop ;

: read-timer
        diff0 @ ;

0 value /checks

: .result
        push base decimal
        read-timer #1000 /checks */mod
        0 .r '.' emit #1000 /checks */ . ." microsec/iteratie."
        pop base
        ;

: check-out
        #10 to /checks
        begin   ^&* execute ?stack read-timer #1000 u<
        while   /checks #10 * to /checks
        repeat
        .result ;

: .time"
        clear.nb
        s" :noname timer-reset /checks 0 do " $>now
        '"' word count $>now
        s"  loop timer-stop ; to ^&* check-out " $>now
        nowbuf count evaluate ;
ENDDOC

#1000 constant /maxlines

2array probes

: proinit
        reset probes
        /maxlines 0
        do      i clear probes
        loop ;

: ^
        state @
        if      1 postpone literal 0 postpone literal #lines @ 1- dup
                /maxlines u< invert abort" Te veel regels in bestand"
                postpone literal s" +to probes " evaluate
        then ;
        immediate

: ttype
        2 /string 0 local pos 0
        ?do     count dup ^I =
                if      drop 8 pos over mod - dup spaces
                else    emit 1
                then
                +to pos pos c/l #12 - u>
                if      leave
                then
        loop    drop ;

create "^"-buf  '^' c, ^I c, #256 allot

: edit-file
        local hoi local hif
        begin   "^"-buf 2 + #256 hif read-line throw
        while   "^"-buf swap 2 + hoi write-line throw
        repeat  drop ;

: profile
        bl word count r/o open-file throw local handle-if
        s" !!!!!!!!.$$$" w/o create-file throw local handle-of
        handle-if handle-of ['] edit-file catch
        if      2drop ." oeps!"
        then
        handle-of close-file throw
        handle-if close-file throw
        s" !!!!!!!!.$$$" included ;

?undef d0> [if]
?def code [if]
code d0>
                pop     ax
                cmp     bx, # 0
                jle     1 $
        0 $:    mov     bx, # true
                next
        1 $:    jnz     2 $
                test    ax, ax
                jnz     0 $
        2 $:    xor     bx, bx
                next
        end-code
[else]
: d0>
        0. d> ;
[then]
[then]

: (.profile)
        0 local line# local handle
        begin   pad #256 handle read-line throw stop? 0= and
        while   cr line# probes 2dup d0>
                if      6 d.r ."  * "
                else    6 spaces ."  | " 2drop
                then
                pad swap ttype
                1 +to line# wordspeed @ ms
        repeat  drop ;

: .profile
        s" !!!!!!!!.$$$" r/o open-file throw dup local handle
        ['] (.profile) catch
        if      drop ." oeps"
        then
        handle close-file throw ;


                            \ (* End of Source *) /
