\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Complex locals 
\ CATEGORY    : Fixed point routines 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : February 28, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -assembler

        MARKER -zlocals


INTERNAL DEFINITIONS ALSO

CASESENSITIVE ON

PRIVATES

CODE zloc@
                LODSW   ES:
                MOV     DI, ' LSP! 2 + @
                ADD     DI, AX
                PUSH    BX
                PUSH    SS: 0 [DI]
                PUSH    SS: -2 [DI]
                PUSH    SS: -4 [DI]
                MOV     BX, SS: -6 [DI]
                NEXT
END-CODE  COMPILE-ONLY  PRIVATE

CODE zloc!
                LODSW   ES:
                MOV     DI, ' LSP! 2 + @
                ADD     DI, AX
                MOV     SS: -6 [DI], BX
                POP     SS: -4 [DI]
                POP     SS: -2 [DI]
                POP     SS: 0 [DI]
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY  PRIVATE

CODE zloc+!
                LODSW   ES:
                MOV     DI, ' LSP! 2 + @
                ADD     DI, AX
                POP     AX
                ADD     SS: -4 [DI], AX
                ADC     SS: -6 [DI], BX
                POP     DX
                POP     AX
                ADD     SS: 0 [DI], AX
                ADC     SS: -2 [DI], DX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY  PRIVATE

CODE zloc0!
                LODSW   ES:
                MOV     DI, ' LSP! 2 + @
                ADD     DI, AX
                XOR     AX, AX
                MOV     SS: 0 [DI], AX
                MOV     SS: -2 [DI], AX
                MOV     SS: -4 [DI], AX
                MOV     SS: -6 [DI], AX
                NEXT
END-CODE  COMPILE-ONLY  PRIVATE

ALIGN
CODE ZLocRet
                ADD     ' LSP! 2 + @ # 4 CELLS
                XCHG    SP, BP
                POP     SI
                XCHG    SP, BP
                NEXT
END-CODE  PRIVATE

' ZLocRet L,

CODE PUSH-ZLOCAL
                XCHG    SP, BP
$IF386
                PUSH    # LHERE CELL-
$ELSE
                MOV     AX, # LHERE CELL-
                PUSH    AX
$THEN
                XCHG    SP, BP
                POP     AX
                POP     CX
                POP     DX
                XCHG    SP, ' LSP! 2 + @
                PUSH    DX
                PUSH    CX
                PUSH    AX
                PUSH    BX
                XCHG    SP, ' LSP! 2 + @
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

DOER: DOZLOCAL
        POSTPONE zloc@ >LOCAL L,
        ;

METHODS DOZLOCAL

: TO
        POSTPONE zloc! >LOCAL L,
        ;

: +TO
        POSTPONE zloc+! >LOCAL L,
        ;

: CLEAR
        POSTPONE zloc0! >LOCAL L,
        ;

END-METHODS

: (ZLOCAL)      ( c-addr u -- )
        [ ' DOZLOCAL >BODY 3 CELLS + ] LITERAL
        ((LOCAL)) 4 +TO LOCALS POSTPONE PUSH-ZLOCAL
    ;  COMPILE-ONLY

?DEF -DECOMPILER [IF]

ALSO DECOMPILER

:NONAME
        CELL+ L@+ \" ZLOCAL " 2/ 3 - .
        ;  ' zloc@ TAB!

:NONAME
        CELL+ L@+ \" TO ZLOCAL " 2/ 3 - .
        ;  ' zloc! TAB!

:NONAME
        CELL+ L@+ \" +TO ZLOCAL " 2/ 3 - .
        ;  ' zloc+! TAB!

:NONAME
        CELL+ L@+ \" CLEAR ZLOCAL " 2/ 3 - .
        ;  ' zloc0! TAB!

PREVIOUS

[THEN]

FORTH DEFINITIONS

\G Create a dictionary entry with name "name" and initial value
\G r1 r2.
\G
\G Executing:
\G ( -- r1 r2 )
\G Place the value on the stack. The value can be manipulated by
\G TO +TO and CLEAR .
: ZLOCAL        ( r1 r2 "name" -- )             \ ZLOCALS
        BL PARSE-WORD (ZLOCAL)
        ;  IMMEDIATE  COMPILE-ONLY

: ZLOCALS|
        BEGIN   BL PARSE-WORD S" |" COMPARE
        WHILE   PARSED-WORD (ZLOCAL)
        REPEAT
        ;  IMMEDIATE  COMPILE-ONLY

DEPRIVE

CASESENSITIVE OFF

PREVIOUS FORTH DEFINITIONS

                            \ (* End of Source *) /
