\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : TRACE / DEBUG like MacFORTH
\ CATEGORY    : Standard Programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : August 15, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        INTERNAL ' $COMPILE IS 'COMPILE FORTH   \ reset default action


        ?DEF -tracer [IF] -tracer [THEN]


        MARKER -tracer


\G A variable used in the tracer. When zero, no trace information
\G is shown on the screen. Else a stack diagram is shown along
\G with the name of the next to be executed word or the word that
\G was executed by the compiler (immediate words). See TRACE .
VARIABLE DEBUG      ( -- a-addr )                   \ TRACER

\G A variable used in the tracer. When not zero, trace information
\G is compiled in the next compiled colon definition. See DEBUG .
VARIABLE TRACE      ( -- a-addr )                   \ TRACER

DEBUG OFF TRACE OFF

INTERNAL DEFINITIONS

\ This is the routine that is built into colon definitions when
\ TRACE is not zero.
: (TRACE)           ( -- )
        DEBUG @
        IF      DEPTH 0< -4 ?ERROR                  \ Stack underflow
                #24 HTAB ." ( " DEPTH ?DUP
                IF      0 SWAP 1-
                        DO      I PICK FROM BASE #10 =
                                IF      .
                                ELSE    U.
                                THEN
                        -1 +LOOP
                THEN
                ." ) "
                CR INLINE# >HEAD .HEAD #16 HTAB
                STOP? DROP
        ELSE    INLINE# DROP
        THEN
    ;

\ When TRACE does not contain zero, built some information for
\ DEBUG into the current definition.
: NEW$COMPILE              ( c-addr u -- )
        TRACE @
        IF      SEARCH-CONTEXT
                IF      POSTPONE (TRACE) DUP L,
                        ?ANSI HEADFLAGS =IMMEDIATE AND
                        IF      EXECUTE EXIT
                        THEN
                        COMPILE, EXIT
                THEN
                PARSED-WORD NUMBER? ?DUP
                IF      POSTPONE (TRACE) ['] LITERAL L,
                        ?PORTABLE POSTPONE LITERALS EXIT
                THEN
                POSTPONE (TRACE) ['] ?CRASH L,
                #-13 ?CRASH
        ELSE    $COMPILE
        THEN
        ;

ALSO

?DEF -decompiler [IF]

DECOMPILER

:NONAME
        CELL+ \" TRACE: " L@+ ..HEAD ;
        ' (TRACE) TAB!

[THEN]

FORTH DEFINITIONS

\G Enable the use of DEBUG and TRACE .
: NEW           ( -- )                              \ DEBUG
        ['] NEW$COMPILE IS 'COMPILE
    ;

\G Disable the use of DEBUG and TRACE .
: OLD           ( -- )                              \ DEBUG
        ['] $COMPILE IS 'COMPILE
    ;

WARNING @ WARNING OFF

\ Redefine for use with the tracer.
: \
        STATE @ TRACE @ AND
        IF      -2 CELLS LDP +!         \ remove tracer information
        THEN
        POSTPONE \
    ;  IMMEDIATE

\ Redefine for use with the tracer.
: (
        STATE @ TRACE @ AND
        IF      -2 CELLS LDP +!         \ remove tracer information
        THEN
        POSTPONE (
    ;  IMMEDIATE

WARNING !

-2 SET-ORDER

NEW DEBUG ON TRACE ON

                            \ (* End of Source *) /
