\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Mouse and joystick interfacing 
\ CATEGORY    : Peripherals 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -assembler

        MARKER -peripher


-- Joystick

code strig
                push    bx
                mov     dx, # 0
                mov     ah, # $84
                int     $15
$if386
                shr     ax, # 4
$else
                shr     ax, # 1
                shr     ax, # 1
                shr     ax, # 1
                shr     ax, # 1
$then
                xor     ax, # 3
                and     ax, # 3
                mov     bx, ax
                next    end-code

code stick
                push    bx
                mov     dx, # 1
                mov     ah, # $84
                int     $15
                push    ax
                next    end-code

-- Mouse

code showmouse
                mov     ax, # 1
                int     $33
                next    end-code

code hidemouse
                mov     ax, # 2
                int     $33
                next    end-code

code button
                push    bx
                mov     ax, # 3
                int     $33
                and     bx, # 7
                next    end-code

code mouse
                push    bx
                mov     ax, # 3
                int     $33
                mov     bx, adr maxypix
                dec     bx
                sub     bx, dx
                mov     ax, adr maxxpix
                mul     cx
                mov     cx, # 640
                div     cx
                push    ax
                next    end-code

                            \ (* End of Source *) /
