\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Routines for saving and restoring graphics screens 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -graphio



privates

$3CE constant ctrl-out  private
$3CF constant data-out  private
$3C4 constant ctrl-in   private
$3C5 constant data-in   private

: (savemulti)
        local size w/o create-file throw local hdl 4 ctrl-out pc! 4 0
        do      i data-out pc!
                sbase 0 size hdl writex-file throw
        loop
        0 data-out pc! hdl close-file throw ;   private

: (loadmulti)
        local size r/o open-file throw local hdl 2 ctrl-in pc! 4 0
        do      1 i lshift data-in pc!
                sbase 0 size hdl readx-file throw drop
        loop
        #15 data-in pc!
        hdl close-file throw ;  private

: (savevres)
        w/o create-file throw >s
        sbase 0 #64000 s writex-file throw
        s> close-file throw ;   private

: (loadvres)
        r/o open-file throw >s
        sbase 0 #64000 s readx-file throw drop
        s> close-file throw ;   private

: (savepic)     ( adr len -- )
        getmode
        case
                $0E of  #16000 (savemulti)      endof
                $10 of  #28000 (savemulti)      endof
                $11 of  #38400 (savemulti)      endof
                $12 of  #38400 (savemulti)      endof
                $13 of  (savevres)      endof
                true abort" invalid screenmode"
        endcase ;

: (loadpic)     ( adr len -- )
        getmode
        case
                $0E of  #16000 (loadmulti)      endof
                $10 of  #28000 (loadmulti)      endof
                $11 of  #38400 (loadmulti)      endof
                $12 of  #38400 (loadmulti)      endof
                $13 of  (loadvres) endof
                true abort" invalid screenmode"
        endcase ;

deprive

: savepic
        s" .pic" bl word append here count (savepic) ;

: loadpic
        s" .pic" bl word append here count (loadpic) ;

                            \ (* End of Source *) /
