\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Goniometric functions 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -gonio



DOC
   sin*16384, cos*16384 with a table
ENDDOC

privates

create sintable private

16384
16380 16374 16361 16344 16321 16293 16261 16225 16182 16134
16082 16025 15964 15897 15825 15749 15668 15582 15491 15396
15296 15191 15081 14966 14848 14725 14598 14465 14329 14188
14044 13893 13741 13582 13421 13254 13084 12910 12732 12550
12365 12174 11983 11785 11585 11381 11173 10962 10749 10531
10310 10087  9859  9630  9397  9191  8922  8681  8437  8192
 7942  7692  7438  7182  6923  6663  6401  6137  5872  5603
 5334  5062  4790  4515  4240  3963  3686  3406  3126  2844
 2562  2280  1997  1712  1428  1143   856   571   286     0

here 91 cells allot
:noname 91 0 do , loop ;
swap internal dp ! forth execute

10 -7 mod 3 <> [if]

: sin
        90 /mod tuck 1 and
        if      negate 90 +
        then
        sintable []cell @ swap 2 and
        if      negate
        then ;

[else]

: sin
        360 mod dup 0<
        if      360 +
        then
        dup 180 <
        if      dup 90 >
                if      180 swap -
                then
                sintable []cell @ exit
        then
        180 - dup 90 >
        if      180 swap -
        then
        sintable []cell @ negate ;

[then]

: cos
        90 swap - sin ;

: tan
        dup sin swap cos ?dup
        if      100 swap */
        else    3 *
        then ;

: scale         ( n1 n2 -- n3 ) ( n1*n2/16384 )
        over abs over abs um* d2* d2* nip -rot xor 0<
        if      negate
        then ;  private

: rotate        ( x1 y1 phi -- x2 y2 )
        dup sin local sine cos local cosine
        over cosine scale over sine scale - -rot
        cosine scale swap sine scale + ;

deprive
                            \ (* End of Source *) /
