\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Fixed point hyperbolic functions 
\ CATEGORY    : Fixed point routines 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -fixlog

        MARKER -fixhyper



: fsinh
        fexp 1.0e fover f/ f- 2.0e f/ ;
        ans

: fcosh
        fexp 1.0e fover f/ f+ f2/ ;
        ans

: ftanh
        fdup fsinh fswap fcosh f/ ;
        ans

: fasinh
        fdup fsqr 1.0e f+ fsqrt f+ fln ;
        ans

: facosh
        fdup fsqr 1.0e f- fsqrt f+ fln ;
        ans

: fatanh
        fdup 1.0e f+ fswap 1.0e fswap f- f/ fln 2.0e f/ ;
        ans
                            \ (* End of Source *) /
