\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Fixed point goniometric functions 
\ CATEGORY    : Fixed point routines 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -fixed

        MARKER -fixgonio



base @ decimal

 9279 3 fconstant pi
 1144 0 fconstant pi/180
37408 1 fconstant pi/2
18558 6 fconstant pi*2

privates

create atntab   private
   51472 0 2,  30386 0 2,  16055 0 2,   8150 0 2,
    4091 0 2,   2047 0 2,   1024 0 2,    512 0 2,
     256 0 2,    128 0 2,     64 0 2,     32 0 2,
      16 0 2,      8 0 2,      4 0 2,      2 0 2,

fvalue fx       private
fvalue fy       private

: tan2
        1.0e to fx fdup minfloat f<
        if      to fy exit
        then
        0.0e to fy 16 0
        do      begin   fdup i atntab []float f@ f< invert
                while   i atntab []float f@ f-
                        fx fy i fshr f-
                        fy fx i fshr f+
                        to fy to fx
                repeat
        loop
        fdrop ; private

: sin2
        >r fx r> negate s>f f*/ 1.0e f+ ;       private

: atn2
        fy minfloat f<
        if      fy exit
        then
        0.0e 16 0
        do      begin   fy fx i fshr f< invert
                while   i atntab []float f@ f+
                        fx fy i fshr f+
                        fy fx i fshr f-
                        to fy to fx
                repeat
        loop ;  private

: getvalue
        fdup pi/2 f>
        if      pi fswap f-
        then
        fdup fsqr to fx 1.0e
        72 sin2 42 sin2 20 sin2 6 sin2 f* ;     private

: fsin
        pi*2 fmod fdup f0<
        if      pi*2 f+
        then
        fdup pi f<
        if      getvalue
        else    pi f- getvalue fnegate
        then ;
        ans

: fcos
        pi/2 fswap f- fsin ;
        ans

: ftan
        fdup f0< >r fabs pi fmod tan2 fy fx f/ r> 0<
        if      fnegate
        then ;
        ans

: fasin
        fdup f0< >r fabs fdup to fy fsqr 1.0e fswap f- fsqrt to fx atn2
        r> 0<
        if      fnegate
        then ;
        ans

: facos
        fasin pi/2 fswap f- ;
        ans

: fatan
        fdup f0< >r fabs to fy 1.0e to fx atn2 r> 0<
        if      fnegate
        then ;
        ans

-- This one is not perfect on multiples and fractions of pi
: fatan2
        fdup f0=
        if      fdrop pi/2 fswap f0<
                if      pi f+
                then
        else    fover f0< >r f/ fatan fdup f0<
                if      pi f+
                then
                r>
                if      pi f+
                then
        then ;
        ans

: fsincos
        fdup fsin fswap fcos ;
        ans

: frad
        pi/180 f* ;

: fdeg
        [ 1.0e pi/180 f/ ] fliteral f* ;

deprive

base !

                            \ (* End of Source *) /
