\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Fixed point routines 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -double
        NEEDS -dlocals

        MARKER -fixed



base @ decimal

' (number?) is number?

' dlocal alias flocal   immediate compile-only

code float+
                add     bx, # 4
                next
end-code  ans

code floats
                add     bx, bx
                add     bx, bx
                next
end-code  ans

code []float
                pop     ax
$if386
                shl     ax, # 2
$else
                shl     ax, # 1
                shl     ax, # 1
$then
                add     bx, ax
                next
end-code

\ needs -flocals

vector (f.)

: f.
        (f.) type space
        ;  ans

: f.r
        >r (f.) r> over - spaces type
        ;

privates

4 value (precision)                     private

: set-precision
        0 max 4 min to (precision)
        ;  ans

: precision
        (precision)
        ;  ans

: (n.)
        precision >r set-precision (f.) r> set-precision
        ;

: n.
        (n.) type space
        ;

: n.r
        >r (n.) r> over - spaces type
        ;

: bignum
        1 precision 0
        ?do     10 um* drop
        loop
        ;  private

' 2,            alias f,
' 2@            alias f@        ans
' 2!            alias f!        ans
' d+!           alias f+!
' d0!           alias f0!
' incr          alias fincr
' decr          alias fdecr
' d+            alias f+        ans
' d-            alias f-        ans
' d<            alias f<        ans
' d=            alias f=
' d>            alias f>
' d0<           alias f0<       ans
' d0=           alias f0=       ans
' d0>           alias f0>
' 2dup          alias fdup      ans
' 2drop         alias fdrop     ans
' 2nip          alias fnip
' 2over         alias fover     ans
' 2swap         alias fswap     ans
' 2tuck         alias ftuck
' 2rot          alias frot      ans
' 2>r           alias f>r       compile-only
' 2r>           alias fr>       compile-only
' 2r@           alias fr@
' dnegate       alias fnegate   ans
' dabs          alias fabs      ans
' d2/           alias f2/
' d2*           alias f2*

: fliteral
        2 postpone literals
        ;  immediate  compile-only  ans

: fpick
        2* 1+ dup>r pick r> pick
        ;  ans

code s>f
$if386
                push    # 0
$else
                xor     ax, ax
                push    ax
$then
                next
end-code

code f>s
                pop     ax
                test    bx, bx
                jns     0 $
                inc     bx
        0 $:    next
end-code

: fint
        f>s s>f
        ;

: frac
        fdup f0< >r fabs drop 0 r> 0<
        if      fnegate
        then
        ;

: fsign
        fdup f0<
        if      fdrop -1
        else    f0> 1 and
        then
        ;

: frandom
        random 0
        ;

0 value floating?

: floating!
        true to floating?
        ;  private

: fnumber
        locals| len adr |
        clear floating? adr len (number?) ?dup
        if      exit
        then
        adr len + 1- c@ >upc 'E' <> len 1 = or
        if      false exit
        then
        0 0 adr len 1- over c@ '-' = dup local signed
        if      1 /string
        then
        push base decimal >number over c@ '.' = over and
        if      1 /string dup to dpl >number
        then
        pop base nip 0<>
        if      2drop false exit
        then
        dpl @
        case
                -1 of   swap floating!  endof
                0 of    swap floating!  endof
                1 of       10 um/mod 0 rot    10 um/mod nip swap floating! endof
                2 of      100 um/mod 0 rot   100 um/mod nip swap floating! endof
                3 of     1000 um/mod 0 rot  1000 um/mod nip swap floating! endof
                4 of    10000 um/mod 0 rot 10000 um/mod nip swap floating! endof
                2drop false exit
        endcase
        signed
        if      dnegate
        then
        2
        ;  private

: use-float
        ['] fnumber is number?
        ;

: use-double
        ['] (number?) is number?
        ;

4 set-precision
use-float

: fconstant
        create  f,
        does>   f@
        ;  ans

: fvariable
        create  1 floats allot
        does>
        ;  ans

: fvalue
        create  1 floats allot
        does>   f@
        ;

methods fvalue

: to
        postpone literal postpone f!
        ;

: +to
        postpone literal postpone f+!
        ;

: clear
        postpone literal postpone f0!
        ;

: adr
        postpone literal
        ;

end-methods

?def -decompiler [if]

decompiler

:noname
        ." FCONSTANT " >parm f@ f.
        ;  ' fconstant >body 3 cells + tab!

:noname
        ." FVARIABLE " >parm dup .hex f@ f.
        ;  ' fvariable >body 3 cells + tab!

:noname
        ." FVALUE " >parm dup .hex f@ f.
        ;  ' fvalue >body 3 cells + tab!

forth

[then]

: floor
        nip 0 swap
        ;  ans

: round
        0.5e f+ nip
        ;

: fround
        round s>f
        ;  ans

#cpu @ 386 = [if]

code uf*
                shl     ebx, # 16
                pop     bx
                pop     eax
                rol     eax, # 16
                mul     ebx
                shr     eax, # 16
                push    ax
                mov     bx, dx
                next
end-code        private

[else]

code uf*
                xchg    sp, bp
                xor     di, di
                mov     ax, 4 [bp]
                mul     0 [bp]
                mov     cx, dx
                mov     ax, 4 [bp]
                mul     bx
                add     cx, ax
                adc     di, dx
                mov     ax, 2 [bp]
                mul     0 [bp]
                add     cx, ax
                adc     di, dx
                mov     ax, 2 [bp]
                mul     bx
                add     di, ax
                mov     bx, di
                mov     4 [bp], cx
                add     bp, # 4
                xchg    sp, bp
                next
end-code        private

[then]

#cpu @ 386 = [if]

code uf/
                rol     ebx, # 16
                pop     bx
                pop     dx
                movzx   edx, dx
                pop     ax
                shl     eax, # 16
                div     ebx
                push    ax
                rol     eax, # 16
                mov     bx, ax
                next
end-code        private

[else]

code uf/
                mov     dx, bx
                pop     ax
                xor     bx, bx
                pop     di
                pop     cx
                push    bx
                push    cx
                xchg    sp, bp
                mov     cx, # 32
        0 $:    shl     2 [bp], # 1
                rcl     0 [bp], # 1
                rcl     di, # 1
                rcl     bx, # 1
                jae     1 $
                sub     di, ax
                sbb     bx, dx
                jmp     2 $
        1 $:    sub     di, ax
                sbb     bx, dx
                jae     2 $
                add     di, ax
                adc     bx, dx
                sub     2 [bp], # 1
                sbb     0 [bp], # 0
        2 $:    inc     2 [bp]
                jnz     3 $
                inc     0 [bp]
        3 $:    loop    0 $
                xchg    sp, bp
                pop     bx
                next
end-code        private

[then]

#cpu @ 386 = [if]

code f*
                rol     ebx, # 16
                pop     bx
                pop     eax
                rol     eax, # 16
                imul    ebx
                rol     eax, # 16
                push    ax
                mov     bx, dx
                next
end-code  ans

[else]

: f*
        dup>r dabs 2swap dup>r dabs uf* 2r> xor 0<
        if      dnegate
        then
        ;  ans

[then]

#cpu @ 386 = [if]

code f/
                rol     ebx, # 16
                pop     bx
                pop     dx
                movsx   edx, dx
                pop     ax
                shl     eax, # 16
                idiv    ebx
                push    ax
                rol     eax, # 16
                mov     bx, ax
                next
end-code  ans

[else]

: f/
        dup 3 pick xor >r dabs 2swap dabs 2swap uf/ r> 0<
        if      dnegate
        then
        ;  ans

[then]

: fsqr
        fabs 2dup uf*
        ;

: fmod
        fabs flocal divisor
        dup>r fabs 0.0e divisor dum/mod 2drop r> 0<
        if      fnegate
        then
        ;

#cpu @ 386 = [if]

code f/mod
                rol     ebx, # 16
                pop     bx
                pop     dx
                movsx   edx, dx
                pop     ax
                shl     eax, # 16
                idiv    ebx
                rol     edx, # 16
                push    edx
                push    ax
                rol     eax, # 16
                mov     bx, ax
                next
end-code

[else]

: f/mod
        not-implemented
        ;

[then]

: f*/
        dup 3 pick xor 5 pick xor >r fabs 2>r fabs 2swap fabs dum*
        2r> dum/mod 2nip r> 0<
        if      fnegate
        then
        ;

    0.0001e fconstant minfloat
32767.9999e fconstant maxfloat

: fsqrt
        fdup f0<
        if      fdrop maxfloat exit
        then
        fdup f0= invert
        if      1.0e 10 0
                do      fover fover uf/ f+ f2/
                loop
                fnip
        then
        ;  ans

: fshr
        over >r >r fabs r> 0
        ?do     f2/
        loop
        r> 0<
        if      fnegate
        then
        ;

: fshl
        over >r >r fabs r> 0
        ?do     f2*
        loop
        r> 0<
        if      fnegate
        then
        ;

:noname
        push base decimal dup>r fabs fdup maxfloat f< invert
        if      r>drop fdrop s" Overflow" pop base exit
        then
        <# 'e' hold swap bignum um* nip 0 precision 0
        ?do     #
        loop
        2drop '.' hold 0 #s r> sign #> pop base
        ;  is (f.)

deprive

base !
                            \ (* End of Source *) /
