\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Fixed point complex numbers 
\ CATEGORY    : Fixed point routines 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -fixlog
        NEEDS -fixgonio

        MARKER -fixcompl



: z@
        dup>r float+ f@ r> f@
        ;

: z!
        dup>r f! r> float+ f!
        ;

: z0!
        dup f0! float+ f0!
        ;

: z+!
        dup>r f+! r> float+ f+!
        ;

: zdup
        fover fover
        ;

: zswap
        frot f>r frot fr>
        ;

: zdrop
        fdrop fdrop
        ;

: z.
        fswap f. f.
        ;

: z.r
        >r fswap r@ f.r r> f.r
        ;

: zn.r
        2>r fswap 2r@ n.r 2r> n.r
        ;

: z0=
        f0= >r f0= r> and
        ;

: zvalue
        create  2 floats allot
        does>   z@
        ;

methods zvalue

: to
        postpone literal postpone z!
        ;

: +to
        postpone literal postpone z+!
        ;

end-methods

: znegate
        fswap fnegate fswap fnegate
        ;

: z+
        f>r frot f+ fswap fr> f+
        ;

: z-
        f>r frot f- fnegate fswap fr> f-
        ;

: re
        fdrop
        ;

: im
        fnip
        ;

: conj
        fnegate
        ;

: z*
        flocal d flocal c flocal b flocal a
        a c f* b d f* f- a d f* b c f* f+
        ;

: z2
        fsqr fswap fsqr f+
        ;

: zabs
        z2 fsqrt
        ;

: 1/z
        zdup z2 flocal noemer flocal im flocal re noemer f0=
        if      maxfloat 0.0e
        else    re noemer f/ im fnegate noemer f/
        then
        ;

: z/
        1/z z*
        ;

: zsqrt
        zdup z0=
        if      exit
        then
        flocal zim flocal zre zre fabs zre zim zabs f+ f2/ fsqrt flocal temp
        zre f0<
        if      zim f0<
                if      temp fnegate to temp
                then
                zim temp f/ f2/ temp
        else    temp zim temp f/ f2/
        then
        ;

: zsqr
        zdup z*
        ;

: zln
        flocal im flocal re re f0=
        if      maxfloat 0.0e exit
        then
        re im zabs fln im re f/ fatan re f0<
        if      pi f+
        then
        ;

: zexp
        fswap fexp f>r fdup fcos fr@ f* fswap fsin fr> f*
        ;

privates

: z2/
        2.0e f/ fswap 2.0e f/ fswap
        ;  private

: zsin
        fnegate fswap zexp zdup 1/z z- 2.0e f/ fswap -2.0e f/
        ;

: zcos
        fnegate fswap zexp zdup 1/z z+ z2/
        ;

: zsinh
        zexp zdup 1/z z- z2/
        ;

: zcosh
        zexp zdup 1/z z+ z2/
        ;

deprive
                            \ (* End of Source *) /
