\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Extended memory access 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -extended



code xms-present?               ( -- flag )             \ true is ok
                push    bx
                xor     bx, bx
                mov     ax, # $4300
                int     $2F
                cmp     al, # $80
        0= if
                dec     bx
        then
                next
end-code

privates

create struct   private here #20 dup allot erase

code xmsheader
                push    es
                push    bx
                mov     ax, # $4310
                int     $2F
                mov     struct #18 + es
                mov     struct #16 + bx
                pop     bx
                pop     es
                ret
end-code  private

code ready
                xor     bh, bh
                cmp     ax, # 1
        0= if
                xor     bl, bl
        then
                next
end-code  private

code (xmshandles)
                call    ' xmsheader
                mov     dx, bx
                mov     ah, # $E
                call    far struct #16 + []
                xor     bh, bh
                push    bx
                jmp     ' ready
end-code  private

code xms-version
                call    ' xmsheader
                push    bx
                mov     ah, # 0
                call    far struct #16 + []
                push    ax
                xor     bx, bx
                next
end-code

code xms-available
                call    ' xmsheader
                push    bx
                mov     ah, # 8
                call    far struct #16 + []
                mov     cx, # #1024
                mul     cx
                push    ax
                push    dx
                xor     bh, bh
                next
end-code

code xms-alloc
                call    ' xmsheader
                mov     dx, bx
                pop     ax
                mov     bx, # #1024
                div     bx
                mov     dx, ax
                mov     ah, # 9
                call    far struct #16 + []
                push    dx
                jmp     ' ready
end-code

code xms-dealloc
                call    ' xmsheader
                mov     dx, bx
                mov     ah, # $A
                call    far struct #16 + []
                jmp     ' ready
end-code

code xms-get
                call    ' xmsheader
                mov     di, # struct
                mov     4 [di], bx
                pop     2 [di]
                pop     0 [di]
                pop     #12 [di]
                pop     #14 [di]
                xor     ax, ax
                mov     6 [di], ax
                mov     8 [di], ax
                mov     #10 [di], ax
                mov     ah, # $B
        begin
                xchg    si, di
                call    far #16 [si]
                mov     si, di
                jmp     ' ready
end-code

code xms-put
                call    ' xmsheader
                mov     di, # struct
                mov     #10 [di], bx
                pop     2 [di]
                pop     0 [di]
                pop     6 [di]
                pop     8 [di]
                xor     ax, ax
                mov     4 [di], ax
                mov     #12 [di], ax
                mov     #14 [di], ax
                mov     ah, # $B
        again
end-code

: ?xms
        ?dup
        if      b. true abort" is an XMS error"
        then
        ;

: xms-handles
        #1024 s>d xms-alloc abort" can't request XMS"
        dup (xmshandles) abort" no XMS handles left"
        swap xms-dealloc abort" can't free XMS"
        ;

deprive
                            \ (* End of Source *) /
