\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Double precision operators 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -assembler

        MARKER -double


#cpu @ #386 = [if]

code 2tuck
                push    bx
                pop     ebx
                pop     eax
                push    ebx
                push    eax
                push    ebx
                pop     bx
                next    end-code

[else]

code 2tuck
                pop     ax
                pop     cx
                pop     dx
                push    ax
                push    bx
                push    dx
                push    cx
                push    ax
                next    end-code

[then]

#cpu @ #386 = [if]

code 4dup
                push    bx
                pop     edx
                pop     eax
                push    eax
                push    edx
                push    eax
                push    edx
                pop     bx
                next    end-code

[else]

code 4dup
                pop     ax
                pop     cx
                pop     dx
                push    dx
                push    cx
                push    ax
                push    bx
                push    dx
                push    cx
                push    ax
                next    end-code

[then]

code d0>
                pop     ax
                cmp     bx, # 0
                jle     1 $
        0 $:    mov     bx, # true
                next
        1 $:    jnz     2 $
                test    ax, ax
                jnz     0 $
        2 $:    xor     bx, bx
                next    end-code

privates

: (dminmax)
        if      2nip
        else    2drop
        then ;  private

: dumax
        4dup du< (dminmax) ;

: dumin
        4dup du> (dminmax) ;

code m-
                neg     bx
                jmp     ' m+    end-code

code qnegate
                pop     dx
                pop     cx
                pop     ax
                not     ax
                not     cx
                not     dx
                not     bx
                add     ax, # 1
                adc     cx, # 0
                adc     dx, # 0
                adc     bx, # 0
                push    ax
                push    cx
                push    dx
                next    end-code

: ?qnegate
        0<
        if      qnegate
        then ;

: qabs
        dup ?qnegate ;

: d>q
        s>d dup ;

#cpu @ #386 = [if]

code dum*
                rol     ebx, # 16
                pop     bx
                pop     eax
                rol     eax, # 16
                mul     ebx
                rol     eax, # 16
                push    eax
                push    dx
                rol     edx, # 16
                mov     bx, dx
                next    end-code

[else]

code dum*
                push    bx
                push    bp
                mov     bp, sp
                xor     cx, cx
                xor     bx, bx
                mov     ax, 8 [bp]
                mul     4 [bp]
                push    ax
                push    dx
                mov     ax, 8 [bp]
                mul     2 [bp]
                add     -4 [bp], ax
                adc     cx, dx
                adc     bx, # 0
                mov     ax, 6 [bp]
                mul     4 [bp]
                add     -4 [bp], ax
                adc     cx, dx
                adc     bx, # 0
                mov     ax, 6 [bp]
                mul     2 [bp]
                add     ax, cx
                adc     dx, bx
                mov     4 [bp], ax
                mov     2 [bp], dx
                pop     6 [bp]
                pop     8 [bp]
                pop     bp
                pop     bx
                next    end-code

[then]

#cpu @ #386 = [if]

code dm*
                rol     ebx, # 16
                pop     bx
                pop     eax
                rol     eax, # 16
                imul    ebx
                rol     eax, # 16
                push    eax
                push    dx
                rol     edx, # 16
                mov     bx, dx
                next    end-code

[else]

: dm*
        dup>r dabs 2swap dup>r dabs dum* 2r> xor ?qnegate ;

[then]

' dm* alias d*q

#cpu @ #386 = [if]

code dum/mod
                rol     ebx, # 16
                pop     bx
                pop     edx
                rol     edx, # 16
                pop     eax
                rol     eax, # 16
                div     ebx
                rol     edx, # 16
                push    edx
                push    ax
                rol     eax, # 16
                mov     bx, ax
                next    end-code

[else]

code dum/mod
                mov     dx, bx
                pop     ax
                xchg    sp, bp
                mov     bx, 0 [bp]
                mov     cx, # $20
        1 $:    shl     6 [bp], # 1
                rcl     4 [bp], # 1
                rcl     2 [bp], # 1
                rcl     0 [bp], # 1
                jae     2 $
                sub     2 [bp], ax
                sbb     0 [bp], dx
                jmp     3 $
        2 $:    sub     2 [bp], ax
                sbb     0 [bp], dx
                jae     3 $
                add     2 [bp], ax
                adc     0 [bp], dx
                sub     6 [bp], # 1
                sbb     4 [bp], # 0
        3 $:    inc     6 [bp]
                jnz     4 $
                inc     4 [bp]
        4 $:    loop    1 $
                xchg    sp, bp
                pop     ax
                pop     bx
                pop     cx
                pop     dx
                push    bx
                push    ax
                push    dx
                mov     bx, cx
                next    end-code

[then]

#cpu @ #386 = [if]

code dm/mod
                rol     ebx, # 16
                pop     bx
                pop     edx
                rol     edx, # 16
                pop     eax
                rol     eax, # 16
reveal  ahead
s" d*/mod" head, reveal
                rol     ebx, # 16
                pop     bx
                pop     ecx
                rol     ecx, # 16
                pop     eax
                rol     eax, # 16
                imul    ecx
        ahead
s" d/mod" head, reveal
                rol     ebx, # 16
                pop     bx
                pop     eax
                rol     eax, # 16
                cdq
        then
        then
                idiv    ebx
                rol     edx, # 16
                push    edx
                push    ax
                rol     eax, # 16
                mov     bx, ax
                next    end-code

[else]

: dm/mod
        2dup 2>r pluck over xor >r 2>r qabs 2r@ dabs dum/mod
        2swap 2r> nip 0<
        if      dnegate
        then
        2swap r> 0<
        if      dnegate
        then
        r>drop r>drop
        ;

: d*/mod
        2>r d*q 2r> dm/mod ;

: d/mod
        2>r d>q 2r> dm/mod ;

[then]

: d/
        d/mod 2nip ;

: dmod
        d/mod 2drop ;

: dmu/mod
        2>r 0 0 2r@ dum/mod 2r> 2swap 2>r dum/mod 2r> ;

#cpu @ #386 = [if]

code um*/mod
                movzx   ebx, bx
                pop     cx
                movzx   ecx, cx
                pop     eax
                rol     eax, # 16
                mul     ecx
                div     ebx
                push    dx
                push    ax
                rol     eax, # 16
                mov     bx, ax
                next    end-code

[else]

code ts/
                pop     dx
                pop     ax
                div     bx
                mov     cx, ax
                pop     ax
                div     bx
                push    dx
                push    ax
                mov     bx, cx
                next    end-code        private

code ds*
                pop     di
                pop     ax
                mul     bx
                push    ax
                mov     cx, dx
                mov     ax, di
                mul     bx
                add     ax, cx
                adc     dx, # 0
                push    ax
                mov     bx, dx
                next    end-code        private

: um*/mod
        >r ds* r> ts/ ;

[then]

: um*/
        um*/mod rot drop ;

code u*/mod
                pop     ax
                pop     cx
                mul     cx
                div     bx
                push    dx
                mov     bx, ax
                next    end-code

: u*/
        u*/mod nip ;

#cpu @ #386 = [if]

code du*/mod
                rol     ebx, # 16
                pop     bx
                pop     ecx
                rol     ecx, # 16
                pop     eax
                rol     eax, # 16
                mul     ecx
                div     ebx
                rol     edx, # 16
                push    edx
                push    ax
                rol     eax, # 16
                mov     bx, ax
                next    end-code

[else]

: du*/mod
        2>r dum* 2r> dum/mod ;

[then]

: du*/
        du*/mod 2nip ;

: d*/
        d*/mod 2nip ;

deprive
                            \ (* End of Source *) /
