\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Plasma fractals 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics

        ?DEF -plasma [IF] -plasma [THEN]

        MARKER -plasma



DOC
   See Fractal Landscapes,
   Phil Koopman,
   Forth Dimensions IX, 1 page 12
ENDDOC


' vres+ is graphics

: newcolor
\       s" 2 choose 2* 1- * + " evaluate
\       ;  immediate
\       2 choose 2* 1- * +
        11 choose 5 - * +
        ;

code mean       ( n1 n2 -- n3 )
                pop     ax
                add     bx, ax
\               inc     bx
                shr     bx, # 1
                next
end-code

: calculate-surface
        local nivo local delta
        local y1 local x1 local y0 local x0

        x0 x1 + 2/ y0 get-dot 0=
        if      x0 y0 get-dot x1 y0 get-dot mean    -- lo
                delta newcolor to color
                x0 x1 + 2/ y0 plot
        then

        x1 y0 y1 + 2/ get-dot 0=
        if      x1 y0 get-dot x1 y1 get-dot mean    -- ro
                delta newcolor to color
                x1 y0 y1 + 2/ plot
        then

        x0 y0 y1 + 2/ get-dot 0=
        if      x0 y0 get-dot x0 y1 get-dot mean    -- lb
                delta newcolor to color
                x0 y0 y1 + 2/ plot
        then

        x0 x1 + 2/ y1 get-dot 0=
        if      x0 y1 get-dot x1 y1 get-dot mean    -- rb
                delta newcolor to color
                x0 x1 + 2/ y1 plot
        then

        x0 x1 + 2/ y0 y1 + 2/ get-dot 0=
        if      x0 y0 get-dot x1 y1 get-dot mean    -- midden
                delta newcolor to color
                x0 x1 + 2/ y0 y1 + 2/ plot
        then

        nivo 1- if
                x0 y0 x0 x1 + 2/ y0 y1 + 2/ delta 2/ nivo 1- recurse -- lo
                x0 x1 + 2/ y0 x1 y0 y1 + 2/ delta 2/ nivo 1- recurse -- ro
                x0 y0 y1 + 2/ x0 x1 + 2/ y1 delta 2/ nivo 1- recurse -- lb
                x0 x1 + 2/ y0 y1 + 2/ x1 y1 delta 2/ nivo 1- recurse -- rb
        then
        ;

: plasma
        text?
        if      graphics
        then
\       s" plasma" (loadpalette)
        grijs
        0 0 xmax ymax (maxc) 1+
        case getmode
                $13 of  9       endof
                $5F of  #10     endof
                kleur
                $4 of   9       endof
                $6 of   9       endof
                #10 swap
        endcase
\       3 pick 3 pick = +
        calculate-surface
        ;


                            \ (* End of Source *) /
