\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Mandelbrot fractals 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -fixed

        ?DEF -mandel [IF] -mandel [THEN]

        MARKER -mandel


' vres+ is graphics

: zetpunt
        2* 2* (maxc) and to color 2dup plot negate plot ;

(
4096 constant iteraties
40 constant n1
)
32 constant iteraties
240 constant n1

n1 constant n2

 0.4e fconstant xs
 0.4e fconstant ys
-1.4011e fconstant xofs

(
 0.08e fconstant xs
 0.08e fconstant ys
-1.6181e fconstant xofs
)

(
1.5e fconstant xs
1.5e fconstant ys
-0.5e fconstant xofs
)

fvalue a
fvalue b
fvalue u
fvalue v
fvalue w
fvalue x
fvalue y

: main
        relplot n1 n1 negate
        do      i s>f n1 s>f f/ xs f* xofs f+ to a n2 0
                do      i s>f n2 s>f f/ ys f* to b
                        a fsqr b fsqr f+ 4.0e f* fdup to u
                        a 2.0e f* f- 0.25e f+ to v
                        u a 8.0e f* f+ [ -15e 4e f/ ] fliteral f<
                        if      j i 0 zetpunt
                        else    v fdup fsqrt f- 2.0e a f* f+ 0.5e f<
                                if      j i 0 zetpunt
                                else    a to x b to y iteraties 0
                                        do      x fsqr to u
                                                y fsqr to v
                                                2.0e x y f* f* to w
                                                u v f- a f+ to x
                                                w b f+ to y
                                                u v f+ 255.0e f>
                                                if      k j i 1 + zetpunt leave
                                                then
                                        loop
                                then
                        then
                loop
                stop? ?leave
        loop ;

: go
        text?
        if      graphics
        then
\       s" plasma" (loadpalette)
        grijs main
        change-colors ;

                            \ (* End of Source *) /
