\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Julia fractals 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -fixed

        ?DEF -julia [IF] -julia [THEN]

        MARKER -julia



' vres+ is graphics

fvalue a
fvalue b

: rommelen
        frandom 2.0e f* 1.0e f- to a frandom 2.0e f* 1.0e f- to b ;

2.0e fconstant p1
2.0e fconstant p2
1.0e fconstant p1
1.0e fconstant p2

fvalue x
fvalue y
fvalue x1
fvalue y1

1000.0e fconstant factor
1e factor f/ fconstant factor'

\ 160 constant schaal
\ 40 constant schaal
\ 80 constant schaal
\ 20 constant iteraties

\ 50 value schaal
150 value schaal
1024 value iteraties

DOC
: go
        rommelen relplot text?
        if      graphics
\               s" plasma" (loadpalette)
                grijs
        then
        true local flag
        home a 12 f.r b 12 f.r
        schaal 3 2 */ 0
        do      schaal 3 2 */ dup negate 1+
                do      j s>f schaal s>f f/ p1 f* to x
                        i s>f schaal s>f f/ p2 f* to y
                        true to flag iteraties 1
                        do      x fsqr y fsqr f- a f+ to x1
                                2.0e x f* y f* b f+ to y1
                                i
                                x fsqr y fsqr f+ factor f>
                                if      false to flag leave
                                then
                                x x1 f- fsqr y y1 f- fsqr f+ factor' f<
                                if      false to flag leave
                                then
                                drop
                                x1 to x y1 to y
                        loop
                        flag
                        if      0
                        then
\                       negate (maxc) ( 2/ ) and
\                       negate 2 lshift (maxc) and
\                       (maxc) and
                        128 + (maxc) and
                        to color j i negate plot
                        j negate i plot
                loop
        loop ;
ENDDOC

: go
        rommelen relplot text?
        if      graphics
\               s" plasma" (loadpalette)
                grijs
        then
        true local flag
        home a 12 f.r b 12 f.r
        schaal 3 2 */ 0
        do      schaal 3 2 */ dup negate 1+
                do      j s>f schaal s>f f/ p1 f* to x
                        i s>f schaal s>f f/ p2 f* to y
                        true to flag iteraties 1
                        do      x fsqr y fsqr f- a f+ to x1
                                2.0e x f* y f* b f+ to y1
                                i
                                x fsqr y fsqr f+ factor f>
                                if      false to flag leave
                                then
                                x x1 f- fsqr y y1 f- fsqr f+ factor' f<
                                if      false to flag leave
                                then
                                drop
                                x1 to x y1 to y
                        loop
                        flag
                        if      0
                        then
                        128 + (maxc) and
                        to color j i negate plot
                        j negate i plot
                loop
                stop? ?leave
        loop ;


                            \ (* End of Source *) /
