\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Display iconfiles from Windows 3.x 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics

        MARKER -icons


126 constant offset
512 constant lengte

create tabel    lengte allot

6 value schaal
2 value rand

code 16*
                shl     bx, # 4
                next    end-code

code 16/mod
                mov     ax, bx
                and     ax, # 15
                push    ax
                shr     bl, # 4
                next    end-code

code schaal*
                imul    bx, adr schaal
                next    end-code

create kleuren
        0 c,  4 c,  2 c,  6 c,
        1 c,  5 c,  3 c,  7 c,
        8 c, 12 c, 10 c, 14 c,
        9 c, 13 c, 11 c, 15 c,

: kleur
        15 and kleuren + c@ to color ;

: tekenen
        32 0
        do      16 0
                do      j 16* i + tabel + c@ 16/mod kleur
                        i 2* schaal*
                        j schaal*
                        over schaal rand - + over schaal rand - + fillbox
                        kleur
                        i 2* 1+ schaal*
                        j schaal*
                        over schaal rand - + over schaal rand - + fillbox
                loop
        loop ;

: (lees)
        r/o bin open-file abort" Kan ikoonbestand niet openen" local handle
        offset s>d handle reposition-file abort" Kan pointer niet verplaatsen"
        tabel lengte tuck handle read-file
        -rot <> or abort" Kan ikoon niet lezen"
        handle close-file abort" Kan ikoonbestand niet sluiten" ;

: lezen
        s" .ico" bl word append here count (lees) ;

: ikoon
        lezen tekenen ;

: alle
        s" *.ico" find-first-file
        if      exit
        then
        begin   home eol found-file 2dup type
                (lees) tekenen find-next-file stop? or
        until ;


                            \ (* End of Source *) /
