\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Fractal trees 
\ CATEGORY    : Graphics 
\ AUTHOR      : Kees Moerman 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -turtle



        MARKER -forest



DOC
  Tekenen van bomen en bossen
  Kees Moerman in: Vijgeblad nr 27

Gebruik:

HRES, VRES, en dergelijke voor een grafisch scherm.
KERS, LOOF, GROOT of GROOT2 om een type boom te kiezen.
HH tekent een vertikale boom.
VV draait de tekening een kwartslag naar rechts, handig op een schermkopie.
(Eerst GRAPHICS in DOS draaien).
n BOS tekent een woudje met n bomen.

ENDDOC


relplot

4 constant thickness

thickness 4 = [if]

: correction
        90 left over 3 and forward 90 right ;
\ alleen redelijk als THICKNESS vier is...

[else]

: correction ;  immediate
\ doe niets

[then]

thickness 1 <> [if]
: lijn
        over forward dup thickness 99 within
        if      tuck 0
                ?do     90 left thickness forward 90 right dup back dup forward
                loop
                drop 90 right thickness * forward 90 left
        else    2drop
        then ;
[else]
: lijn
        drop forward ;
[then]

0 value hoek
0 value subhoek
0 value dlengte
0 value lengte
0 value dikte
0 value ddikte
0 value blad

: reduce
        dup>r abs >r
        ddikte r@ - ddikte */ swap
        dlengte r> - dlengte */ swap r> ;

vector splits

: (use0)
        over 7071 10000 */ over 1- 2dup -45 -rot 45 ;

: use0
        ['] (use0) is splits ;

: (use1)
        over 2* 3 / over 1- 2dup 40 choose negate -rot 40 choose ;

: use1
        ['] (use1) is splits ;

: (use2)
        2dup 2dup 2>r hoek 2* 1+ choose hoek - dup>r ?dup
        if      dup 0<
                if      subhoek +
                else    subhoek -
                then
        else    subhoek 2* 1+ choose subhoek -
        then
        reduce r> 2r> rot reduce ;

: use2
        ['] (use2) is splits ;  use2

: een-blad
        blad
        if      randcolor
                8 0
                do      blad forward 45 left
                loop
                white
        then ;

: (boom)
        dup 0>
        if      correction 2dup lijn splits
                dup>r left recurse r> right
                dup>r left recurse r> right
                drop 180 left forward 180 right
        else    2drop een-blad
        then ;

: boom
        2dup to dikte to lengte 0 -1600 setturtle
        90 left 1000 forward 2000 back 1000 forward 90 right 2dup lijn (boom) ;

: vboom
        2dup to dikte to lengte -1800 0 setturtle 90 right
        90 left 1000 forward 2000 back 1000 forward 90 right 2dup lijn (boom) ;

: hh
        page lengte dikte boom ;

: vv
        page lengte dikte vboom ;

: =boom
        to blad to ddikte to dikte to lengte to dlengte to subhoek to hoek ;

\               hoek  dhoek dlen  len   dikte ddik  blad
: kers
        20      40      100     500     10      120     10 =boom ;

: loof
        10      40      150     300     10      150     25 =boom ;

: groot
        10      40      150     200     20      110     0  =boom ;

: groot2
        40      50      150     300     20      150     0  =boom ;

: spar
        10      70      150     200     20      120     0  =boom ;

: bos
        0
        ?do     0 phi! 4000 choose 2000 - -1500 setturtle
                case 3 choose
                        0 of    kers    endof
                        1 of    loof    endof
                        groot2
                endcase
                dikte 80 100 */ to dikte lengte dikte 2dup lijn (boom)
        loop ;


                            \ (* End of Source *) /
