\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Elektrostatisch veld
\ CATEGORY    : Natuurkunde
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : September 02, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -fixed

        ?DEF -elektra [IF] -elektra [THEN]


        MARKER -elektra


relplot

decimal

: 1/f
        fdup f0=
        if      fdrop 1e exit
        then
        1e fswap f/
    ;

50e fconstant schaal

schaal 1/f fconstant delta

14 constant items

create table
         1.0000e schaal f* f>s ,  0.0000e schaal f* f>s ,  1e f,
         0.5000e schaal f* f>s ,  0.8660e schaal f* f>s ,  1e f,
        -0.5000e schaal f* f>s ,  0.8660e schaal f* f>s ,  1e f,
        -1.0000e schaal f* f>s ,  0.0000e schaal f* f>s ,  1e f,
         0.5000e schaal f* f>s , -0.8660e schaal f* f>s ,  1e f,
        -0.5000e schaal f* f>s , -0.8660e schaal f* f>s ,  1e f,

         0.5000e schaal f* f>s ,  0.8660e -3e f* schaal f* f>s ,  1e f,
        -0.5000e schaal f* f>s ,  0.8660e -3e f* schaal f* f>s ,  1e f,
         1.0000e schaal f* f>s ,  0.8660e -2e f* schaal f* f>s ,  1e f,
        -1.0000e schaal f* f>s ,  0.8660e -2e f* schaal f* f>s ,  1e f,

        -2.0000e schaal f* f>s ,  0.0000e schaal f* f>s ,  1e f,
        -2.5000e schaal f* f>s ,  0.8660e schaal f* f>s ,  1e f,
        -2.0000e schaal f* f>s ,  0.8660e 2e f* schaal f* f>s ,  1e f,
        -1.0000e schaal f* f>s ,  0.8660e 2e f* schaal f* f>s ,  1e f,

: .x        ( x1 -- x2 )
        [ 2 cells float+ ] literal * table + @
    ;

: .y        ( x1 -- x2 )
        [ 2 cells float+ ] literal * table + cell+ @
    ;

: .e        ( x -- r )
        [ 2 cells float+ ] literal * table + cell+ cell+ f@
    ;

: calculate     ( x y ix -- r )
        locals| ix y x |
        ix .x x - ?dup
        if      s>f delta f* fsqr
                ix .y y - ?dup
                if      s>f delta f* fsqr f+
                        1/f ix .e f* exit
                then
                fdrop
        then
        0e
    ;

: go
        text?
        if      graphics
        then
        home
        200 -200
        do      200 -200
                do      0e items 0
                        do      j k i calculate f+
                        loop
                        f>s to color
                        i j plot
                loop
                stop? ?leave
        loop
    ;



                            \ (* End of Source *) /
