\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Printing texts via ANSI.SYS 
\ CATEGORY    : MS-DOS 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -dosecho



-- IMPLEMENTATION
privates

create buffer                           private \ Output buffer
        here #256 dup allot erase               \ Allocate space

: translate     ( c-addr1 u1 -- c-addr2 u2 )    \ Change string
        s" echo " buffer place                  \ Prepare string
        bounds                                  \ -- c-addr1+u1 c-addr1
        ?do     i c@ '_' =                      \ If '_'
                if      ^[                      \ Replace with ^[
                else    i c@                    \ Use character itself
                then
                buffer append-char              \ Store in buffer
        loop
        buffer count                            \ Return string
    ;  private

-- INTERFACE

: putline       ( c-addr u -- )                 \ Call DOS with string
        translate system
    ;

-- ENDMODULE
deprive

-- PROGRAM
: go            ( -- )                          \ Test program
        ?at                                     \ Save cursor position
        s" _[12;25H_[5;31;42m Hallo, dit is een test _[0m" putline
        at-xy                                   \ Restore cursor position
    ;

                            \ (* End of Source *) /
