\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Display catagories of words 
\ CATEGORY    : Wordlists 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        ?DEF -aliassen [IF] -aliassen [THEN]

        MARKER -aliassen


privates

also internal

: .flags
        dup =ansi and
        if      'A'
        else    bl
        then
        emit dup =immediate and
        if      'I'
        else    bl
        then
        emit dup =comp and
        if      'C'
        else    bl
        then
        emit dup =private and
        if      'P'
        else    bl
        then
        emit dup =hidden and
        if      'H'
        else    bl
        then
        emit
        drop space
        ;  private

: ?nil
        ?dup
        if      h. exit
        then
        5 spaces
        ;  private

: .name
        cr
        ." dea=" dup h.
        ." link=" dup h@ h.
        ." flag=" dup head>flags h@ .flags
        ." forg=" dup head>forget h@ ?nil
        ." code=" dup head> h.
        ''' emit .head ''' emit space
    ;

: get-word
        stop?
        if      false exit
        then
        temporary @
        if      temporary @ dup h@ temporary ! true exit
        then
        false
        ;  private

: another'
        begin   get-word dup
        while   ansi @
        while   over head>flags h@ =ansi and 0=
        while   2drop
        repeat
        then
        then
        ;  private

: (alia)
        begin   another'
        while   dup dup head> >head <>
                if      dup .name
                        head> dup >head .name cr
                then
                drop
        repeat
        ;  private

: (fgts)
        begin   another'
        while   dup head>forget h@
                if      .name
                else    drop
                then
        repeat
        ;  private

: (flag)
        begin   another'
        while   dup head>flags h@
                if      .name
                else    drop
                then
        repeat
        ;  private

: (comp)
        begin   another'
        while   dup head>flags h@ =comp and
                if      .name
                else    drop
                then
        repeat
        ;  private

: (ansi)
        begin   another'
        while   dup head>flags h@ =ansi and
                if      .name
                else    drop
                then
        repeat
        ;  private

: (-ansi)
        begin   another'
        while   dup head>flags h@ =ansi and 0=
                if      .name
                else    drop
                then
        repeat
        ;  private

: (all)
        begin   another'
        while   .name
        repeat
        ;  private

: .alia
        every?
        if      voc-link
                begin   dup cr dup 8 spaces .vocname
                        voc@ temporary ! (alia) @ ?dup 0=
                until
        else    get-context voc@ temporary ! (alia)
        then
        ;

: .fgts
        every?
        if      voc-link
                begin   dup cr dup 8 spaces .vocname
                        voc@ temporary ! (fgts) @ ?dup 0=
                until
        else    get-context voc@ temporary ! (fgts)
        then
        ;

: .flag
        every?
        if      voc-link
                begin   dup cr dup 8 spaces .vocname
                        voc@ temporary ! (flag) @ ?dup 0=
                until
        else    get-context voc@ temporary ! (flag)
        then
        ;

: .comp
        every?
        if      voc-link
                begin   dup cr dup 8 spaces .vocname
                        voc@ temporary ! (comp) @ ?dup 0=
                until
        else    get-context voc@ temporary ! (comp)
        then
        ;

: .ansi
        every?
        if      voc-link
                begin   dup cr dup 8 spaces .vocname
                        voc@ temporary ! (ansi) @ ?dup 0=
                until
        else    get-context voc@ temporary ! (ansi)
        then
        ;

: -ansi
        every?
        if      voc-link
                begin   dup cr dup 8 spaces .vocname
                        voc@ temporary ! (-ansi) @ ?dup 0=
                until
        else    get-context voc@ temporary ! (-ansi)
        then
        ;

: .all
        every?
        if      voc-link
                begin   dup cr dup 8 spaces .vocname
                        voc@ temporary ! (all) @ ?dup 0=
                until
        else    get-context voc@ temporary ! (all)
        then
        ;

deprive

previous

                            \ (* End of Source *) /
