\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Display wordlists in alphabetic or special order 
\ CATEGORY    : Wordlists  
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -arrays

        MARKER -alfabet

        NEEDS -quicksort



DOC
   Sorting of vocabularies according to Wil Baden, FD VI,5
ENDDOC


vector .names

privates

variable total          total off               private \ count of names
variable comparand                              private

array nametable                                 private \ here are the words

: hc@           ( h-addr -- char )                      \ fetch byte
        hseg swap c@x
        ;  private

: ?cal          ( dea -- xt )                           \ get execution token
        head> dup c@ $E9 =                              \ is it a call
        if      >call                                   \ then creator
        then
        ;  private

: alphabeticnames                                       \ display words
        cr false local token total @ 0
        ?do     i nametable dup head>name char+
                hc@ dup token <>                        \ different token
                if      cr ."   '" dup emit ''' emit cr \ tell it
                        to token                        \ new token
                else    drop
                then
                ?head stop? ?leave                      \ print name
        loop
        ;  private

: sizenames                                             \ display names
        cr false local token total @ 0
        ?do     i nametable dup head>name
                hc@ dup token <>                        \ different token
                if      cr ."   " dup .dec cr           \ tell it
                        to token                        \ new token
                else    drop
                then
                ?head stop? ?leave                      \ print name
        loop
        ;  private

: callnames                                             \ display names
        cr false local token total @ 0
        ?do     i nametable dup ?cal dup token <>       \ different token
                if      cr ."   " dup h. cr             \ tell it
                        to token                        \ new token
                else    drop
                then
                ?head stop? ?leave                      \ print name
        loop
        cr token h.
        ;  private

: alphabeticcmp         ( dea1 dea2 -- flag )           \ compare
        head>name dup hc@ >r 1+ swap                    \ get count and address
        head>name dup hc@ >r 1+ swap                    \ same with other word
        2r> min 0                                       \ minimal compare
        do      over i + hc@ over i + hc@ - dup
                if      0< nip nip unloop exit          \ first is less
                then
                drop
        loop
        1- hc@ swap 1- hc@ >                            \ first is less
        ;  private

: sizecmp               ( dea1 dea2 -- flag )           \ compare
        over head>name hc@ over head>name hc@ - ?dup    \ subtract counts
        if      0< -rot 2drop                           \ different
        else    alphabeticcmp                           \ equal, other method
        then
        ;  private

: callcmp               ( dea1 dea2 -- flag )           \ compare
        over ?cal over ?cal 2dup u<                     \ compare xt's
        if      2drop 2drop true                        \ first less
        else    =
                if      alphabeticcmp                   \ equal, other method
                else    2drop false                     \ failed
                then
        then
        ;  private

:noname
        comparand @
        ;  is qs_comparand

:noname
        comparand !
        ;  is qs_save

:noname
        nametable
        ;  is qs_get

:noname
        to nametable
        ;  is qs_put

: cleartable                                            \ clear array
        total off
        reset nametable
        ;

: alphabetic                                            \ method
        ['] alphabeticnames is .names
        ['] alphabeticcmp is qs_compare
        ;

: size                                                  \ method
        ['] sizenames is .names
        ['] sizecmp is qs_compare
        ;

: calls                                                 \ method
        ['] callnames is .names
        ['] callcmp is qs_compare
        ;

: sort                                                  \ the sort program
        timer-reset
        total @ 0= abort" Nothing to sort"
        0 total @ 1- quick
        .elapsed
        ;

?def decompiler [if]

decompiler

: .all
        total @ 0
        ?do     i nametable head> (see)
                stop? ?leave
        loop
        ;

forth

[then]

: vertical      ( -- )
        cr total @ 0
        ?do     i nametable .head cr
                stop? ?leave
        loop
        ;

: (addvoc)      ( -- )
        begin   another
        while   total @ to nametable total incr
        repeat
        ;  private

\ Use this like ROOT-WORDLIST =ADDVOC
\ Because NAMES ROOT is not possible
: =addvoc       ( wid -- )                              \ special wordlists
        voc@ temporary ! (addvoc)
        ;

: addvoc        ( ccc -- )                              \ another wordlist
        ' dup >call [ ' forth >call ] literal <>
        abort" Only vocabularies can be added"
        >body =addvoc
        ;

: allvocs       ( -- )                                  \ handle all wordlists
        cleartable voc-link
        begin   regular?
                if      dup =addvoc
                then
                @ ?dup 0=
        until
        ;

: names         ( ccc -- )                              \ one wordlist
        cleartable addvoc
        ;

alphabetic                                              \ choose method

deprive


: .help
        CR
        CR ."      CLEARTABLE     clears the sortarray."
        CR ."      ALLVOCS        put all vocabularies in the array to sort."
        CR ."      NAMES voc.     put only one vocabulary in the array."
        CR ."      ADDVOC voc.    add a next vocabulary."
        CR ."      ALPHABETIC, SIZE, CALLS  are the sort orders."
        CR ."      SORT           does the sorting."
        CR ."      .NAMES         lists the words."
        CR ."      VERTICAL       lists them, each on a new line."
[ ?def decompiler ] [if]
        CR ."      .ALL           decompiles the words in the sorted order."
[then]
     ;

                .HELP CR

                            \ (* End of Source *) /
