\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : RCA COSMAC 1802 microprocessor 
\ CATEGORY    : Simulations 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -1802lib

        ?DEF -1802 [IF] -1802 [THEN]

        MARKER -1802


hex

slow
reset
clearlabels
trgseg 2@ swap 0 fillp

FF30 == __int
        begin
                dec     2
                sav
                dec     2
                stxd
                shlc
                str     2

                ghi     F
                shr
                glo     F
                shrc
                plo     F
                ghi     F
                shrc
                phi     F

                ldxa
                shr
                ldxa
                ret
        again
asm;

label __jsr
        begin
                ghi     pc:
                phi     tmp:
                glo     pc:
                plo     tmp:
                lda     tmp:
                phi     pc:
                lda     tmp:
                plo     pc:
                dec     sp:
                glo     tmp:
                stxd
                ghi     tmp:
                str     sp:
                sep     pc:
        again
asm;

label __rts
        begin
                ldxa
                phi     pc:
                ldxa
                plo     pc:
                sep     pc:
        again
asm;

400 == marx
        begin
                ghi     E
                shl
                glo     E
                shlc
                plo     E
                ghi     E
                shlc
                phi     E
                sex     2
                irx
                ret
        again
asm;

100 == _main
                ldi     0
                phi     E
                plo     E
                ldi     marx split
                phi     D
                ldi
                plo     D
        begin
\               jsr     200
                mark
                sep     D
                dec     2
                db      68
                ds      s" Hello, World"
                dw      0D0A
        again
asm;

label sub1
                glo     E
                adi     1
                plo     E
                rts
asm;

label sub2
                jsr     sub1
                ghi     E
                adi     1
                phi     E
                ldi     10
        begin
                seq
                smi     1
                req
        0= until
                rts
asm;

200 == sub3
                jsr     sub1
                jsr     sub2
                rts
asm;

0 org
                dis
                db      0
                ldi     __int split
                phi     int:
                ldi
                plo     int:
                ldi     B000 split
                phi     sp:
                ldi
                plo     sp:
                ldi     C000 split
                phi     rp:
                ldi
                plo     rp:
                ldi     __jsr split
                phi     jsr:
                ldi
                plo     jsr:
                ldi     __rts split
                phi     rts:
                ldi
                plo     rts:
                ldi     0
                phi     F
                ldi     1
                plo     F
                ldi     _main split
                phi     pc:
                ldi
                plo     pc:
                ret
                db      sp: 10 * pc: +
asm;

1802asm

: ds:
        10 0
        do      bl parse-word number? 1 <> abort" Ken niet"
                c,-t ?stack
        loop
        ;

forth

2910 == [write]
        ds:     F8 7C A7 93 B7 B8 F8 27 A8 49 B5 09 A5 29 29 29
        ds:     49 BE 09 AE D8 30 33 F8 1D B0 F8 04 B4 D7 20 90
        ds:     3A 29 D3 BF F8 52 A8 F8 82 D8 4E D8 25 95 3A 3A
        ds:     85 3A 3A F8 63 D8 9F FA 7F D8 F8 27 A8 D8 C0 15
asm;

: go
        page
        begin   20 20 choose + steps interrupt stop?
        until
        home ;

: fill-memory
        [ 1802asm ]
        400 to here-t
        100 0
        do      i c,-t 0 ,-t
        loop
        [ forth ] ;

                            \ (* End of Source *) /
