\ BrainFuck to 4tH Converter - Copyright 2004,2009 J.L. Bezemer
\ You can redistribute this file and/or modify it under
\ the terms of the GNU General Public License

78 constant rmargin

include lib/print.4th
include lib/row.4th

create BFop
  char > , ," char+"
  char < , ," char-"
  char + , ," dup c@ 1+ over c!"
  char - , ," dup c@ 1- over c!"
  char . , ," dup c@ emit"
  char , , ," char> over c!"
  char [ , ," begin dup c@ while" 
  char ] , ," repeat"
  NULL ,

: Preprocess
  ." ( This file was generated by BF24tH - Copyright 2004 J.L. Bezemer)" cr
  cr
  ." 10 constant EOL                        \ end of line character" cr
  ." 30000 constant #BFMemory" cr
  ." #BFMemory string BFmemory              \ BF memory" cr
  cr
  ." : char>                                ( t m -- t m c)" cr
  ."   >r dup tib =                         \ save pointer, if start buffer" cr
  ."   if refill else true then             \ then refill the buffer" cr
  ."   if                                   \ if read is successful" cr
  ."     dup c@ dup 0=                      \ get character, if end of string" cr
  ."     if EOL + nip tib swap              \ return LF and signal end of buffer" cr
  ."     else swap char+ swap               \ else increment pointer" cr
  ."     then" cr
  ."   else 0                               \ else return NULL" cr
  ."   then r> swap                         \ restore pointer and swap char" cr
  ." ;" cr
  nl
  s" : BF" print
;

: PostProcess bl show [char] ; show cr cr ." tib BFMemory BF" cr ;
: Usage abort" Usage: bf24th bf-source 4th-source" ;
: Read-file pad 1 accept ;

: Process
  pad c@ BFop 2 num-key row
  if nip cell+ @c count print else drop drop then
;

include lib/convert.4th


