:set symbol="msg_list" value="event list"
:set symbol="mark_menu" value="File"
.*
.chap &drnt for Win32
.*
.if &e'&dohelp eq 0 .do begin
.section Introduction
.do end
.*
.np
.ix 'debugger' 'post-mortem'
.ix '&drnt'
The 32-bit version of &drnt is a post-mortem debugger for Win32
applications.
When an exception occurs in a program, a post-mortem debugger allows
you, after the fact, to examine the state of both the program and the
system in order to determine the cause of the exception.
In addition to being a debugging tool, &drnt is a system utility that
enables you to examine and modify process information.
.begnote
.note Note:
Use the 32-bit version of &drnt to monitor native (Win32) applications
running under Windows 9x and NT based operating systems.
Use the 16-bit version of &drnt to monitor 16-bit Windows (Win16)
applications.
.endnote
.*
.section Using &drnt
.*
.np
This section discusses the following topics:
.begbull $compact
.bull
Starting &drnt
.bull
Quitting &drnt
.bull
The &drnt Menu Bar
.endbull
.np
&drnt is designed to be used effectively while minimized. You can
access some of &drnt's main functionality using the system menu while
the application is minimized. This includes the Log Current State, Log
Options, and Process Control menu items.
.*
.beglevel
.*
.section Starting &drnt
.*
.np
.ix 'start' '&drnt'
.ix '&drnt' 'start'
To start &drnt double click on the &drnt icon. This opens the &drnt
window.
.begnote
.note Note:
You can run only one instance of &drnt at a time.
.endnote
.*
.section Quitting &drnt
.*
.np
.ix '&drnt' 'leave'
.ix 'quit' '&drnt'
To exit &drnt, choose Exit from the File menu of the &drnt window.
.*
.section The &drnt Menu Bar
.*
.np
.ix 'Menu bar' '&drnt'
.ix '&drnt' 'Menu bar'
The Menu bar consists of the following four menus:
.begpoint
.point File
Save to a file and work with the event list
a file
.point Log
Work with the log file
.point Process
Work with processes currently running under Windows
.point Help
Access on-line help information
.endpoint
.*
.endlevel
.*
.section Using the &drnt Window
.*
.np
.ix 'event list' 'in &drnt'
.ix '&drnt' 'event list'
When you open &drnt, a window appears which contains the event list.
The event list records events generated by processes to which &drnt
is attached. To record these events you must first attach &drnt to the
desired processes. To perform this function, refer to the
section entitled :HDREF refid='drntat'..
Some examples of events are errors, the starting and ending of
threads, and the loading and unloading of DLLs.
.keep 16
.figure *depth='2.24' *scale=64 *file='drw1' The &drnt window contains the event list where occurring events are recorded.
.np
The following sections describe functions that allow you to manipulate
the event list:
.begbull $compact
.bull
Saving the Event List
.bull
Clearing the Event List
.bull
Marking the Event List
.bull
Setting the Fonts
.endbull
.*
.beglevel
.*
.section &drnt.: Saving Event List Information to a File
.*
.np
.ix '&drnt' 'save'
The Save items in the File menu allow you to save the contents of the
event list to a text file. Saving information to a file enables you to
print the output later or annotate the text file on-line.
.np
.ix 'Save' 'in &drnt'
.ix '&drnt' 'save'
Choose Save from the File menu to save the event list information into
the current working directory. A message box appears indicating the
path to which &drnt saved the file.
.np
.ix 'Save As' 'in &drnt'
.ix '&drnt' 'Save As'
Choose Save As from the File menu to specify the file to which you
want to save the information currently in the window. This opens a
Save As dialog box where you select the desired file. Click on OK when
completed. A message box appears indicating the path to which &drnt
saved the event list.
.*
.section &drnt.: Clearing the Event List
.*
.np
.ix 'event list' 'clear'
.ix 'Clear List'
Choose Clear List from the File menu to delete all information from
the event list.
.*
.section &drnt.: Marking the Event List
.*
.ix '&drnt' 'marking event list'
.ix 'event list' 'marking in &drnt'
:INCLUDE file='wguimark.gml'
.*
.section &drnt.: Setting the Fonts
.*
.np
.ix 'fonts' 'setting in &drnt'
.ix '&drnt' 'set font'
The Set Font item in the File menu allows you to set the font, style,
and size for the text in the &drnt window. Choosing this item opens
the Font dialog box. Select the desired font details and click on OK
to close the dialog and apply the fonts.
.*
.endlevel
.*
.section Debugging Information Processors
.*
.np
Debugging Information Processors (DIP's) are Dynamic Link Libraries
that &drnt loads to read debugging information. Each DIP allows &drnt
to read a different type of debugging information.
.beglevel
.*
.section Using the Debugging Information Processor Status dialog
.*
.np
Choosing the Show DIP Status item from the File menu displays the
Debugging Information Processor Status dialog.
.keep 17
.figure *depth='2.5' *scale=80 *file='drw4' The Debugging Information Processor Status dialog shows the DIP's &drnt has loaded.
.np
This dialog contains a list of all the DIP's that &drnt attempted to
load at startup and the results of those loads. If &drnt was unable to
load a particular DIP then the dialog will show the reason for the
failure. &drnt can only read a given type of debugging information if
it has successfully loaded the appropriate DIP.
.endlevel
.*
.section &drnt.: Exception Handling
.*
.np
.ix 'exception' 'handling in &drnt'
.ix '&drnt' 'exception handling'
.ix 'fatal error in &drnt'
When a fatal error, or exception, occurs in a process to which &drnt
is attached, &drnt intercepts the exception. By intercepting the
exception, &drnt halts the program's execution to prevent it from
terminating. When an exception occurs, a &drnt exception dialog box
appears on the screen indicating that a fatal error has occurred. This
dialog displays information about the error and gives you several
options.
.keep 24
.figure *depth='2.30' *scale=64 *file='drw5' The exception dialog appears when a fatal error occurs in a program.
.np
The information displayed about the error includes:
.begpoint $break
.point Process Name
The name of the process in which the error occurred.
.point Process ID
The unique identifier associated with the process.
.point Fault Type
The type of fault that occurred.
.point Fault CS:EIP
The address of the instruction being executed when the fault occurred.
.point Source Info
The source line on which the error occurred. This only appears if the
program running contains debugging information and the exception
occurred on an assembly instruction that corresponds to a source line.
.endpoint
.np
There are four buttons on the exception dialog that you can use to
proceed.
.begnote
.note Act
.ix 'Act'
When the Act button is pressed &drnt.'s action is determined by the
option currently selected in the "action to take" section of the
dialog. The following describes the action taken for each option.
.begpoint $break
.point Terminate Task
When the Terminate Task radio button is selected choosing Act causes
the faulting process to be terminated immediately.
.*
.point Restart Instruction
When the Restart Instruction radio button is selected choosing Act
causes the faulting process to restart execution starting with the
instruction pointed to by its CS:EIP. This option is primarily used to
restart a process after you have changed its register values using the
Process Status dialog.
.*
.point Chain to Next Handler
A handler is a piece of code, a program, or a routine that gets called
when an exception occurs. A process can have several exception
handlers. When the Chain to Next Handler radio button is selected
choosing Act tells the operating system to continue searching for a
handler to deal with this exception. If no handler is found for the
exception then &drnt will redisplay the exception dialog to give you a
second chance to deal with the exception. During this second chance
notification the chain to next handler option is not available. This
option is useful for testing your own exception handling code.
.endpoint
.note Act and Log
.ix 'Act and Log'
Choosing the Act and Log button first creates a log file entry
recording information about this exception then takes the same action
that would result from choosing the Act button.
.note Registers
.ix 'Registers'
Select the Registers button to open the Process Status dialog. This
dialog gives you additional information on the state of the process
when the exception occurred. From this window you can change the
registers and flags and view the process's address space.
Refer to the section entitled :HDREF refid='drntex'.
for further information.
.note Options
.ix 'Options'
Select the Options button to choose the information you want to write
to the log file. This opens the Log Options dialog explained in the
section entitled :HDREF refid='drntcu'..
.endnote
.*
.beglevel
.*
.section Using External Exception Handlers
.*
.np
You can use the Continue Exceptions item in the file menu to tell
&drnt to only report on exceptions that are not handled by another
exception handler. When this item is checked &drnt only displays an
exception dialog if the system is unable to find a handler for an
exception. This behavior is the same as when Continue Exceptions is
not checked and chain to next handler is selected on the exception
dialog.
.*
.section *refid=drntex Examining the Process Status
.*
.np
.ix 'Process Status dialog'
.ix '&drnt' 'Process Status dialog'
The Process Status dialog appears when you choose the Registers button
in the exception dialog.
:CMT. .figure *depth='1.xx' *file='drwx' The Process Status dialog provides additional information on the program state when the exception occurred.
.np
This dialog displays information in four sections:
.begbull $compact
.bull
Source Information
.bull
Registers
.bull
Flags
.bull
Instructions Around Fault
.endbull
.np
The Source Information section indicates the source file where the
error occurred and the line of that source file. In order to get
source information, your program must contain debugging information.
N/A appears in the Source Information section if the program does not
contain debugging information or the exception occurred on an assembly
instruction that does not correspond to a source file.
.np
The Registers and Flags sections display information in the CPU at the
time of the exception.
.np
The Instructions Around Fault section displays the assembly
instructions surrounding the instruction that was being executed when
the fault occurred. An asterisk marks the instruction to which the
CS:EIP is currently pointing.
.np
When the Show Symbols box is checked, &drnt tries to replace addresses
in the assembly code with symbolic names. &drnt can only replace
addresses if the faulting module contained debugging information. If
this box is not checked, addresses appear as numeric values.
.*
.beglevel
.*
.section &drnt.: Changing the Registers
.*
.np
.ix 'Process Status dialog' 'in &drnt'
.ix '&drnt' 'Process Status dialog'
In the Process Status dialog you can set up testing and debugging
situations by changing the values of the registers and flags. To
change a register value simply enter a new value in the edit field
that contains the current register value. To change the state of a
flag register just check or uncheck the check box associated with that
flag. A flag has a value of 1 when its check box is checked.
.np
The register and flag values will not take effect until you choose OK
on the Process Status dialog.
.*
.section &drnt.: Applying Registers
.*
.np
.ix 'Apply Registers'
.ix '&drnt' 'Apply Registers'
Selecting the Apply Registers button on the Process Status dialog
after making changes to the registers and flags updates the displayed
information based on your changes.
.*
.section *refid=drntvi &drnt.: Viewing Memory
.*
.np
.ix 'View Memory'
.ix '&drnt' 'View Memory'
.ix 'Memory Walk window'
Selecting the View Memory button in the Process Status dialog opens a
Memory Walk window which allows you to view the address space of the
process that caused the exception.
:CMT. .figure *depth='1.xx' *file='drwx' The Memory Walk window displays a walk of the address space for the process that caused the exception.
.np
The information in this window appears under the following headings:
.begpoint
.point Base
This is the address where this memory object begins.
.point AllocBase
The is the address where the allocation object begins. This tells you
which allocation object a memory object belongs to.
.point Size
This is the size of the memory object.
.point Prot
Codes indicating what you can do with the memory.
The codes are:
.begbull $compact
.bull
RO&mdash.Read Only
.bull
NA&mdash.Not applicable
.bull
ExRO&mdash.Executable and Read Only
.bull
RW&mdash.Read, Write
.bull
WC&mdash.Write, Copy
.bull
Ex&mdash.Executable
.bull
ExRW&mdash.Executable, Read, Write
.bull
ExWC&mdash.Executable, Write, Copy
.endbull
.point State
The state of the memory. Values are:
.begbull $compact
.bull
Free&mdash.range of addresses not being used
.bull
Committed&mdash.range of addresses refers to memory that exists
.bull
Reserved&mdash.this range of addresses has been set aside for future
use but no memory exists for the addresses
.endbull
.point Object
Information indicating what the memory is being used for. This field
is only completed if &drnt can provide useful information.
.point Image
The name of the module that owns the memory object. This field is only
completed if &drnt can provide useful information.
.endpoint
.np
From this window you can select a memory object and view its contents.
To view this information, double click on the desired object. This
opens a Memory Range window for the selected object. This window
displays all of the data stored in the selected object. The data
appears in hexadecimal form. This window allows you to see if the data
in memory is what you believe it should be.
:CMT. .figure *depth='1.xx' *file='drwx' The Memory Range window displays the data, in hexadecimal form, that is stored in the selected object.
.begnote
.note Note:
You can only view memory for an object whose state is Committed since
there is no memory associated with other objects.
.endnote
.np
There are a number of functions you can perform in the Memory Range
window. Following is a description of these functions.
.*
.beglevel
.*
.section &drnt.: Saving Window Information
.*
.np
.ix 'Save' 'on Memory Range window'
.ix '&drnt' 'save on Memory Range window'
The Save items in the File menu on the Memory Range window allows you
to save the currently displayed information to a text file. Choosing
Save from the File menu on the Memory Range window saves the data in
the window into the current working directory. A message box appears
indicating the path to which &drnt saved the file.
.ix 'Save As' 'on Memory Range window'
.np
Choosing Save As from the File menu allows you to specify the file to
which you want to save the data currently in the window. This opens a
Save As dialog box where you select the desired file. Click on OK when
completed. A message box appears indicating the path to which &drnt
saved the file.
.*
.section &drnt.: Changing the Display
.*
.np
.ix 'Display' 'change in &drnt'
.ix '&drnt' 'change display'
There are three ways to display the information in the Memory Range
window. You can display the information as:
.begbull $compact
.bull
Bytes
.bull
Words
.bull
DWords
.endbull
.np
To change the form of the displayed data, select an item from the
Display menu. When displaying data in bytes, the data appears in the
window as it physically appears in memory. When the data is displayed
as words, the bytes in memory are interpreted for you so that the
values displayed are those that would be obtained by treating the
memory as an array of words. For example, if memory containing the
values:
.millust begin
12 34 56 78 9A BC DE FF
.millust end
was shown as words, the memory window would display:
.millust begin
3412 7856 BC9A FFDE
.millust end
.np
A similar interpretation is performed when the data is displayed as
DWords. If the above memory was shown as DWords, the memory window
would display:
.millust begin
78563412 FFDEBC9A
.millust end
.np
This rearrangement of bytes does not affect the textual interpretation
of the data shown on the right hand side of the window.
.*
.section &drnt.: Setting the Offset
.*
.np
In the Memory Range window you can set the offset. This means that you
can reposition the data so that specific information appears at the
top of the window. The offset you enter appears on the first line. It
will not necessarily be the first piece of information because
rounding often occurs to avoid breaking a line.
.ix 'Set Offset' 'in &drnt'
.ix 'Offset' 'set in &drnt'
.ix '&drnt' 'setting Offset'
.ix 'Memory Range window' 'set offset'
.begstep
.step Choose Set Offset
from the menu bar on the Memory Display window.
.result
This opens a Goto Offset dialog box.
.step Enter the desired offset
that you want to position at the top of the Memory Range window. You
can enter the offset in decimal or hexadecimal form. However, you must
prefix hexadecimal values with 0x.
.step Click on OK.
This closes the dialog and positions the data as requested.
.endstep
.keep 15
.figure *depth='2.26' *scale=100 *file='drw9' In the Goto Offset dialog, enter the offset you want to appear at the top of the Memory Display window.
.*
.endlevel
.*
.endlevel
.*
.endlevel
.*
.section &drnt.: Working with Log Files
.*
.np
.ix 'Log file'
A log file is a text file created by &drnt.. The log file consists of
entries that describe the state of the system at the time the entry
was made. &drnt gives you the opportunity to create a log file entry
each time an exception occurs. Such entries include information about
the state of the program that caused the exception, as well as
information about the state of the system. You can create a log file
entry at any time using the Log Current State menu item. Log entries
made in this way only contain information about the state of the
system.
.ix 'Log Current State' 'in &drnt'
.ix '&drnt' 'Log Current State'
.np
A log file is a permanent record of the state of the system and,
possibly, your program. With a log file you can make note of an error
and return to it at a later time to examine and debug it.
.*
.beglevel
.*
.section *refid=drntcr Creating A Log File Entry
.*
.np
You can create a log file entry at any time by selecting Log Current
state from the Log menu or the system menu. You can also create a log
file entry when an exception occurs by choosing the Act and Log button
on the Exception dialog.
.np
When a log entry is created the following dialogs may be displayed:
.begbull $compact
.bull
Annotate Log
.bull
Memory Dump
.endbull
.*
.beglevel
.*
.section Using the Annotate Log Dialog
.*
.np
When the Query for notes option in the Log Options dialog is selected,
an Annotate Log dialog box appears whenever a log entry is created.
:CMT. .figure *depth='1.xx' *file='drwx' In the Annotate Log dialog box, enter text you want to include in the log file entry.
.np
In the space provided, enter any explanatory text that you want to
include in the log file. Press OK when completed. This information
appears under the heading "User Notes" at the beginning of the log file.
.*
.section Using the Memory Dump Dialog
.*
.np
When the Memory Dump option in the Log Options dialog is selected,
&drnt displays the Log Memory Dump dialog whenever a log entry is
created because of an exception. This dialog displays a list of all
committed pages of memory owned by the process that caused the
exception.
:CMT. .figure *depth='1.xx' *file='drwx' In the Memory Dump dialog box, select the information you want to include in the log file entry.
.np
This dialog allows you to select the memory objects you want to
include in the log file entry. The data contained in any memory object
highlighted in the list box will be written to the log file. Clicking on
an object in the list box toggles it between selected and unselected.
.np
The following buttons are available on the dialog:
.begpoint
.point Select All
Selects all memory for dumping to the log file
.point Clear All
De-selects all memory currently selected in the dialog
.point Cancel
Closes the dialog and continues writing to the log file but does not
include information on any of the memory objects in the dialog
.point OK
Closes the dialog and writes selected objects to the log file
.endpoint
.*
.endlevel
.*
.section Viewing the Current Log File
.*
.np
.ix 'View Log' 'in &drnt'
.ix '&drnt' 'View Log'
Choosing View Log from the Log menu invokes an editor which allows you
to view the current log file. You can select this editor in the Log
Viewer section of the Log Options dialog.
.*
.section Erasing the Log File
.*
.np
.ix 'Log file' 'erase'
.ix '&drnt' 'erase log file'
To erase the current log file, choose Erase Log File from the Log
menu. This erases the log file specified in the Log Options dialog.
.np
Choosing this item reveals a message box which asks you to verify that
you want to erase the specified log file. Select Yes to erase the log
file or No to cancel the request.
.*
.section *refid=drntcu Customizing the Log File
.*
.np
.ix '&drnt' 'Log Options'
.ix 'Log Options' 'in &drnt'
.ix 'Log File' 'customizing'
The Log Options item in the Log menu opens the Log Options dialog
where you indicate to &drnt the information you want to appear in log
file entries. The Log Options item also appears in the system menu.
.keep 23
.figure *depth='3.73' *scale=64 *file='drw12' In the Log Options dialog, you customize the log file to which you write information.
.np
The following sections describe the options that make up the Log
Options dialog.
.*
.beglevel
.*
.section &drnt.: Naming the Log File
.*
.np
In the Log File field, you specify the file to which &drnt writes the
log file entries. The Browse button to the right of this field opens
the Pick log file name dialog. This dialog lets you browse your file
structure and select the path to which &drnt writes the log file
entries.
.*
.section &drnt.: Choosing the Log Viewer
.*
.np
.ix 'Log Viewer' 'choosing'
In the Log Viewer field, you specify the editor you want to invoke when
you select View Log from the Log menu. The Browse button to the right
of this field opens the Pick log viewer dialog. This dialog lets you
browse your file structure and select the desired editor.
.np
When View Log is selected from the Log menu, this editor will be
invoked with the name of the log file passed as a command line
parameter.
.*
.section &drnt.: Specifying the Log File Data
.*
.np
.ix 'Log File data'
.ix 'Disassembly options'
In the Log File Data and Disassembly Options sections of the Log
Options dialog, you select the information you want to appear in the
log file. The Log File Data section lists the various types of
information that can be included in a log file. If the check box for a
piece of information is marked then that type of information will be
written to the log file. The options in this section are:
.begpoint $break Log File Data
.point Memory Dump
When this box is checked, a Memory Dump dialog is displayed whenever a
log file entry is made. This dialog allows you to select the regions
of memory you want to dump into the log file and is discussed in the
section entitled :HDREF refid='drntcr'..
.np
This option only affects log file entries created because of an
exception.
.point Query for notes
When this box is checked, an Annotate Log dialog is displayed whenever
a log file entry is made. This dialog lets you enter text to be
included in the log file entry. The Annotate Log dialog is discussed
in the section entitled :HDREF refid='drntcr'..
.point Loaded modules
When this box is checked, each log file entry includes a list of all
modules loaded for each process running in the system.
.point Current Processes
When this box is checked, each log file entry includes a list of all
processes currently running in the system, including information about
each process.
.point Mem Manager Info
When this box is checked, log file entries will include summary
information on the memory usage of the process that caused the
exception. This option affects only log file entries created because
of an exception.
.endpoint
.np
The fields in the Disassembly Options section relate to the
disassembly section appearing in the log file. These fields affect
only log file entries made because of exceptions.
.begbull
.bull
The value in the Disasm Backup field tells &drnt the number of
instructions before the fault you want written to the log file.
.bull
The value in the Disasm Lines field tells &drnt the total number of
instructions you want it to show in the log file. This value includes
the instructions displayed before the fault.
.endbull
.*
.section &drnt.: Other Options
.*
.np
.ix 'Auto Log' 'in &drnt'
.ix '&drnt' 'Auto Log'
.ix 'Log Restarted Processes'
When the Auto Log option is selected, &drnt creates a log file when an
exception occurs and then terminates the application instead of
revealing the exception dialog.
.np
The Max Log File Size option allows you to set the maximum size in
bytes for a log file. When the log file exceeds this size, &drnt
prompts you with a message box when you start the application.
.keep 14
.figure *depth='2.02' *scale=100 *file='drw14' A message box prompts you to erase the log file when it becomes larger than the maximum log file size specified on the Log File Options dialog.
.np
This message box offers you the opportunity to delete your log file
before it becomes uncontrollably large.
.*
.endlevel
.*
.endlevel
.*
.section *refid=drntat Attaching Processes to &drnt
.*
.np
.ix 'Processes' 'attaching to &drnt'
.ix '&drnt' 'attaching processes to'
Attaching processes to &drnt enables it to monitor events that occur
within the processes. When processes are attached, &drnt reports on
events that occur within your process, such as DLL loads, thread
creations, and thread terminations. Attaching also allows &drnt to
detect exceptions in your process.
.np
There are four ways to attach processes to &drnt:
.begbull $compact
.bull
Command line
.bull
Add New process menu item
.bull
Auto Add Process feature
.bull
Process Control dialog
.endbull
.np
&drnt cannot detach from processes to which it is attached. The
attachment exists until the process terminates. If you try to close
&drnt while it is attached to processes, a warning box appears listing
the processes to which &drnt is still attached.
:CMT. .figure *depth='1.xx' *file='drwx' A warning box appears when you try to close &drnt while it is still attached to processes.
.np
Select Yes or No to continue.
.*
.beglevel
.*
.section Command Line
.*
.np
You can run a program and attach &drnt to it at start-up by passing
the path of the executable to &drnt as a command line parameter. For
example, to run the program
.fi foo.exe
and attach &drnt to it, type:
.millust drwatcom foo.exe
.np
.ix 'command line parameter'
If you often want to run a certain program with &drnt attached to it
then you can create a Program Manager icon that runs &drnt with the
name of the program as a command line parameter.
.np
Double clicking on the icon when &drnt is not running causes &drnt to
start-up. &drnt then starts the specified process and attaches to it
immediately.
.np
Double clicking on the icon when there is already an instance of &drnt
running causes the existing instance of &drnt to run the specified
process and attach to it. The second &drnt terminates immediately so
that only one instance of &drnt is left running.
.*
.section Add New Process
.*
.np
.ix 'Process' 'add new'
.ix '&drnt' 'add new process'
The Add New Process item in the Process menu is another way to start a
new process and attach to it immediately.
.begstep To start a new process using this item:
.step Choose Add New Process
from the Process menu.
.result
This opens the Load Process dialog where you browse the file structure.
.step Select the program
you want to start with &drnt attached.
.step Click on OK.
.result
This runs the selected program and attaches to it immediately.
.endstep
.*
.section Auto Add Processes
.*
.np
.ix 'Process' 'auto add'
.ix '&drnt' 'Auto Add Process'
Checking the Auto Add Process item in the Process menu tells &drnt to
attach to all new processes that start in the system. When you
activate this feature, &drnt checks the system every few seconds for
new processes. When it finds them, it attaches to them. &drnt will not
automatically attach to processes that began before the Auto Add
Process item was checked.
.np
The disadvantage of this feature is that in the few seconds between
&drnt's process checks, your process can start-up, run, and possibly
cause an exception. When this occurs, a system dialog box appears
reporting the error. Selecting OK on this dialog immediately may not
allow &drnt sufficient time to attach to the faulting process. Wait
for a few seconds and select the OK button on this dialog. The dialog
closes and &drnt attaches to the faulting process. The &drnt exception
dialog then appears and you can proceed as usual.
.begnote
.note Note:
Occasionally, when this feature is active a message box may appear
saying, "An unexpected failure occurred while processing a
DebugActiveProcess API request. You may choose OK to terminate the
process or Cancel to ignore the error". This message results from a
known limitation in Win32. If it appears simply choose Cancel.
.endnote
.*
.section Process Control
.*
.np
.ix 'Process Control'
.ix '&drnt' 'Process Control'
Using the Add Process button on the Process Control dialog, you can
attach &drnt to any process that is currently running in the system.
.begstep To do this follow these instructions:
.step Choose Process Control
from the Process menu or the system menu.
.result
This opens the Process Control dialog which lists all processes
currently running under Windows.
.step Click on the process
to which you want &drnt to attach.
You can only select one process at a time.
.step Select the Add Process
button.
.result
This attaches &drnt to the selected process. An asterisk appears to
the left of this process indicating that &drnt is currently attached
to it.
.endstep
:CMT. .figure *depth='1.xx' *file='drwx5' The Process Control dialog displays all currently running processes.
.*
.endlevel
.*
.section Performing Process Control
.*
.np
.ix 'Process Control' 'performing'
.ix '&drnt' 'performing Process Control'
Selecting Process Control from the process menu or the system menu
opens the Process Control dialog. This dialog lists all processes
currently running under Windows. Any process to which &drnt
is attached is marked with an asterisk. When you select a process by
clicking on it, the Selected Process section of the dialog displays
its Process ID, Name, and Priority.
:CMT. .figure *depth='1.xx' *file='drwx' The Selected Process section of the Process Control dialog displays summary information for the selected process.
.np
The Refresh button on this dialog updates the displayed process
information.
.np
From this dialog you can perform several functions. This section
describes each function.
.begnote
.note Important:
The Process Control functions are extremely powerful and give you the
ability to perform functions that can make the operating system
unstable. Because of this, it is wise to save information before you
attempt to use the Process Control functions.
.endnote
.*
.beglevel
.*
.section Setting the Process Priority
.*
.np
Each process in the system has an assigned priority class. This
priority class establishes the schedule for running processes. The Set
Priority button on the process Control dialog allows you to assign a
priority to the selected process.
.begstep To set a process's priority:
.step Select the process
from the Process List to which you want to assign a priority.
.step Select the Set Priority
button.
.ix 'Set Priority'
.result
This opens the Set Process Priority dialog which displays the priority
classes: idle, normal, high, and real time.
.step Select the desired priority
for the selected process.
.step Click on OK
to assign the priority and close the Set Process Priority dialog.
.endstep
:CMT. .figure *depth='1.xx' *file='drwx' In the Set Process Priority dialog, you choose the desired priority for the selected process.
.*
.section Terminating a Process
.*
.np
.ix 'Kill Process'
.ix 'Process' 'terminate'
.ix 'Process Control'
.ix '&drnt' 'terminate a process'
The Kill Process button on the Process Control dialog terminates a
process selected from the Process List in the Process Control dialog.
.begstep To terminate a process:
.step Choose Process Control
from the Process menu.
.result
This opens the Process Control dialog containing a list of all
processes currently running in the system.
.step Click once on the process
you want to terminate to select it.
.step Select the Kill Process
button.
.result
This terminates the selected process. The process's entry in the list
may not be removed until you select the Refresh button.
.endstep
.*
.section Viewing the Threads for a Process
.*
.np
.ix 'Threads' 'viewing for a process'
.ix '&drnt' 'viewing threads'
A process is made up of one or more threads. The View Threads button
in the Process Control dialog opens a Thread Control dialog that lets
you view and manipulate the threads for the selected process. With
this dialog, you can terminate, suspend, and resume threads.
.begstep To view the threads for a process:
.step Select the process
from the Process List whose threads you want to view.
.step Select the View Threads
button from the Process Control dialog.
.result
This opens the Thread Control dialog which displays the threads that
make up the selected process.
.endstep
:CMT. .figure *depth='1.xx' *file='drwx' From the Thread Control dialog box, you can terminate, suspend, and resume threads.
.np
Selecting a thread from the Threads list displays information for that
thread in the Selected Thread section of the dialog. This information
is:
.begpoint $break
.point tid (Thread Id)
A unique identifier assigned by the operating system to each thread in
the system.
.point State
Indicates the current state of the thread. This tells you if the
thread is currently ready for execution or if it is waiting for some
event.
.point Priority
The thread's current priority class
.endpoint
.np
Use the Refresh button to update the information displayed in the
Thread Control dialog.
.*
.beglevel
.*
.section Terminating a Thread
.*
.np
.ix 'Thread' 'terminate'
.ix 'Kill Thread'
.ix '&drnt' 'terminate a thread'
Use the Kill Thread button to terminate a thread.
.np
To terminate a thread, select the desired thread from the Threads list
and select the Kill Thread button.
.*
.section Suspending a Thread
.*
.np
Each thread has a suspend count. A thread can only be scheduled for
execution when its suspend count is zero. To increment a thread's
suspend count, select the thread on the list in the Thread Control
dialog and press the Suspend button.
.*
.section Resuming a Thread
.*
.np
.ix 'Thread' 'resume'
.ix '&drnt' 'resume a thread'
Each thread has a suspend count. A thread can only be scheduled for
execution when its suspend count is zero. To decrement a thread's
suspend count, select the thread on the list in the Thread Control
dialog and press the Resume button.
.*
.endlevel
.*
.section Viewing the Memory for a Process
.*
.np
.ix 'Memory' 'viewing for &drnt process'
.ix '&drnt' 'viewing memory for a process'
Selecting the View Memory button on the Process Control dialog opens a
Memory Walk window for the currently selected process. For information
on this window, see the section entitled :HDREF refid='drntvi'..
.*
.section Summarizing Process Memory Usage
.*
.np
Selecting the Memory Info button on the Process Control dialog opens a
Memory Information dialog box. This dialog provides a breakdown of the
memory usage for the process selected from the Process List.
.np
To view this memory information, select the desired process from the
Process List and select the Memory Info button.
.np
The Memory Information dialog displays information in the following
sections:
.begbull $compact
.bull
Mapped and Committed memory
.bull
Reserved Memory
.bull
Memory Usage by Module (Address Space)
.endbull
:CMT. .figure *depth='1.xx' *file='drwx' The Memory Information dialog summarizes the memory usage of the selected process.
.np
The Mapped and Committed section displays the amount of committed
memory the application is using broken down by its protection.
.np
The Reserved section displays the amount a memory reserved but not yet
committed. This information is broken down by its protection.
.np
In the Address Space section of this dialog, you can view the memory
usage of each module that the selected process currently has loaded.
The combo box in this section lists all modules the process has
loaded. Selecting a module from the combo box displays a summary of
its memory usage. Selecting the All Images item in the combo box
displays the total memory usage by all loaded modules listed in the
combo box.
.np
Use the Refresh button to update the information displayed in the
Memory Information dialog box.
.*
.endlevel
.*
