/***************************************************************************
*
*                            Open Watcom Project
*
*  Copyright (c) 2004-2007 The Open Watcom Contributors. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
*  Description: Implementation of the strmiids.lib library.
*
**************************************************************************/

#include <windows.h>

/* mmstream.h */
EXTERN_C const IID  IID_IMultiMediaStream =
    { 0xB502D1BC, 0x9A57, 0x11D0, { 0x8F, 0xDE, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID  IID_IMediaStream =
    { 0xB502D1BD, 0x9A57, 0x11D0, { 0x8F, 0xDE, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID  IID_IStreamSample =
    { 0xB502D1BE, 0x9A57, 0x11D0, { 0x8F, 0xDE, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };

/* ddraw.h */
EXTERN_C const CLSID    CLSID_DirectDraw =
    { 0xD7B70EE0, 0x4340, 0x11CF, { 0xB0, 0x63, 0x00, 0x20, 0xAF, 0xC2, 0xCD, 0x35 } };
EXTERN_C const CLSID    CLSID_DirectDraw7 =
    { 0x3C305196, 0x50DB, 0x11D3, { 0x9C, 0xFE, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5 } };
EXTERN_C const CLSID    CLSID_DirectDrawClipper =
    { 0x593817A0, 0x7DB3, 0x11CF, { 0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56 } };
EXTERN_C const IID      IID_IDirectDraw =
    { 0x6C14DB80, 0xA733, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID      IID_IDirectDraw2 =
    { 0xB3A6F3E0, 0x2B43, 0x11CF, { 0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56 } };
EXTERN_C const IID      IID_IDirectDraw4 =
    { 0x9C59509A, 0x39BD, 0x11D1, { 0x8C, 0x4A, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5 } };
EXTERN_C const IID      IID_IDirectDraw7 =
    { 0x15E65EC0, 0x3B9C, 0x11D2, { 0xB9, 0x2F, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B } };
EXTERN_C const IID      IID_IDirectDrawSurface =
    { 0x6C14DB81, 0xA733, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID      IID_IDirectDrawSurface2 =
    { 0x57805885, 0x6EEC, 0x11CF, { 0x94, 0x41, 0xA8, 0x23, 0x03, 0xC1, 0x0E, 0x27 } };
EXTERN_C const IID      IID_IDirectDrawSurface3 =
    { 0xDA044E00, 0x69B2, 0x11D0, { 0xA1, 0xD5, 0x00, 0xAA, 0x00, 0xB8, 0xDF, 0xBB } };
EXTERN_C const IID      IID_IDirectDrawSurface4 =
    { 0x0B2B8630, 0xAD35, 0x11D0, { 0x8E, 0xA6, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B } };
EXTERN_C const IID      IID_IDirectDrawSurface7 =
    { 0x06675A80, 0x3B9B, 0x11D2, { 0xB9, 0x2F, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B } };
EXTERN_C const IID      IID_IDirectDrawPalette =
    { 0x6C14DB84, 0xA733, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID      IID_IDirectDrawClipper =
    { 0x6C14DB85, 0xA733, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID      IID_IDirectDrawColorControl =
    { 0x4B9F0EE0, 0x0D7E, 0x11D0, { 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8 } };
EXTERN_C const IID      IID_IDirectDrawGammaControl =
    { 0x69C11C3E, 0xB46E, 0x11D1, { 0xAD, 0x7A, 0x00, 0xC0, 0x4F, 0xC2, 0x9B, 0x4E } };

/* strmif.h */
EXTERN_C const IID  IID_IPin =
    { 0x56A86891, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IEnumPins =
    { 0x56A68692, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IEnumMediaTypes =
    { 0x89C31040, 0x846B, 0x11CE, { 0x97, 0xD3, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const IID  IID_IFilterGraph =
    { 0x56A8689F, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IEnumFilters =
    { 0x56A86893, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IMediaFilter =
    { 0x56A86899, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IBaseFilter =
    { 0x56A86895, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IReferenceClock =
    { 0x56A86897, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IReferenceClockTimerControl =
    { 0xEBEC459C, 0x2ECA, 0x4D42, { 0xA8, 0xAF, 0x30, 0xDF, 0x55, 0x76, 0x14, 0xB8 } };
EXTERN_C const IID  IID_IReferenceClock2 =
    { 0x36B73885, 0xC2C8, 0x11CF, { 0x8B, 0x46, 0x00, 0x80, 0x5F, 0x6C, 0xEF, 0x60 } };
EXTERN_C const IID  IID_IMediaSample =
    { 0x56A8689A, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IMediaSample2 =
    { 0x36B73884, 0xC2C8, 0x11CF, { 0x8B, 0x46, 0x00, 0x80, 0x5F, 0x6C, 0xEF, 0x60 } };
EXTERN_C const IID  IID_IMediaSample2Config =
    { 0x68961E68, 0x832B, 0x41EA, { 0xBC, 0x91, 0x63, 0x59, 0x3F, 0x3E, 0x70, 0xE3 } };
EXTERN_C const IID  IID_IMemAllocator =
    { 0x56A8689C, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IMemAllocatorCallbackTemp =
    { 0x379A0CF0, 0xC1DE, 0x11D2, { 0xAB, 0xF5, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IMemAllocatorNotifyCallbackTemp =
    { 0x92980B30, 0xC1DE, 0x11D2, { 0xAB, 0xF5, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IMemInputPin =
    { 0x56A8689D, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IAMovieSetup =
    { 0xA3D8CEC0, 0x7E5A, 0x11CF, { 0xBB, 0xC5, 0x00, 0x80, 0x5F, 0x6C, 0xEF, 0x20 } };
EXTERN_C const IID  IID_IMediaSeeking =
    { 0x36B73880, 0xC2C8, 0x11CF, { 0x8B, 0x46, 0x00, 0x80, 0x5F, 0x6C, 0xEF, 0x60 } };
EXTERN_C const IID  IID_IEnumRegFilters =
    { 0x56A868A4, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IFilterMapper =
    { 0x56A868A3, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IFilterMapper2 =
    { 0xB79BB0B0, 0x33C1, 0x11D1, { 0xAB, 0xE1, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IFilterMapper3 =
    { 0xB79BB0B1, 0x33C1, 0x11D1, { 0xAB, 0xE1, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IQualityControl =
    { 0x56A868A5, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IOverlayNotify =
    { 0x56A868A0, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IOverlayNotify2 =
    { 0x680EFA10, 0xD535, 0x11D1, { 0x87, 0xC8, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96 } };
EXTERN_C const IID  IID_IOverlay =
    { 0x56A868A1, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IMediaEventSink =
    { 0x56A868A2, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IFileSourceFilter =
    { 0x56A868A6, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IFileSinkFilter =
    { 0xA2104830, 0x7C70, 0x11CF, { 0x8B, 0xCE, 0x00, 0xAA, 0x00, 0xA3, 0xF1, 0xA6 } };
EXTERN_C const IID  IID_IFileSinkFilter2 =
    { 0x00855B90, 0xCE1B, 0x11D0, { 0xBD, 0x4F, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const IID  IID_IGraphBuilder =
    { 0x56A868A9, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_ICaptureGraphBuilder =
    { 0xBF87B6E0, 0x8C27, 0x11D0, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const IID  IID_IAMCopyCaptureFileProgress =
    { 0x670D1D20, 0xA068, 0x11D0, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const IID  IID_ICaptureGraphBuilder2 =
    { 0x93E5A4E0, 0x2D50, 0x11D2, { 0xAB, 0xFA, 0x00, 0xA0, 0xC9, 0xC6, 0xE3, 0x8D } };
EXTERN_C const IID  IID_IFilterGraph2 =
    { 0x36B73882, 0xC2C8, 0x11CF, { 0x8B, 0x46, 0x00, 0x80, 0x5F, 0x6C, 0xEF, 0x60 } };
EXTERN_C const IID  IID_IFilterGraph3 =
    { 0xAAF38154, 0xB80B, 0x422F, { 0x91, 0xE6, 0xB6, 0x64, 0x67, 0x50, 0x9A, 0x07 } };
EXTERN_C const IID  IID_IStreamBuilder =
    { 0x56A868BF, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IAsyncReader =
    { 0x56A868AA, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IGraphVersion =
    { 0x56A868AB, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IResourceConsumer =
    { 0x56A868AD, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IResourceManager =
    { 0x56A868AC, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IDistributorNotify =
    { 0x56A868AF, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID  IID_IAMStreamControl =
    { 0x36B73881, 0xC2C8, 0x11CF, { 0x8B, 0x46, 0x00, 0x80, 0x5F, 0x6C, 0xEF, 0x60 } };
EXTERN_C const IID  IID_ISeekingPassThru =
    { 0x36B73883, 0xC2C8, 0x11CF, { 0x8B, 0x46, 0x00, 0x80, 0x5F, 0x6C, 0xEF, 0x60 } };
EXTERN_C const IID  IID_IAMStreamConfig =
    { 0xC6E13340, 0x30AC, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IConfigInterleaving =
    { 0xBEE3D220, 0x157B, 0x11D0, { 0xBD, 0x23, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const IID  IID_IConfigAviMux =
    { 0x5ACD6AA0, 0xF482, 0x11CE, { 0x8B, 0x67, 0x00, 0xAA, 0x00, 0xA3, 0xF1, 0xA6 } };
EXTERN_C const IID  IID_IAMVideoCompression =
    { 0xC6E13343, 0x30AC, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IAMVfwCaptureDialogs =
    { 0xD8D715A0, 0x6E5E, 0x11D0, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const IID  IID_IAMVfwCompressDialogs =
    { 0xD8D715A3, 0x6E5E, 0x11D0, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const IID  IID_IAMDroppedFrames =
    { 0xC6E13344, 0x30AC, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IAMAudioInputMixer =
    { 0x54C39211, 0x8380, 0x11D0, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const IID  IID_IAMBufferNegotiation =
    { 0x56ED71A0, 0xAF5F, 0x11D0, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const IID  IID_IAMAnalogVideoDecoder =
    { 0xC6E13350, 0x30AC, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IAMVideoProcAmp =
    { 0xC6E13360, 0x30AC, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IAMCameraControl =
    { 0xC6E13370, 0x30AC, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IAMVideoControl =
    { 0x6A2E0670, 0x28E4, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IAMCrossbar =
    { 0xC6E13380, 0x30AC, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IAMTuner =
    { 0x211A8761, 0x03AC, 0x11D1, { 0x8D, 0x13, 0x00, 0xAA, 0x00, 0xBD, 0x83, 0x39 } };
EXTERN_C const IID  IID_IAMTunerNotification =
    { 0x211A8760, 0x03AC, 0x11D1, { 0x8D, 0x13, 0x00, 0xAA, 0x00, 0xBD, 0x83, 0x39 } };
EXTERN_C const IID  IID_IAMTVTuner =
    { 0x211A8766, 0x03AC, 0x11D1, { 0x8D, 0x13, 0x00, 0xAA, 0x00, 0xBD, 0x83, 0x39 } };
EXTERN_C const IID  IID_IBPCSatelliteTuner =
    { 0x211A8765, 0x03AC, 0x11D1, { 0x8D, 0x13, 0x00, 0xAA, 0x00, 0xBD, 0x83, 0x39 } };
EXTERN_C const IID  IID_IAMTVAudio =
    { 0x83EC1C30, 0x23D1, 0x11D1, { 0x99, 0xE6, 0x00, 0xA0, 0xC9, 0x56, 0x02, 0x66 } };
EXTERN_C const IID  IID_IAMTVAudioNotification =
    { 0x83EC1C33, 0x23D1, 0x11D1, { 0x99, 0xE6, 0x00, 0xA0, 0xC9, 0x56, 0x02, 0x66 } };
EXTERN_C const IID  IID_IAMAnalogVideoEncoder =
    { 0xC6E133B0, 0x30AC, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const IID  IID_IKsPropertySet =
    { 0x31EFAC30, 0x515C, 0x11D0, { 0xA9, 0xAA, 0x00, 0xAA, 0x00, 0x61, 0xBE, 0x93 } };
EXTERN_C const IID  IID_IMediaPropertyBag =
    { 0x6025A880, 0xC0D5, 0x11D0, { 0xBD, 0x4E, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const IID  IID_IPersistMediaPropertyBag =
    { 0x5738E040, 0xB67F, 0x11D0, { 0xBD, 0x4D, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const IID  IID_IAMPhysicalPinInfo =
    { 0xF938C991, 0x3029, 0x11CF, { 0x8C, 0x44, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14 } };
EXTERN_C const IID  IID_IAMExtDevice =
    { 0xB5730A90, 0x1A2C, 0x11CF, { 0x8C, 0x23, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14 } };
EXTERN_C const IID  IID_IAMExtTransport =
    { 0xA03CD5F0, 0x3045, 0x11CF, { 0x8C, 0x44, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14 } };
EXTERN_C const IID  IID_IAMTimecodeReader =
    { 0x9B496CE1, 0x811B, 0x11CF, { 0x8C, 0x77, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14 } };
EXTERN_C const IID  IID_IAMTimecodeGenerator =
    { 0x9B496CE0, 0x811B, 0x11CF, { 0x8C, 0x77, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14 } };
EXTERN_C const IID  IID_IAMTimecodeDisplay =
    { 0x9B496CE2, 0x811B, 0x11CF, { 0x8B, 0x77, 0x00, 0xAA, 0x00, 0x6B, 0x68, 0x14 } };
EXTERN_C const IID  IID_IAMDevMemoryAllocator =
    { 0xC6545BF0, 0xE76B, 0x11D0, { 0xBD, 0x52, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const IID  IID_IAMDevMemoryControl =
    { 0xC6545BF1, 0xE76B, 0x11D0, { 0xBD, 0x52, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const IID  IID_IAMStreamSelect =
    { 0xC1960960, 0x17F5, 0x11D1, { 0xAB, 0xE1, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IAMResourceControl =
    { 0x8389D2D0, 0x77D7, 0x11D1, { 0xAB, 0xE6, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IAMClockAdjust =
    { 0x4D5466B0, 0xA49C, 0x11D1, { 0xAB, 0xE8, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IAMFilterMiscFlags =
    { 0x2DD74950, 0xA890, 0x11D1, { 0xAB, 0xE8, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IDrawVideoImage =
    { 0x48EFB120, 0xAB49, 0x11D2, { 0xAE, 0xD2, 0x00, 0xA0, 0xC9, 0x95, 0xE8, 0xD5 } };
EXTERN_C const IID  IID_IDecimateVideoImage =
    { 0x2E5EA3E0, 0xE924, 0x11D2, { 0xB6, 0xDA, 0x00, 0xA0, 0xC9, 0x95, 0xE8, 0xD5 } };
EXTERN_C const IID  IID_IAMVideoDecimationProperties =
    { 0x60D32930, 0x13DA, 0x11D3, { 0x9E, 0xC6, 0xC4, 0xFC, 0xAE, 0xF5, 0xC7, 0xBE } };
EXTERN_C const IID  IID_IVideoFrameStep =
    { 0xE46A9787, 0x2B71, 0x444D, { 0xA4, 0xB5, 0x1F, 0xAB, 0x7B, 0x70, 0x8D, 0x6A } };
EXTERN_C const IID  IID_IAMPushSource =
    { 0xF185FE76, 0xE64E, 0x11D2, { 0xB7, 0x6E, 0x00, 0xC0, 0x4F, 0xB6, 0xBD, 0x3D } };
EXTERN_C const IID  IID_IAMDeviceRemoval =
    { 0xF90A6130, 0xB658, 0x11D2, { 0xAE, 0x49, 0x00, 0x00, 0xF8, 0x75, 0x4B, 0x99 } };
EXTERN_C const IID  IID_IDVEnc =
    { 0xD18E17A0, 0xAACB, 0x11D0, { 0xAF, 0xB0, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const IID  IID_IIPDVDec =
    { 0xB8E8BD60, 0x0BFE, 0x11D0, { 0xAF, 0x91, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const IID  IID_IDVRGB219 =
    { 0x58473A19, 0x2BC8, 0x4663, { 0x80, 0x12, 0x25, 0xF8, 0x1B, 0xAB, 0xDD, 0xD1 } };
EXTERN_C const IID  IID_IDVSplitter =
    { 0x92A3A302, 0xDA7C, 0x4A1F, { 0xBA, 0x7E, 0x18, 0x02, 0xBB, 0x5D, 0x2D, 0x02 } };
EXTERN_C const IID  IID_IAMAudioRendererStats =
    { 0x22320CB2, 0xD41A, 0x11D2, { 0xBF, 0x7C, 0xD7, 0xCB, 0x9D, 0xF0, 0xBF, 0x93 } };
EXTERN_C const IID  IID_IAMLatency =
    { 0x62EA93BA, 0xEC62, 0x11D2, { 0xB7, 0x70, 0x00, 0xC0, 0x4F, 0xB6, 0xBD, 0x3D } };
EXTERN_C const IID  IID_IAMGraphStreams =
    { 0x632105FA, 0x072E, 0x11D3, { 0x8A, 0xF9, 0x00, 0xC0, 0x4F, 0xB6, 0xBD, 0x3D } };
EXTERN_C const IID  IID_IAMOverlayFX =
    { 0x62FAE250, 0x7E65, 0x4460, { 0xBF, 0xC9, 0x63, 0x98, 0xB3, 0x22, 0x07, 0x3C } };
EXTERN_C const IID  IID_IAMOpenProgress =
    { 0x8E1C39A1, 0xDE53, 0x11CF, { 0xAA, 0x63, 0x00, 0x80, 0xC7, 0x44, 0x52, 0x8D } };
EXTERN_C const IID  IID_IMpeg2Demultiplexer =
    { 0x436EEE9C, 0x264F, 0x4242, { 0x90, 0xE1, 0x4E, 0x33, 0x0C, 0x10, 0x75, 0x12 } };
EXTERN_C const IID  IID_IEnumStreamIdMap =
    { 0x945C1566, 0x6202, 0x46FC, { 0x96, 0xC7, 0xD8, 0x7F, 0x28, 0x9C, 0x65, 0x34 } };
EXTERN_C const IID  IID_IMPEG2StreamIdMap =
    { 0xD0E04C47, 0x25B8, 0x4369, { 0x92, 0x5A, 0x36, 0x2A, 0x01, 0xD9, 0x54, 0x44 } };
EXTERN_C const IID  IID_IRegisterServiceProvider =
    { 0x7B3A2F01, 0x0751, 0x48DD, { 0xB5, 0x56, 0x00, 0x47, 0x85, 0x17, 0x1C, 0x54 } };
EXTERN_C const IID  IID_IAMClockSlave =
    { 0x9FD52741, 0x176D, 0x4B36, { 0x8F, 0x51, 0xCA, 0x8F, 0x93, 0x32, 0x23, 0xBE } };
EXTERN_C const IID  IID_IAMGraphBuilderCallback =
    { 0x4995F511, 0x9DDB, 0x4F12, { 0xBD, 0x3B, 0xF0, 0x46, 0x11, 0x80, 0x7B, 0x79 } };
EXTERN_C const IID  IID_ICodecAPI =
    { 0x901DB4C7, 0x31CE, 0x41A2, { 0x85, 0xDC, 0x8F, 0xA0, 0xBF, 0x41, 0xB8, 0xDA } };
EXTERN_C const IID  IID_IGetCapabilitiesKey =
    { 0xA8809222, 0x07BB, 0x48EA, { 0x95, 0x1C, 0x33, 0x15, 0x81, 0x00, 0x62, 0x5B } };
EXTERN_C const IID  IID_IEncoderAPI =
    { 0x70423839, 0x6ACC, 0x4B23, { 0xB0, 0x79, 0x21, 0xDB, 0xF0, 0x81, 0x56, 0xA5 } };
EXTERN_C const IID  IID_IVideoEncoder =
    { 0x02997C3B, 0x8E1B, 0x460E, { 0x92, 0x70, 0x54, 0x5E, 0x0D, 0xE9, 0x56, 0x3E } };
EXTERN_C const IID  IID_IAMDecoderCaps =
    { 0xC0DFF467, 0xD499, 0x4986, { 0x97, 0x2B, 0xE1, 0xD9, 0x09, 0x0F, 0xA9, 0x41 } };
EXTERN_C const IID  IID_IAMCertifiedOutputPrecision =
    { 0x6FEDED3E, 0x0FF1, 0x4901, { 0xA2, 0xF1, 0x43, 0xF7, 0x01, 0x2C, 0x85, 0x15 } };
EXTERN_C const IID  IID_IAMAsyncReaderTimestampScaling =
    { 0xCF7B26FC, 0x9A00, 0x485B, { 0x81, 0x47, 0x3E, 0x78, 0x9D, 0x5E, 0x8F, 0x67 } };
EXTERN_C const IID  IID_IAMPluginControl =
    { 0x0E26A181, 0xF40C, 0x4635, { 0x87, 0x86, 0x97, 0x62, 0x84, 0xB5, 0x29, 0x81 } };
EXTERN_C const IID  IID_IDvdControl =
    { 0xA70EFE61, 0xE2A3, 0x11D0, { 0xA9, 0xBE, 0x00, 0xAA, 0x00, 0x61, 0xBE, 0x93 } };
EXTERN_C const IID  IID_IDvdInfo =
    { 0xA70EFE60, 0xE2A3, 0x11D0, { 0xA9, 0xBE, 0x00, 0xAA, 0x00, 0x61, 0xBE, 0x93 } };
EXTERN_C const IID  IID_IDvdCmd =
    { 0x5A4A97E4, 0x94EE, 0x4A55, { 0x97, 0x51, 0x74, 0xB5, 0x64, 0x3A, 0xA2, 0x7D } };
EXTERN_C const IID  IID_IDvdState =
    { 0x86303D6D, 0x1C4A, 0x4087, { 0xAB, 0x42, 0xF7, 0x11, 0x16, 0x70, 0x48, 0xEF } };
EXTERN_C const IID  IID_IDvdControl2 =
    { 0x33BC7430, 0xEEC0, 0x11D2, { 0x82, 0x01, 0x00, 0xA0, 0xC9, 0xD7, 0x48, 0x42 } };
EXTERN_C const IID  IID_IDvdInfo2 =
    { 0x34151510, 0xEEC0, 0x11D2, { 0x82, 0x01, 0x00, 0xA0, 0xC9, 0xD7, 0x48, 0x42 } };
EXTERN_C const IID  IID_IDvdGraphBuilder =
    { 0xFCC152B6, 0xF372, 0x11D0, { 0x8E, 0x00, 0x00, 0xC0, 0x4F, 0xD7, 0xC0, 0x8B } };
EXTERN_C const IID  IID_IDDrawExclModeVideo =
    { 0x153ACC21, 0xD83B, 0x11D1, { 0x82, 0xBF, 0x00, 0xA0, 0xC9, 0x69, 0x6C, 0x8F } };
EXTERN_C const IID  IID_IDDrawExclModeVideoCallback =
    { 0x913C24A0, 0x20AB, 0x11D2, { 0x90, 0x38, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x98 } };
EXTERN_C const IID  IID_IPinConnection =
    { 0x4A9A62D3, 0x27D4, 0x403D, { 0x91, 0xE9, 0x89, 0xF5, 0x40, 0xE5, 0x55, 0x34 } };
EXTERN_C const IID  IID_IPinFlowControl =
    { 0xC56E9859, 0xDBF3, 0x4F6B, { 0x81, 0x19, 0x38, 0x4A, 0xF2, 0x06, 0x0D, 0xEB } };
EXTERN_C const IID  IID_IGraphConfig =
    { 0x03A1EB8E, 0x32BF, 0x4245, { 0x85, 0x02, 0x11, 0x4D, 0x08, 0xA9, 0xCB, 0x88 } };
EXTERN_C const IID  IID_IGraphConfigCallback =
    { 0xADE0FD60, 0xD19D, 0x11D2, { 0xAB, 0xF6, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID  IID_IFilterChain =
    { 0xDCFBDCF6, 0x0DC2, 0x45F5, { 0x9A, 0xB2, 0x7C, 0x33, 0x0E, 0xA0, 0x9C, 0x29 } };
EXTERN_C const IID  IID_IVMRImagePresenter =
    { 0xCE704FE7, 0xE71E, 0x41FB, { 0xBA, 0xA2, 0xC4, 0x40, 0x3E, 0x11, 0x82, 0xF5 } };
EXTERN_C const IID  IID_IVMRSurfaceAllocator =
    { 0x31CE832E, 0x4484, 0x458B, { 0x8C, 0xCA, 0xF4, 0xD7, 0xE3, 0xDB, 0x0B, 0x52 } };
EXTERN_C const IID  IID_IVMRSurfaceAllocatorNotify =
    { 0xAADA05A8, 0x5A4E, 0x4729, { 0xAF, 0x0B, 0xCE, 0xA2, 0x7A, 0xED, 0x51, 0xE2 } };
EXTERN_C const IID  IID_IVMRWindowlessControl =
    { 0x0EB1088C, 0x4DCD, 0x46F0, { 0x87, 0x8F, 0x39, 0xDA, 0xE8, 0x6A, 0x51, 0xB7 } };
EXTERN_C const IID  IID_IVMRMixerControl =
    { 0x1C1A17B0, 0xBED0, 0x415D, { 0x97, 0x4B, 0xDC, 0x66, 0x96, 0x13, 0x15, 0x99 } };
EXTERN_C const IID  IID_IVMRMonitorConfig =
    { 0x9CF0B1B6, 0xFBAA, 0x4B7F, { 0x88, 0xCF, 0xCF, 0x1F, 0x13, 0x0A, 0x0D, 0xCE } };
EXTERN_C const IID  IID_IVMRFilterConfig =
    { 0x9E5530C5, 0x7034, 0x48B4, { 0xBB, 0x46, 0x0B, 0x8A, 0x6E, 0xFC, 0x8E, 0x36 } };
EXTERN_C const IID  IID_IVMRAspectRatioControl =
    { 0xEDE80B5C, 0xBAD6, 0x4623, { 0xB5, 0x37, 0x65, 0x58, 0x6C, 0x9F, 0x8D, 0xFD } };
EXTERN_C const IID  IID_IVMRDeinterlaceControl =
    { 0xBB057577, 0x0DB8, 0x4E6A, { 0x87, 0xA7, 0x1A, 0x8C, 0x9A, 0x50, 0x5A, 0x0F } };
EXTERN_C const IID  IID_IVMRMixerBitmap =
    { 0x1E673275, 0x0257, 0x40AA, { 0xAF, 0x20, 0x7C, 0x60, 0x8D, 0x4A, 0x04, 0x28 } };
EXTERN_C const IID  IID_IVMRImageCompositor =
    { 0x7A4FB5AF, 0x479F, 0x4074, { 0xBB, 0x40, 0xCE, 0x67, 0x22, 0xE4, 0x3C, 0x82 } };
EXTERN_C const IID  IID_IVMRVideoStreamControl =
    { 0x058D1F11, 0x2A54, 0x4BEF, { 0xBD, 0x54, 0xDF, 0x70, 0x66, 0x26, 0xB7, 0x27 } };
EXTERN_C const IID  IID_IVMRSurface =
    { 0xA9849BBE, 0x9EC8, 0x4263, { 0xB7, 0x64, 0x62, 0x73, 0x0F, 0x0D, 0x15, 0xD0 } };
EXTERN_C const IID  IID_IVMRImagePresenterConfig =
    { 0x9F3A1C85, 0x8555, 0x49BA, { 0x93, 0x5F, 0xBE, 0x5B, 0x5B, 0x29, 0xD1, 0x78 } };
EXTERN_C const IID  IID_IVMRImagePresenterExclModeConfig =
    { 0xE6F7CE40, 0x4673, 0x44F1, { 0x8F, 0x77, 0x54, 0x99, 0xD6, 0x8C, 0xB4, 0xEA } };
EXTERN_C const IID  IID_IVPManager =
    { 0xAAC18C18, 0xE186, 0x46D2, { 0x82, 0x5D, 0xA1, 0xF8, 0xDC, 0x8E, 0x39, 0x5A } };

/* ddstream.h */
EXTERN_C const IID  IID_IDirectDrawMediaStream =
    { 0xF4104FCE, 0x9A70, 0x11D0, { 0x8F, 0xDE, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID  IID_IDirectDrawStreamSample =
    { 0xF4104FCF, 0x9A70, 0x11D0, { 0x8F, 0xDE, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };

/* austream.h */
EXTERN_C const IID  IID_IAudioMediaStream =
    { 0xF7537560, 0xA3BE, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };
EXTERN_C const IID  IID_IAudioStreamSample =
    { 0x345FEE00, 0xABA5, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };
EXTERN_C const IID  IID_IMemoryData =
    { 0x327FC560, 0xAF60, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };
EXTERN_C const IID  IID_IAudioData =
    { 0x54C719C0, 0xAF60, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };

/* amstream.h */
EXTERN_C const IID      IID_IAMMultiMediaStream =
    { 0xBEBE595C, 0x9A6F, 0x11D0, { 0x8F, 0xDE, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID      IID_IAMMediaStream =
    { 0xBEBE595D, 0x9A6F, 0x11D0, { 0x8F, 0xDE, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID      IID_IMediaStreamFilter =
    { 0xBEBE595E, 0x9A6F, 0x11D0, { 0x8F, 0xDE, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID      IID_IDirectDrawMediaSampleAllocator =
    { 0xAB6B4AFC, 0xF6E4, 0x11D0, { 0x90, 0x0D, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID      IID_IDirectDrawMediaSample =
    { 0xAB6B4AFE, 0xF6E4, 0x11D0, { 0x90, 0x0D, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID      IID_IAMMediaTypeStream =
    { 0xAB6B4AFA, 0xF6E4, 0x11D0, { 0x90, 0x0D, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const IID      IID_IAMMediaTypeSample =
    { 0xAB6B4AFB, 0xF6E4, 0x11D0, { 0x90, 0x0D, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const CLSID    CLSID_AMMultiMediaStream =
    { 0x49C47CE5, 0x9BA4, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };
EXTERN_C const CLSID    CLSID_AMDirectDrawStream =
    { 0x49C47CE4, 0x9BA4, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };
EXTERN_C const CLSID    CLSID_AMAudioStream =
    { 0x8496E040, 0xAF4C, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };
EXTERN_C const CLSID    CLSID_AMAudioData =
    { 0xF2468580, 0xAF8A, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };
EXTERN_C const CLSID    CLSID_AMMediaTypeStream =
    { 0xCF0F2F7C, 0xF7BF, 0x11D0, { 0x90, 0x0D, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };

/* qedit.h */
EXTERN_C const IID      IID_IPropertySetter =
    { 0xAE9472BD, 0xB0C3, 0x11D2, { 0x8D, 0x24, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const IID      IID_IDxtCompositor =
    { 0xBB44391E, 0x6ABD, 0x422F, { 0x9E, 0x2E, 0x38, 0x5C, 0x9D, 0xFF, 0x51, 0xFC } };
EXTERN_C const IID      IID_IDxtAlphaSetter =
    { 0x4EE9EAD9, 0xDA4D, 0x43D0, { 0x93, 0x83, 0x06, 0xB9, 0x0C, 0x08, 0xB1, 0x2B } };
EXTERN_C const IID      IID_IDxtJpeg =
    { 0xDE75D011, 0x7A65, 0x11D2, { 0x8C, 0xEA, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const IID      IID_IDxtKey =
    { 0x3255DE56, 0x38FB, 0x4901, { 0xB9, 0x80, 0x94, 0xB4, 0x38, 0x01, 0x0D, 0x7B } };
EXTERN_C const IID      IID_IMediaLocator =
    { 0x288581E0, 0x66CE, 0x11D2, { 0x91, 0x8F, 0x00, 0xC0, 0xDF, 0x10, 0xD4, 0x34 } };
EXTERN_C const IID      IID_IMediaDet =
    { 0x65BD0710, 0x24D2, 0x4FF7, { 0x93, 0x24, 0xED, 0x2E, 0x5D, 0x3A, 0xBA, 0xFA } };
EXTERN_C const IID      IID_IGrfCache =
    { 0xAE9472BE, 0xB0C3, 0x11D2, { 0x8D, 0x24, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const IID      IID_IRenderEngine =
    { 0x6BEE3A81, 0x66C9, 0x11D2, { 0x91, 0x8F, 0x00, 0xC0, 0xDF, 0x10, 0xD4, 0x34 } };
EXTERN_C const IID      IID_IRenderEngine2 =
    { 0x6BEE3A82, 0x66C9, 0x11D2, { 0x91, 0x8F, 0x00, 0xC0, 0xDF, 0x10, 0xD4, 0x34 } };
EXTERN_C const IID      IID_IFindCompressorCB =
    { 0xF03FA8DE, 0x879A, 0x4D59, { 0x9B, 0x2C, 0x26, 0xBB, 0x1C, 0xF8, 0x34, 0x61 } };
EXTERN_C const IID      IID_ISmartRenderEngine =
    { 0xF03FA8CE, 0x879A, 0x4D59, { 0x9B, 0x2C, 0x26, 0xBB, 0x1C, 0xF8, 0x34, 0x61 } };
EXTERN_C const IID      IID_IAMTimelineObj =
    { 0x78520B77, 0x61F9, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IAMTimelineEffectable =
    { 0xEAE58537, 0x622E, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IAMTimelineEffect =
    { 0xBCE0C264, 0x622D, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IAMTimelineTransable =
    { 0x378FA386, 0x622E, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IAMTimelineSplittable =
    { 0xA0F840A0, 0xD590, 0x11D2, { 0x8D, 0x55, 0x00, 0xA0, 0x9C, 0x43, 0x1E, 0x20 } };
EXTERN_C const IID      IID_IAMTimelineTrans =
    { 0xBCE0C265, 0x622D, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IAMTimelineSrc =
    { 0x78530B79, 0x61F9, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IAMTimelineTrack =
    { 0xEAE58538, 0x622E, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IAMTimelineVirtualTrack =
    { 0xA8ED5F80, 0xC2C7, 0x11D2, { 0x8D, 0x39, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const IID      IID_IAMTimelineComp =
    { 0xEAE58536, 0x622E, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IAMTimelineGroup =
    { 0x9EED4F00, 0xB8A6, 0x11D2, { 0x80, 0x23, 0x00, 0xC0, 0xDF, 0x10, 0xD4, 0x34 } };
EXTERN_C const IID      IID_IAMTimeline =
    { 0x78530B74, 0x61F9, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IXml2Dex =
    { 0x18C628ED, 0x962A, 0x11D2, { 0x8D, 0x08, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const IID      IID_IAMErrorLog =
    { 0xE43E73A2, 0x0EFA, 0x11D3, { 0x96, 0x01, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const IID      IID_IAMSetErrorLog =
    { 0x963566DA, 0xBE21, 0x4EAF, { 0x88, 0xE9, 0x35, 0x70, 0x4F, 0x8F, 0x52, 0xA1 } };
EXTERN_C const IID      IID_ISampleGrabberCB =
    { 0x0579154A, 0x2B53, 0x4994, { 0xB0, 0xD0, 0xE7, 0x73, 0x14, 0x8E, 0xFF, 0x85 } };
EXTERN_C const IID      IID_ISampleGrabber =
    { 0x6B652FFF, 0x11FE, 0x4FCE, { 0x92, 0xAD, 0x02, 0x66, 0xB5, 0xD7, 0xC7, 0x8F } };
EXTERN_C const IID      LIBID_DexterLib =
    { 0x78530B68, 0x61F9, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const IID      IID_IResize =
    { 0x4ADA63A0, 0x72D5, 0x11D2, { 0x95, 0x2A, 0x00, 0x60, 0x08, 0x18, 0x40, 0xBC } };
EXTERN_C const CLSID    CLSID_AMTimeline =
    { 0x78530B75, 0x61F9, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const CLSID    CLSID_AMTimelineObj =
    { 0x78530B78, 0x61F9, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const CLSID    CLSID_AMTimelineSrc =
    { 0x78530B7A, 0x61F9, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const CLSID    CLSID_AMTimelineTrack =
    { 0x8F6C3C50, 0x897B, 0x11D2, { 0x8C, 0xFB, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const CLSID    CLSID_AMTimelineComp =
    { 0x74D2EC80, 0x6233, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const CLSID    CLSID_AMTimelineGroup =
    { 0xF6D371E1, 0xB8A6, 0x11D2, { 0x80, 0x23, 0x00, 0xC0, 0xDF, 0x10, 0xD4, 0x34 } };
EXTERN_C const CLSID    CLSID_AMTimelineTrans =
    { 0x74D2EC81, 0x6233, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const CLSID    CLSID_AMTimelineEffect =
    { 0x74D2EC82, 0x6233, 0x11D2, { 0x8C, 0xAD, 0x00, 0xA0, 0x24, 0x58, 0x09, 0x02 } };
EXTERN_C const CLSID    CLSID_RenderEngine =
    { 0x64D8A8E0, 0x80A2, 0x11D2, { 0x8C, 0xF3, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const CLSID    CLSID_SmartRenderEngine =
    { 0x498B0949, 0xBBE9, 0x4072, { 0x98, 0xBE, 0x6C, 0xCA, 0xEB, 0x79, 0xDC, 0x6F } };
EXTERN_C const CLSID    CLSID_AudMixer =
    { 0x036A9790, 0xC153, 0x11D2, { 0x9E, 0xF7, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37 } };
EXTERN_C const CLSID    CLSID_Xml2Dex =
    { 0x18C628EE, 0x962A, 0x11D2, { 0x8D, 0x08, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const CLSID    CLSID_MediaLocator =
    { 0xCC1101F2, 0x79DC, 0x11D2, { 0x8C, 0xE6, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const CLSID    CLSID_PropertySetter =
    { 0xADF95821, 0xDED7, 0x11D2, { 0xAC, 0xBE, 0x00, 0x80, 0xC7, 0x5E, 0x24, 0x6E } };
EXTERN_C const CLSID    CLSID_MediaDet =
    { 0x65BD0711, 0x24D2, 0x4FF7, { 0x93, 0x24, 0xED, 0x2E, 0x5D, 0x3A, 0xBA, 0xFA } };
EXTERN_C const CLSID    CLSID_SampleGrabber =
    { 0xC1F400A0, 0x3F08, 0x11D3, { 0x9F, 0x0B, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37 } };
EXTERN_C const CLSID    CLSID_NullRenderer =
    { 0xC1F400A4, 0x3F08, 0x11D3, { 0x9F, 0x0B, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37 } };
EXTERN_C const CLSID    CLSID_DxtCompositor =
    { 0xBB44391D, 0x6ABD, 0x422F, { 0x9E, 0x2E, 0x38, 0x5C, 0x9D, 0xFF, 0x51, 0xFC } };
EXTERN_C const CLSID    CLSID_DxtAlphaSetter =
    { 0x506D89AE, 0x909A, 0x44F7, { 0x94, 0x44, 0xAB, 0xD5, 0x75, 0x89, 0x6E, 0x35 } };
EXTERN_C const CLSID    CLSID_DxtJpeg =
    { 0xDE75D012, 0x7A65, 0x11D2, { 0x8C, 0xEA, 0x00, 0xA0, 0xC9, 0x44, 0x1E, 0x20 } };
EXTERN_C const CLSID    CLSID_ColorSource =
    { 0x0CFDD070, 0x581A, 0x11D2, { 0x9E, 0xE6, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37 } };
EXTERN_C const CLSID    CLSID_DxtKey =
    { 0xC5B19592, 0x145E, 0x11D3, { 0x9F, 0x04, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37 } };

/* vmr9.h */
EXTERN_C const IID  IID_IVMRImagePresenter9 =
    { 0x69188C61, 0x12A3, 0x40F0, { 0x8F, 0xFC, 0x34, 0x2E, 0x7B, 0x43, 0x3F, 0xD7 } };
EXTERN_C const IID  IID_IVMRSurfaceAllocator9 =
    { 0x8D5148EA, 0x3F5D, 0x46CF, { 0x9D, 0xF1, 0xD1, 0xB8, 0x96, 0xEE, 0xDB, 0x1F } };
EXTERN_C const IID  IID_IVMRSurfaceAllocatorEx9 =
    { 0x6DE9A68A, 0xA928, 0x4522, { 0xBF, 0x57, 0x65, 0x5A, 0xE3, 0x86, 0x64, 0x56 } };
EXTERN_C const IID  IID_IVMRSurfaceAllocatorNotify9 =
    { 0xDCA3F5DF, 0xBB3A, 0x4D03, { 0xBD, 0x81, 0x84, 0x61, 0x4B, 0xFB, 0xFA, 0x0C } };
EXTERN_C const IID  IID_IVMRWindowlessControl9 =
    { 0x8F537D09, 0xF85E, 0x4414, { 0xB2, 0x3B, 0x50, 0x2E, 0x54, 0xC7, 0x99, 0x27 } };
EXTERN_C const IID  IID_IVMRMixerControl9 =
    { 0x1A777EAA, 0x47C8, 0x4930, { 0xB2, 0xC9, 0x8F, 0xEE, 0x1C, 0x1B, 0x0F, 0x3B } };
EXTERN_C const IID  IID_IVMRMixerBitmap9 =
    { 0xCED175E5, 0x1935, 0x4820, { 0x81, 0xBD, 0xFF, 0x6A, 0xD0, 0x0C, 0x91, 0x08 } };
EXTERN_C const IID  IID_IVMRSurface9 =
    { 0xDFC581A1, 0x6E1F, 0x4C3A, { 0x8D, 0x0A, 0x5E, 0x97, 0x92, 0xEA, 0x2A, 0xFC } };
EXTERN_C const IID  IID_IVMRImagePresenterConfig9 =
    { 0x45C15CAB, 0x6E22, 0x420A, { 0x80, 0x43, 0xAE, 0x1F, 0x0A, 0xC0, 0x2C, 0x7D } };
EXTERN_C const IID  IID_IVMRVideoStreamControl9 =
    { 0xD0CFE38B, 0x93E7, 0x4772, { 0x89, 0x57, 0x04, 0x00, 0xC4, 0x9A, 0x44, 0x85 } };
EXTERN_C const IID  IID_IVMRFilterConfig9 =
    { 0x5A804648, 0x4F66, 0x4867, { 0x9C, 0x43, 0x4F, 0x5C, 0x82, 0x2C, 0xF1, 0xB8 } };
EXTERN_C const IID  IID_IVMRAspectRatioControl9 =
    { 0x00D96C29, 0xBBDE, 0x4EFC, { 0x99, 0x01, 0xBB, 0x50, 0x36, 0x39, 0x21, 0x46 } };
EXTERN_C const IID  IID_IVMRMonitorConfig9 =
    { 0x46C2E457, 0x8BA0, 0x4EEF, { 0xB8, 0x0B, 0x06, 0x80, 0xF0, 0x97, 0x87, 0x49 } };
EXTERN_C const IID  IID_IVMRDeinterlaceControl9 =
    { 0xA215FB8D, 0x13C2, 0x4F7F, { 0x99, 0x3C, 0x00, 0x3D, 0x62, 0x71, 0xA4, 0x59 } };
EXTERN_C const IID  IID_IVMRImageCompositor9 =
    { 0x4A5C89EB, 0xDF51, 0x4654, { 0xAC, 0x2A, 0xE4, 0x8E, 0x02, 0xBB, 0xAB, 0xF6 } };

/* control.h */
EXTERN_C const IID      LIBID_QuartzTypeLib =
    { 0x56A868B0, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IAMCollection =
    { 0x56A868B9, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IMediaControl =
    { 0x56A868B1, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IMediaEvent =
    { 0x56A868B6, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IMediaEventEx =
    { 0x56A868C0, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IMediaPosition =
    { 0x56A868B2, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IBasicAudio =
    { 0x56A868B3, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IVideoWindow =
    { 0x56A868B4, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IBasicVideo =
    { 0x56A868B5, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IBasicVideo2 =
    { 0x329BB360, 0xF6EA, 0x11D1, { 0x90, 0x38, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x98 } };
EXTERN_C const IID      IID_IDeferredCommand =
    { 0x56A868B8, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IQueueCommand =
    { 0x56A868B7, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_FilgraphManager =
    { 0xE436EBB3, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IFilterInfo =
    { 0x56A868BA, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IRegFilterInfo =
    { 0x56A868BB, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IMediaTypeInfo =
    { 0x56A868BC, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IPinInfo =
    { 0x56A868BD, 0x0AD4, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const IID      IID_IAMStats =
    { 0xBC9BCF80, 0xDCD2, 0x11D2, { 0xAB, 0xF6, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };

/* uuids.h */
EXTERN_C const GUID     MEDIASUBTYPE_None =
    { 0xE436EB8E, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIATYPE_Video =
    { 0x73646976, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIATYPE_Audio =
    { 0x73647561, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIATYPE_Text =
    { 0x73747874, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIATYPE_Midi =
    { 0x7364696D, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIATYPE_Stream =
    { 0xE436EB83, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIATYPE_Interleaved =
    { 0x73766169, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIATYPE_File =
    { 0x656C6966, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIATYPE_ScriptCommand =
    { 0x73636D64, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIATYPE_AUXLine21Data =
    { 0x670AEA80, 0x3A82, 0x11D0, { 0xB7, 0x9B, 0x00, 0xAA, 0x00, 0x37, 0x67, 0xA7 } };
EXTERN_C const GUID     MEDIATYPE_AUXTeletextPage =
    { 0x11264ACB, 0x37DE, 0x4EBA, { 0x8C, 0x35, 0x7F, 0x04, 0xA1, 0xA6, 0x83, 0x32 } };
EXTERN_C const GUID     MEDIATYPE_CC_CONTAINER =
    { 0xAEB312E9, 0x3357, 0x43CA, { 0xB7, 0x01, 0x97, 0xEC, 0x19, 0x8E, 0x2B, 0x62 } };
EXTERN_C const GUID     MEDIATYPE_DTVCCData =
    { 0xFB77E152, 0x53B2, 0x499C, { 0xB4, 0x6B, 0x50, 0x9F, 0xC3, 0x3E, 0xDF, 0xD7 } };
EXTERN_C const GUID     MEDIATYPE_MSTVCaption =
    { 0xB88B8A89, 0xB049, 0x4C80, { 0xAD, 0xCF, 0x58, 0x98, 0x98, 0x5E, 0x22, 0xC1 } };
EXTERN_C const GUID     MEDIATYPE_VBI =
    { 0xF72A76E1, 0xEB0A, 0x11D0, { 0xAC, 0xE4, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     MEDIASUBTYPE_DVB_SUBTITLES =
    { 0x34FFCBC3, 0xD5B3, 0x4171, { 0x90, 0x02, 0xD4, 0xC6, 0x03, 0x01, 0x69, 0x7F } };
EXTERN_C const GUID     MEDIASUBTYPE_ISDB_CAPTIONS =
    { 0x059DD67D, 0x2E55, 0x4D41, { 0x8D, 0x1B, 0x01, 0xF5, 0xE4, 0xF5, 0x06, 0x07 } };
EXTERN_C const GUID     MEDIASUBTYPE_ISDB_SUPERIMPOSE =
    { 0x36DC6D28, 0xF1A6, 0x4216, { 0x90, 0x48, 0x9C, 0xFC, 0xEF, 0xEB, 0x5E, 0xBA } };
EXTERN_C const GUID     MEDIATYPE_Timecode =
    { 0x0482DEE3, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIATYPE_LMRT =
    { 0x74726C6D, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIATYPE_URL_STREAM =
    { 0x736C7275, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_CLPL =
    { 0x4C504C43, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_YUYV =
    { 0x56595559, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IYUV =
    { 0x56555949, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_YVU9 =
    { 0x39555659, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_Y411 =
    { 0x31313459, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_Y41P =
    { 0x50313459, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_YUY2 =
    { 0x32595559, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_YVYU =
    { 0x55595659, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_UYVY =
    { 0x59565955, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_Y211 =
    { 0x31313259, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_CLJR =
    { 0x524A4C43, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IF09 =
    { 0x39304649, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_CPLA =
    { 0x414C5043, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_MJPG =
    { 0x47504A4D, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_TVMJ =
    { 0x4A4D5654, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_WAKE =
    { 0x454B4157, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_CFCC =
    { 0x43434643, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IJPG =
    { 0x47504A49, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_Plum =
    { 0x6D756C50, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_DVCS =
    { 0x53435644, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_H264 =
    { 0x34363248, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_DVSD =
    { 0x44535644, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_MDVF =
    { 0x4656444D, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB1 =
    { 0xE436EB78, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB4 =
    { 0xE436EB79, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB8 =
    { 0xE436EB7A, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB565 =
    { 0xE436EB7B, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB555 =
    { 0xE436EB7C, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB24 =
    { 0xE436EB7D, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB32 =
    { 0xE436EB7E, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB1555 =
    { 0x297C55AF, 0xE209, 0x4CB3, { 0xB7, 0x57, 0xC7, 0x6D, 0x6B, 0x9C, 0x88, 0xA8 } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB4444 =
    { 0x6E6415E6, 0x5C24, 0x425F, { 0x93, 0xCD, 0x80, 0x10, 0x2B, 0x3D, 0x1C, 0xCA } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB32 =
    { 0x773C9AC0, 0x3274, 0x11D0, { 0xB7, 0x24, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01 } };
EXTERN_C const GUID     MEDIASUBTYPE_A2R10G10B10 =
    { 0x2F8BB76D, 0xB644, 0x4550, { 0xAC, 0xF3, 0xD3, 0x0C, 0xAA, 0x65, 0xD5, 0xC5 } };
EXTERN_C const GUID     MEDIASUBTYPE_A2B10G10R10 =
    { 0x576F7893, 0xBDF6, 0x48C4, { 0x87, 0x5F, 0xAE, 0x7B, 0x81, 0x83, 0x45, 0x67 } };
EXTERN_C const GUID     MEDIASUBTYPE_AYUV =
    { 0x56555941, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_AI44 =
    { 0x34344941, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IA44 =
    { 0x34344149, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB32_D3D_DX7_RT =
    { 0x32335237, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB16_D3D_DX7_RT =
    { 0x36315237, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB32_D3D_DX7_RT =
    { 0x38384137, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB4444_D3D_DX7_RT =
    { 0x34344137, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB1555_D3D_DX7_RT =
    { 0x35314137, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB32_D3D_DX9_RT =
    { 0x32335239, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_RGB16_D3D_DX9_RT =
    { 0x36315239, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB32_D3D_DX9_RT =
    { 0x38384139, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB4444_D3D_DX9_RT =
    { 0x34344139, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_ARGB1555_D3D_DX9_RT =
    { 0x35314139, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_YV12 =
    { 0x32315659, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_NV12 =
    { 0x3231564E, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_NV11 =
    { 0x3131564E, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_P208 =
    { '802P', 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_P210 =
    { '012P', 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_P216 =
    { '612P', 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_P010 =
    { '010P', 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_P016 =
    { '610P', 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_Y210 =
    { '012Y', 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_Y216 =
    { '612Y', 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_P408 =
    { '804P', 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_NV24 =
    { 0x3432564E, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IMC1 =
    { 0x31434D49, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IMC2 =
    { 0x32434D49, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IMC3 =
    { 0x33434D49, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IMC4 =
    { 0x34434D49, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_S340 =
    { 0x30343353, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_S342 =
    { 0x32343353, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_Overlay =
    { 0xE436EB7F, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_MPEG1Packet =
    { 0xE436EB80, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_MPEG1Payload =
    { 0xE436EB81, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_MPEG1AudioPayload =
    { 0x00000050, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_MPEG1SystemStream =
    { 0xE436EB82, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_MPEG1System =
    { 0xE436EB84, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_MPEG1VideoCD =
    { 0xE436EB85, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_MPEG1Video =
    { 0xE436EB86, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_MPEG1Audio =
    { 0xE436EB87, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_Avi =
    { 0xE436EB88, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_Asf =
    { 0x3DB80F90, 0x9412, 0x11D1, { 0xAD, 0xED, 0x00, 0x00, 0xF8, 0x75, 0x4B, 0x99 } };
EXTERN_C const GUID     MEDIASUBTYPE_QTMovie =
    { 0xE436EB89, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_QTRpza =
    { 0x617A7072, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_QTSmc =
    { 0x20636D73, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_QTRle =
    { 0x20656C72, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_QTJpeg =
    { 0x6765706A, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_PCMAudio_Obsolete =
    { 0xE436EB8A, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_PCM =
    { 0x00000001, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_WAVE =
    { 0xE436EB8B, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_AU =
    { 0xE436EB8C, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_AIFF =
    { 0xE436EB8D, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const GUID     MEDIASUBTYPE_dvsd =
    { 0x64737664, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_dvhd =
    { 0x64687664, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_dvsl =
    { 0x6C737664, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_dv25 =
    { 0x35327664, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_dv50 =
    { 0x30357664, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_dvh1 =
    { 0x31687664, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_Line21_BytePair =
    { 0x6E8D4A22, 0x310C, 0x11D0, { 0xB7, 0x9A, 0x00, 0xAA, 0x00, 0x37, 0x67, 0xA7 } };
EXTERN_C const GUID     MEDIASUBTYPE_Line21_GOPPacket =
    { 0x6E8D4A23, 0x310C, 0x11D0, { 0xB7, 0x9A, 0x00, 0xAA, 0x00, 0x37, 0x67, 0xA7 } };
EXTERN_C const GUID     MEDIASUBTYPE_Line21_VBIRawData =
    { 0x6E8D4A24, 0x310C, 0x11D0, { 0xB7, 0x9A, 0x00, 0xAA, 0x00, 0x37, 0x67, 0xA7 } };
EXTERN_C const GUID     MEDIASUBTYPE_708_608Data =
    { 0x0AF414BC, 0x4ED2, 0x445E, { 0x98, 0x39, 0x8F, 0x09, 0x55, 0x68, 0xAB, 0x3C } };
EXTERN_C const GUID     MEDIASUBTYPE_DtvCcData =
    { 0xF52ADDAA, 0x36F0, 0x43F5, { 0x95, 0xEA, 0x6D, 0x86, 0x64, 0x84, 0x26, 0x2A } };
EXTERN_C const GUID     MEDIASUBTYPE_CC_CONTAINER =
    { 0x7EA626DB, 0x54DA, 0x437B, { 0xBE, 0x9F, 0xF7, 0x30, 0x73, 0xAD, 0xFA, 0x3C } };
EXTERN_C const GUID     MEDIASUBTYPE_TELETEXT =
    { 0xF72A76E3, 0xEB0A, 0x11D0, { 0xAC, 0xE4, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     MEDIASUBTYPE_VBI =
    { 0x663DA43C, 0x03E8, 0x4E9A, { 0x9C, 0xD5, 0xBF, 0x11, 0xED, 0x0D, 0xEF, 0x76 } };
EXTERN_C const GUID     MEDIASUBTYPE_WSS =
    { 0x2791D576, 0x8E7A, 0x466F, { 0x9E, 0x90, 0x5D, 0x3F, 0x30, 0x83, 0x73, 0x8B } };
EXTERN_C const GUID     MEDIASUBTYPE_XDS =
    { 0x01CA73E3, 0xDCE6, 0x4575, { 0xAF, 0xE1, 0x2B, 0xF1, 0xC9, 0x02, 0xCA, 0xF3 } };
EXTERN_C const GUID     MEDIASUBTYPE_VPS =
    { 0xA1B3F620, 0x9792, 0x4D8D, { 0x81, 0xA4, 0x86, 0xAF, 0x25, 0x77, 0x20, 0x90 } };
EXTERN_C const GUID     MEDIASUBTYPE_DRM_Audio =
    { 0x00000009, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_IEEE_FLOAT =
    { 0x00000003, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_DOLBY_AC3_SPDIF =
    { 0x00000092, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_RAW_SPORT =
    { 0x00000240, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_SPDIF_TAG_241h =
    { 0x00000241, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } };
EXTERN_C const GUID     MEDIASUBTYPE_DssVideo =
    { 0xA0AF4F81, 0xE163, 0x11D0, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const GUID     MEDIASUBTYPE_DssAudio =
    { 0xA0AF4F82, 0xE163, 0x11D0, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const GUID     MEDIASUBTYPE_VPVideo =
    { 0x5A9B6A40, 0x1A22, 0x11D1, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const GUID     MEDIASUBTYPE_VPVBI =
    { 0x5A9B6A41, 0x1A22, 0x11D1, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const CLSID    CLSID_CaptureGraphBuilder =
    { 0xBF87B6E0, 0x8C27, 0x11D0, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const CLSID    CLSID_CaptureGraphBuilder2 =
    { 0xBF87B6E1, 0x8C27, 0x11D0, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const CLSID    CLSID_ProtoFilterGraph =
    { 0xE436EBB0, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_SystemClock =
    { 0xE436EBB1, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_FilterMapper =
    { 0xE436EBB2, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_FilterGraph =
    { 0xE436EBB3, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_FilterGraphNoThread =
    { 0xE436EBB8, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_FilterGraphPrivateThread =
    { 0xA3ECBC41, 0x581A, 0x4476, { 0xB6, 0x93, 0xA6, 0x33, 0x40, 0x46, 0x2D, 0x8B } };
EXTERN_C const CLSID    CLSID_MPEG1Doc =
    { 0xE4BBD160, 0x4269, 0x11CE, { 0x83, 0x8D, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const CLSID    CLSID_FileSource =
    { 0x701722E0, 0x8AE3, 0x11CE, { 0xA8, 0x5C, 0x00, 0xAA, 0x00, 0x2F, 0xEA, 0xB5 } };
EXTERN_C const CLSID    CLSID_MPEG1PacketPlayer =
    { 0x26C25940, 0x4CA9, 0x11CE, { 0xA8, 0x28, 0x00, 0xAA, 0x00, 0x2F, 0xEA, 0xB5 } };
EXTERN_C const CLSID    CLSID_MPEG1Splitter =
    { 0x336475D0, 0x942A, 0x11CE, { 0xA8, 0x70, 0x00, 0xAA, 0x00, 0x2F, 0xEA, 0xB5 } };
EXTERN_C const CLSID    CLSID_CMpegVideoCodec =
    { 0xFEB50740, 0x7BEF, 0x11CE, { 0x9B, 0xD9, 0x00, 0x00, 0xE2, 0x02, 0x59, 0x9C } };
EXTERN_C const CLSID    CLSID_CMpegAudioCodec =
    { 0x4A2286E0, 0x7BEF, 0x11CE, { 0x9B, 0xD9, 0x00, 0x00, 0xE2, 0x02, 0x59, 0x9C } };
EXTERN_C const CLSID    CLSID_TextRender =
    { 0xE30629D3, 0x27E5, 0x11CE, { 0x87, 0x5D, 0x00, 0x60, 0x8C, 0xB7, 0x80, 0x66 } };
EXTERN_C const CLSID    CLSID_InfTee =
    { 0xF8388A40, 0xD5BB, 0x11D0, { 0xBE, 0x5A, 0x00, 0x80, 0xC7, 0x06, 0x56, 0x8E } };
EXTERN_C const CLSID    CLSID_AviSplitter =
    { 0x1B544C20, 0xFD0B, 0x11CE, { 0x8C, 0x63, 0x00, 0xAA, 0x00, 0x44, 0xB5, 0x1E } };
EXTERN_C const CLSID    CLSID_AviReader =
    { 0x1B544C21, 0xFD0B, 0x11CE, { 0x8C, 0x63, 0x00, 0xAA, 0x00, 0x44, 0xB5, 0x1E } };
EXTERN_C const CLSID    CLSID_VfwCapture =
    { 0x1B544C22, 0xFD0B, 0x11CE, { 0x8C, 0x63, 0x00, 0xAA, 0x00, 0x44, 0xB5, 0x1E } };
EXTERN_C const CLSID    CLSID_CaptureProperties =
    { 0x1B544C22, 0xFD0B, 0x11CE, { 0x8C, 0x63, 0x00, 0xAA, 0x00, 0x44, 0xB5, 0x1E } };
EXTERN_C const CLSID    CLSID_FGControl =
    { 0xE436EBB4, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_MOVReader =
    { 0x44584800, 0xF8EE, 0x11CE, { 0xB2, 0xD4, 0x00, 0xDD, 0x01, 0x10, 0x1B, 0x85 } };
EXTERN_C const CLSID    CLSID_QuickTimeParser =
    { 0xD51BD5A0, 0x7548, 0x11CF, { 0xA5, 0x20, 0x00, 0x80, 0xC7, 0x7E, 0xF5, 0x8A } };
EXTERN_C const CLSID    CLSID_QTDec =
    { 0xFDFE9681, 0x74A3, 0x11D0, { 0xAF, 0xA7, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const CLSID    CLSID_AVIDoc =
    { 0xD3588AB0, 0x0781, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_VideoRenderer =
    { 0x70E102B0, 0x5556, 0x11CE, { 0x97, 0xC0, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const CLSID    CLSID_Colour =
    { 0x1643E180, 0x90F5, 0x11CE, { 0x97, 0xD5, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const CLSID    CLSID_Dither =
    { 0x1DA08500, 0x9EDC, 0x11CF, { 0xBC, 0x10, 0x00, 0xAA, 0x00, 0xAC, 0x74, 0xF6 } };
EXTERN_C const CLSID    CLSID_ModexRenderer =
    { 0x07167665, 0x5011, 0x11CF, { 0xBF, 0x33, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const CLSID    CLSID_AudioRender =
    { 0xE30629D1, 0x27E5, 0x11CE, { 0x87, 0x5D, 0x00, 0x60, 0x8C, 0xB7, 0x80, 0x66 } };
EXTERN_C const CLSID    CLSID_AudioProperties =
    { 0x05589FAF, 0xC356, 0x11CE, { 0xBF, 0x01, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const CLSID    CLSID_DSoundRender =
    { 0x79376820, 0x07D0, 0x11CF, { 0xA2, 0x4D, 0x00, 0x20, 0xAF, 0xD7, 0x97, 0x67 } };
EXTERN_C const CLSID    CLSID_AudioRecord =
    { 0xE30629D2, 0x27E5, 0x11CE, { 0x87, 0x5D, 0x00, 0x60, 0x8C, 0xB7, 0x80, 0x66 } };
EXTERN_C const CLSID    CLSID_AudioInputMixerProperties =
    { 0x2CA8CA52, 0x3C3F, 0x11D2, { 0xB7, 0x3D, 0x00, 0xC0, 0x4F, 0xB6, 0xBD, 0x3D } };
EXTERN_C const CLSID    CLSID_AVIDec =
    { 0xCF49D4E0, 0x1115, 0x11CE, { 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_AVIDraw =
    { 0xA888DF60, 0x1E90, 0x11CF, { 0xAC, 0x98, 0x00, 0xAA, 0x00, 0x4C, 0x0F, 0xA9 } };
EXTERN_C const CLSID    CLSID_ACMWrapper =
    { 0x6A08CF80, 0x0E18, 0x11CF, { 0xA2, 0x4D, 0x00, 0x20, 0xAF, 0xD7, 0x97, 0x67 } };
EXTERN_C const CLSID    CLSID_AsyncReader =
    { 0xE436EBB5, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_URLReader =
    { 0xE436EBB6, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_PersistMonikerPID =
    { 0xE436EBB7, 0x524F, 0x11CE, { 0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70 } };
EXTERN_C const CLSID    CLSID_AVICo =
    { 0xD76E2820, 0x1563, 0x11CF, { 0xAC, 0x98, 0x00, 0xAA, 0x00, 0x4C, 0x0F, 0xA9 } };
EXTERN_C const CLSID    CLSID_FileWriter =
    { 0x8596E5F0, 0x0DA5, 0x11D0, { 0xBD, 0x21, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_AviDest =
    { 0xE2510970, 0xF137, 0x11CE, { 0x8B, 0x67, 0x00, 0xAA, 0x00, 0xA3, 0xF1, 0xA6 } };
EXTERN_C const CLSID    CLSID_AviMuxProptyPage =
    { 0xC647B5C0, 0x157C, 0x11D0, { 0xBD, 0x23, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_AviMuxProptyPage1 =
    { 0x0A9AE910, 0x85C0, 0x11D0, { 0xBD, 0x42, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_AVIMIDIRender =
    { 0x07B65360, 0xC445, 0x11CE, { 0xAF, 0xDE, 0x00, 0xAA, 0x00, 0x6C, 0x14, 0xF4 } };
EXTERN_C const CLSID    CLSID_WMAsfReader =
    { 0x187463A0, 0x5BB7, 0x11D3, { 0xAC, 0xBE, 0x00, 0x80, 0xC7, 0x5E, 0x24, 0x6E } };
EXTERN_C const CLSID    CLSID_WMAsfWriter =
    { 0x7C23220E, 0x55BB, 0x11D3, { 0x8B, 0x16, 0x00, 0xC0, 0x4F, 0xB6, 0xBD, 0x3D } };
EXTERN_C const CLSID    CLSID_MPEG2Demultiplexer =
    { 0xAFB6C280, 0x2C41, 0x11D3, { 0x8A, 0x60, 0x00, 0x00, 0xF8, 0x1E, 0x0E, 0x4A } };
EXTERN_C const CLSID    CLSID_MPEG2Demultiplexer_NoClock =
    { 0x687D3367, 0x3644, 0x467A, { 0xAD, 0xFE, 0x6C, 0xD7, 0xA8, 0x5C, 0x4A, 0x2C } };
EXTERN_C const CLSID    CLSID_MMSPLITTER =
    { 0x3AE86B20, 0x7BE8, 0x11D1, { 0xAB, 0xE6, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const CLSID    CLSID_StreamBufferSink =
    { 0x2DB47AE5, 0xCF39, 0x43C2, { 0xB4, 0xD6, 0x0C, 0xD8, 0xD9, 0x09, 0x46, 0xF4 } };
EXTERN_C const CLSID    CLSID_SBE2Sink =
    { 0xE2448508, 0x95DA, 0x4205, { 0x9A, 0x27, 0x7E, 0xC8, 0x1E, 0x72, 0x3B, 0x1A } };
EXTERN_C const CLSID    CLSID_StreamBufferSource =
    { 0xC9F4FE02, 0xF851, 0x4EB5, { 0x99, 0xEE, 0xAD, 0x60, 0x2A, 0xF1, 0xE6, 0x19 } };
EXTERN_C const CLSID    CLSID_StreamBufferConfig =
    { 0xFA8A68B2, 0xC864, 0x4BA2, { 0xAD, 0x53, 0xD3, 0x87, 0x6A, 0x87, 0x49, 0x4B } };
EXTERN_C const CLSID    CLSID_StreamBufferPropertyHandler =
    { 0xE37A73F8, 0xFB01, 0x43DC, { 0x91, 0x4E, 0xAA, 0xEE, 0x76, 0x09, 0x5A, 0xB9 } };
EXTERN_C const CLSID    CLSID_StreamBufferThumbnailHandler =
    { 0x713790EE, 0x5EE1, 0x45BA, { 0x80, 0x70, 0xA1, 0x33, 0x7D, 0x27, 0x62, 0xFA } };
EXTERN_C const CLSID    CLSID_Mpeg2VideoStreamAnalyzer =
    { 0x6CFAD761, 0x735D, 0x4AA5, { 0x8A, 0xFC, 0xAF, 0x91, 0xA7, 0xD6, 0x1E, 0xBA } };
EXTERN_C const CLSID    CLSID_StreamBufferRecordingAttributes =
    { 0xCCAA63AC, 0x1057, 0x4778, { 0xAE, 0x92, 0x12, 0x06, 0xAB, 0x9A, 0xCE, 0xE6 } };
EXTERN_C const CLSID    CLSID_StreamBufferComposeRecording =
    { 0xD682C4BA, 0xA90A, 0x42FE, { 0xB9, 0xE1, 0x03, 0x10, 0x98, 0x49, 0xC4, 0x23 } };
EXTERN_C const CLSID    CLSID_SBE2File =
    { 0x93A094D7, 0x51E8, 0x485B, { 0x90, 0x4A, 0x8D, 0x6B, 0x97, 0xDC, 0x6B, 0x39 } };
EXTERN_C const CLSID    CLSID_DVVideoCodec =
    { 0xB1B77C00, 0xC3E4, 0x11CF, { 0xAF, 0x79, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const CLSID    CLSID_DVVideoEnc =
    { 0x13AA3650, 0xBB6F, 0x11D0, { 0xAF, 0xB9, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const CLSID    CLSID_DVSplitter =
    { 0x4EB31670, 0x9FC6, 0x11CF, { 0xAF, 0x6E, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const CLSID    CLSID_DVMux =
    { 0x129D7E40, 0xC10D, 0x11D0, { 0xAF, 0xB9, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const CLSID    CLSID_SeekingPassThru =
    { 0x060AF76C, 0x68DD, 0x11D0, { 0x8F, 0xC1, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D } };
EXTERN_C const CLSID    CLSID_Line21Decoder =
    { 0x6E8D4A20, 0x310C, 0x11D0, { 0xB7, 0x9A, 0x00, 0xAA, 0x00, 0x37, 0x67, 0xA7 } };
EXTERN_C const CLSID    CLSID_Line21Decoder2 =
    { 0xE4206432, 0x01A1, 0x4BEE, { 0xB3, 0xE1, 0x37, 0x02, 0xC8, 0xED, 0xC5, 0x74 } };
EXTERN_C const CLSID    CLSID_CCAFilter =
    { 0x3D07A539, 0x35CA, 0x447C, { 0x9B, 0x05, 0x8D, 0x85, 0xCE, 0x92, 0x4F, 0x9E } };
EXTERN_C const CLSID    CLSID_OverlayMixer =
    { 0xCD8743A1, 0x3736, 0x11D0, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const CLSID    CLSID_VBISurfaces =
    { 0x814B9800, 0x1C88, 0x11D1, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const CLSID    CLSID_WSTDecoder =
    { 0x70BC06E0, 0x5666, 0x11D3, { 0xA1, 0x84, 0x00, 0x10, 0x5A, 0xEF, 0x9F, 0x33 } };
EXTERN_C const CLSID    CLSID_MjpegDec =
    { 0x301056D0, 0x6DFF, 0x11D2, { 0x9E, 0xEB, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37 } };
EXTERN_C const CLSID    CLSID_MJPGEnc =
    { 0xB80AB0A0, 0x7416, 0x11D2, { 0x9E, 0xEB, 0x00, 0x60, 0x08, 0x03, 0x9E, 0x37 } };
EXTERN_C const CLSID    CLSID_SystemDeviceEnum =
    { 0x62BE5D10, 0x60EB, 0x11D0, { 0xBD, 0x3B, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_CDeviceMoniker =
    { 0x4315D437, 0x5B8C, 0x11D0, { 0xBD, 0x3B, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_VideoInputDeviceCategory =
    { 0x860BB310, 0x5D01, 0x11D0, { 0xBD, 0x3B, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_CVidCapClassManager =
    { 0x860BB310, 0x5D01, 0x11D0, { 0xBD, 0x3B, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_LegacyAmFilterCategory =
    { 0x083863F1, 0x70DE, 0x11D0, { 0xBD, 0x40, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_CQzFilterClassManager =
    { 0x083863F1, 0x70DE, 0x11D0, { 0xBD, 0x40, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_VideoCompressorCategory =
    { 0x33D9A760, 0x90C8, 0x11D0, { 0xBD, 0x43, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_CIcmCoClassManager =
    { 0x33D9A760, 0x90C8, 0x11D0, { 0xBD, 0x43, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_AudioCompressorCategory =
    { 0x33D9A761, 0x90C8, 0x11D0, { 0xBD, 0x43, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_CAcmCoClassManager =
    { 0x33D9A761, 0x90C8, 0x11D0, { 0xBD, 0x43, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_AudioInputDeviceCategory =
    { 0x33D9A762, 0x90C8, 0x11D0, { 0xBD, 0x43, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_CWaveinClassManager =
    { 0x33D9A762, 0x90C8, 0x11D0, { 0xBD, 0x43, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_AudioRendererCategory =
    { 0xE0F158E1, 0xCB04, 0x11D0, { 0xBD, 0x4E, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_MidiRendererCategory =
    { 0x4EFE2452, 0x168A, 0x11D1, { 0xBC, 0x76, 0x00, 0xC0, 0x4F, 0xB9, 0x45, 0x3B } };
EXTERN_C const CLSID    CLSID_CMidiOutClassManager =
    { 0x4EFE2452, 0x168A, 0x11D1, { 0xBC, 0x76, 0x00, 0xC0, 0x4F, 0xB9, 0x45, 0x3B } };
EXTERN_C const CLSID    CLSID_TransmitCategory =
    { 0xCC7BFB41, 0xF175, 0x11D1, { 0xA3, 0x92, 0x00, 0xE0, 0x29, 0x1F, 0x39, 0x59 } };
EXTERN_C const CLSID    CLSID_DeviceControlCategory =
    { 0xCC7BFB46, 0xF175, 0x11D1, { 0xA3, 0x92, 0x00, 0xE0, 0x29, 0x1F, 0x39, 0x59 } };
EXTERN_C const CLSID    CLSID_ActiveMovieCategories =
    { 0xDA4E3DA0, 0xD07D, 0x11D0, { 0xBD, 0x50, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_DVDHWDecodersCategory =
    { 0x2721AE20, 0x7E70, 0x11D0, { 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00 } };
EXTERN_C const CLSID    CLSID_MediaEncoderCategory =
    { 0x7D22E920, 0x5CA9, 0x4787, { 0x8C, 0x2B, 0xA6, 0x77, 0x9B, 0xD1, 0x17, 0x81 } };
EXTERN_C const CLSID    CLSID_MediaMultiplexerCategory =
    { 0x236C9559, 0xADCE, 0x4736, { 0xBF, 0x72, 0xBA, 0xB3, 0x4E, 0x39, 0x21, 0x96 } };
EXTERN_C const CLSID    CLSID_FilterMapper2 =
    { 0xCDA42200, 0xBD88, 0x11D0, { 0xBD, 0x4E, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_MemoryAllocator =
    { 0x1E651CC0, 0xB199, 0x11D0, { 0x82, 0x12, 0x00, 0xC0, 0x4F, 0xC3, 0x2C, 0x45 } };
EXTERN_C const CLSID    CLSID_MediaPropertyBag =
    { 0xCDBD8D00, 0xC193, 0x11D0, { 0xBD, 0x4E, 0x00, 0xA0, 0xC9, 0x11, 0xCE, 0x86 } };
EXTERN_C const CLSID    CLSID_DvdGraphBuilder =
    { 0xFCC152B7, 0xF372, 0x11D0, { 0x8E, 0x00, 0x00, 0xC0, 0x4F, 0xD7, 0xC0, 0x8B } };
EXTERN_C const CLSID    CLSID_DVDNavigator =
    { 0x9B8C4620, 0x2C1A, 0x11D0, { 0x84, 0x93, 0x00, 0xA0, 0x24, 0x38, 0xAD, 0x48 } };
EXTERN_C const CLSID    CLSID_DVDState =
    { 0xF963C5CF, 0xA659, 0x4A93, { 0x96, 0x38, 0xCA, 0xF3, 0xCD, 0x27, 0x7D, 0x13 } };
EXTERN_C const CLSID    CLSID_SmartTee =
    { 0xCC58E280, 0x8AA1, 0x11D1, { 0xB3, 0xF1, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const CLSID    CLSID_DtvCcFilter =
    { 0xFB056BA0, 0x2502, 0x45B9, { 0x8E, 0x86, 0x2B, 0x40, 0xDE, 0x84, 0xAD, 0x29 } };
EXTERN_C const CLSID    CLSID_CaptionsFilter =
    { 0x2F7EE4B6, 0x6FF5, 0x4EB4, { 0xB2, 0x4A, 0x2B, 0xFC, 0x41, 0x11, 0x71, 0x71 } };
EXTERN_C const CLSID    CLSID_SubtitlesFilter =
    { 0x9F22CFEA, 0xCE07, 0x41AB, { 0x8B, 0xA0, 0xC7, 0x36, 0x4A, 0xF9, 0x0A, 0xF9 } };
EXTERN_C const CLSID    CLSID_DirectShowPluginControl =
    { 0x8670C736, 0xF614, 0x427B, { 0x8A, 0xDA, 0xBB, 0xAD, 0xC5, 0x87, 0x19, 0x4B } };
EXTERN_C const GUID     FORMAT_None =
    { 0x0F6417D6, 0xC318, 0x11D0, { 0xA4, 0x3F, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96 } };
EXTERN_C const GUID     FORMAT_VideoInfo =
    { 0x05589F80, 0xC356, 0x11CE, { 0xBF, 0x01, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const GUID     FORMAT_VideoInfo2 =
    { 0xF72A76A0, 0xEB0A, 0x11D0, { 0xAC, 0xE4, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     FORMAT_WaveFormatEx =
    { 0x05589F81, 0xC356, 0x11CE, { 0xBF, 0x01, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const GUID     FORMAT_MPEGVideo =
    { 0x05589F82, 0xC356, 0x11CE, { 0xBF, 0x01, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const GUID     FORMAT_MPEGStreams =
    { 0x05589F83, 0xC356, 0x11CE, { 0xBF, 0x01, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const GUID     FORMAT_DvInfo =
    { 0x05589F84, 0xC356, 0x11CE, { 0xBF, 0x01, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const GUID     FORMAT_525WSS =
    { 0xC7ECF04D, 0x4582, 0x4869, { 0x9A, 0xBB, 0xBF, 0xB5, 0x23, 0xB6, 0x2E, 0xDF } };
EXTERN_C const CLSID    CLSID_DirectDrawProperties =
    { 0x944D4C00, 0xDD52, 0x11CE, { 0xBF, 0x0E, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const CLSID    CLSID_PerformanceProperties =
    { 0x59CE6880, 0xACF8, 0x11CF, { 0xB5, 0x6E, 0x00, 0x80, 0xC7, 0xC4, 0xB6, 0x8A } };
EXTERN_C const CLSID    CLSID_QualityProperties =
    { 0x418AFB70, 0xF8B8, 0x11CE, { 0xAA, 0xC6, 0x00, 0x20, 0xAF, 0x0B, 0x99, 0xA3 } };
EXTERN_C const IID      IID_IBaseVideoMixer =
    { 0x61DED640, 0xE912, 0x11CE, { 0xA0, 0x99, 0x00, 0xAA, 0x00, 0x47, 0x9A, 0x58 } };
EXTERN_C const IID      IID_IDirectDrawVideo =
    { 0x36D39EB0, 0xDD75, 0x11CE, { 0xBF, 0x0E, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const IID      IID_IQualProp =
    { 0x1BD0ECB0, 0xF8E2, 0x11CE, { 0xAA, 0xC6, 0x00, 0x20, 0xAF, 0x0B, 0x99, 0xA3 } };
EXTERN_C const CLSID    CLSID_VPObject =
    { 0xCE292861, 0xFC88, 0x11D0, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const IID      IID_IVPObject =
    { 0xCE292862, 0xFC88, 0x11D0, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const IID      IID_IVPControl =
    { 0x25DF12C1, 0x3DE0, 0x11D1, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const CLSID    CLSID_VPVBIObject =
    { 0x814B9801, 0x1C88, 0x11D1, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const IID      IID_IVPVBIObject =
    { 0x814B9802, 0x1C88, 0x11D1, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const IID      IID_IVPConfig =
    { 0xBC29A660, 0x30E3, 0x11D0, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const IID      IID_IVPNotify =
    { 0xC76794A1, 0xD6C5, 0x11D0, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const IID      IID_IVPNotify2 =
    { 0xEBF47183, 0x8764, 0x11D1, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const IID      IID_IVPVBIConfig =
    { 0xEC529B00, 0x1A1F, 0x11D1, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const IID      IID_IVPVBINotify =
    { 0xEC529B01, 0x1A1F, 0x11D1, { 0xBA, 0xD9, 0x00, 0x60, 0x97, 0x44, 0x11, 0x1A } };
EXTERN_C const IID      IID_IMixerPinConfig =
    { 0x593CDDE1, 0x0759, 0x11D1, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const IID      IID_IMixerPinConfig2 =
    { 0xEBF47182, 0x8764, 0x11D1, { 0x9E, 0x69, 0x00, 0xC0, 0x4F, 0xD7, 0xC1, 0x5B } };
EXTERN_C const CLSID    CLSID_ModexProperties =
    { 0x0618AA30, 0x6BC4, 0x11CF, { 0xBF, 0x36, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const IID      IID_IFullScreenVideo =
    { 0xDD1D7110, 0x7836, 0x11CF, { 0xBF, 0x47, 0x00, 0xAA, 0x00, 0x55, 0x59, 0x5A } };
EXTERN_C const IID      IID_IFullScreenVideoEx =
    { 0x53479470, 0xF1DD, 0x11CF, { 0xBC, 0x42, 0x00, 0xAA, 0x00, 0xAC, 0x74, 0xF6 } };
EXTERN_C const CLSID    CLSID_DVDevPropertiesPage =
    { 0x101193C0, 0x0BFE, 0x11D0, { 0xAF, 0x91, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const CLSID    CLSID_DVEncPropertiesPage =
    { 0x4150F050, 0xBB6F, 0x11D0, { 0xAF, 0xB9, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const CLSID    CLSID_DVMuxPropertyPage =
    { 0x4DB880E0, 0xC10D, 0x11D0, { 0xAF, 0xB9, 0x00, 0xAA, 0x00, 0xB6, 0x7A, 0x42 } };
EXTERN_C const IID      IID_IAMDirectSound =
    { 0x546F4260, 0xD53E, 0x11CF, { 0xB3, 0xF0, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const IID      IID_IMpegAudioDecoder =
    { 0xB45DD570, 0x3C77, 0x11D1, { 0xAB, 0xE1, 0x00, 0xA0, 0xC9, 0x05, 0xF3, 0x75 } };
EXTERN_C const IID      IID_IAMLine21Decoder =
    { 0x6E8D4A21, 0x310C, 0x11D0, { 0xB7, 0x9A, 0x00, 0xAA, 0x00, 0x37, 0x67, 0xA7 } };
EXTERN_C const IID      IID_IAMWstDecoder =
    { 0xC056DE21, 0x75C2, 0x11D3, { 0xA1, 0x84, 0x00, 0x10, 0x5A, 0xEF, 0x9F, 0x33 } };
EXTERN_C const CLSID    CLSID_WstDecoderPropertyPage =
    { 0x04E27F80, 0x91E4, 0x11D3, { 0xA1, 0x84, 0x00, 0x10, 0x5A, 0xEF, 0x9F, 0x33 } };
EXTERN_C const GUID     FORMAT_AnalogVideo =
    { 0x0482DDE0, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIATYPE_AnalogVideo =
    { 0x0482DDE1, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_NTSC_M =
    { 0x0482DDE2, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_PAL_B =
    { 0x0482DDE5, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_PAL_D =
    { 0x0482DDE6, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_PAL_G =
    { 0x0482DDE7, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_PAL_H =
    { 0x0482DDE8, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_PAL_I =
    { 0x0482DDE9, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_PAL_M =
    { 0x0482DDEA, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_PAL_N =
    { 0x0482DDEB, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_PAL_N_COMBO =
    { 0x0482DDEC, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_SECAM_B =
    { 0x0482DDF0, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_SECAM_D =
    { 0x0482DDF1, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_SECAM_G =
    { 0x0482DDF2, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_SECAM_H =
    { 0x0482DDF3, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_SECAM_K =
    { 0x0482DDF4, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_SECAM_K1 =
    { 0x0482DDF5, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIASUBTYPE_AnalogVideo_SECAM_L =
    { 0x0482DDF6, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     MEDIATYPE_AnalogAudio =
    { 0x0482DEE1, 0x7817, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const GUID     FORMAT_CAPTIONED_H264VIDEO =
    { 0xA4EFC024, 0x873E, 0x4DA3, { 0x89, 0x8B, 0x47, 0x4D, 0xDB, 0xD7, 0x9F, 0xD0 } };
EXTERN_C const GUID     FORMAT_CC_CONTAINER =
    { 0x50997A4A, 0xE508, 0x4054, { 0xA2, 0xB2, 0x10, 0xFF, 0x0A, 0xC1, 0xA6, 0x9A } };
EXTERN_C const GUID     CAPTION_FORMAT_ATSC =
    { 0x3ED9CB31, 0xFD10, 0x4ADE, { 0xBC, 0xCC, 0xFB, 0x91, 0x05, 0xD2, 0xF3, 0xEF } };
EXTERN_C const GUID     CAPTION_FORMAT_DVB =
    { 0x12230DB4, 0xFF2A, 0x447E, { 0xBB, 0x88, 0x68, 0x41, 0xC4, 0x16, 0xD0, 0x68 } };
EXTERN_C const GUID     CAPTION_FORMAT_DIRECTV =
    { 0xE9CA1CE7, 0x915E, 0x47BE, { 0x9B, 0xB9, 0xBF, 0x1D, 0x8A, 0x13, 0xA5, 0xEC } };
EXTERN_C const GUID     CAPTION_FORMAT_ECHOSTAR =
    { 0xEBB1A262, 0x1158, 0x4B99, { 0xAE, 0x80, 0x92, 0xAC, 0x77, 0x69, 0x52, 0xC4 } };
EXTERN_C const GUID     FORMAT_CAPTIONED_MPEG2VIDEO =
    { 0x7AB2ADA2, 0x81B6, 0x4F14, { 0xB3, 0xC8, 0xD0, 0xC4, 0x86, 0x39, 0x3B, 0x67 } };
EXTERN_C const GUID     TIME_FORMAT_NONE =
    { 0x00000000, 0x0000, 0x0000, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } };
EXTERN_C const GUID     TIME_FORMAT_FRAME =
    { 0x7B785570, 0x8C82, 0x11CF, { 0xBC, 0x0C, 0x00, 0xAA, 0x00, 0xAC, 0x74, 0xF6 } };
EXTERN_C const GUID     TIME_FORMAT_BYTE =
    { 0x7B785571, 0x8C82, 0x11CF, { 0xBC, 0x0C, 0x00, 0xAA, 0x00, 0xAC, 0x74, 0xF6 } };
EXTERN_C const GUID     TIME_FORMAT_SAMPLE =
    { 0x7B785572, 0x8C82, 0x11CF, { 0xBC, 0x0C, 0x00, 0xAA, 0x00, 0xAC, 0x74, 0xF6 } };
EXTERN_C const GUID     TIME_FORMAT_FIELD =
    { 0x7B785573, 0x8C82, 0x11CF, { 0xBC, 0x0C, 0x00, 0xAA, 0x00, 0xAC, 0x74, 0xF6 } };
EXTERN_C const GUID     TIME_FORMAT_MEDIA_TIME =
    { 0x7B785574, 0x8C82, 0x11CF, { 0xBC, 0x0C, 0x00, 0xAA, 0x00, 0xAC, 0x74, 0xF6 } };
EXTERN_C const GUID     AMPROPSETID_Pin =
    { 0x9B00F101, 0x1567, 0x11D1, { 0xB3, 0xF1, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const GUID     PIN_CATEGORY_CAPTURE =
    { 0xFB6C4281, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_PREVIEW =
    { 0xFB6C4282, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_ANALOGVIDEOIN =
    { 0xFB6C4283, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_VBI =
    { 0xFB6C4284, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_VIDEOPORT =
    { 0xFB6C4285, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_NABTS =
    { 0xFB6C4286, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_EDS =
    { 0xFB6C4287, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_TELETEXT =
    { 0xFB6C4288, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_CC =
    { 0xFB6C4289, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_STILL =
    { 0xFB6C428A, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_TIMECODE =
    { 0xFB6C428B, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     PIN_CATEGORY_VIDEOPORT_VBI =
    { 0xFB6C428C, 0x0353, 0x11D1, { 0x90, 0x5F, 0x00, 0x00, 0xC0, 0xCC, 0x16, 0xBA } };
EXTERN_C const GUID     LOOK_UPSTREAM_ONLY =
    { 0xAC798BE0, 0x98E3, 0x11D1, { 0xB3, 0xF1, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const GUID     LOOK_DOWNSTREAM_ONLY =
    { 0xAC798BE1, 0x98E3, 0x11D1, { 0xB3, 0xF1, 0x00, 0xAA, 0x00, 0x37, 0x61, 0xC5 } };
EXTERN_C const CLSID    CLSID_TVTunerFilterPropertyPage =
    { 0x266EEE41, 0x6C63, 0x11CF, { 0x8A, 0x03, 0x00, 0xAA, 0x00, 0x6E, 0xCB, 0x65 } };
EXTERN_C const CLSID    CLSID_CrossbarFilterPropertyPage =
    { 0x71F96461, 0x78F3, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const CLSID    CLSID_TVAudioFilterPropertyPage =
    { 0x71F96463, 0x78F3, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const CLSID    CLSID_VideoProcAmpPropertyPage =
    { 0x71F96464, 0x78F3, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const CLSID    CLSID_CameraControlPropertyPage =
    { 0x71F96465, 0x78F3, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const CLSID    CLSID_AnalogVideoDecoderPropertyPage =
    { 0x71F96466, 0x78F3, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const CLSID    CLSID_VideoStreamConfigPropertyPage =
    { 0x71F96467, 0x78F3, 0x11D0, { 0xA1, 0x8C, 0x00, 0xA0, 0xC9, 0x11, 0x89, 0x56 } };
EXTERN_C const CLSID    CLSID_AudioRendererAdvancedProperties =
    { 0x37E92A92, 0xD9AA, 0x11D2, { 0xBF, 0x84, 0x8E, 0xF2, 0xB1, 0x55, 0x5A, 0xED } };
EXTERN_C const CLSID    CLSID_VideoMixingRenderer =
    { 0xB87BEB7B, 0x8D29, 0x423F, { 0xAE, 0x4D, 0x65, 0x82, 0xC1, 0x01, 0x75, 0xAC } };
EXTERN_C const CLSID    CLSID_VideoRendererDefault =
    { 0x6BC1CFFA, 0x8FC1, 0x4261, { 0xAC, 0x22, 0xCF, 0xB4, 0xCC, 0x38, 0xDB, 0x50 } };
EXTERN_C const CLSID    CLSID_AllocPresenter =
    { 0x99D54F63, 0x1A69, 0x41AE, { 0xAA, 0x4D, 0xC9, 0x76, 0xEB, 0x3F, 0x07, 0x13 } };
EXTERN_C const CLSID    CLSID_AllocPresenterDDXclMode =
    { 0x4444AC9E, 0x242E, 0x471B, { 0xA3, 0xC7, 0x45, 0xDC, 0xD4, 0x63, 0x52, 0xBC } };
EXTERN_C const CLSID    CLSID_VideoPortManager =
    { 0x6F26A6CD, 0x967B, 0x47FD, { 0x87, 0x4A, 0x7A, 0xED, 0x2C, 0x9D, 0x25, 0xA2 } };
EXTERN_C const CLSID    CLSID_VideoMixingRenderer9 =
    { 0x51B4ABF3, 0x748F, 0x4E3B, { 0xA2, 0x76, 0xC8, 0x28, 0x33, 0x0E, 0x92, 0x6A } };
EXTERN_C const CLSID    CLSID_EnhancedVideoRenderer =
    { 0xFA10746C, 0x9B63, 0x4B6C, { 0xBC, 0x49, 0xFC, 0x30, 0x0E, 0xA5, 0xF2, 0x56 } };
EXTERN_C const CLSID    CLSID_MFVideoMixer9 =
    { 0xE474E05A, 0xAB65, 0x4F6A, { 0x82, 0x7C, 0x21, 0x8B, 0x1B, 0xAA, 0xF3, 0x1F } };
EXTERN_C const CLSID    CLSID_MFVideoPresenter9 =
    { 0x98455561, 0x5136, 0x4D28, { 0xAB, 0x08, 0x4C, 0xEE, 0x40, 0xEA, 0x27, 0x81 } };
EXTERN_C const CLSID    CLSID_EVRTearlessWindowPresenter9 =
    { 0xA0A7A57B, 0x59B2, 0x4919, { 0xA6, 0x94, 0xAD, 0xD0, 0xA5, 0x26, 0xC3, 0x73 } };
EXTERN_C const CLSID    CLSID_EVRPlaybackPipelineOptimizer =
    { 0x62079164, 0x233B, 0x41F8, { 0xA8, 0x0F, 0xF0, 0x17, 0x05, 0xF5, 0x14, 0xA8 } };
EXTERN_C const GUID     EVRConfig_ForceBob =
    { 0xE447DF01, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_AllowDropToBob =
    { 0xE447DF02, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_ForceThrottle =
    { 0xE447DF03, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_AllowDropToThrottle =
    { 0xE447DF04, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_ForceHalfInterlace =
    { 0xE447DF05, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_AllowDropToHalfInterlace =
    { 0xE447DF06, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_ForceScaling =
    { 0xE447DF07, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_AllowScaling =
    { 0xE447DF08, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_ForceBatching =
    { 0xE447DF09, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const GUID     EVRConfig_AllowBatching =
    { 0xE447DF0A, 0x10CA, 0x4D17, { 0xB1, 0x7E, 0x6A, 0x84, 0x0F, 0x8A, 0x3A, 0x4C } };
EXTERN_C const CLSID    CLSID_NetworkProvider =
    { 0xB2F3A67C, 0x29DA, 0x4C78, { 0x88, 0x31, 0x09, 0x1E, 0xD5, 0x09, 0xA4, 0x75 } };
EXTERN_C const CLSID    CLSID_ATSCNetworkProvider =
    { 0x0DAD2FDD, 0x5FD7, 0x11D3, { 0x8F, 0x50, 0x00, 0xC0, 0x4F, 0x79, 0x71, 0xE2 } };
EXTERN_C const CLSID    CLSID_ATSCNetworkPropertyPage =
    { 0xE3444D16, 0x5AC4, 0x4386, { 0x88, 0xDF, 0x13, 0xFD, 0x23, 0x0E, 0x1D, 0xDA } };
EXTERN_C const CLSID    CLSID_DVBSNetworkProvider =
    { 0xFA4B375A, 0x45B4, 0x4D45, { 0x84, 0x40, 0x26, 0x39, 0x57, 0xB1, 0x16, 0x23 } };
EXTERN_C const CLSID    CLSID_DVBTNetworkProvider =
    { 0x216C62DF, 0x6D7F, 0x4E9A, { 0x85, 0x71, 0x05, 0xF1, 0x4E, 0xDB, 0x76, 0x6A } };
EXTERN_C const CLSID    CLSID_DVBCNetworkProvider =
    { 0xDC0C0FE7, 0x0485, 0x4266, { 0xB9, 0x3F, 0x68, 0xFB, 0xF8, 0x0E, 0xD8, 0x34 } };
EXTERN_C const GUID     DSATTRIB_UDCRTag =
    { 0xEB7836CA, 0x14FF, 0x4919, { 0xBC, 0xE7, 0x3A, 0xF1, 0x23, 0x19, 0xE5, 0x0C } };
EXTERN_C const GUID     DSATTRIB_PicSampleSeq =
    { 0x2F5BAE02, 0x7B8F, 0x4F60, { 0x82, 0xD6, 0xE4, 0xEA, 0x2F, 0x1F, 0x4C, 0x99 } };
EXTERN_C const GUID     DSATTRIB_OptionalVideoAttributes =
    { 0x5A5F08CA, 0x55C2, 0x4033, { 0x92, 0xAB, 0x55, 0xDB, 0x8F, 0x78, 0x12, 0x26 } };
EXTERN_C const GUID     DSATTRIB_CC_CONTAINER_INFO =
    { 0xE7E050FB, 0xDD5D, 0x40DD, { 0x99, 0x15, 0x35, 0xDC, 0xB8, 0x1B, 0xDC, 0x8A } };
EXTERN_C const GUID     DSATTRIB_TRANSPORT_PROPERTIES =
    { 0xB622F612, 0x47AD, 0x4671, { 0xAD, 0x6C, 0x05, 0xA9, 0x8E, 0x65, 0xDE, 0x3A } };
EXTERN_C const GUID     DSATTRIB_PBDATAG_ATTRIBUTE =
    { 0xE0B56679, 0x12B9, 0x43CC, { 0xB7, 0xDF, 0x57, 0x8C, 0xAA, 0x5A, 0x7B, 0x63 } };
EXTERN_C const GUID     DSATTRIB_CAPTURE_STREAMTIME =
    { 0x0C1A5614, 0x30CD, 0x4F40, { 0xBC, 0xBF, 0xD0, 0x3E, 0x52, 0x30, 0x62, 0x07 } };
EXTERN_C const GUID     DSATTRIB_DSHOW_STREAM_DESC =
    { 0x5FB5673B, 0x0A2A, 0x4565, { 0x82, 0x7B, 0x68, 0x53, 0xFD, 0x75, 0xE6, 0x11 } };
EXTERN_C const GUID     DSATTRIB_SAMPLE_LIVE_STREAM_TIME =
    { 0x892CD111, 0x72F3, 0x411D, { 0x8B, 0x91, 0xA9, 0xE9, 0x12, 0x3A, 0xC2, 0x9A } };
EXTERN_C const GUID     UUID_UdriTagTables =
    { 0xE1B98D74, 0x9778, 0x4878, { 0xB6, 0x64, 0xEB, 0x20, 0x20, 0x36, 0x4D, 0x88 } };
EXTERN_C const GUID     UUID_WMDRMTagTables =
    { 0x5DCD1101, 0x9263, 0x45BB, { 0xA4, 0xD5, 0xC4, 0x15, 0xAB, 0x8C, 0x58, 0x9C } };
EXTERN_C const CLSID    CLSID_DShowTVEFilter =
    { 0x05500280, 0xFAA5, 0x4DF9, { 0x82, 0x46, 0xBF, 0xC2, 0x3A, 0xC5, 0xCE, 0xA8 } };
EXTERN_C const CLSID    CLSID_TVEFilterTuneProperties =
    { 0x05500281, 0xFAA5, 0x4DF9, { 0x82, 0x46, 0xBF, 0xC2, 0x3A, 0xC5, 0xCE, 0xA8 } };
EXTERN_C const CLSID    CLSID_TVEFilterCCProperties =
    { 0x05500282, 0xFAA5, 0x4DF9, { 0x82, 0x46, 0xBF, 0xC2, 0x3A, 0xC5, 0xCE, 0xA8 } };
EXTERN_C const CLSID    CLSID_TVEFilterStatsProperties =
    { 0x05500283, 0xFAA5, 0x4DF9, { 0x82, 0x46, 0xBF, 0xC2, 0x3A, 0xC5, 0xCE, 0xA8 } };
EXTERN_C const CLSID    CLSID_IVideoEncoderProxy =
    { 0xB43C4EEC, 0x8C32, 0x4791, { 0x91, 0x02, 0x50, 0x8A, 0xDA, 0x5E, 0xE8, 0xE7 } };
EXTERN_C const CLSID    CLSID_ICodecAPIProxy =
    { 0x7FF0997A, 0x1999, 0x4286, { 0xA7, 0x3C, 0x62, 0x2B, 0x88, 0x14, 0xE7, 0xEB } };
EXTERN_C const CLSID    CLSID_IVideoEncoderCodecAPIProxy =
    { 0xB05DABD9, 0x56E5, 0x4FDC, { 0xAF, 0xA4, 0x8A, 0x47, 0xE9, 0x1F, 0x1C, 0x9C } };
EXTERN_C const GUID     ENCAPIPARAM_BITRATE =
    { 0x49CC4C43, 0xCA83, 0x4AD4, { 0xA9, 0xAF, 0xF3, 0x69, 0x6A, 0xF6, 0x66, 0xDF } };
EXTERN_C const GUID     ENCAPIPARAM_PEAK_BITRATE =
    { 0x703F16A9, 0x3D48, 0x44A1, { 0xB0, 0x77, 0x01, 0x8D, 0xFF, 0x91, 0x5D, 0x19 } };
EXTERN_C const GUID     ENCAPIPARAM_BITRATE_MODE =
    { 0xEE5FB25C, 0xC713, 0x40D1, { 0x9D, 0x58, 0xC0, 0xD7, 0x24, 0x1E, 0x25, 0x0F } };
EXTERN_C const GUID     ENCAPIPARAM_SAP_MODE =
    { 0x0C0171DB, 0xFEFC, 0x4AF7, { 0x99, 0x91, 0xA5, 0x65, 0x7C, 0x19, 0x1C, 0xD1 } };
EXTERN_C const GUID     CODECAPI_CHANGELISTS =
    { 0x62B12ACF, 0xF6B0, 0x47D9, { 0x94, 0x56, 0x96, 0xF2, 0x2C, 0x4E, 0x0B, 0x9D } };
EXTERN_C const GUID     CODECAPI_VIDEO_ENCODER =
    { 0x7112E8E1, 0x3D03, 0x47EF, { 0x8E, 0x60, 0x03, 0xF1, 0xCF, 0x53, 0x73, 0x01 } };
EXTERN_C const GUID     CODECAPI_AUDIO_ENCODER =
    { 0xB9D19A3E, 0xF897, 0x429C, { 0xBC, 0x46, 0x81, 0x38, 0xB7, 0x27, 0x2B, 0x2D } };
EXTERN_C const GUID     CODECAPI_SETALLDEFAULTS =
    { 0x6C5E6A7C, 0xACF8, 0x4F55, { 0xA9, 0x99, 0x1A, 0x62, 0x81, 0x09, 0x05, 0x1B } };
EXTERN_C const GUID     CODECAPI_ALLSETTINGS =
    { 0x6A577E92, 0x83E1, 0x4113, { 0xAD, 0xC2, 0x4F, 0xCE, 0xC3, 0x2F, 0x83, 0xA1 } };
EXTERN_C const GUID     CODECAPI_SUPPORTSEVENTS =
    { 0x0581AF97, 0x7693, 0x4DBD, { 0x9D, 0xCA, 0x3F, 0x9E, 0xBD, 0x65, 0x85, 0xA1 } };
EXTERN_C const GUID     CODECAPI_CURRENTCHANGELIST =
    { 0x1CB14E83, 0x7D72, 0x4657, { 0x83, 0xFD, 0x47, 0xA2, 0xC5, 0xB9, 0xD1, 0x3D } };
EXTERN_C const CLSID    CLSID_SBE2MediaTypeProfile =
    { 0x1F26A602, 0x2B5C, 0x4B63, { 0xB8, 0xE8, 0x9E, 0xA5, 0xC1, 0xA7, 0xDC, 0x2E } };
EXTERN_C const CLSID    CLSID_SBE2FileScan =
    { 0x3E458037, 0x0CA6, 0x41AA, { 0xA5, 0x94, 0x2A, 0xA6, 0xC0, 0x2D, 0x70, 0x9B } };
EXTERN_C const GUID     CODECAPI_AVDecMmcssClass =
    { 0xE0AD4828, 0xDF66, 0x4893, { 0x9F, 0x33, 0x78, 0x8A, 0xA4, 0xEC, 0x40, 0x82 } };
