/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Table of PowerPC opcodes and corresponding decode routines.
*
****************************************************************************/


#define u(a)    ((a##ul)<<26)
#define v(a,b)  (u(a) + ((b##ul)<<1))
#define w(a,b)  (u(a) + (b##ul))
#define x(a,b)  (u(a) + ((b##ul)<<2))
/*
      Idx,              Name,           Opcode,         Mask,           Handler
*/
inspick( abs,           "abs",          v(31,360),      0xFC00FBFE,     PPCMathda )
inspick( add,           "add",          v(31,266),      0xFC0003FE,     PPCMath )
inspick( addc,          "addc",         v(31, 10),      0xFC0003FE,     PPCMath )
inspick( adde,          "adde",         v(31,138),      0xFC0003FE,     PPCMath )
inspick( addi,          "addi",         u(14),          0xFC000000,     PPCImmediate )
inspick( addic,         "addic",        u(12),          0xFC000000,     PPCImmediate )
inspick( addic_dot,     "addic.",       u(13),          0xFC000000,     PPCImmediate )
inspick( addis,         "addis",        u(15),          0xFC000000,     PPCImmediate )
inspick( addme,         "addme",        v(31,234),      0xFC00FBFE,     PPCMathda )
inspick( addze,         "addze",        v(31,202),      0xFC00FBFE,     PPCMathda )
inspick( and,           "and",          v(31, 28),      0xFC0007FE,     PPCMath )
inspick( andc,          "andc",         v(31, 60),      0xFC0007FE,     PPCMath )
inspick( andi_dot,      "andi.",        u(28),          0xFC000000,     PPCImmediate )
inspick( andis_dot,     "andis.",       u(29),          0xFC000000,     PPCImmediate )
inspick( b,             "b",            u(18),          0xFC000000,     PPCBranch )
inspick( bc,            "bc",           u(16),          0xFC000000,     PPCBranch )
inspick( bcctr,         "bcctr",        v(19,528),      0xFC00FFFE,     PPCBranch )
inspick( bclr,          "bclr",         v(19, 16),      0xFC00FFFE,     PPCBranch )
inspick( clcs,          "clcs",         v(31,531),      0xFC00FFFE,     PPCMathda )
inspick( cmp,           "cmp",          v(31,  0),      0xFC4007FF,     PPCCompare )
inspick( cmpi,          "cmpi",         u(11),          0xFC400000,     PPCCompare )
inspick( cmpl,          "cmpl",         v(31, 32),      0xFC4007FF,     PPCCompare )
inspick( cmpli,         "cmpli",        u(10),          0xFC400000,     PPCCompare )
inspick( cntlzd,        "cntlzd",       v(31, 58),      0xFC00FFFE,     PPCMathsa )
inspick( cntlzw,        "cntlzw",       v(31, 26),      0xFC00FFFE,     PPCMathsa )
inspick( crand,         "crand",        v(19,257),      0xFC0007FF,     PPCCondition )
inspick( crandc,        "crandc",       v(19,129),      0xFC0007FF,     PPCCondition )
inspick( creqv,         "creqv",        v(19,289),      0xFC0007FF,     PPCCondition )
inspick( crnand,        "crnand",       v(19,225),      0xFC0007FF,     PPCCondition )
inspick( crnor,         "crnor",        v(19, 33),      0xFC0007FF,     PPCCondition )
inspick( cror,          "cror",         v(19,449),      0xFC0007FF,     PPCCondition )
inspick( crorc,         "crorc",        v(19,417),      0xFC0007FF,     PPCCondition )
inspick( crxor,         "crxor",        v(19,193),      0xFC0007FF,     PPCCondition )
inspick( dcbf,          "dcbf",         v(31, 86),      0xFFE007FF,     PPCMathab )
inspick( dcbi,          "dcbi",         v(31,470),      0xFFE007FF,     PPCMathab )
inspick( dcbst,         "dcbst",        v(31, 54),      0xFFE007FF,     PPCMathab )
inspick( dcbt,          "dcbt",         v(31,278),      0xFFE007FF,     PPCMathab )
inspick( dcbtst,        "dcbtst",       v(31,246),      0xFFE007FF,     PPCMathab )
inspick( dcbz,          "dcbz",         v(31,1014),     0xFFE007FF,     PPCMathab )
inspick( div,           "div",          v(31,331),      0xFC0003FE,     PPCMath )
inspick( divd,          "divd",         v(31,489),      0xFC0003FE,     PPCMath )
inspick( divdu,         "divdu",        v(31,457),      0xFC0003FE,     PPCMath )
inspick( divs,          "divs",         v(31,363),      0xFC0003FE,     PPCMath )
inspick( divw,          "divw",         v(31,491),      0xFC0003FE,     PPCMath )
inspick( divwu,         "divwu",        v(31,459),      0xFC0003FE,     PPCMath )
inspick( doz,           "doz",          v(31,264),      0xFC0003FE,     PPCMath )
inspick( dozi,          "dozi",         u( 9),          0xFC000000,     PPCImmediate )
inspick( eciwx,         "eciwx",        v(31,310),      0xFC0007FF,     PPCMath )
inspick( ecowx,         "ecowx",        v(31,438),      0xFC0007FF,     PPCMath )
inspick( eieio,         "eieio",        v(31,854),      0xFC0007FF,     PPCNull )
inspick( eqv,           "eqv",          v(31,284),      0xFC0007FE,     PPCMath2 )
inspick( extsb,         "extsb",        v(31,954),      0xFC00FFFE,     PPCMathsa )
inspick( extsh,         "extsh",        v(31,922),      0xFC00FFFE,     PPCMathsa )
inspick( extsw,         "extsw",        v(31,986),      0xFC00FFFE,     PPCMathsa )
inspick( fabs,          "fabs",         v(63,264),      0xFC1F07FE,     PPCFloatdb )
inspick( fadd,          "fadd",         v(63, 21),      0xFC0007FE,     PPCFloatdab )
inspick( fadds,         "fadds",        v(59, 21),      0xFC0007FE,     PPCFloatdab )
inspick( fcfid,         "fcfid",        v(63,846),      0xFC1F07FE,     PPCFloatdb )
inspick( fcmpo,         "fcmpo",        v(63, 32),      0xFC6007FF,     PPCFloatCmpab )
inspick( fcmpu,         "fcmpu",        v(63,  0),      0xFC6007FF,     PPCFloatCmpab )
inspick( fctid,         "fctid",        v(63,814),      0xFC1F07FE,     PPCFloatdb )
inspick( fctidz,        "fctidz",       v(63,815),      0xFC1F07FE,     PPCFloatdb )
inspick( fctiw,         "fctiw",        v(63, 14),      0xFC1F07FE,     PPCFloatdb )
inspick( fctiwz,        "fctiwz",       v(63, 15),      0xFC1F07FE,     PPCFloatdb )
inspick( fdiv,          "fdiv",         v(63, 18),      0xFC0007FE,     PPCFloatdab )
inspick( fdivs,         "fdivs",        v(59, 18),      0xFC0007FE,     PPCFloatdab )
inspick( fmadd,         "fmadd",        v(63, 29),      0xFC00003E,     PPCFloat )
inspick( fmadds,        "fmadds",       v(59, 29),      0xFC00003E,     PPCFloat )
inspick( fmr,           "fmr",          v(63, 72),      0xFC1F07FE,     PPCFloatdb )
inspick( fmsub,         "fmsub",        v(63, 28),      0xFC00003E,     PPCFloat )
inspick( fmsubs,        "fmsubs",       v(59, 28),      0xFC00003E,     PPCFloat )
inspick( fmul,          "fmul",         v(63, 25),      0xFC00F83E,     PPCFloatdac )
inspick( fmuls,         "fmuls",        v(59, 25),      0xFC00F83E,     PPCFloatdac )
inspick( fnabs,         "fnabs",        v(63,136),      0xFC1F07FE,     PPCFloatdb )
inspick( fneg,          "fneg",         v(63, 40),      0xFC1F07FE,     PPCFloatdb )
inspick( fnmadd,        "fnmadd",       v(63, 31),      0xFC00003E,     PPCFloat )
inspick( fnmadds,       "fnmadds",      v(59, 31),      0xFC00003E,     PPCFloat )
inspick( fnmsub,        "fnmsub",       v(63, 30),      0xFC00003E,     PPCFloat )
inspick( fnmsubs,       "fnmsubs",      v(59, 30),      0xFC00003E,     PPCFloat )
inspick( frsp,          "frsp",         v(63, 12),      0xFC1F07FE,     PPCFloatdb )
inspick( fsub,          "fsub",         v(63, 20),      0xFC0007FE,     PPCFloatdab )
inspick( fsubs,         "fsubs",        v(59, 20),      0xFC0007FE,     PPCFloatdab )
inspick( icbi,          "icbi",         v(31,982),      0xFFE007FF,     PPCMathab )
inspick( isync,         "isync",        v(19,150),      0xFFFFFFFF,     PPCNull )
inspick( lbz,           "lbz",          u(34),          0xFC000000,     PPCMem1 )
inspick( lbzu,          "lbzu",         u(35),          0xFC000000,     PPCMem1 )
inspick( lbzux,         "lbzux",        v(31,119),      0xFC0007FF,     PPCMem2 )
inspick( lbzx,          "lbzx",         v(31, 87),      0xFC0007FF,     PPCMem2 )
inspick( ld,            "ld",           w(58,0),        0xFC000003,     PPCMemD1 )
inspick( ldarx,         "ldarx",        v(31, 84),      0xFC0007FF,     PPCMemD2 )
inspick( ldu,           "ldu",          w(58,1),        0xFC000003,     PPCMemD1 )
inspick( ldux,          "ldux",         v(31, 53),      0xFC0007FF,     PPCMemD2 )
inspick( ldx,           "ldx",          v(31, 21),      0xFC0007FF,     PPCMemD2 )
inspick( lfd,           "lfd",          u(50),          0xFC000000,     PPCFloatMem1 )
inspick( lfdu,          "lfdu",         u(51),          0xFC000000,     PPCFloatMem1 )
inspick( lfdux,         "lfdux",        v(31,631),      0xFC0007FF,     PPCFloatMem2 )
inspick( lfdx,          "lfdx",         v(31,599),      0xFC0007FF,     PPCFloatMem2 )
inspick( lfs,           "lfs",          u(48),          0xFC000000,     PPCFloatMem1 )
inspick( lfsu,          "lfsu",         u(49),          0xFC000000,     PPCFloatMem1 )
inspick( lfsux,         "lfsux",        v(31,567),      0xFC0007FF,     PPCFloatMem2 )
inspick( lfsx,          "lfsx",         v(31,535),      0xFC0007FF,     PPCFloatMem2 )
inspick( lha,           "lha",          u(42),          0xFC000000,     PPCMem1 )
inspick( lhau,          "lhau",         u(43),          0xFC000000,     PPCMem1 )
inspick( lhaux,         "lhaux",        v(31,375),      0xFC0007FF,     PPCMem2 )
inspick( lhax,          "lhax",         v(31,343),      0xFC0007FF,     PPCMem2 )
inspick( lhbrx,         "lhbrx",        v(31,790),      0xFC0007FF,     PPCMem2 )
inspick( lhz,           "lhz",          u(40),          0xFC000000,     PPCMem1 )
inspick( lhzu,          "lhzu",         u(41),          0xFC000000,     PPCMem1 )
inspick( lhzux,         "lhzux",        v(31,311),      0xFC0007FF,     PPCMem2 )
inspick( lhzx,          "lhzx",         v(31,279),      0xFC0007FF,     PPCMem2 )
inspick( lmw,           "lmw",          u(46),          0xFC000000,     PPCMem1 )
inspick( lscbx,         "lscbx",        v(31,277),      0xFC0007FE,     PPCMem2 )
inspick( lswi,          "lswi",         v(31,597),      0xFC0007FF,     PPCMem3 )
inspick( lswx,          "lswx",         v(31,533),      0xFC0007FF,     PPCMem2 )
inspick( lwa,           "lwa",          w(58,2),        0xFC000003,     PPCMemD1 )
inspick( lwaux,         "lwaux",        v(31,373),      0xFC0007FF,     PPCMem2 )
inspick( lwax,          "lwax",         v(31,341),      0xFC0007FF,     PPCMem2 )
inspick( lwarx,         "lwarx",        v(31, 20),      0xFC0007FF,     PPCMem2 )
inspick( lwbrx,         "lwbrx",        v(31,534),      0xFC0007FF,     PPCMem2 )
inspick( lwz,           "lwz",          u(32),          0xFC000000,     PPCMem1 )
inspick( lwzu,          "lwzu",         u(33),          0xFC000000,     PPCMem1 )
inspick( lwzux,         "lwzux",        v(31, 55),      0xFC0007FF,     PPCMem2 )
inspick( lwzx,          "lwzx",         v(31, 23),      0xFC0007FF,     PPCMem2 )
inspick( maskg,         "maskg",        v(31, 29),      0xFC0007FE,     PPCMath2 )
inspick( maskir,        "maskir",       v(31,541),      0xFC0007FE,     PPCMath2 )
inspick( mcrf,          "mcrf",         u(19),          0xFC63FFFF,     PPCConditionField )
inspick( mcrfs,         "mcrfs",        v(63, 64),      0xFC63FFFF,     PPCConditionField )
inspick( mcrxr,         "mcrxr",        v(31,512),      0xFC7FFFFF,     PPCConditionField )
inspick( mfcr,          "mfcr",         v(31, 19),      0xFC1FFFFF,     PPCMathd )
inspick( mffs,          "mffs",         v(63,583),      0xFC1FFFFE,     PPCFloato )
inspick( mfmsr,         "mfmsr",        v(31, 83),      0xFC1FFFFF,     PPCMathd )
inspick( mfspr,         "mfspr",        v(31,339),      0xFC0007FF,     PPCSpecial )
inspick( mfsr,          "mfsr",         v(31,595),      0xFC10FFFF,     PPCSpecial )
inspick( mfsrin,        "mfsrin",       v(31,659),      0xFC1F07FF,     PPCMathdb )
inspick( mtcrf,         "mtcrf",        v(31,144),      0xFC100FFF,     PPCSpecial )
inspick( mtfsb0,        "mtfsb0",       v(63, 70),      0xFC1FFFFE,     PPCCondition )
inspick( mtfsb1,        "mtfsb1",       v(63, 38),      0xFC1FFFFE,     PPCCondition )
inspick( mtfsf,         "mtfsf",        v(31,711),      0xFE0107FE,     PPCFloato )
inspick( mtfsfi,        "mtfsfi",       v(63,134),      0xFC7F0FFE,     PPCConditionField )
inspick( mtmsr,         "mtmsr",        v(31,146),      0xFC1FFFFF,     PPCMathd )
inspick( mtspr,         "mtspr",        v(31,467),      0xFC0007FF,     PPCSpecial )
inspick( mtsr,          "mtsr",         v(31,210),      0xFC10FFFF,     PPCSpecial )
inspick( mtsrin,        "mtsrin",       v(31,242),      0xFC1F07FF,     PPCMathdb )
inspick( mul,           "mul",          v(31,107),      0xFC0003FE,     PPCMath )
inspick( mulhd,         "mulhd",        v(31, 73),      0xFC0007FE,     PPCMath )
inspick( mulhdu,        "mulhdu",       v(31,  9),      0xFC0007FE,     PPCMath )
inspick( mulhw,         "mulhw",        v(31, 75),      0xFC0007FE,     PPCMath )
inspick( mulhwu,        "mulhwu",       v(31, 11),      0xFC0007FE,     PPCMath )
inspick( mulld,         "mulld",        v(31,233),      0xFC0003FE,     PPCMath )
inspick( mulli,         "mulli",        u( 7),          0xFC000000,     PPCImmediate )
inspick( mullw,         "mullw",        v(31,235),      0xFC0003FE,     PPCMath )
inspick( nabs,          "nabs",         v(31,488),      0xFC00FBFE,     PPCMathda )
inspick( nand,          "nand",         v(31,476),      0xFC0007FE,     PPCMath2 )
inspick( neg,           "neg",          v(31,104),      0xFC00FBFE,     PPCMathda )
inspick( nor,           "nor",          v(31,124),      0xFC0007FE,     PPCMath2 )
inspick( or,            "or",           v(31,444),      0xFC0007FE,     PPCMath2 )
inspick( orc,           "orc",          v(31,412),      0xFC0007FE,     PPCMath2 )
inspick( ori,           "ori",          u(24),          0xFC000000,     PPCImmed2 )
inspick( oris,          "oris",         u(25),          0xFC000000,     PPCImmed2 )
inspick( rfi,           "rfi",          v(19,50),       0xFFFFFFFF,     PPCNull )
inspick( rldcl,         "rldcl",        v(30,  8),      0xFC00001E,     PPCRotateD )
inspick( rldcr,         "rldcr",        v(30,  9),      0xFC00001E,     PPCRotateD )
inspick( rldic,         "rldic",        x(30,  2),      0xFC00001C,     PPCRotateImmD )
inspick( rldicl,        "rldicl",       x(30,  0),      0xFC00001C,     PPCRotateImmD )
inspick( rldicr,        "rldicr",       x(30,  1),      0xFC00001C,     PPCRotateImmD )
inspick( rldimi,        "rldimi",       x(30,  3),      0xFC00001C,     PPCRotateImmD )
inspick( rlmi,          "rlmi",         u(22),          0xFC000000,     PPCRotate )
inspick( rlwimi,        "rlwimi",       u(20),          0xFC000000,     PPCRotate )
inspick( rlwinm,        "rlwinm",       u(21),          0xFC000000,     PPCRotate )
inspick( rlwnm,         "rlwnm",        u(23),          0xFC000000,     PPCRotate )
inspick( rrib,          "rrib",         v(31,537),      0xFC0007FE,     PPCMath2 )
inspick( sc,            "sc",           v(17,  1),      0xFFFFFFFF,     PPCNull )
inspick( slbia,         "slbia",        v(31,498),      0xFFFFFFFF,     PPCNull )
inspick( slbie,         "slbie",        v(31,434),      0xFFFF07FF,     PPCMathb )
inspick( sld,           "sld",          v(31, 27),      0xFC0007FE,     PPCMath2 )
inspick( sle,           "sle",          v(31,153),      0xFC0007FE,     PPCMath2 )
inspick( sleq,          "sleq",         v(31,217),      0xFC0007FE,     PPCMath2 )
inspick( sliq,          "sliq",         v(31,184),      0xFC0007FE,     PPCShiftImmed )
inspick( slliq,         "slliq",        v(31,248),      0xFC0007FE,     PPCShiftImmed )
inspick( sllq,          "sllq",         v(31,216),      0xFC0007FE,     PPCMath2 )
inspick( slq,           "slq",          v(31,152),      0xFC0007FE,     PPCMath2 )
inspick( slw,           "slw",          v(31, 24),      0xFC0007FE,     PPCMath2 )
inspick( srad,          "srad",         v(31,794),      0xFC0007FE,     PPCMath2 )
inspick( sradi,         "sradi",        x(31,413),      0xFC0007FE,     PPCShiftImmedD )
inspick( sraq,          "sraq",         v(31,920),      0xFC0007FE,     PPCMath2 )
inspick( sraiq,         "sraiq",        v(31,952),      0xFC0007FE,     PPCShiftImmed )
inspick( sraw,          "sraw",         v(31,792),      0xFC0007FE,     PPCMath2 )
inspick( srawi,         "srawi",        v(31,824),      0xFC0007FE,     PPCShiftImmed )
inspick( srd,           "srd",          v(31,539),      0xFC0007FE,     PPCMath2 )
inspick( sre,           "sre",          v(31,665),      0xFC0007FE,     PPCMath2 )
inspick( srea,          "srea",         v(31,921),      0xFC0007FE,     PPCMath2 )
inspick( sreq,          "sreq",         v(31,729),      0xFC0007FE,     PPCMath2 )
inspick( sriq,          "sriq",         v(31,696),      0xFC0007FE,     PPCShiftImmed )
inspick( srliq,         "srliq",        v(31,760),      0xFC0007FE,     PPCShiftImmed )
inspick( srlq,          "srlq",         v(31,728),      0xFC0007FE,     PPCMath2 )
inspick( srq,           "srq",          v(31,664),      0xFC0007FE,     PPCMath2 )
inspick( srw,           "srw",          v(31,536),      0xFC0007FE,     PPCMath2 )
inspick( stb,           "stb",          u(38),          0xFC000000,     PPCMem1 )
inspick( stbu,          "stbu",         u(39),          0xFC000000,     PPCMem1 )
inspick( stbux,         "stbux",        v(31,247),      0xFC0007FF,     PPCMem2 )
inspick( stbx,          "stbx",         v(31,215),      0xFC0007FF,     PPCMem2 )
inspick( std,           "std",          w(62,0),        0xFC000003,     PPCMemD1 )
inspick( stdcx,         "stdcx",        v(31,241)+1,    0xFC0007FF,     PPCMem2 )
inspick( stdu,          "stdu",         w(62,1),        0xFC000003,     PPCMemD1 )
inspick( stdux,         "stdux",        v(31,181),      0xFC0007FF,     PPCMem2 )
inspick( stdx,          "stdx",         v(31,149),      0xFC0007FF,     PPCMem2 )
inspick( stfd,          "stfd",         u(54),          0xFC000000,     PPCFloatMem1 )
inspick( stfdu,         "stfdu",        u(55),          0xFC000000,     PPCFloatMem1 )
inspick( stfdux,        "stfdux",       v(31,759),      0xFC0007FF,     PPCFloatMem2 )
inspick( stfdx,         "stfdx",        v(31,727),      0xFC0007FF,     PPCFloatMem2 )
inspick( stfs,          "stfs",         u(52),          0xFC000000,     PPCFloatMem1 )
inspick( stfsu,         "stfsu",        u(53),          0xFC000000,     PPCFloatMem1 )
inspick( stfsux,        "stfsux",       v(31,695),      0xFC0007FF,     PPCFloatMem2 )
inspick( stfsx,         "stfsx",        v(31,663),      0xFC0007FF,     PPCFloatMem2 )
inspick( sth,           "sth",          u(44),          0xFC000000,     PPCMem1 )
inspick( sthbrx,        "sthbrx",       v(31,918),      0xFC0007FF,     PPCMem2 )
inspick( sthu,          "sthu",         u(45),          0xFC000000,     PPCMem1 )
inspick( sthux,         "sthux",        v(31,439),      0xFC0007FF,     PPCMem2 )
inspick( sthx,          "sthx",         v(31,407),      0xFC0007FF,     PPCMem2 )
inspick( stmw,          "stmw",         u(47),          0xFC000000,     PPCMem1 )
inspick( stswi,         "stswi",        v(31,725),      0xFC0007FF,     PPCMem3 )
inspick( stswx,         "stswx",        v(31,661),      0xFC0007FF,     PPCMem2 )
inspick( stw,           "stw",          u(36),          0xFC000000,     PPCMem1 )
inspick( stwbrx,        "stwbrx",       v(31,662),      0xFC0007FF,     PPCMem2 )
inspick( stwcx,         "stwcx",        v(31,150)+1,    0xFC0007FF,     PPCMem2 )
inspick( stwu,          "stwu",         u(37),          0xFC000000,     PPCMem1 )
inspick( stwux,         "stwux",        v(31,183),      0xFC0007FF,     PPCMem2 )
inspick( stwx,          "stwx",         v(31,151),      0xFC0007FF,     PPCMem2 )
inspick( subf,          "subf",         v(31, 40),      0xFC0003FE,     PPCMath )
inspick( subfc,         "subfc",        v(31,  8),      0xFC0003FE,     PPCMath )
inspick( subfe,         "subfe",        v(31,136),      0xFC0003FE,     PPCMath )
inspick( subfic,        "subfic",       u( 8),          0xFC000000,     PPCImmediate )
inspick( subfme,        "subfme",       v(31,232),      0xFC00FBFE,     PPCMathda )
inspick( subfze,        "subfze",       v(31,200),      0xFC00FBFE,     PPCMathda )
inspick( sync,          "sync",         v(31,598),      0xFFFFFFFF,     PPCNull )
inspick( td,            "td",           v(31, 68),      0xFC0007FF,     PPCTrap )
inspick( tdi,           "tdi",          u( 2),          0xFC000000,     PPCTrap )
inspick( tlbia,         "tlbia",        v(31,370),      0xFFFFFFFF,     PPCNull )
inspick( tlbie,         "tlbie",        v(31,306),      0xFFFF07FF,     PPCMathb )
inspick( tlbsync,       "tlbsync",      v(31,556),      0xFFFFFFFF,     PPCNull )
inspick( tw,            "tw",           v(31,  4),      0xFC0007FF,     PPCTrap )
inspick( twi,           "twi",          u( 3),          0xFC000000,     PPCTrap )
inspick( xor,           "xor",          v(31,316),      0xFC0007FE,     PPCMath2 )
inspick( xori,          "xori",         u(26),          0xFC000000,     PPCImmed2 )
inspick( xoris,         "xoris",        u(27),          0xFC000000,     PPCImmed2 )
#undef u
#undef v
#undef x
#undef w
