.chap *refid=crtmsgs &product Run-Time Messages
.*
.np
.ix 'run-time' 'messages'
The following is a list of error messages produced by the &product
run-time library.
These messages can only appear during the execution of an application
built with one of the C run-time libraries.
.*
.section Run-Time Error Messages
.*
.begnote
.ix 'run-time' 'error messages'
.note Assertion failed: %s, file %s, line %d
.np
This message is displayed whenever an assertion that you have made in
your program is not true.
.note Stack Overflow!
.np
Your program is trying to use more stack space than is available.
If you believe that your program is correct, you can increase the
size of the stack by using the "option stack=nnnn" when you link the
program.
The stack size can also be specified with
.if '&target' eq 'QNX' .do begin
the "N" option if you are using &wclcmdup..
.do end
.el .do begin
the "k" option if you are using &wclcmdup16. or &wclcmdup32..
.do end
.note Floating-point support not loaded
.np
You have called one of the printf functions with a format of "%e", "%f",
or "%g", but have not passed a floating-point value.
The compiler generates a reference to the variable "_fltused_" whenever
you pass a floating-point value to a function.
During the linking phase, the extra floating-point formatting routines
will also be brought into your application when "_fltused_" is referenced.
Otherwise, you only get the non floating-point formatting routines.
.note *** NULL assignment detected
.np
This message is displayed if any of the first 32 bytes of your
program's data segment has been modified.
The check is performed just before your program exits to the operating
system.
All this message means is that sometime during the execution of your
program, this memory was modified.
.np
To find the problem, you must link your application with debugging
information and use &dbgname to monitor its execution.
First, run the application with &dbgname until it completes.
Examine the first 16 bytes of the data segment ("examine __nullarea")
and press the space bar to see the next 16 bytes.
Any values that are not equal to '01' have been modified.
Reload the application, set watch points on the modified locations, and
start execution.
&dbgname will stop when the specified location(s) change in value.
.endnote
.*
.section errno Values and Their Meanings
.*
.np
.ix 'run-time' 'error messages'
.ix 'diagnostics' 'run-time'
.ix 'messages' 'run-time'
.ix 'diagnostics' 'errno'
.ix 'messages' 'errno'
.if '&target' eq 'QNX' .do begin
:INCLUDE file='ERRNOQNX'.
.do end
.el .do begin
:INCLUDE file='ERRNODOS'.
.do end
.*
.section Math Run-Time Error Messages
.*
.np
.ix 'diagnostics' 'run-time'
.ix 'messages' 'run-time'
.ix 'diagnostics' 'matherr'
.ix 'messages' 'matherr'
The following errors can be generated by the math functions in the C
run-time library.
.if '&target' eq 'QNX' .do begin
.ix 'error codes' 'math.h'
.do end
.el .do begin
.ix 'error codes' 'MATH.H'
.do end
.ix 'matherr'
These error codes correspond to the exception types defined in
.fi math.h
and returned by the
.id matherr
function when a math error occurs.
.begnote $setptnt 22
.ix 'matherr' 'DOMAIN'
.note DOMAIN
.us Domain error
.np
An argument to the function is outside the domain of the function.
.ix 'matherr' 'OVERFLOW'
.note OVERFLOW
.us Overflow range error
.np
The function result is too large.
.ix 'matherr' 'PLOSS'
.note PLOSS
.us Partial loss of significance
.np
A partial loss of significance occurred.
.ix 'matherr' 'SING'
.note SING
.us Argument singularity
.np
An argument to the function has a bad value (e.g., log(0.0)).
.ix 'matherr' 'TLOSS'
.note TLOSS
.us Total loss of significance
.np
A total loss of significance occurred.
An argument to a function was too large to produce a meaningful result.
.ix 'matherr' 'UNDERFLOW'
.note UNDERFLOW
.us Underflow range error
.np
The result is too small to be represented.
.endnote
