/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


#if defined( _STANDALONE_ )

#include "asmglob.h"
#include <stdarg.h>

#include "asmdefs.h"
#include "asmsym.h"
#include "directiv.h"

extern char             *curr_src_line;

extern void             MsgPrintf( int resourceid ); // don't use this
extern int              MsgGet( int resourceid, char *buffer );
extern int              trademark( void );
extern char             *get_curr_filename( void );

void                    OpenErrFile( void );
void                    print_include_file_nesting_structure( void );

//    WngLvls[level] // warning levels associated with warning messages
//    CompFlags.errout_redirected

#ifdef __UNIX__
#define errout stderr
#else
#define errout stdout
#endif

/* globals to this module */
#define ErrLimit Options.error_limit
#define ErrCount Options.error_count
#define WngCount Options.warning_count
#define WngLevel Options.warning_level
#define ErrLine LineNumber
#define __fprintf fprintf
#define __vfprintf vfprintf
#define __printf printf

static int              Errfile_Written = FALSE;
static FILE             *ErrFile = NULL;

static void             AsmSuicide( void );
static void             PutMsg( FILE *fp, char *prefix, int msgnum, va_list args );
static void             PrtMsg1( register char *prefix, register int msgnum,
                                              va_list args1, va_list args2 );

void AsmError( int msgnum )
/*************************/
{
    AsmErr( msgnum );
}

#ifdef DEBUG_OUT
void DoDebugMsg( const char *format, ... )
/****************************************/
{
    va_list args;
    if( !Options.debug ) return;

    va_start( args, format );
    vprintf( format, args );
    va_end( args );
}
#endif

void AsmNote( int msgnum, ... )
/*****************************/
{
    va_list args1, args2;

    va_start( args1, msgnum );
    va_start( args2, msgnum );

    PrtMsg1( "Note!", msgnum, args1, args2 );
    va_end( args1 );
    va_end( args2 );
}

void AsmErr( int msgnum, ... )
/****************************/
{
    va_list args1, args2;

#ifdef DEBUG_OUT
    printf( "%s\n", curr_src_line );
#endif
    va_start( args1, msgnum );
    va_start( args2, msgnum );
    if( ErrLimit == -1  ||  ErrCount < ErrLimit ) {
        PrtMsg1( "Error!", msgnum, args1, args2 );
        va_end( args1 );
        va_end( args2 );
        ++ErrCount;
        print_include_file_nesting_structure();
    } else {
        PrtMsg1( "", ERR_TOO_MANY_ERRORS, args1, args2 );
        AsmSuicide();
    }
}

void AsmWarn( int level, int msgnum, ... )
/****************************************/
{
    va_list args1, args2;

    if( level <= WngLevel ) {
#ifdef DEBUG_OUT
        printf( "%s\n", curr_src_line );
#endif
        va_start( args1, msgnum );
        va_start( args2, msgnum );
        if( !Options.warning_error ) {
            PrtMsg1( "Warning!", msgnum, args1, args2 );
            ++WngCount;
        } else {
            PrtMsg1( "Error!", msgnum, args1, args2 );
            ++ErrCount;
        }
        va_end( args1 );
        va_end( args2 );
    }
}

static void PrtMsg1( register char *prefix, register int msgnum,
                   va_list args1, va_list args2 )
/**************************/
// print messages from WOMP !!!
{
    if( !Options.banner_printed ) {
        Options.banner_printed = TRUE;
        trademark();
    }
    if( ErrFile == NULL ) OpenErrFile();
    PutMsg( errout, prefix, msgnum, args1 );
    fflush( errout );                       /* 27-feb-90 */
    if( ErrFile ) {
        Errfile_Written = TRUE;
        PutMsg( ErrFile, prefix, msgnum, args2 );
    }
}

void PrtMsg( int msgnum, ... )
/****************************/
// print messages from WOMP !!!
{
    va_list args1;

    if( !Options.banner_printed ) {
        Options.banner_printed = TRUE;
        trademark();
    }
    if( ErrFile == NULL )
        OpenErrFile();
    va_start( args1, msgnum );
    PutMsg( errout, "Warning!", msgnum, args1 );
    fflush( errout );
}

void DelErrFile() {
    // fixme if( CompFlags.errout_redirected ) return;
    remove( AsmFiles.fname[ERR] );
}

void OpenErrFile()
/****************/
{
//    if( !isatty( fileno( errout ) ) ) return;
    if( AsmFiles.fname[ERR] != NULL ) {
        ErrFile = fopen( AsmFiles.fname[ERR], "w" );
    }
}

static void PutMsg( FILE *fp, char *prefix, int msgnum, va_list args )
/********************************************************************/
{
    char *fname;
    unsigned line_num;
    char msgbuf[MAX_LINE_LEN];

    if( fp != NULL ) {
        fname = get_curr_filename();
        line_num = LineNumber;
        if( line_num != 0 ) {
            if( fname != NULL ) {
                __fprintf( fp, "%s(%u): ", fname, line_num );
            }
        }
        __fprintf( fp, "%s %c%03d: ", prefix, *prefix, msgnum );
        // CGetMsg( msgbuf, msgnum );
        MsgGet( msgnum, msgbuf );
        __vfprintf( fp, msgbuf, args );
        __fprintf( fp, "\n" );
    }
}

static void AsmSuicide()
{
    exit(1);
}

void PrintStats()
/***************/
{
    __printf( "%s: ", AsmFiles.fname[ASM] );
    __printf( "%u lines, ", LineNumber );
    __printf( "%u warnings, ", WngCount );
    __printf( "%u errors\n", ErrCount );
#ifdef DEBUG_OUT
    __printf( "%u passes\n", Parse_Pass + 1 );
#endif
    fflush( stdout );                   /* 27-feb-90 for QNX */
}
#endif
