/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  intrinsic function constant tables data
*
****************************************************************************/


//      id         keyword      next       ret_typ        args_typ       flags
pick( IF_NONE,     "",         0,          0,              0,            0 )
pick( IF_ABS,      "ABS",      IF_IABS,    TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_ACOS,     "ACOS",     IF_DACOS,   TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_AIMAG,    "AIMAG",    IF_DIMAG,   TY_REAL,       TY_COMPLEX,   ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_AINT,     "AINT",     IF_DINT,    TY_REAL,       TY_REAL,      ONE_ARG|IF_GENERIC|IF_ARG_OK )
pick( IF_ALGAMA,   "ALGAMA",   IF_NO_MORE, TY_REAL,       TY_REAL,      ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_ALLOCATED,"ALLOCATED",MAGIC,      TY_LOGICAL,    TY_NO_TYPE,   ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_ALOG,     "ALOG",     IF_DLOG,    TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_ALOG10,   "ALOG10",   IF_DLOG10,  TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_AMAX0,    "AMAX0",    IF_NO_MORE, TY_REAL,       TY_INTEGER,   TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_AMAX1,    "AMAX1",    IF_DMAX1,   TY_REAL,       TY_REAL,      TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_AMIN0,    "AMIN0",    IF_NO_MORE, TY_REAL,       TY_INTEGER,   TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_AMIN1,    "AMIN1",    IF_DMIN1,   TY_REAL,       TY_REAL,      TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_AMOD,     "AMOD",     IF_DMOD,    TY_REAL,       TY_REAL,      TWO_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_ANINT,    "ANINT",    IF_DNINT,   TY_REAL,       TY_REAL,      ONE_ARG|IF_GENERIC|IF_ARG_OK )
pick( IF_ASIN,     "ASIN",     IF_DASIN,   TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_ATAN,     "ATAN",     IF_DATAN,   TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_ATAN2,    "ATAN2",    IF_DATAN2,  TY_REAL,       TY_REAL,      TWO_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_BTEST,    "BTEST",    IF_I2BTEST, TY_LOGICAL,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_CABS,     "CABS",     IF_CDABS,   TY_REAL,       TY_COMPLEX,   ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CCOS,     "CCOS",     IF_CDCOS,   TY_COMPLEX,    TY_COMPLEX,   ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CDABS,    "CDABS",    IF_CQABS,   TY_DOUBLE,     TY_DCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CDCOS,    "CDCOS",    IF_CQCOS,   TY_DCOMPLEX,   TY_DCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CDEXP,    "CDEXP",    IF_CQEXP,   TY_DCOMPLEX,   TY_DCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CDLOG,    "CDLOG",    IF_CQLOG,   TY_DCOMPLEX,   TY_DCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CDSIN,    "CDSIN",    IF_CQSIN,   TY_DCOMPLEX,   TY_DCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CDSQRT,   "CDSQRT",   IF_CQSQRT,  TY_DCOMPLEX,   TY_DCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CEXP,     "CEXP",     IF_CDEXP,   TY_COMPLEX,    TY_COMPLEX,   ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CHAR,     "CHAR",     MAGIC,      TY_CHAR,       TY_INTEGER,   ONE_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_CLOG,     "CLOG",     IF_CDLOG,   TY_COMPLEX,    TY_COMPLEX,   ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CMPLX,    "CMPLX",    MAGIC,      TY_COMPLEX,    TY_NO_TYPE,   ONE_OR_TWO|IF_GENERIC|IF_NOT_ARG )
pick( IF_CONJG,    "CONJG",    IF_DCONJG,  TY_COMPLEX,    TY_COMPLEX,   ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_COS,      "COS",      IF_DCOS,    TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_COSH,     "COSH",     IF_DCOSH,   TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_COTAN,    "COTAN",    IF_DCOTAN,  TY_REAL,       TY_REAL,      ONE_ARG|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_CQABS,    "CQABS",    IF_NO_MORE, TY_EXTENDED,   TY_XCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CQCOS,    "CQCOS",    IF_NO_MORE, TY_XCOMPLEX,   TY_XCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CQEXP,    "CQEXP",    IF_NO_MORE, TY_XCOMPLEX,   TY_XCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CQLOG,    "CQLOG",    IF_NO_MORE, TY_XCOMPLEX,   TY_XCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CQSIN,    "CQSIN",    IF_NO_MORE, TY_XCOMPLEX,   TY_XCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CQSQRT,   "CQSQRT",   IF_NO_MORE, TY_XCOMPLEX,   TY_XCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CSIN,     "CSIN",     IF_CDSIN,   TY_COMPLEX,    TY_COMPLEX,   ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_CSQRT,    "CSQRT",    IF_CDSQRT,  TY_COMPLEX,    TY_COMPLEX,   ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DABS,     "DABS",     IF_QABS,    TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DACOS,    "DACOS",    IF_QACOS,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DASIN,    "DASIN",    IF_QASIN,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DATAN,    "DATAN",    IF_QATAN,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DATAN2,   "DATAN2",   IF_QATAN2,  TY_DOUBLE,     TY_DOUBLE,    TWO_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DBLE,     "DBLE",     MAGIC,      TY_DOUBLE,     TY_NO_TYPE,   ONE_ARG|IF_GENERIC|IF_NOT_ARG )
pick( IF_DCMPLX,   "DCMPLX",   MAGIC,      TY_DCOMPLEX,   TY_NO_TYPE,   ONE_OR_TWO|IF_EXTENSION|IF_GENERIC|IF_NOT_ARG )
pick( IF_DCONJG,   "DCONJG",   IF_QCONJG,  TY_DCOMPLEX,   TY_DCOMPLEX,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DCOS,     "DCOS",     IF_QCOS,    TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DCOSH,    "DCOSH",    IF_QCOSH,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DCOTAN,   "DCOTAN",   IF_QCOTAN,  TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DDIM,     "DDIM",     IF_QDIM,    TY_DOUBLE,     TY_DOUBLE,    TWO_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DERF,     "DERF",     IF_QERF,    TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DERFC,    "DERFC",    IF_QERFC,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DEXP,     "DEXP",     IF_QEXP,    TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DFLOAT,   "DFLOAT",   MAGIC,      TY_DOUBLE,     TY_INTEGER,   ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_DGAMMA,   "DGAMMA",   IF_QGAMMA,  TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DIM,      "DIM",      IF_IDIM,    TY_REAL,       TY_REAL,      TWO_ARG|IF_GENERIC|IF_ARG_OK )
pick( IF_DIMAG,    "DIMAG",    IF_QIMAG,   TY_DOUBLE,     TY_DCOMPLEX,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DINT,     "DINT",     IF_QINT,    TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DLGAMA,   "DLGAMA",   IF_QLGAMA,  TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DLOG,     "DLOG",     IF_QLOG,    TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DLOG10,   "DLOG10",   IF_QLOG10,  TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DMAX1,    "DMAX1",    IF_QMAX1,   TY_DOUBLE,     TY_DOUBLE,    TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_DMIN1,    "DMIN1",    IF_QMIN1,   TY_DOUBLE,     TY_DOUBLE,    TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_DMOD,     "DMOD",     IF_QMOD,    TY_DOUBLE,     TY_DOUBLE,    TWO_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DNINT,    "DNINT",    IF_QNINT,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DPROD,    "DPROD",    IF_QPROD,   TY_DOUBLE,     TY_REAL,      TWO_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DREAL,    "DREAL",    MAGIC,      TY_DOUBLE,     TY_DCOMPLEX,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_DSIGN,    "DSIGN",    IF_QSIGN,   TY_DOUBLE,     TY_DOUBLE,    TWO_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DSIN,     "DSIN",     IF_QSIN,    TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DSINH,    "DSINH",    IF_QSINH,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DSQRT,    "DSQRT",    IF_QSQRT,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DTAN,     "DTAN",     IF_QTAN,    TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_DTANH,    "DTANH",    IF_QTANH,   TY_DOUBLE,     TY_DOUBLE,    ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_ERF,      "ERF",      IF_DERF,    TY_REAL,       TY_REAL,      ONE_ARG|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_ERFC,     "ERFC",     IF_DERFC,   TY_REAL,       TY_REAL,      ONE_ARG|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_EXP,      "EXP",      IF_DEXP,    TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_FLOAT,    "FLOAT",    MAGIC,      TY_REAL,       TY_INTEGER,   ONE_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_GAMMA,    "GAMMA",    IF_DGAMMA,  TY_REAL,       TY_REAL,      ONE_ARG|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_HFIX,     "HFIX",     MAGIC,      TY_INTEGER,    TY_REAL,      ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_I1ABS,    "I1ABS",    IF_DABS,    TY_INTEGER_1,  TY_INTEGER_1, ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1AND,    "I1AND",    IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1BCHNG,  "I1BCHNG",  IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1BCLR,   "I1BCLR",   IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1BSET,   "I1BSET",   IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1BTEST,  "I1BTEST",  IF_NO_MORE, TY_LOGICAL,    TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1DIM,    "I1DIM",    IF_DDIM,    TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1EOR,    "I1EOR",    IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1LSHIFT, "I1LSHIFT", IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1MAX0,   "I1MAX0",   IF_AMAX1,   TY_INTEGER_1,  TY_INTEGER_1, TWO_OR_MORE|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_I1MIN0,   "I1MIN0",   IF_AMIN1,   TY_INTEGER_1,  TY_INTEGER_1, TWO_OR_MORE|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_I1MOD,    "I1MOD",    IF_AMOD,    TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1NOT,    "I1NOT",    IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1OR,     "I1OR",     IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1RSHIFT, "I1RSHIFT", IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1SHA,    "I1SHA",    IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1SHC,    "I1SHC",    IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1SHFT,   "I1SHFT",   IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1SHL,    "I1SHL",    IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I1SIGN,   "I1SIGN",   IF_NO_MORE, TY_INTEGER_1,  TY_INTEGER_1, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2ABS,    "I2ABS",    IF_I1ABS,   TY_INTEGER_2,  TY_INTEGER_2, ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2AND,    "I2AND",    IF_I1AND,   TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2BCHNG,  "I2BCHNG",  IF_I1BCHNG, TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2BCLR,   "I2BCLR",   IF_I1BCLR,  TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2BSET,   "I2BSET",   IF_I1BSET,  TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2BTEST,  "I2BTEST",  IF_I1BTEST, TY_LOGICAL,    TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2DIM,    "I2DIM",    IF_I1DIM,   TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2EOR,    "I2EOR",    IF_I1EOR,   TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2LSHIFT, "I2LSHIFT", IF_I1LSHIFT,TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2MAX0,   "I2MAX0",   IF_I1MAX0,  TY_INTEGER_2,  TY_INTEGER_2, TWO_OR_MORE|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_I2MIN0,   "I2MIN0",   IF_I1MIN0,  TY_INTEGER_2,  TY_INTEGER_2, TWO_OR_MORE|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_I2MOD,    "I2MOD",    IF_I1MOD,   TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2NOT,    "I2NOT",    IF_I1NOT,   TY_INTEGER_2,  TY_INTEGER_2, ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2OR,     "I2OR",     IF_I1OR,    TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2RSHIFT, "I2RSHIFT", IF_I1RSHIFT,TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2SHA,    "I2SHA",    IF_I1SHA,   TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2SHC,    "I2SHC",    IF_I1SHC,   TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2SHFT,   "I2SHFT",   IF_I1SHFT,  TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2SHL,    "I2SHL",    IF_I1SHL,   TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_I2SIGN,   "I2SIGN",   IF_I1SIGN,  TY_INTEGER_2,  TY_INTEGER_2, TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_IABS,     "IABS",     IF_I2ABS,   TY_INTEGER,    TY_INTEGER,   ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_IAND,     "IAND",     IF_I2AND,   TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_IBCHNG,   "IBCHNG",   IF_I2BCHNG, TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_IBCLR,    "IBCLR",    IF_I2BCLR,  TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_IBSET,    "IBSET",    IF_I2BSET,  TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_ICHAR,    "ICHAR",    IF_NO_MORE, TY_INTEGER,    TY_CHAR,      ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_IDIM,     "IDIM",     IF_I2DIM,   TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_IDINT,    "IDINT",    MAGIC,      TY_INTEGER,    TY_DOUBLE,    ONE_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_IDNINT,   "IDNINT",   IF_IQNINT,  TY_INTEGER,    TY_DOUBLE,    ONE_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_IEOR,     "IEOR",     IF_I2EOR,   TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_IFIX,     "IFIX",     MAGIC,      TY_INTEGER,    TY_REAL,      ONE_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_IMAG,     "IMAG",     IF_AIMAG,   TY_NO_TYPE,    TY_NO_TYPE,   ONE_ARG|IF_GENERIC|IF_NOT_ARG )
pick( IF_INDEX,    "INDEX",    IF_NO_MORE, TY_INTEGER,    TY_CHAR,      TWO_ARG|IF_NOT_GEN|IF_ARG_OK )
pick( IF_INT,      "INT",      MAGIC,      TY_INTEGER,    TY_REAL,      ONE_ARG|IF_GENERIC|IF_NOT_ARG )
pick( IF_IOR,      "IOR",      IF_I2OR,    TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_IQINT,    "IQINT",    MAGIC,      TY_INTEGER,    TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_IQNINT,   "IQNINT",   IF_NO_MORE, TY_INTEGER,    TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_ISHA,     "ISHA",     IF_I2SHA,   TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_ISHC,     "ISHC",     IF_I2SHC,   TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_ISHFT,    "ISHFT",    IF_I2SHFT,  TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_ISHL,     "ISHL",     IF_I2SHL,   TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_ISIGN,    "ISIGN",    IF_DSIGN,   TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_ISIZEOF,  "ISIZEOF",  MAGIC,      TY_INTEGER,    TY_NO_TYPE,   ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_LEN,      "LEN",      IF_NO_MORE, TY_INTEGER,    TY_CHAR,      ONE_ARG|IF_IN_LINE|IF_NOT_GEN|IF_ARG_OK )
pick( IF_LENTRIM,  "LENTRIM",  IF_NO_MORE, TY_INTEGER,    TY_CHAR,      ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_LGAMMA,   "LGAMMA",   IF_DLGAMA,  TY_NO_TYPE,    TY_NO_TYPE,   ONE_ARG|IF_EXTENSION|IF_GENERIC|IF_NOT_ARG )
pick( IF_LGE,      "LGE",      IF_NO_MORE, TY_LOGICAL,    TY_CHAR,      TWO_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_LGT,      "LGT",      IF_NO_MORE, TY_LOGICAL,    TY_CHAR,      TWO_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_LLE,      "LLE",      IF_NO_MORE, TY_LOGICAL,    TY_CHAR,      TWO_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_LLT,      "LLT",      IF_NO_MORE, TY_LOGICAL,    TY_CHAR,      TWO_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_LOC,      "LOC",      MAGIC,      TY_INTEGER,    TY_NO_TYPE,   ONE_ARG|IF_EXTENSION|IF_GENERIC|IF_NOT_ARG )
pick( IF_LOG,      "LOG",      IF_ALOG,    TY_NO_TYPE,    TY_NO_TYPE,   ONE_ARG|IF_GENERIC|IF_NOT_ARG )
pick( IF_LOG10,    "LOG10",    IF_ALOG10,  TY_NO_TYPE,    TY_NO_TYPE,   ONE_ARG|IF_GENERIC|IF_NOT_ARG )
pick( IF_LSHIFT,   "LSHIFT",   IF_I2LSHIFT,TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_MAX,      "MAX",      IF_MAX0,    TY_NO_TYPE,    TY_NO_TYPE,   TWO_OR_MORE|IF_GENERIC|IF_NOT_ARG )
pick( IF_MAX0,     "MAX0",     IF_I2MAX0,  TY_INTEGER,    TY_INTEGER,   TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_MAX1,     "MAX1",     IF_NO_MORE, TY_INTEGER,    TY_REAL,      TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_MIN,      "MIN",      IF_MIN0,    TY_NO_TYPE,    TY_NO_TYPE,   TWO_OR_MORE|IF_GENERIC|IF_NOT_ARG )
pick( IF_MIN0,     "MIN0",     IF_I2MIN0,  TY_INTEGER,    TY_INTEGER,   TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_MIN1,     "MIN1",     IF_NO_MORE, TY_INTEGER,    TY_REAL,      TWO_OR_MORE|IF_IN_LINE|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_MOD,      "MOD",      IF_I2MOD,   TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_NINT,     "NINT",     IF_IDNINT,  TY_INTEGER,    TY_REAL,      ONE_ARG|IF_GENERIC|IF_ARG_OK )
pick( IF_NOT,      "NOT",      IF_I2NOT,   TY_INTEGER,    TY_INTEGER,   ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_QABS,     "QABS",     IF_CABS,    TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QACOS,    "QACOS",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QASIN,    "QASIN",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QATAN,    "QATAN",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QATAN2,   "QATAN2",   IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QCMPLX,   "QCMPLX",   MAGIC,      TY_XCOMPLEX,   TY_NO_TYPE,   ONE_OR_TWO|IF_EXTENSION|IF_GENERIC|IF_NOT_ARG )
pick( IF_QCONJG,   "QCONJG",   IF_NO_MORE, TY_XCOMPLEX,   TY_XCOMPLEX,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QCOS,     "QCOS",     IF_CCOS,    TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QCOSH,    "QCOSH",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QCOTAN,   "QCOTAN",   IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QDIM,     "QDIM",     IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  TWO_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QERF,     "QERF",     IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QERFC,    "QERFC",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QEXP,     "QEXP",     IF_CEXP,    TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QEXT,     "QEXT",     MAGIC,      TY_EXTENDED,   TY_NO_TYPE,   ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_NOT_ARG )
pick( IF_QGAMMA,   "QGAMMA",   IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QIMAG,    "QIMAG",    IF_NO_MORE, TY_EXTENDED,   TY_XCOMPLEX,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QINT,     "QINT",     IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QLGAMA,   "QLGAMA",   IF_ALGAMA,  TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QLOG,     "QLOG",     IF_CLOG,    TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QLOG10,   "QLOG10",   IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QMAX1,    "QMAX1",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  TWO_OR_MORE|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_QMIN1,    "QMIN1",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  TWO_OR_MORE|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_QMOD,     "QMOD",     IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QNINT,    "QNINT",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QPROD,    "QPROD",    IF_NO_MORE, TY_EXTENDED,   TY_DOUBLE,    TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QSIGN,    "QSIGN",    IF_I2SIGN,  TY_EXTENDED,   TY_EXTENDED,  TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QSIN,     "QSIN",     IF_CSIN,    TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QSINH,    "QSINH",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QSQRT,    "QSQRT",    IF_CSQRT,   TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QTAN,     "QTAN",     IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_QTANH,    "QTANH",    IF_NO_MORE, TY_EXTENDED,   TY_EXTENDED,  ONE_ARG|IF_IN_LINE|IF_EXTENSION|IF_NOT_GEN|IF_ARG_OK )
pick( IF_REAL,     "REAL",     MAGIC,      TY_REAL,       TY_INTEGER,   ONE_ARG|IF_GENERIC|IF_NOT_ARG )
pick( IF_RSHIFT,   "RSHIFT",   IF_I2RSHIFT,TY_INTEGER,    TY_INTEGER,   TWO_ARG|IF_IN_LINE|IF_EXTENSION|IF_GENERIC|IF_ARG_OK )
pick( IF_SIGN,     "SIGN",     IF_ISIGN,   TY_REAL,       TY_REAL,      TWO_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_SIN,      "SIN",      IF_DSIN,    TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_SINH,     "SINH",     IF_DSINH,   TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_SNGL,     "SNGL",     MAGIC,      TY_REAL,       TY_DOUBLE,    ONE_ARG|IF_NOT_GEN|IF_NOT_ARG )
pick( IF_SQRT,     "SQRT",     IF_DSQRT,   TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_TAN,      "TAN",      IF_DTAN,    TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_TANH,     "TANH",     IF_DTANH,   TY_REAL,       TY_REAL,      ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_ARG_OK )
pick( IF_VOLATILE, "VOLATILE", MAGIC,      TY_NO_TYPE,    TY_NO_TYPE,   ONE_ARG|IF_IN_LINE|IF_GENERIC|IF_NOT_ARG )
