	SECTION _TEXT align=1 CLASS=CODE USE32
	SECTION _DATA align=16 CLASS=DATA USE32
	SECTION _BSS align=16 CLASS=BSS USE32
	SECTION _CONST align=16 CLASS=CONST USE32
	SECTION _STRING align=4 CLASS=STRING USE32
	SECTION _INIT_ align=1 CLASS=INITDATA USE32
	SECTION _EXIT_ align=1 CLASS=EXITDATA USE32
	SECTION cppinit  align=1 CLASS=CPPINIT USE32
	SECTION cppexit  align=1 CLASS=CPPEXIT USE32
	GROUP DGROUP _DATA _BSS _CONST _STRING

SECTION _TEXT
;
; Line 63:	static void _interrupt newkeyboard(void)
;
_newkeyboard:
	PUSHA
	MOV	EBP,ESP
L_2:
;
; Line 64:	{
;
;
; Line 65:	asm push ds
;
	PUSH	DS
;
; Line 66:	asm push es
;
	PUSH	ES
;
; Line 67:	asm mov ds, cs:[dsSel]
;
	MOV	DS,WORD [CS:_dsSel]
;
; Line 68:	asm mov es, cs:[dsSel]
;
	MOV	ES,WORD [CS:_dsSel]
;
; Line 69:	keyportvalue = inp(KEYBOARDPORT);
;
	PUSH	BYTE 060H
	CALL	_inp
	POP	ECX
	MOV	DWORD [_keyportvalue],EAX
;
; Line 70:	asm pushfd
;
	PUSHFD
;
; Line 71:	asm call fword [keyboardLast];
;
	CALL	DWORD FAR [_keyboardLast]
;
; Line 72:	asm pop es
;
	POP	ES
;
; Line 73:	asm pop ds
;
	POP	DS
;
; Line 74:	}
;
L_1:
	POPA
	IRET
;
; Line 77:	static void _interrupt newtimer(void)
;
_newtimer:
	PUSHA
	MOV	EBP,ESP
L_4:
;
; Line 78:	{
;
;
; Line 79:	asm push ds
;
	PUSH	DS
;
; Line 80:	asm push es
;
	PUSH	ES
;
; Line 81:	asm mov ax,cs:[dsSel] ;
;
	MOV	AX,WORD [CS:_dsSel]
;
; Line 82:	asm mov ds,ax
;
	MOV	DS,AX
;
; Line 83:	asm mov es,ax
;
	MOV	ES,AX
;
; Line 84:	asm mov ecx,[stackbot] ;
;
	MOV	ECX,DWORD [_stackbot]
;
; Line 85:	asm add	ecx,TIMERSTACKSIZE-4 ;
;
	ADD	ECX,DWORD 0FFFCH
;
; Line 86:	asm mov	[oldss],ss
;
	MOV	WORD [_oldss],SS
;
; Line 87:	asm mov	[oldsp],esp
;
	MOV	DWORD [_oldsp],ESP
;
; Line 88:	asm mov	ss,ax ;
;
	MOV	SS,AX
;
; Line 89:	asm mov	esp,ecx
;
	MOV	ESP,ECX
;
; Line 91:	if (timer_running(doubletimer))
;
	MOV	EAX,DWORD [_doubletimer]
	TEST	EAX,EAX
	JLE	SHORT	L_5
;
; Line 92:	countdown(doubletimer);
;
	DEC	DWORD [_doubletimer]
L_5:
;
; Line 93:	if (timer_running(delaytimer))
;
	MOV	EAX,DWORD [_delaytimer]
	TEST	EAX,EAX
	JLE	SHORT	L_7
;
; Line 94:	countdown(delaytimer);
;
	DEC	DWORD [_delaytimer]
L_7:
;
; Line 95:	if (timer_running(clocktimer))
;
	MOV	EAX,DWORD [_clocktimer]
	TEST	EAX,EAX
	JLE	SHORT	L_9
;
; Line 96:	countdown(clocktimer);
;
	DEC	DWORD [_clocktimer]
L_9:
;
; Line 97:	asm pushfd
;
	PUSHFD
;
; Line 98:	asm call fword [timerLast];
;
	CALL	DWORD FAR [_timerLast]
;
; Line 99:	asm mov ss,[oldss]
;
	MOV	SS,WORD [_oldss]
;
; Line 100:	asm mov esp,[oldsp]
;
	MOV	ESP,DWORD [_oldsp]
;
; Line 101:	asm pop es
;
	POP	ES
;
; Line 102:	asm pop ds
;
	POP	DS
;
; Line 103:	}
;
L_3:
	POPA
	IRET
;
; Line 104:	static void _interrupt newctrlbreak(void)
;
_newctrlbreak:
	PUSHA
	MOV	EBP,ESP
L_12:
;
; Line 105:	{
;
;
; Line 106:	}
;
L_11:
	POPA
	IRET
[GLOBAL	_TestCriticalError]
;
; Line 110:	int TestCriticalError(void)
;
_TestCriticalError:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
L_17:
;
; Line 111:	{
;
;
; Line 112:	int rtn = 0;
;
	MOV	EBX,00H
;
; Line 113:	if (CriticalError)    {
;
	MOV	EAX,DWORD [_CriticalError]
	TEST	EAX,EAX
	JE	SHORT	L_18
;
; Line 114:	rtn = 1;
;
	MOV	EBX,01H
;
; Line 115:	CriticalError = FALSE;
;
	MOV	DWORD [_CriticalError],00H
;
; Line 116:	if (TestErrorMessage(ermsg) == FALSE)
;
	PUSH	BYTE 01H
	PUSH	BYTE 032H
	PUSH	BYTE 031H
	PUSH	DWORD L_15
	PUSH	DWORD L_14
	PUSH	DWORD _ErrorBoxProc
	PUSH	BYTE 02H
	PUSH	DWORD _ermsg
	PUSH	DWORD L_13
	PUSH	BYTE 00H
	CALL	_GenericMessage
	ADD	ESP,BYTE 028H
	TEST	EAX,EAX
	JNE	SHORT	L_20
;
; Line 117:	rtn = 2;
;
	MOV	EBX,02H
L_20:
L_18:
;
; Line 119:	return rtn;
;
	MOV	EAX,EBX
L_16:
	POP	EBX
	POP	EBP
	RET
;
; Line 123:	static void _interrupt newcrit(IREGS ir)
;
_newcrit:
	PUSHA
	MOV	EBP,ESP
	LEA	ESI,[EBP+00H]
L_23:
;
; Line 124:	{
;
;
; Line 125:	asm push ds
;
	PUSH	DS
;
; Line 126:	asm push es
;
	PUSH	ES
;
; Line 127:	asm mov ds, cs:[dsSel]
;
	MOV	DS,WORD [CS:_dsSel]
;
; Line 128:	asm mov es, cs:[dsSel]
;
	MOV	ES,WORD [CS:_dsSel]
;
; Line 129:	if (!(ir.ax & 0x8000))     {
;
	MOV	EAX,DWORD [ESI+020H]
	AND	EAX,08000H
	JNE	SHORT	L_24
;
; Line 130:	ermsg[sizeof(ermsg) - 2] = (ir.ax & 0xff) + 'A';
;
	MOVZX	EAX,BYTE [ESI+020H]
	ADD	EAX,BYTE 041H
	MOV	BYTE [_ermsg+016H],AL
;
; Line 131:	CriticalError = TRUE;
;
	MOV	DWORD [_CriticalError],01H
L_24:
;
; Line 133:	ir.ax = 0;
;
	MOV	DWORD [ESI+020H],00H
;
; Line 134:	asm pop es
;
	POP	ES
;
; Line 135:	asm pop ds
;
	POP	DS
;
; Line 136:	}
;
L_22:
	POPA
	IRET
;
; Line 138:	static void StopMsg(void)
;
_StopMsg:
	PUSH	EBP
	MOV	EBP,ESP
L_27:
;
; Line 139:	{
;
;
; Line 140:	if (hasints)
;
	MOV	EAX,DWORD [_hasints]
	TEST	EAX,EAX
	JE	SHORT	L_28
;
; Line 142:	dpmi_set_protected_interrupt(TIMER,*(SELECTOR *)((unsigned char *)&timerLast + 4),*(ULONG *)&timerLast) ;
;
	MOV	EAX,DWORD _timerLast
	PUSH	DWORD [EAX+00H]
	MOV	EAX,DWORD _timerLast+04H
	MOVZX	EAX,WORD [EAX+00H]
	PUSH	EAX
	PUSH	BYTE 08H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 143:	dpmi_free_memory(timerMemhand) ;
;
	PUSH	DWORD [_timerMemhand]
	CALL	_dpmi_free_memory
	POP	ECX
;
; Line 144:	dpmi_set_protected_interrupt(KEYBOARDVECT,*(SELECTOR *)((unsigned char *)&keyboardLast + 4),*(ULONG *)&keyboardLast) ;
;
	MOV	EAX,DWORD _keyboardLast
	PUSH	DWORD [EAX+00H]
	MOV	EAX,DWORD _keyboardLast+04H
	MOVZX	EAX,WORD [EAX+00H]
	PUSH	EAX
	PUSH	BYTE 09H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 145:	hasints = FALSE;
;
	MOV	DWORD [_hasints],00H
L_28:
;
; Line 147:	ClearClipboard();
;
	CALL	_ClearClipboard
;
; Line 148:	ClearDialogBoxes();
;
	CALL	_ClearDialogBoxes
;
; Line 149:	ConsoleRundown();
;
	CALL	_ConsoleRundown
;
; Line 150:	hide_mousecursor();
;
	CALL	_hide_mousecursor
;
; Line 151:	}
;
L_26:
	POP	EBP
	RET
[GLOBAL	_init_messages]
;
; Line 154:	BOOL init_messages(void)
;
_init_messages:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 08H
L_31:
;
; Line 155:	{
;
;
; Line 156:	asm mov [dsSel],ds
;
	MOV	WORD [_dsSel],DS
;
; Line 157:	AllocTesting = TRUE;
;
	MOV	DWORD [_AllocTesting],01H
;
; Line 158:	if (setjmp(AllocError) != 0)	{
;
	PUSH	DWORD _AllocError
	CALL	_setjmp
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_32
;
; Line 159:	StopMsg();
;
	CALL	_StopMsg
;
; Line 160:	return FALSE;
;
	MOV	EAX,00H
	JMP	NEAR	L_30
L_32:
;
; Line 162:	resetmouse();
;
	CALL	_resetmouse
;
; Line 163:	set_mousetravel(0, SCREENWIDTH-1, 0, SCREENHEIGHT-1);
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_36
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_34
L_36:
	MOV	AX,00H
	ADD	EAX,084H
	MOVSX	EAX,BYTE [EAX+00H]
	INC	EAX
	JMP	SHORT	L_35
L_34:
	MOV	EAX,019H
L_35:
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	MOV	AX,00H
	ADD	EAX,BYTE 04AH
	MOVSX	EAX,BYTE [EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 164:	ConsoleInit();
;
	CALL	_ConsoleInit
;
; Line 165:	px = py = -1;
;
	MOV	EAX,01H
	NEG	EAX
	MOV	DWORD [_py],EAX
	MOV	DWORD [_px],EAX
;
; Line 166:	pmx = pmy = -1;
;
	MOV	EAX,01H
	NEG	EAX
	MOV	DWORD [_pmy],EAX
	MOV	DWORD [_pmx],EAX
;
; Line 167:	mx = my = 0;
;
	MOV	DWORD [_my],00H
	MOV	DWORD [_mx],00H
;
; Line 168:	CaptureMouse = CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
	MOV	DWORD [_CaptureMouse],00H
;
; Line 169:	NoChildCaptureMouse = FALSE;
;
	MOV	DWORD [_NoChildCaptureMouse],00H
;
; Line 170:	NoChildCaptureKeyboard = FALSE;
;
	MOV	DWORD [_NoChildCaptureKeyboard],00H
;
; Line 171:	MsgQueueOnCtr = MsgQueueOffCtr = MsgQueueCtr = 0;
;
	MOV	DWORD [_MsgQueueCtr],00H
	MOV	DWORD [_MsgQueueOffCtr],00H
	MOV	DWORD [_MsgQueueOnCtr],00H
;
; Line 172:	EventQueueOnCtr = EventQueueOffCtr = EventQueueCtr = 0;
;
	MOV	DWORD [_EventQueueCtr],00H
	MOV	DWORD [_EventQueueOffCtr],00H
	MOV	DWORD [_EventQueueOnCtr],00H
;
; Line 173:	if (!hasints)    {
;
	MOV	EAX,DWORD [_hasints]
	TEST	EAX,EAX
	JNE	NEAR	L_37
;
; Line 176:	asm mov [cssel],cs
;
	MOV	WORD [EBP-08H],CS
;
; Line 177:	asm mov [dssel],ds
;
	MOV	WORD [EBP-06H],DS
;
; Line 178:	dpmi_get_memory(&stackbot,&timerMemhand, TIMERSTACKSIZE) ;
;
	PUSH	DWORD 010000H
	PUSH	DWORD _timerMemhand
	PUSH	DWORD _stackbot
	CALL	_dpmi_get_memory
	ADD	ESP,BYTE 0CH
;
; Line 179:	dpmi_get_sel_base(&linear, dssel);
;
	MOVZX	EAX,WORD [EBP-06H]
	PUSH	EAX
	LEA	EAX,[EBP-04H]
	PUSH	EAX
	CALL	_dpmi_get_sel_base
	ADD	ESP,BYTE 08H
;
; Line 180:	stackbot -= linear;
;
	MOV	EAX,DWORD [EBP-04H]
	IMUL	EAX,BYTE 01H
	SUB	DWORD [_stackbot],EAX
;
; Line 181:	dpmi_get_protected_interrupt(((unsigned char *)&timerLast + 4), &timerLast, TIMER) ;
;
	PUSH	BYTE 08H
	PUSH	DWORD _timerLast
	MOV	EAX,DWORD _timerLast+04H
	PUSH	EAX
	CALL	_dpmi_get_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 182:	dpmi_set_protected_interrupt(TIMER,cssel,(ULONG)newtimer) ;
;
	PUSH	DWORD _newtimer
	MOVZX	EAX,WORD [EBP-08H]
	PUSH	EAX
	PUSH	BYTE 08H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 184:	dpmi_get_protected_interrupt(((unsigned char *)&keyboardLast + 4), &keyboardLast, KEYBOARDVECT) ;
;
	PUSH	BYTE 09H
	PUSH	DWORD _keyboardLast
	MOV	EAX,DWORD _keyboardLast+04H
	PUSH	EAX
	CALL	_dpmi_get_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 185:	dpmi_set_protected_interrupt(KEYBOARDVECT,cssel,(ULONG)newkeyboard) ;
;
	PUSH	DWORD _newkeyboard
	MOVZX	EAX,WORD [EBP-08H]
	PUSH	EAX
	PUSH	BYTE 09H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 187:	dpmi_set_protected_interrupt(CTRLBREAK,cssel,(ULONG)newctrlbreak) ;
;
	PUSH	DWORD _newctrlbreak
	MOVZX	EAX,WORD [EBP-08H]
	PUSH	EAX
	PUSH	BYTE 023H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 189:	dpmi_set_protected_interrupt(CRIT,cssel,(ULONG)newcrit) ;
;
	PUSH	DWORD _newcrit
	MOVZX	EAX,WORD [EBP-08H]
	PUSH	EAX
	PUSH	BYTE 024H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
L_37:
;
; Line 192:	PostMessage(NULL,START,0,0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	CALL	_PostMessage
	ADD	ESP,BYTE 010H
;
; Line 193:	lagdelay = FIRSTDELAY;
;
	MOV	DWORD [_lagdelay],07H
;
; Line 194:	return TRUE;
;
	MOV	EAX,01H
L_30:
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 198:	static void PostEvent(MESSAGE event, int p1, int p2)
;
_PostEvent:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _EventQueueOnCtr
	MOV	EDI,DWORD _EventQueue
L_40:
;
; Line 199:	{
;
;
; Line 200:	if (EventQueueCtr != MAXMESSAGES)    {
;
	MOV	EAX,DWORD [_EventQueueCtr]
	CMP	EAX,BYTE 064H
	JE	SHORT	L_41
;
; Line 201:	EventQueue[EventQueueOnCtr].event = event;
;
	MOV	EAX,DWORD [EBP+08H]
	MOV	ECX,DWORD [ESI+00H]
	IMUL	ECX,BYTE 0CH
	MOV	DWORD [ECX+EDI+00H],EAX
;
; Line 202:	EventQueue[EventQueueOnCtr].mx = p1;
;
	MOV	EAX,DWORD [EBP+0CH]
	MOV	ECX,DWORD [ESI+00H]
	IMUL	ECX,BYTE 0CH
	LEA	ECX,[ECX+EDI+00H]
	MOV	DWORD [ECX+04H],EAX
;
; Line 203:	EventQueue[EventQueueOnCtr].my = p2;
;
	MOV	EAX,DWORD [EBP+010H]
	MOV	ECX,DWORD [ESI+00H]
	IMUL	ECX,BYTE 0CH
	LEA	ECX,[ECX+EDI+00H]
	MOV	DWORD [ECX+08H],EAX
;
; Line 204:	if (++EventQueueOnCtr == MAXMESSAGES)
;
	INC	DWORD [ESI+00H]
	MOV	EAX,DWORD [ESI+00H]
	CMP	EAX,BYTE 064H
	JNE	SHORT	L_43
;
; Line 205:	EventQueueOnCtr = 0;
;
	MOV	DWORD [ESI+00H],00H
L_43:
;
; Line 206:	EventQueueCtr++;
;
	INC	DWORD [_EventQueueCtr]
L_41:
;
; Line 208:	}
;
L_39:
	POP	EDI
	POP	ESI
	POP	EBP
	RET
;
; Line 211:	static void near collect_events(void)
;
_collect_events:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 010H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD _lagdelay
L_52:
;
; Line 212:	{
;
;
; Line 220:	if (timed_out(clocktimer))    {
;
	MOV	EAX,DWORD [_clocktimer]
	TEST	EAX,EAX
	JNE	NEAR	L_53
;
; Line 222:	time_t t = time(NULL);
;
	PUSH	BYTE 00H
	CALL	_time
	POP	ECX
	MOV	DWORD [EBP-010H],EAX
;
; Line 223:	now = localtime(&t);
;
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_localtime
	POP	ECX
	MOV	DWORD [EBP-08H],EAX
;
; Line 224:	hr = now->tm_hour > 12 ?
;
	MOV	EAX,DWORD [EBP-08H]
	MOV	EAX,DWORD [EAX+08H]
	CMP	EAX,BYTE 0CH
	JLE	SHORT	L_55
	MOV	EAX,DWORD [EBP-08H]
	MOV	EAX,DWORD [EAX+08H]
	SUB	EAX,BYTE 0CH
	JMP	SHORT	L_56
L_55:
	MOV	EAX,DWORD [EBP-08H]
	MOV	EAX,DWORD [EAX+08H]
L_56:
	MOV	DWORD [EBP-04H],EAX
;
; Line 227:	if (hr == 0)
;
	MOV	EAX,DWORD [EBP-04H]
	TEST	EAX,EAX
	JNE	SHORT	L_57
;
; Line 228:	hr = 12;
;
	MOV	DWORD [EBP-04H],0CH
L_57:
;
; Line 229:	sprintf(time_string, "%2d:%02d", hr, now->tm_min);
;
	MOV	EAX,DWORD [EBP-08H]
	PUSH	DWORD [EAX+04H]
	PUSH	DWORD [EBP-04H]
	PUSH	DWORD L_47
	PUSH	DWORD _time_string
	CALL	_sprintf
	ADD	ESP,BYTE 010H
;
; Line 230:	strcpy(time_string+5, now->tm_hour > 11 ? "pm " : "am ");
;
	MOV	EAX,DWORD [EBP-08H]
	MOV	EAX,DWORD [EAX+08H]
	CMP	EAX,BYTE 0BH
	JLE	SHORT	L_59
	MOV	EAX,DWORD L_48
	JMP	SHORT	L_60
L_59:
	MOV	EAX,DWORD L_49
L_60:
	PUSH	EAX
	MOV	EAX,DWORD _time_string+05H
	PUSH	EAX
	CALL	_strcpy
	ADD	ESP,BYTE 08H
;
; Line 232:	if (flipflop)
;
	MOV	EAX,DWORD [L_46]
	TEST	EAX,EAX
	JE	SHORT	L_61
;
; Line 233:	*(time_string+2) = ' ';
;
	MOV	BYTE [_time_string+02H],020H
L_61:
;
; Line 234:	flipflop ^= TRUE;
;
	XOR	DWORD [L_46],BYTE 01H
;
; Line 236:	set_timer(clocktimer, 1);
;
	MOV	DWORD [_clocktimer],013H
;
; Line 238:	PostEvent(CLOCKTICK, FP_SEG(time_string), FP_OFF(time_string));
;
	PUSH	DWORD _time_string
	PUSH	BYTE 00H
	PUSH	BYTE 010H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_53:
;
; Line 242:	if ((sk = getshift()) != ShiftKeys)    {
;
	CALL	_getshift
	MOV	ESI,EAX
	CMP	EAX,DWORD [L_45]
	JE	SHORT	L_63
;
; Line 243:	ShiftKeys = sk;
;
	MOV	DWORD [L_45],ESI
;
; Line 245:	PostEvent(SHIFT_CHANGED, sk, 0);
;
	PUSH	BYTE 00H
	PUSH	ESI
	PUSH	BYTE 01CH
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 246:	if (sk & ALTKEY)
;
	MOV	EAX,ESI
	AND	EAX,BYTE 08H
	JE	SHORT	L_65
;
; Line 247:	AltDown = TRUE;
;
	MOV	DWORD [_AltDown],01H
L_65:
L_63:
;
; Line 252:	if (sk & ALTKEY)	{
;
	MOV	EAX,ESI
	AND	EAX,BYTE 08H
	JE	NEAR	L_67
;
; Line 253:	if (keyportvalue == 14)    {
;
	MOV	EAX,DWORD [_keyportvalue]
	CMP	EAX,BYTE 0EH
	JNE	SHORT	L_69
;
; Line 254:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
	JMP	SHORT	L_71
L_73:
	MOV	AX,00H
	ADD	EAX,BYTE 01CH
	MOV	AX,WORD [EAX+00H]
	MOV	CX,00H
	ADD	ECX,BYTE 01AH
	MOV	WORD [ECX+00H],AX
L_71:
;
; Line 255:	waitforkeyboard();
;
	MOV	EAX,DWORD [_keyportvalue]
	AND	EAX,080H
	JE	SHORT	L_73
L_72:
;
; Line 256:	PostEvent(KEYBOARD, ALT_BS, sk);
;
	PUSH	ESI
	PUSH	DWORD 010C5H
	PUSH	BYTE 013H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_69:
;
; Line 258:	if (keyportvalue == 83)    {
;
	MOV	EAX,DWORD [_keyportvalue]
	CMP	EAX,BYTE 053H
	JNE	SHORT	L_74
;
; Line 259:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
	JMP	SHORT	L_76
L_78:
	MOV	AX,00H
	ADD	EAX,BYTE 01CH
	MOV	AX,WORD [EAX+00H]
	MOV	CX,00H
	ADD	ECX,BYTE 01AH
	MOV	WORD [ECX+00H],AX
L_76:
;
; Line 260:	waitforkeyboard();
;
	MOV	EAX,DWORD [_keyportvalue]
	AND	EAX,080H
	JE	SHORT	L_78
L_77:
;
; Line 261:	PostEvent(KEYBOARD, ALT_DEL, sk);
;
	PUSH	ESI
	PUSH	DWORD 010B8H
	PUSH	BYTE 013H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_74:
L_67:
;
; Line 264:	if (sk & CTRLKEY)	{
;
	MOV	EAX,ESI
	AND	EAX,BYTE 04H
	JE	SHORT	L_79
;
; Line 265:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 266:	if (keyportvalue == 82)    {
;
	MOV	EAX,DWORD [_keyportvalue]
	CMP	EAX,BYTE 052H
	JNE	SHORT	L_81
	JMP	SHORT	L_83
L_85:
	MOV	AX,00H
	ADD	EAX,BYTE 01CH
	MOV	AX,WORD [EAX+00H]
	MOV	CX,00H
	ADD	ECX,BYTE 01AH
	MOV	WORD [ECX+00H],AX
L_83:
;
; Line 267:	waitforkeyboard();
;
	MOV	EAX,DWORD [_keyportvalue]
	AND	EAX,080H
	JE	SHORT	L_85
L_84:
;
; Line 268:	PostEvent(KEYBOARD, CTRL_INS, sk);
;
	PUSH	ESI
	PUSH	DWORD 010BAH
	PUSH	BYTE 013H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_81:
L_79:
;
; Line 272:	if (keyhit())    {
;
	CALL	_kbhit
	TEST	EAX,EAX
	JE	NEAR	L_86
;
; Line 275:	int c = getkey();
;
	CALL	_getkey
	MOV	EBX,EAX
;
; Line 276:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 278:	if (sk & (LEFTSHIFT | RIGHTSHIFT))    {
;
	MOV	EAX,ESI
	AND	EAX,BYTE 03H
	JE	SHORT	L_88
;
; Line 279:	if (c >= '0' && c <= '9')
;
	MOV	EAX,EBX
	CMP	EAX,BYTE 030H
	JL	SHORT	L_90
	MOV	EAX,EBX
	CMP	EAX,BYTE 039H
	JG	SHORT	L_90
;
; Line 280:	c = cvt[c-'0'];
;
	MOV	EAX,EBX
	SUB	EAX,BYTE 030H
	LEA	EAX,[EAX*4+00H]
	MOV	EBX,DWORD [EAX+L_50]
	JMP	SHORT	L_91
L_90:
;
; Line 281:	else if (c == '.' || c == DEL)
;
	MOV	EAX,EBX
	CMP	EAX,BYTE 02EH
	JE	SHORT	L_94
	MOV	EAX,EBX
	CMP	EAX,010D3H
	JNE	SHORT	L_92
L_94:
;
; Line 282:	c = SHIFT_DEL;
;
	MOV	EBX,010C6H
	JMP	SHORT	L_93
L_92:
;
; Line 283:	else if (c == INS)
;
	MOV	EAX,EBX
	CMP	EAX,010D2H
	JNE	SHORT	L_95
;
; Line 284:	c = SHIFT_INS;
;
	MOV	EBX,010B9H
L_95:
L_93:
L_91:
L_88:
;
; Line 286:	if (c != '\r' && (c < ' ' || c > 127))
;
	MOV	EAX,EBX
	CMP	EAX,BYTE 0DH
	JE	SHORT	L_97
	MOV	EAX,EBX
	CMP	EAX,BYTE 020H
	JL	SHORT	L_99
	MOV	EAX,EBX
	CMP	EAX,BYTE 07FH
	JLE	SHORT	L_97
L_99:
;
; Line 287:	clearBIOSbuffer();
;
	MOV	AX,00H
	ADD	EAX,BYTE 01CH
	MOV	AX,WORD [EAX+00H]
	MOV	CX,00H
	ADD	ECX,BYTE 01AH
	MOV	WORD [ECX+00H],AX
L_97:
;
; Line 289:	PostEvent(KEYBOARD, c, sk);
;
	PUSH	ESI
	PUSH	EBX
	PUSH	BYTE 013H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_86:
;
; Line 292:	if (button_releases())    {
;
	CALL	_button_releases
	TEST	EAX,EAX
	JE	SHORT	L_100
;
; Line 294:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 295:	doubletimer = DOUBLETICKS;
;
	MOV	DWORD [_doubletimer],05H
;
; Line 296:	PostEvent(BUTTON_RELEASED, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 025H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 297:	disable_timer(delaytimer);
;
	MOV	DWORD [_delaytimer],0FFFFFFFFH
L_100:
;
; Line 299:	get_mouseposition(&mx, &my);
;
	PUSH	DWORD _my
	PUSH	DWORD _mx
	CALL	_get_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 300:	if (mx != px || my != py)  {
;
	MOV	EAX,DWORD [_mx]
	CMP	EAX,DWORD [_px]
	JNE	SHORT	L_104
	MOV	EAX,DWORD [_my]
	CMP	EAX,DWORD [_py]
	JE	SHORT	L_102
L_104:
;
; Line 301:	px = mx;
;
	MOV	EAX,DWORD [_mx]
	MOV	DWORD [_px],EAX
;
; Line 302:	py = my;
;
	MOV	EAX,DWORD [_my]
	MOV	DWORD [_py],EAX
;
; Line 303:	PostEvent(MOUSE_MOVED, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 024H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_102:
;
; Line 305:	if (rightbutton())	{
;
	CALL	_mousebuttons
	AND	EAX,BYTE 02H
	JE	SHORT	L_105
;
; Line 306:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 307:	PostEvent(RIGHT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 021H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_105:
;
; Line 309:	if (leftbutton())    {
;
	CALL	_mousebuttons
	AND	EAX,BYTE 01H
	JE	NEAR	L_107
;
; Line 310:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 311:	if (mx == pmx && my == pmy)    {
;
	MOV	EAX,DWORD [_mx]
	CMP	EAX,DWORD [_pmx]
	JNE	SHORT	L_109
	MOV	EAX,DWORD [_my]
	CMP	EAX,DWORD [_pmy]
	JNE	SHORT	L_109
;
; Line 313:	if (timer_running(doubletimer))    {
;
	MOV	EAX,DWORD [_doubletimer]
	TEST	EAX,EAX
	JLE	SHORT	L_111
;
; Line 315:	disable_timer(doubletimer);
;
	MOV	DWORD [_doubletimer],0FFFFFFFFH
;
; Line 316:	PostEvent(DOUBLE_CLICK, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 023H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
	JMP	SHORT	L_112
L_111:
;
; Line 318:	else if (!timer_running(delaytimer))    {
;
	MOV	EAX,DWORD [_delaytimer]
	TEST	EAX,EAX
	JG	SHORT	L_113
;
; Line 320:	delaytimer = lagdelay;
;
	MOV	EAX,DWORD [EDI+00H]
	MOV	DWORD [_delaytimer],EAX
;
; Line 321:	lagdelay = DELAYTICKS;
;
	MOV	DWORD [EDI+00H],01H
;
; Line 323:	PostEvent(LEFT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 022H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_113:
L_112:
	JMP	SHORT	L_110
L_109:
;
; Line 328:	disable_timer(doubletimer);
;
	MOV	DWORD [_doubletimer],0FFFFFFFFH
;
; Line 329:	delaytimer = FIRSTDELAY;
;
	MOV	DWORD [_delaytimer],07H
;
; Line 330:	lagdelay = DELAYTICKS;
;
	MOV	DWORD [EDI+00H],01H
;
; Line 331:	PostEvent(LEFT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 022H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 332:	pmx = mx;
;
	MOV	EAX,DWORD [_mx]
	MOV	DWORD [_pmx],EAX
;
; Line 333:	pmy = my;
;
	MOV	EAX,DWORD [_my]
	MOV	DWORD [_pmy],EAX
L_110:
	JMP	SHORT	L_108
L_107:
;
; Line 337:	lagdelay = FIRSTDELAY;
;
	MOV	DWORD [EDI+00H],07H
L_108:
;
; Line 338:	}
;
L_51:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_PostMessage]
;
; Line 341:	void PostMessage(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
;
_PostMessage:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _MsgQueueOnCtr
	MOV	EDI,DWORD _MsgQueue
L_116:
;
; Line 342:	{
;
;
; Line 343:	if (MsgQueueCtr != MAXMESSAGES)    {
;
	MOV	EAX,DWORD [_MsgQueueCtr]
	CMP	EAX,BYTE 064H
	JE	SHORT	L_117
;
; Line 344:	MsgQueue[MsgQueueOnCtr].wnd = wnd;
;
	MOV	EAX,DWORD [EBP+08H]
	MOV	ECX,DWORD [ESI+00H]
	SHL	ECX,04H
	MOV	DWORD [ECX+EDI+00H],EAX
;
; Line 345:	MsgQueue[MsgQueueOnCtr].msg = msg;
;
	MOV	EAX,DWORD [EBP+0CH]
	MOV	ECX,DWORD [ESI+00H]
	SHL	ECX,04H
	LEA	ECX,[ECX+EDI+00H]
	MOV	DWORD [ECX+04H],EAX
;
; Line 346:	MsgQueue[MsgQueueOnCtr].p1 = p1;
;
	MOV	EAX,DWORD [EBP+010H]
	MOV	ECX,DWORD [ESI+00H]
	SHL	ECX,04H
	LEA	ECX,[ECX+EDI+00H]
	MOV	DWORD [ECX+08H],EAX
;
; Line 347:	MsgQueue[MsgQueueOnCtr].p2 = p2;
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	ECX,DWORD [ESI+00H]
	SHL	ECX,04H
	LEA	ECX,[ECX+EDI+00H]
	MOV	DWORD [ECX+0CH],EAX
;
; Line 348:	if (++MsgQueueOnCtr == MAXMESSAGES)
;
	INC	DWORD [ESI+00H]
	MOV	EAX,DWORD [ESI+00H]
	CMP	EAX,BYTE 064H
	JNE	SHORT	L_119
;
; Line 349:	MsgQueueOnCtr = 0;
;
	MOV	DWORD [ESI+00H],00H
L_119:
;
; Line 350:	MsgQueueCtr++;
;
	INC	DWORD [_MsgQueueCtr]
L_117:
;
; Line 352:	}
;
L_115:
	POP	EDI
	POP	ESI
	POP	EBP
	RET
[GLOBAL	_SendMessage]
;
; Line 355:	int SendMessage(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
;
_SendMessage:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 024H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD [EBP+010H]
L_122:
;
; Line 356:	{
;
;
; Line 357:	int rtn = TRUE, x, y;
;
	MOV	DWORD [EBP-0CH],01H
;
; Line 362:	if (wnd != NULL)
;
	MOV	EAX,ESI
	TEST	EAX,EAX
	JE	NEAR	L_123
;
; Line 363:	switch (msg)    {
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,BYTE 021H
	JE	SHORT	L_129
	JA	SHORT	L_135
	CMP	EAX,BYTE 013H
	JE	SHORT	L_133
	JA	SHORT	L_136
	CMP	EAX,BYTE 0AH
	JE	SHORT	L_128
	JA	NEAR	L_126
	CMP	EAX,BYTE 09H
	JE	SHORT	L_127
	JMP	SHORT	L_126
L_136:
	CMP	EAX,BYTE 01CH
	JE	SHORT	L_134
	JMP	SHORT	L_126
L_135:
	CMP	EAX,BYTE 023H
	JE	SHORT	L_131
	JA	SHORT	L_137
	CMP	EAX,BYTE 022H
	JE	SHORT	L_130
	JMP	SHORT	L_126
L_137:
	CMP	EAX,BYTE 025H
	JE	SHORT	L_132
	JMP	SHORT	L_126
L_127:
;
; Line 365:	case BORDER:
;
L_128:
;
; Line 368:	if (isVisible(wnd))
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_138
;
; Line 369:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
L_138:
;
; Line 370:	break;
;
	JMP	SHORT	L_125
L_129:
;
; Line 372:	case LEFT_BUTTON:
;
L_130:
;
; Line 373:	case DOUBLE_CLICK:
;
L_131:
;
; Line 374:	case BUTTON_RELEASED:
;
L_132:
;
; Line 377:	if (isVisible(wnd) || wnd == CaptureMouse)
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JNE	SHORT	L_142
	MOV	EAX,ESI
	CMP	EAX,DWORD [_CaptureMouse]
	JNE	SHORT	L_140
L_142:
;
; Line 378:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
L_140:
;
; Line 379:	break;
;
	JMP	SHORT	L_125
L_133:
;
; Line 381:	case SHIFT_CHANGED:
;
L_134:
;
; Line 384:	if (!(isVisible(wnd) || wnd == CaptureKeyboard))
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JNE	SHORT	L_143
	MOV	EAX,ESI
	CMP	EAX,DWORD [_CaptureKeyboard]
	JNE	SHORT	L_125
;
; Line 385:	break;
;
L_143:
;
; Line 386:	default:
;
L_126:
;
; Line 387:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
;
; Line 388:	break;
;
	JMP	SHORT	L_125
L_125:
L_123:
;
; Line 392:	if (rtn != FALSE)    {
;
	MOV	EAX,DWORD [EBP-0CH]
	TEST	EAX,EAX
	JE	NEAR	L_145
;
; Line 395:	switch (msg)    {
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,BYTE 01DH
	JE	NEAR	L_160
	JA	NEAR	L_172
	CMP	EAX,BYTE 016H
	JE	NEAR	L_152
	JA	SHORT	L_173
	CMP	EAX,BYTE 012H
	JE	NEAR	L_151
	JA	SHORT	L_174
	CMP	EAX,BYTE 011H
	JE	NEAR	L_150
	JA	NEAR	L_148
	CMP	EAX,BYTE 01H
	JE	NEAR	L_149
	JMP	NEAR	L_148
L_174:
	CMP	EAX,BYTE 015H
	JE	NEAR	L_154
	JA	NEAR	L_148
	CMP	EAX,BYTE 014H
	JE	NEAR	L_153
	JMP	NEAR	L_148
L_173:
	CMP	EAX,BYTE 019H
	JE	NEAR	L_159
	JA	SHORT	L_175
	CMP	EAX,BYTE 018H
	JE	NEAR	L_158
	JA	NEAR	L_148
	CMP	EAX,BYTE 017H
	JE	NEAR	L_155
	JMP	NEAR	L_148
L_175:
	CMP	EAX,BYTE 01BH
	JE	NEAR	L_157
	JA	NEAR	L_148
	CMP	EAX,BYTE 01AH
	JE	NEAR	L_156
	JMP	NEAR	L_148
L_172:
	CMP	EAX,BYTE 028H
	JE	NEAR	L_164
	JA	SHORT	L_176
	CMP	EAX,BYTE 020H
	JE	NEAR	L_162
	JA	SHORT	L_177
	CMP	EAX,BYTE 01FH
	JE	NEAR	L_163
	JA	NEAR	L_148
	CMP	EAX,BYTE 01EH
	JE	NEAR	L_161
	JMP	NEAR	L_148
L_177:
	CMP	EAX,BYTE 027H
	JE	NEAR	L_166
	JA	NEAR	L_148
	CMP	EAX,BYTE 026H
	JE	NEAR	L_167
	JMP	NEAR	L_148
L_176:
	CMP	EAX,BYTE 02BH
	JE	NEAR	L_169
	JA	SHORT	L_178
	CMP	EAX,BYTE 02AH
	JE	NEAR	L_168
	JA	NEAR	L_148
	CMP	EAX,BYTE 029H
	JE	NEAR	L_165
	JMP	NEAR	L_148
L_178:
	CMP	EAX,BYTE 02DH
	JE	NEAR	L_171
	JA	NEAR	L_148
	CMP	EAX,BYTE 02CH
	JE	NEAR	L_170
	JMP	NEAR	L_148
L_149:
;
; Line 397:	StopMsg();
;
	CALL	_StopMsg
;
; Line 398:	break;
;
	JMP	NEAR	L_147
L_150:
;
; Line 401:	if (Cwnd == NULL)
;
	MOV	EAX,DWORD [_Cwnd]
	TEST	EAX,EAX
	JNE	SHORT	L_179
;
; Line 402:	set_timer(clocktimer, 0);
;
	MOV	DWORD [_clocktimer],01H
L_179:
;
; Line 403:	wnd->PrevClock = Cwnd;
;
	MOV	EAX,DWORD [_Cwnd]
	MOV	DWORD [ESI+07CH],EAX
;
; Line 404:	Cwnd = wnd;
;
	MOV	DWORD [_Cwnd],ESI
;
; Line 405:	break;
;
	JMP	NEAR	L_147
L_151:
;
; Line 407:	Cwnd = wnd->PrevClock;
;
	MOV	EAX,DWORD [ESI+07CH]
	MOV	DWORD [_Cwnd],EAX
;
; Line 408:	if (Cwnd == NULL)
;
	MOV	EAX,DWORD [_Cwnd]
	TEST	EAX,EAX
	JNE	SHORT	L_181
;
; Line 409:	disable_timer(clocktimer);
;
	MOV	DWORD [_clocktimer],0FFFFFFFFH
L_181:
;
; Line 410:	break;
;
	JMP	NEAR	L_147
L_152:
;
; Line 413:	if (wnd == NULL)
;
	MOV	EAX,ESI
	TEST	EAX,EAX
	JNE	SHORT	L_183
;
; Line 414:	cursor((int)p1, (int)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_cursor
	ADD	ESP,BYTE 08H
	JMP	NEAR	L_184
L_183:
;
; Line 415:	else if (wnd == inFocus)
;
	MOV	EAX,ESI
	CMP	EAX,DWORD [_inFocus]
	JNE	NEAR	L_185
;
; Line 416:	cursor(GetClientLeft(wnd)+(int)p1,
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_187
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_187
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_187
	MOV	EAX,03H
	JMP	SHORT	L_188
L_187:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_192
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_191
L_192:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_189
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_189
L_191:
	MOV	EAX,02H
	JMP	SHORT	L_190
L_189:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,014108H
	JE	SHORT	L_193
	MOV	EAX,01H
	JMP	SHORT	L_194
L_193:
	MOV	EAX,00H
L_194:
L_190:
L_188:
	ADD	EAX,DWORD [ESI+010H]
	ADD	EAX,DWORD [EBP+014H]
	PUSH	EAX
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_195
	MOV	EAX,01H
	JMP	SHORT	L_196
L_195:
	MOV	EAX,00H
L_196:
	ADD	EAX,DWORD [ESI+0CH]
	ADD	EAX,EBX
	PUSH	EAX
	CALL	_cursor
	ADD	ESP,BYTE 08H
L_185:
L_184:
;
; Line 418:	break;
;
	JMP	NEAR	L_147
L_153:
;
; Line 420:	if (p2)
;
	MOV	EAX,DWORD [EBP+014H]
	TEST	EAX,EAX
	JE	SHORT	L_197
;
; Line 421:	((WINDOW)p2)->PrevKeyboard=CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	ECX,DWORD [EBP+014H]
	MOV	DWORD [ECX+078H],EAX
	JMP	SHORT	L_198
L_197:
;
; Line 423:	wnd->PrevKeyboard = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [ESI+078H],EAX
L_198:
;
; Line 424:	CaptureKeyboard = wnd;
;
	MOV	DWORD [_CaptureKeyboard],ESI
;
; Line 425:	NoChildCaptureKeyboard = (int)p1;
;
	MOV	DWORD [_NoChildCaptureKeyboard],EBX
;
; Line 426:	break;
;
	JMP	NEAR	L_147
L_154:
;
; Line 428:	if (wnd != NULL)	{
;
	MOV	EAX,ESI
	TEST	EAX,EAX
	JE	SHORT	L_199
;
; Line 429:	if (CaptureKeyboard == wnd || (int)p1)
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	CMP	EAX,ESI
	JE	SHORT	L_203
	TEST	EBX,EBX
	JE	SHORT	L_201
L_203:
;
; Line 430:	CaptureKeyboard = wnd->PrevKeyboard;
;
	MOV	EAX,DWORD [ESI+078H]
	MOV	DWORD [_CaptureKeyboard],EAX
	JMP	SHORT	L_202
L_201:
;
; Line 432:	WINDOW twnd = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [EBP-024H],EAX
	JMP	SHORT	L_204
L_206:
;
; Line 434:	if (twnd->PrevKeyboard == wnd)	{
;
	MOV	EAX,DWORD [EBP-024H]
	MOV	EAX,DWORD [EAX+078H]
	CMP	EAX,ESI
	JNE	SHORT	L_207
;
; Line 435:	twnd->PrevKeyboard = wnd->PrevKeyboard;
;
	MOV	EAX,DWORD [ESI+078H]
	MOV	ECX,DWORD [EBP-024H]
	MOV	DWORD [ECX+078H],EAX
;
; Line 436:	break;
;
	JMP	SHORT	L_205
L_207:
;
; Line 438:	twnd = twnd->PrevKeyboard;
;
	MOV	EAX,DWORD [EBP-024H]
	MOV	EAX,DWORD [EAX+078H]
	MOV	DWORD [EBP-024H],EAX
L_204:
;
; Line 433:	while (twnd != NULL)	{
;
	MOV	EAX,DWORD [EBP-024H]
	TEST	EAX,EAX
	JNE	SHORT	L_206
L_205:
;
; Line 440:	if (twnd == NULL)
;
	MOV	EAX,DWORD [EBP-024H]
	TEST	EAX,EAX
	JNE	SHORT	L_209
;
; Line 441:	CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
L_209:
L_202:
;
; Line 443:	wnd->PrevKeyboard = NULL;
;
	MOV	DWORD [ESI+078H],00H
	JMP	SHORT	L_200
L_199:
;
; Line 446:	CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
L_200:
;
; Line 447:	NoChildCaptureKeyboard = FALSE;
;
	MOV	DWORD [_NoChildCaptureKeyboard],00H
;
; Line 448:	break;
;
	JMP	NEAR	L_147
L_155:
;
; Line 450:	curr_cursor(&x, &y);
;
	LEA	EAX,[EBP-04H]
	PUSH	EAX
	LEA	EAX,[EBP-08H]
	PUSH	EAX
	CALL	_curr_cursor
	ADD	ESP,BYTE 08H
;
; Line 451:	*(int*)p1 = x;
;
	MOV	EAX,DWORD [EBP-08H]
	MOV	DWORD [EBX+00H],EAX
;
; Line 452:	*(int*)p2 = y;
;
	MOV	EAX,DWORD [EBP-04H]
	MOV	ECX,DWORD [EBP+014H]
	MOV	DWORD [ECX+00H],EAX
;
; Line 453:	break;
;
	JMP	NEAR	L_147
L_156:
;
; Line 455:	savecursor();
;
	CALL	_savecursor
;
; Line 456:	break;
;
	JMP	NEAR	L_147
L_157:
;
; Line 458:	restorecursor();
;
	CALL	_restorecursor
;
; Line 459:	break;
;
	JMP	NEAR	L_147
L_158:
;
; Line 461:	normalcursor();
;
	CALL	_normalcursor
;
; Line 462:	hidecursor();
;
	CALL	_hidecursor
;
; Line 463:	break;
;
	JMP	NEAR	L_147
L_159:
;
; Line 465:	if (p1)
;
	TEST	EBX,EBX
	JE	SHORT	L_211
;
; Line 466:	set_cursor_type(0x0607);
;
	PUSH	DWORD 0607H
	CALL	_set_cursor_type
	POP	ECX
	JMP	SHORT	L_212
L_211:
;
; Line 468:	set_cursor_type(0x0106);
;
	PUSH	DWORD 0106H
	CALL	_set_cursor_type
	POP	ECX
L_212:
;
; Line 469:	unhidecursor();
;
	CALL	_unhidecursor
;
; Line 470:	break;
;
	JMP	NEAR	L_147
L_160:
	JMP	SHORT	L_213
L_215:
	MOV	AX,00H
	ADD	EAX,BYTE 01CH
	MOV	AX,WORD [EAX+00H]
	MOV	CX,00H
	ADD	ECX,BYTE 01AH
	MOV	WORD [ECX+00H],AX
L_213:
;
; Line 472:	waitforkeyboard();
;
	MOV	EAX,DWORD [_keyportvalue]
	AND	EAX,080H
	JE	SHORT	L_215
L_214:
;
; Line 473:	break;
;
	JMP	NEAR	L_147
L_161:
;
; Line 476:	resetmouse();
;
	CALL	_resetmouse
;
; Line 477:	set_mousetravel(0, SCREENWIDTH-1, 0, SCREENHEIGHT-1);
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_218
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_216
L_218:
	MOV	AX,00H
	ADD	EAX,084H
	MOVSX	EAX,BYTE [EAX+00H]
	INC	EAX
	JMP	SHORT	L_217
L_216:
	MOV	EAX,019H
L_217:
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	MOV	AX,00H
	ADD	EAX,BYTE 04AH
	MOVSX	EAX,BYTE [EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 478:	break;
;
	JMP	NEAR	L_147
L_162:
;
; Line 480:	rtn = mouse_installed();
;
	CALL	_mouse_installed
	MOV	DWORD [EBP-0CH],EAX
;
; Line 481:	break;
;
	JMP	NEAR	L_147
L_163:
;
; Line 484:	if (!p1)	{
;
	TEST	EBX,EBX
	JNE	SHORT	L_219
;
; Line 485:	rc.lf = rc.tp = 0;
;
	MOV	DWORD [EBP-01CH],00H
	MOV	DWORD [EBP-020H],00H
;
; Line 486:	rc.rt = SCREENWIDTH-1;
;
	MOV	AX,00H
	ADD	EAX,BYTE 04AH
	MOVSX	EAX,BYTE [EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	MOV	DWORD [EBP-018H],EAX
;
; Line 487:	rc.bt = SCREENHEIGHT-1;
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_223
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_221
L_223:
	MOV	AX,00H
	ADD	EAX,084H
	MOVSX	EAX,BYTE [EAX+00H]
	INC	EAX
	JMP	SHORT	L_222
L_221:
	MOV	EAX,019H
L_222:
	DEC	EAX
	MOV	DWORD [EBP-014H],EAX
	JMP	SHORT	L_220
L_219:
;
; Line 490:	rc = *(RECT *)p1;
;
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBX+00H]
	LEA	EDI,[EBP-020H]
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
L_220:
;
; Line 491:	set_mousetravel(rc.lf, rc.rt, rc.tp, rc.bt);
;
	PUSH	DWORD [EBP-014H]
	PUSH	DWORD [EBP-01CH]
	PUSH	DWORD [EBP-018H]
	PUSH	DWORD [EBP-020H]
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 492:	break;
;
	JMP	NEAR	L_147
L_164:
;
; Line 495:	show_mousecursor();
;
	CALL	_show_mousecursor
;
; Line 496:	break;
;
	JMP	NEAR	L_147
L_165:
;
; Line 498:	hide_mousecursor();
;
	CALL	_hide_mousecursor
;
; Line 499:	break;
;
	JMP	NEAR	L_147
L_166:
;
; Line 501:	set_mouseposition((int)p1, (int)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_set_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 502:	break;
;
	JMP	NEAR	L_147
L_167:
;
; Line 504:	get_mouseposition((int*)p1,(int*)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_get_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 505:	break;
;
	JMP	NEAR	L_147
L_168:
;
; Line 507:	waitformouse();
;
L_224:
	CALL	_mousebuttons
	TEST	EAX,EAX
	JNE	SHORT	L_224
;
; Line 508:	break;
;
	JMP	NEAR	L_147
L_169:
;
; Line 510:	rtn = mousebuttons();
;
	CALL	_mousebuttons
	MOV	DWORD [EBP-0CH],EAX
;
; Line 511:	break;
;
	JMP	NEAR	L_147
L_170:
;
; Line 513:	if (p2)
;
	MOV	EAX,DWORD [EBP+014H]
	TEST	EAX,EAX
	JE	SHORT	L_225
;
; Line 514:	((WINDOW)p2)->PrevMouse = CaptureMouse;
;
	MOV	EAX,DWORD [_CaptureMouse]
	MOV	ECX,DWORD [EBP+014H]
	MOV	DWORD [ECX+074H],EAX
	JMP	SHORT	L_226
L_225:
;
; Line 516:	wnd->PrevMouse = CaptureMouse;
;
	MOV	EAX,DWORD [_CaptureMouse]
	MOV	DWORD [ESI+074H],EAX
L_226:
;
; Line 517:	CaptureMouse = wnd;
;
	MOV	DWORD [_CaptureMouse],ESI
;
; Line 518:	NoChildCaptureMouse = (int)p1;
;
	MOV	DWORD [_NoChildCaptureMouse],EBX
;
; Line 519:	break;
;
	JMP	SHORT	L_147
L_171:
;
; Line 521:	if (wnd != NULL)	{
;
	MOV	EAX,ESI
	TEST	EAX,EAX
	JE	SHORT	L_227
;
; Line 522:	if (CaptureMouse == wnd || (int)p1)
;
	MOV	EAX,DWORD [_CaptureMouse]
	CMP	EAX,ESI
	JE	SHORT	L_231
	TEST	EBX,EBX
	JE	SHORT	L_229
L_231:
;
; Line 523:	CaptureMouse = wnd->PrevMouse;
;
	MOV	EAX,DWORD [ESI+074H]
	MOV	DWORD [_CaptureMouse],EAX
	JMP	SHORT	L_230
L_229:
;
; Line 525:	WINDOW twnd = CaptureMouse;
;
	MOV	EDI,DWORD [_CaptureMouse]
	JMP	SHORT	L_232
L_234:
;
; Line 527:	if (twnd->PrevMouse == wnd)	{
;
	MOV	EAX,DWORD [EDI+074H]
	CMP	EAX,ESI
	JNE	SHORT	L_235
;
; Line 528:	twnd->PrevMouse = wnd->PrevMouse;
;
	MOV	EAX,DWORD [ESI+074H]
	MOV	DWORD [EDI+074H],EAX
;
; Line 529:	break;
;
	JMP	SHORT	L_233
L_235:
;
; Line 531:	twnd = twnd->PrevMouse;
;
	MOV	EDI,DWORD [EDI+074H]
L_232:
;
; Line 526:	while (twnd != NULL)	{
;
	MOV	EAX,EDI
	TEST	EAX,EAX
	JNE	SHORT	L_234
L_233:
;
; Line 533:	if (twnd == NULL)
;
	MOV	EAX,EDI
	TEST	EAX,EAX
	JNE	SHORT	L_237
;
; Line 534:	CaptureMouse = NULL;
;
	MOV	DWORD [_CaptureMouse],00H
L_237:
L_230:
;
; Line 536:	wnd->PrevMouse = NULL;
;
	MOV	DWORD [ESI+074H],00H
	JMP	SHORT	L_228
L_227:
;
; Line 539:	CaptureMouse = NULL;
;
	MOV	DWORD [_CaptureMouse],00H
L_228:
;
; Line 540:	NoChildCaptureMouse = FALSE;
;
	MOV	DWORD [_NoChildCaptureMouse],00H
;
; Line 541:	break;
;
	JMP	SHORT	L_147
L_148:
;
; Line 543:	break;
;
	JMP	SHORT	L_147
L_147:
L_145:
;
; Line 546:	return rtn;
;
	MOV	EAX,DWORD [EBP-0CH]
L_121:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 549:	static RECT VisibleRect(WINDOW wnd)
;
_VisibleRect:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 024H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	EDI,[EBP-010H]
	LEA	EBX,[EBP-024H]
L_240:
;
; Line 550:	{
;
;
; Line 551:	RECT rc = WindowRect(wnd);
;
	MOV	EAX,DWORD [EBP+0CH]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+0CH]
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
;
; Line 552:	if (!TestAttribute(wnd, NOCLIP))	{
;
	MOV	EAX,DWORD [EBP+0CH]
	MOV	EAX,DWORD [EAX+054H]
	AND	EAX,0800H
	JNE	SHORT	L_241
;
; Line 553:	WINDOW pwnd = GetParent(wnd);
;
	MOV	EAX,DWORD [EBP+0CH]
	MOV	ESI,DWORD [EAX+03CH]
;
; Line 555:	prc = ClientRect(pwnd);
;
	PUSH	ESI
	PUSH	EBX
	CALL	_ClientRect
	ADD	ESP,BYTE 08H
	JMP	SHORT	L_243
L_245:
;
; Line 557:	if (TestAttribute(pwnd, NOCLIP))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0800H
	JNE	SHORT	L_244
;
; Line 558:	break;
;
L_246:
;
; Line 559:	rc = subRectangle(rc, prc);
;
	PUSH	DWORD [EBX+00H+0CH]
	PUSH	DWORD [EBX+00H+08H]
	PUSH	DWORD [EBX+00H+04H]
	PUSH	DWORD [EBX+00H+00H]
	PUSH	DWORD [EDI+00H+0CH]
	PUSH	DWORD [EDI+00H+08H]
	PUSH	DWORD [EDI+00H+04H]
	PUSH	DWORD [EDI+00H+00H]
	PUSH	EDI
	CALL	_subRectangle
	ADD	ESP,BYTE 024H
;
; Line 560:	if (!ValidRect(rc))
;
	MOV	EAX,DWORD [EDI+08H]
	TEST	EAX,EAX
	JNE	SHORT	L_248
	MOV	EAX,DWORD [EDI+00H]
	TEST	EAX,EAX
	JNE	SHORT	L_248
	MOV	EAX,DWORD [EDI+04H]
	TEST	EAX,EAX
	JNE	SHORT	L_248
	MOV	EAX,DWORD [EDI+0CH]
	TEST	EAX,EAX
	JE	SHORT	L_244
;
; Line 561:	break;
;
L_248:
;
; Line 562:	if ((pwnd = GetParent(pwnd)) != NULL)
;
	MOV	EAX,DWORD [ESI+03CH]
	MOV	ESI,EAX
	TEST	EAX,EAX
	JE	SHORT	L_250
;
; Line 563:	prc = ClientRect(pwnd);
;
	PUSH	ESI
	PUSH	EBX
	CALL	_ClientRect
	ADD	ESP,BYTE 08H
L_250:
L_243:
;
; Line 556:	while (pwnd != NULL)	{
;
	MOV	EAX,ESI
	TEST	EAX,EAX
	JNE	SHORT	L_245
L_244:
L_241:
;
; Line 566:	return rc;
;
	MOV	EAX,DWORD [EBP+08H]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EDI+00H]
	LEA	EDI,[EAX+00H]
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
	MOV	EAX,DWORD [EBP+08H]
L_239:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 570:	static WINDOW inWindow(WINDOW wnd, int x, int y)
;
_inWindow:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 020H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
L_253:
;
; Line 571:	{
;
;
; Line 572:	WINDOW Hit = NULL;
;
	MOV	EBX,00H
	JMP	SHORT	L_254
L_256:
;
; Line 574:	if (isVisible(wnd))	{
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_257
;
; Line 576:	RECT rc = VisibleRect(wnd);
;
	PUSH	ESI
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_VisibleRect
	ADD	ESP,BYTE 08H
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+00H]
	LEA	EDI,[EBP-020H]
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
;
; Line 577:	if (InsideRect(x, y, rc))
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,DWORD [EBP-020H]
	JL	SHORT	L_259
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,DWORD [EBP-018H]
	JG	SHORT	L_259
	MOV	EAX,DWORD [EBP+010H]
	CMP	EAX,DWORD [EBP-01CH]
	JL	SHORT	L_259
	MOV	EAX,DWORD [EBP+010H]
	CMP	EAX,DWORD [EBP-014H]
	JG	SHORT	L_259
;
; Line 578:	Hit = wnd;
;
	MOV	EBX,ESI
L_259:
;
; Line 579:	if ((wnd1 = inWindow(LastWindow(wnd), x, y)) != NULL)
;
	PUSH	DWORD [EBP+010H]
	PUSH	DWORD [EBP+0CH]
	PUSH	DWORD [ESI+044H]
	CALL	_inWindow
	ADD	ESP,BYTE 0CH
	MOV	EDI,EAX
	TEST	EAX,EAX
	JE	SHORT	L_261
;
; Line 580:	Hit = wnd1;
;
	MOV	EBX,EDI
L_261:
;
; Line 581:	if (Hit != NULL)
;
	MOV	EAX,EBX
	TEST	EAX,EAX
	JNE	SHORT	L_255
;
; Line 582:	break;
;
L_263:
L_257:
;
; Line 584:	wnd = PrevWindow(wnd);
;
	MOV	ESI,DWORD [ESI+04CH]
L_254:
;
; Line 573:	while (wnd != NULL)	{
;
	MOV	EAX,ESI
	TEST	EAX,EAX
	JNE	SHORT	L_256
L_255:
;
; Line 586:	return Hit;
;
	MOV	EAX,EBX
L_252:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 589:	static WINDOW MouseWindow(int x, int y)
;
_MouseWindow:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD _CaptureMouse
L_266:
;
; Line 590:	{
;
;
; Line 593:	WINDOW Mwnd = inWindow(ApplicationWindow, x, y);
;
	PUSH	DWORD [EBP+0CH]
	PUSH	DWORD [EBP+08H]
	PUSH	DWORD [_ApplicationWindow]
	CALL	_inWindow
	ADD	ESP,BYTE 0CH
	MOV	EBX,EAX
;
; Line 595:	if (CaptureMouse != NULL)	{
;
	MOV	EAX,DWORD [ESI+00H]
	TEST	EAX,EAX
	JE	SHORT	L_267
;
; Line 596:	if (NoChildCaptureMouse ||
;
	MOV	EAX,DWORD [_NoChildCaptureMouse]
	TEST	EAX,EAX
	JNE	SHORT	L_271
	MOV	EAX,EBX
	TEST	EAX,EAX
	JE	SHORT	L_271
	PUSH	DWORD [ESI+00H]
	PUSH	EBX
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JNE	SHORT	L_269
L_271:
;
; Line 599:	Mwnd = CaptureMouse;
;
	MOV	EBX,DWORD [ESI+00H]
L_269:
L_267:
;
; Line 601:	return Mwnd;
;
	MOV	EAX,EBX
L_265:
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_handshake]
;
; Line 604:	void handshake(void)
;
_handshake:
	PUSH	EBP
	MOV	EBP,ESP
L_273:
;
; Line 605:	{
;
;
; Line 606:	handshaking++;
;
	INC	DWORD [_handshaking]
;
; Line 607:	dispatch_message();
;
	CALL	_dispatch_message
;
; Line 608:	--handshaking;
;
	DEC	DWORD [_handshaking]
;
; Line 609:	}
;
L_272:
	POP	EBP
	RET
[GLOBAL	_dispatch_message]
;
; Line 612:	BOOL dispatch_message(void)
;
_dispatch_message:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 018H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBP-014H]
	MOV	EDI,DWORD _MsgQueueOffCtr
L_275:
;
; Line 613:	{
;
;
; Line 616:	collect_events();
;
	CALL	_collect_events
	JMP	NEAR	L_276
L_278:
;
; Line 621:	ev = EventQueue[EventQueueOffCtr];
;
	MOV	EAX,DWORD [_EventQueueOffCtr]
	IMUL	EAX,BYTE 0CH
	MOV	ECX,DWORD [EAX+00H+_EventQueue]
	MOV	DWORD [ESI+00H],ECX
	MOV	ECX,DWORD [EAX+00H+_EventQueue+04H]
	MOV	DWORD [ESI+00H+04H],ECX
	MOV	ECX,DWORD [EAX+00H+_EventQueue+04H+04H]
	MOV	DWORD [ESI+00H+04H+04H],ECX
;
; Line 622:	if (++EventQueueOffCtr == MAXMESSAGES)
;
	INC	DWORD [_EventQueueOffCtr]
	MOV	EAX,DWORD [_EventQueueOffCtr]
	CMP	EAX,BYTE 064H
	JNE	SHORT	L_279
;
; Line 623:	EventQueueOffCtr = 0;
;
	MOV	DWORD [_EventQueueOffCtr],00H
L_279:
;
; Line 624:	--EventQueueCtr;
;
	DEC	DWORD [_EventQueueCtr]
;
; Line 628:	Kwnd = inFocus;
;
	MOV	EAX,DWORD [_inFocus]
	MOV	DWORD [EBP-04H],EAX
;
; Line 631:	if (CaptureKeyboard != NULL)
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	TEST	EAX,EAX
	JE	SHORT	L_281
;
; Line 632:	if (Kwnd == NULL ||
;
	MOV	EAX,DWORD [EBP-04H]
	TEST	EAX,EAX
	JE	SHORT	L_285
	MOV	EAX,DWORD [_NoChildCaptureKeyboard]
	TEST	EAX,EAX
	JNE	SHORT	L_285
	PUSH	DWORD [_CaptureKeyboard]
	PUSH	DWORD [EBP-04H]
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JNE	SHORT	L_283
L_285:
;
; Line 635:	Kwnd = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [EBP-04H],EAX
L_283:
L_281:
;
; Line 639:	switch (ev.event)    {
;
	MOV	EAX,DWORD [ESI+00H]
	CMP	EAX,BYTE 022H
	JE	SHORT	L_290
	JA	SHORT	L_296
	CMP	EAX,BYTE 01CH
	JE	SHORT	L_288
	JA	SHORT	L_297
	CMP	EAX,BYTE 013H
	JE	SHORT	L_289
	JA	NEAR	L_287
	CMP	EAX,BYTE 010H
	JE	NEAR	L_295
	JMP	NEAR	L_287
L_297:
	CMP	EAX,BYTE 021H
	JE	NEAR	L_293
	JMP	NEAR	L_287
L_296:
	CMP	EAX,BYTE 024H
	JE	NEAR	L_294
	JA	SHORT	L_298
	CMP	EAX,BYTE 023H
	JE	NEAR	L_292
	JMP	NEAR	L_287
L_298:
	CMP	EAX,BYTE 025H
	JE	NEAR	L_291
	JMP	NEAR	L_287
L_288:
;
; Line 641:	case KEYBOARD:
;
L_289:
;
; Line 642:	if (!handshaking)
;
	MOV	EAX,DWORD [_handshaking]
	TEST	EAX,EAX
	JNE	SHORT	L_299
;
; Line 643:	SendMessage(Kwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [ESI+08H]
	PUSH	DWORD [ESI+04H]
	MOVSX	EAX,WORD [ESI+00H]
	PUSH	EAX
	PUSH	DWORD [EBP-04H]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_299:
;
; Line 644:	break;
;
	JMP	NEAR	L_286
L_290:
;
; Line 646:	if (!handshaking)	{
;
	MOV	EAX,DWORD [_handshaking]
	TEST	EAX,EAX
	JNE	SHORT	L_301
;
; Line 647:	Mwnd = MouseWindow(ev.mx, ev.my);
;
	PUSH	DWORD [ESI+08H]
	PUSH	DWORD [ESI+04H]
	CALL	_MouseWindow
	ADD	ESP,BYTE 08H
	MOV	EBX,EAX
;
; Line 648:	if (!CaptureMouse ||
;
	MOV	EAX,DWORD [_CaptureMouse]
	TEST	EAX,EAX
	JE	SHORT	L_305
	MOV	EAX,DWORD [_NoChildCaptureMouse]
	TEST	EAX,EAX
	JNE	SHORT	L_303
	PUSH	DWORD [_CaptureMouse]
	PUSH	EBX
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JE	SHORT	L_303
L_305:
;
; Line 651:	if (Mwnd != inFocus)
;
	MOV	EAX,EBX
	CMP	EAX,DWORD [_inFocus]
	JE	SHORT	L_306
;
; Line 652:	SendMessage(Mwnd, SETFOCUS, TRUE, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 01H
	PUSH	BYTE 08H
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_306:
L_303:
;
; Line 653:	SendMessage(Mwnd, LEFT_BUTTON, ev.mx, ev.my);
;
	PUSH	DWORD [ESI+08H]
	PUSH	DWORD [ESI+04H]
	PUSH	BYTE 022H
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_301:
;
; Line 655:	break;
;
	JMP	SHORT	L_286
L_291:
;
; Line 657:	case DOUBLE_CLICK:
;
L_292:
;
; Line 658:	case RIGHT_BUTTON:
;
L_293:
;
; Line 659:	if (handshaking)
;
	MOV	EAX,DWORD [_handshaking]
	TEST	EAX,EAX
	JNE	SHORT	L_286
;
; Line 660:	break;
;
L_308:
;
; Line 661:	case MOUSE_MOVED:
;
L_294:
;
; Line 662:	Mwnd = MouseWindow(ev.mx, ev.my);
;
	PUSH	DWORD [ESI+08H]
	PUSH	DWORD [ESI+04H]
	CALL	_MouseWindow
	ADD	ESP,BYTE 08H
	MOV	EBX,EAX
;
; Line 663:	SendMessage(Mwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [ESI+08H]
	PUSH	DWORD [ESI+04H]
	MOVSX	EAX,WORD [ESI+00H]
	PUSH	EAX
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 664:	break;
;
	JMP	SHORT	L_286
L_295:
;
; Line 666:	SendMessage(Cwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [ESI+08H]
	PUSH	DWORD [ESI+04H]
	MOVSX	EAX,WORD [ESI+00H]
	PUSH	EAX
	PUSH	DWORD [_Cwnd]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 667:	break;
;
	JMP	SHORT	L_286
L_287:
;
; Line 669:	break;
;
	JMP	SHORT	L_286
L_286:
L_276:
;
; Line 618:	while (EventQueueCtr > 0)  {
;
	MOV	EAX,DWORD [_EventQueueCtr]
	TEST	EAX,EAX
	JG	NEAR	L_278
L_277:
	JMP	SHORT	L_310
L_312:
;
; Line 676:	mq = MsgQueue[MsgQueueOffCtr];
;
	MOV	EAX,DWORD [EDI+00H]
	SHL	EAX,04H
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+00H+_MsgQueue]
	LEA	EDI,[EBP-018H]
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
;
; Line 677:	if (++MsgQueueOffCtr == MAXMESSAGES)
;
	INC	DWORD [EDI+00H]
	MOV	EAX,DWORD [EDI+00H]
	CMP	EAX,BYTE 064H
	JNE	SHORT	L_313
;
; Line 678:	MsgQueueOffCtr = 0;
;
	MOV	DWORD [EDI+00H],00H
L_313:
;
; Line 679:	--MsgQueueCtr;
;
	DEC	DWORD [_MsgQueueCtr]
;
; Line 680:	SendMessage(mq.wnd, mq.msg, mq.p1, mq.p2);
;
	PUSH	DWORD [EBP-0CH]
	PUSH	DWORD [EBP-010H]
	MOVSX	EAX,WORD [EBP-014H]
	PUSH	EAX
	PUSH	DWORD [EBP-018H]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 681:	if (mq.msg == ENDDIALOG)
;
	MOV	EAX,DWORD [EBP-014H]
	CMP	EAX,BYTE 049H
	JNE	SHORT	L_315
;
; Line 682:	return FALSE;
;
	MOV	EAX,00H
	JMP	SHORT	L_274
L_315:
;
; Line 683:	if (mq.msg == STOP)	{
;
	MOV	EAX,DWORD [EBP-014H]
	CMP	EAX,BYTE 01H
	JNE	SHORT	L_317
;
; Line 684:	PostMessage(NULL, STOP, 0, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 01H
	PUSH	BYTE 00H
	CALL	_PostMessage
	ADD	ESP,BYTE 010H
;
; Line 685:	return FALSE;
;
	MOV	EAX,00H
	JMP	SHORT	L_274
L_317:
L_310:
;
; Line 673:	while (MsgQueueCtr > 0)  {
;
	MOV	EAX,DWORD [_MsgQueueCtr]
	TEST	EAX,EAX
	JG	SHORT	L_312
L_311:
;
; Line 688:	return TRUE;
;
	MOV	EAX,01H
L_274:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
SECTION _STRING
L_49:
	DB	061H,06DH,020H,00H
L_48:
	DB	070H,06DH,020H,00H
L_47:
	DB	025H,032H,064H,03AH,025H,030H,032H,064H,00H
L_15:
	DB	020H,043H,061H,06EH,063H,065H,06CH,020H,00H
L_14:
	DB	020H,020H,020H,04FH,04BH,020H,020H,020H,00H
L_13:
	DB	045H,072H,072H,06FH,072H,00H
SECTION _DATA

_px	DD	0FFFFFFFFH

_py	DD	0FFFFFFFFH

_pmx	DD	0FFFFFFFFH

_pmy	DD	0FFFFFFFFH

_handshaking	DD	00H
[GLOBAL	_AllocTesting]

_AllocTesting	DD	00H
[GLOBAL	_AltDown]

_AltDown	DD	00H

_lagdelay	DD	07H

_doubletimer	DD	0FFFFFFFFH

_delaytimer	DD	0FFFFFFFFH

_clocktimer	DD	0FFFFFFFFH
[GLOBAL	_time_string]

_time_string	DB	020H,020H,020H,020H,020H,020H,020H,020H,020H,00H

_ermsg	DB	045H,072H,072H,06FH,072H,020H,061H,063H,063H,065H,073H,073H
	DB	069H,06EH,067H,020H,064H,072H,069H,076H,065H,020H,078H,00H
	RESB	02H

L_45	DD	00H

L_46	DD	00H

L_50	DD	010B9H,010CFH,010D0H,010D1H,010CBH
	DD	035H,010CDH,010C7H,010C8H,010C9H
SECTION _BSS

_mx	RESB	04H

_my	RESB	04H

_CriticalError	RESB	04H

_timerMemhand	RESB	04H

_dsSel	RESB	02H

_oldss	RESB	02H

_oldsp	RESB	04H

_hasints	RESB	04H

_timerLast	RESB	06H

_keyboardLast	RESB	06H

_stackbot	RESB	04H
[GLOBAL	_AllocError]

_AllocError	RESB	028H

_EventQueue	RESB	04B0H

_MsgQueue	RESB	0640H

_EventQueueOnCtr	RESB	04H

_EventQueueOffCtr	RESB	04H

_EventQueueCtr	RESB	04H

_MsgQueueOnCtr	RESB	04H

_MsgQueueOffCtr	RESB	04H

_MsgQueueCtr	RESB	04H

_keyportvalue	RESB	04H
[GLOBAL	_CaptureMouse]

_CaptureMouse	RESB	04H
[GLOBAL	_CaptureKeyboard]

_CaptureKeyboard	RESB	04H

_NoChildCaptureMouse	RESB	04H

_NoChildCaptureKeyboard	RESB	04H

_Cwnd	RESB	04H
SECTION _CONST

SECTION _TEXT
[EXTERN	_sprintf]
[EXTERN	_ConsoleInit]
[EXTERN	_ErrorBoxProc]
[EXTERN	_time]
[EXTERN	_GenericMessage]
[EXTERN	_ClientRect]
[EXTERN	_show_mousecursor]
[EXTERN	_unhidecursor]
[EXTERN	_inFocus]
[EXTERN	_set_mouseposition]
[EXTERN	_dpmi_set_protected_interrupt]
[EXTERN	_isVisible]
[EXTERN	_dpmi_get_sel_base]
[EXTERN	_hide_mousecursor]
[EXTERN	_mousebuttons]
[EXTERN	_restorecursor]
[EXTERN	_isEGA]
[EXTERN	_localtime]
[EXTERN	_kbhit]
[EXTERN	_hidecursor]
[EXTERN	_set_cursor_type]
[EXTERN	_set_mousetravel]
[EXTERN	_isAncestor]
[EXTERN	_setjmp]
[EXTERN	_normalcursor]
[EXTERN	_isVGA]
[EXTERN	_cursor]
[EXTERN	_ApplicationWindow]
[EXTERN	_getkey]
[EXTERN	_curr_cursor]
[EXTERN	_ClearDialogBoxes]
[EXTERN	_resetmouse]
[EXTERN	_getshift]
[EXTERN	_ClearClipboard]
[EXTERN	_subRectangle]
[EXTERN	_inp]
[EXTERN	_get_mouseposition]
[EXTERN	___seg0040]
[EXTERN	_mouse_installed]
[EXTERN	_ConsoleRundown]
[EXTERN	_button_releases]
[EXTERN	_dpmi_get_memory]
[EXTERN	_savecursor]
[EXTERN	_dpmi_get_protected_interrupt]
[EXTERN	_dpmi_free_memory]
[EXTERN	_strcpy]
