/*
	Software License Agreement (BSD License)
	
	Copyright (c) 1997-2008, David Lindauer, (LADSoft).
	All rights reserved.
	
	Redistribution and use of this software in source and binary forms, with or without modification, are
	permitted provided that the following conditions are met:
	
	* Redistributions of source code must retain the above
	  copyright notice, this list of conditions and the
	  following disclaimer.
	
	* Redistributions in binary form must reproduce the above
	  copyright notice, this list of conditions and the
	  following disclaimer in the documentation and/or other
	  materials provided with the distribution.
	
	* Neither the name of LADSoft nor the names of its
	  contributors may be used to endorse or promote products
	  derived from this software without specific prior
	  written permission of LADSoft.
	
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifdef win32
#include <windows.h>
#else
typedef long	LONG ;
#define	PASCAL _stdcall
typedef void * PEXCEPTION_RECORD, * PCONTEXT ;
#endif
#include "_rtti.h"

#define OUR_CPP_EXC_CODE 0xEEFABCD

extern void *_xceptblockchain ;

void __call_terminate() ;
LONG ___xceptionhandle(PEXCEPTION_RECORD p, void *record, PCONTEXT context, void *param) ;

#ifdef win32
#pragma startup initCPPxcept 255

void __global_unwind(PEXCEPTION_POINTERS p, void *record) ;

extern LONG (* ___cppxcept)(PEXCEPTION_RECORD p, void *record , CONTEXT *context, void *param ) ;

LONG ___cppxceptionhandle(PEXCEPTION_RECORD p, void *record, PCONTEXT context, void *param)
{
	if (p->ExceptionCode == OUR_CPP_EXC_CODE) {
#ifdef win32
		__global_unwind(p,record) ;
#endif
		__call_terminate() ;
	}
	return 1 ; // continue search
}
static void initCPPxcept()
{
	___cppxcept = ___cppxceptionhandle ;
}
#endif
void __raise_throw()
{
#ifdef win32
	RaiseException(OUR_CPP_EXC_CODE,EXCEPTION_NONCONTINUABLE,0,0) ;
#endif
}
void _InitExceptBlock()
{
   asm mov ecx,[eax+4]              // get offset of frame data XCEPTDATA struct
   asm add ecx,ebp
   asm mov edx,fs:[0]               // 0 = old xcept chain
   asm mov [ecx],edx
   asm mov edx,___xceptionhandle    // 4 = windows xception handle func
   asm mov [ecx+4],edx
   asm mov dword ptr [ecx+8],XC_SIG // 8 = signature
   asm mov dword ptr [ecx+12],0     // 12 = ESP of throw block, zero for now
   asm mov [ecx+16],ebp             // 16 = EBP of this func
   asm mov edx,[esp]                // 20 = EIP the offsets in the table are based from
   asm mov [ecx+20],edx              
   asm mov [ecx+24],eax             // 24 = pointer to the xception block
   asm mov dword ptr [ecx+28],0     // 28 = flags, mark no xcept in progress
                                    // there are more bytes but they are 
                                    // used by throw() and not initted here
   asm mov fs:[0],ecx
}

void _RundownExceptBlock()
{
   asm mov ecx,fs:[0]
   asm mov ecx,[ecx]
   asm mov fs:[0],ecx
}