;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   Compress                    ;
; Compress and store to the macro storage area  ;
; the source line in LINE, given LINE_SIZE and  ;
; SRC_SIZE.                                     ;
;===============================================;

Compress Proc Near
 Mov Di,Mac_Point       ;macro pointer
 Cmp Di,Mac_Size        ;check if enough room
 Jbe Compms             ;jump if so

;----- out of memory for macro definition

 Mov Bx,Mac_Size        ;memory available
 Mov Ax,828ch           ;error 140
 Call Error             ;error routine, critical error (no return)

;----- start compress

Compms Mov Cx,Src_Size  ;bytes in line
 Or Cx,Cx               ;check if zero
 Jnz Compnonn           ;jump if not

;----- store nul line

 Push Es
 Mov Es,Mac_Seg         ;macro segment
 Mov Ax,Cx
 Stosw                  ;uncommented line length
 Stosw                  ;stored line length
 Pop Es
 Mov Mac_Point,Di       ;save pointer
 Ret

;----- store non-nul line

Compnonn Push Es
 Sub Bp,Bp              ;BP counts stored bytes
 Mov Si,Line            ;location
 Mov Es,Mac_Seg         ;macro segement

 Mov Ax,Line_Size       ;size with comment truncated
 Stosw                  ;store
 Mov Bx,Di              ;save line length location
 Inc Di
 Inc Di                 ;skip two bytes for stored length

 Sub Dl,Dl              ;initial space count

;----- loop for each byte in line

Compmloop Lodsb         ;load next byte
 Cmp Al,' '             ;check if space
 Je Compnsp             ;jump if so

;----- non-space character, store any spaces before storing byte

 Or Dl,Dl               ;check if any spaces
 Jz Nocompspc           ;jump if none

 Push Ax
 Call Store_Cspc        ;store any spaces
 Pop Ax

Nocompspc Cmp Al,Spc_Mark ;check if special marker byte
 Je Compspm             ;jump if so
 Stosb                  ;store
 Inc Bp                 ;another byte in
 Loop Compmloop         ;loop back for each character

 Seg Es
 Mov [Bx],Bp            ;save bytes in line
 Mov Mac_Point,Di       ;save pointer
 Pop Es
 Ret

;----- special marker byte, store as zero spaces

Compspm Stosb           ;store
 Sub Al,Al              ;zero
 Stosb                  ;store
 Inc Bp
 Inc Bp                 ;update bytes in line
 Loop Compmloop         ;loop back for each character

 Seg Es
 Mov [Bx],Bp            ;save bytes in line
 Mov Mac_Point,Di       ;save pointer
 Pop Es
 Ret

;----- space

Compnsp Cmp Dl,0ffh     ;check if max number of spaces
 Jne Nospcmax           ;jump if not
 Call Store_Cspc        ;store present spaces first

Nospcmax Inc Dl         ;add another space
 Loop Compmloop         ;loop back for each character

 Call Store_Cspc        ;store remaining spaces
 Seg Es
 Mov [Bx],Bp            ;save bytes in line
 Mov Mac_Point,Di       ;save pointer
 Pop Es
 Ret
 Endp                   ;Compress

;===============================================;
;                   Store_Cspc                  ;
; Store DL number of compressed spaces to       ;
; ES:DI. Note: DL better not equal zero.        ;
;===============================================;

Store_Cspc Proc Near
 Cmp Dl,1               ;check if only one
 Jz Stcson              ;jump if so

;----- more than two spaces

 Mov Al,Spc_Mark        ;compressed space mark
 Stosb                  ;store
 Mov Al,Dl              ;number of spaces
 Stosb                  ;store
 Inc Bp
 Inc Bp                 ;update bytes in line
 Sub Dl,Dl              ;reset space count
 Ret

;----- one space

Stcson Mov Al,' '       ;space
 Stosb                  ;store
 Sub Dl,Dl              ;clear number of spaces
 Inc Bp                 ;update bytes in line
 Ret
 Endp                   ;Store_Cspc

;===============================================;
;                   Uncompress                  ;
; Extract and uncompress macro line from the    ;
; macro storage area and put in LINE and set    ;
; LINE_SIZE and SRC_SIZE. Carry is set if line  ;
; not returned (end of macro).                  ;
;===============================================;

Uncompress Proc Near
 Mov Si,Mac_Loc         ;present read location
 Cmp Si,Mac_End         ;compare to end of macro
 Je Uncompend           ;jump if so

 Push Ds
 Mov Ds,Mac_Seg         ;macro segment
 Lodsw                  ;load line length without comment
 Mov Dx,Ax
 Lodsw                  ;load stored line length (bytes stored)
 Pop Ds

 Mov Line_Size,Dx       ;stored line length
 Or Ax,Ax               ;check if nul
 Jz Unconull            ;jump if so

 Sub Bp,Bp              ;counts bytes in uncompressed line
 Mov Cx,Ax
 Mov Di,Line            ;load line location

 Push Ds
 Mov Ds,Mac_Seg         ;macro segment

;----- loop for each line byte

Uncomloop Lodsb         ;load next byte
 Cmp Al,Spc_Mark        ;check if space mark
 Je Uncospc             ;jump if so
 Stosb                  ;store
 Inc Bp                 ;update bytes in line
 Loop Uncomloop         ;loop for each byte

 Pop Ds
 Mov Src_Size,Bp        ;save bytes in line
 Mov Mac_Loc,Si         ;save macro pointer
 Clc
 Ret

;----- space mark

Uncospc Dec Cx          ;decrement for mask byte
 Lodsb                  ;load length byte
 Or Al,Al               ;check if zero
 Jz Uncozspc            ;jump if so

;----- store some number of spaces

 Push Cx
 Mov Cl,Al
 Sub Ch,Ch              ;CX gets spaces to add
 Add Bp,Cx              ;update number of bytes in line
 Mov Al,' '             ;space

 Rep
 Stosb                  ;store spaces
 Pop Cx
 Loop Uncomloop         ;loop for each byte

 Pop Ds
 Mov Src_Size,Bp        ;save bytes in line
 Mov Mac_Loc,Si         ;save macro pointer
 Clc
 Ret

;----- zero bytes, special character itself

Uncozspc Mov Al,Spc_Mark ;make special mark
 Stosb                  ;store
 Inc Bp                 ;update bytes in line
 Loop Uncomloop         ;loop for each byte

 Pop Ds
 Mov Src_Size,Bp        ;save bytes in line
 Mov Mac_Loc,Si         ;save macro pointer
 Clc
 Ret

;----- nul line

Unconull Mov Src_Size,Ax ;set to zero
 Mov Mac_Loc,Si         ;save macro pointer
 Clc
 Ret

;----- end of macro

Uncompend Stc
 Ret
 Endp                   ;Uncompress

