;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   Get_Ffield                  ;
; Get the next file field from the source       ;
; line. The field is put in TEMPBUFF. The       ;
; first byte is the field length. ZF=1 if no    ;
; field returned. Only spaces, control          ;
; characters, and commas are treated as         ;
; delimiters. If a comma is found first a nul   ;
; field is returned. A space or comma is        ;
; assumed to  end the field. Is used for        ;
; getting file names from the command line.     ;
;===============================================;

Get_Ffield Proc Near
 Mov Cx,Line_Rem        ;remaining line
 Mov Si,Line_Point      ;line pointer
 Call Skip_Space        ;skip spaces and control chars
 Jz Gffzero             ;jump if empty line

;----- load field

 Mov Di,Tempbuff        ;location to store
 Inc Di                 ;room for length
 Mov Bx,Cx              ;save number in BX
 Mov Dl,' '             ;space
 Mov Dh,','             ;comma

;----- loop until end of line or delimiter

Gffcharl Lodsb          ;load character
 Cmp Al,Dh              ;check if comma
 Je Gffend              ;jump if so
 Cmp Al,Dl              ;check if space or lower
 Jbe Gffend             ;jump if so
 Stosb                  ;store character
 Loop Gffcharl          ;loop for next character

;----- finished, store field length and update line data

Gffend Sub Bx,Cx        ;field length
 Mov Di,Tempbuff        ;beginning of buffer
 Mov [Di],Bl            ;store field length

 Or Cx,Cx               ;check if ran out of characters
 Jz Gfflinz             ;jump if so
 Dec Cx                 ;reduce for final delimiter
Gfflinz Mov Line_Rem,Cx ;save remaining line

 Mov Line_Point,Si      ;save line pointer
 Or Bl,Bl               ;set zero flag
 Ret

;----- field not found

Gffzero Mov Line_Rem,Cx ;no line remaining
 Mov Di,Tempbuff        ;location to store
 Sub Al,Al              ;clear AL, and set zero flag
 Mov [Di],Al            ;zero field length
 Ret
 Endp                   ;Get_Ffield

;===============================================;
;                   Get_Field                   ;
; Get the next field from the source line. The  ;
; field is put in TEMPBUFF. The first byte is   ;
; the field length. ZF=1 if no field returned.  ;
; Only spaces and control characters are        ;
; treated as delimiters. Is used for getting    ;
; label and mneumonic fields (not operands).    ;
;===============================================;

Get_Field Proc Near
 Mov Cx,Line_Rem        ;remaining line
 Mov Si,Line_Point      ;line pointer
 Call Skip_Space        ;skip spaces and control chars
 Jz Gfzero              ;jump if empty line

;----- load field

 Mov Di,Tempbuff        ;location to store
 Inc Di                 ;room for length
 Mov Bx,Cx              ;save number in BX
 Mov Dl,' '             ;look for space or control

;----- loop until end of line or delimiter

Fldcharl Lodsb          ;load character
 Cmp Al,Dl              ;check if space or lower
 Jbe Fldend             ;jump if so
 Stosb                  ;store character
 Loop Fldcharl          ;loop for next character

;----- end of field, store field length

Fldend Sub Bx,Cx        ;field length
 Mov Di,Tempbuff        ;beginning of buffer
 Mov [Di],Bl            ;store field length

;----- finished

 Dec Si                 ;last delimiter not skipped
 Mov Line_Rem,Cx        ;save remaining line
 Mov Line_Point,Si      ;save line pointer
 Or Bl,Bl               ;set zero flag
 Ret

;----- field not found

Gfzero Mov Line_Rem,Cx  ;no line remaining
 Mov Di,Tempbuff        ;location to store
 Sub Al,Al              ;clear AL, and set zero flag
 Mov [Di],Al            ;zero field length
 Ret
 Endp                   ;Get_Field

;===============================================;
;                   Skip_Field                  ;
; Skip the next field. Like GET_FIELD, but      ;
; does't save the field. No flags or anything   ;
; are set.                                      ;
;===============================================;

Skip_Field Proc Near
 Mov Cx,Line_Rem        ;remaining line
 Mov Si,Line_Point      ;line pointer
 Call Skip_Space        ;skip spaces and control chars
 Jz Sfzero              ;jump if nul

;----- load normal field

 Mov Bx,Cx              ;save number in BX
 Mov Dl,' '             ;look for space or control

;----- loop until end of line or delimiter

Flscharl Lodsb          ;load character
 Cmp Al,Dl              ;check if space or lower
 Jbe Flsend             ;jump if so
 Loop Flscharl          ;loop for next character

;----- end of field, finished

Flsend Dec Si           ;last delimiter not skipped
 Mov Line_Rem,Cx        ;save remaining line
 Mov Line_Point,Si      ;save line pointer
 Ret

;----- field not found

Sfzero Mov Line_Rem,Cx  ;no line remaining
 Ret
 Endp                   ;Skip_Field

;===============================================;
;                   Get_Mfield                  ;
; Get the next macro field from the source      ;
; line. The field is put in MAC_BUFF. The       ;
; carry is set if end of line and no field      ;
; returned. Commas are used to delimit the      ;
; fields, all other characters are included in  ;
; the field.                                    ;
;===============================================;

Get_Mfield Proc Near
 Mov Mfspace,False      ;do not store initial space
 And Oprnd_Stat,Not Oprnd_End ;not end of operand, only bit used
 Mov Di,Mac_Buff        ;storage
 Inc Di

;-----initial call to check for end of line

 Push Di
 Call Get_Oprnd         ;get next field
 Pop Di
 Jc Gmfdelim            ;jump if special delimiter
 Jz Gmfldone            ;jump if end of line
 Jmps Gmfcont

;----- loop until end of line or comma

Gmfloop Push Di
 Call Get_Oprnd         ;get next field
 Pop Di
 Jc Gmfdelim            ;jump if special delimiter
 Jz Gmfdone             ;jump if end of line

;----- store normal field

Gmfcont Cmp Mfspace,True ;check if store space
 Jne Gmfcontns          ;jump if not
 Mov Al,' '             ;seperator
 Stosb                  ;store

Gmfcontns Mov Si,Tempbuff ;field location
 Mov Dl,[Si+1]          ;save first character
 Store_Str              ;move string

 Mov Mfspace,True       ;store space
 Cmp Dl,Str_Delim       ;check if string delimiter
 Jne Gmfloop            ;jump if not
 Mov Al,Dl
 Stosb                  ;store delimiter to close string
 Jmps Gmfloop

;----- special delimiter

Gmfdelim Cmp Al,','     ;check if comma
 Je Gmfdone
 Stosb                  ;store
 Mov Mfspace,False      ;do not store space
 Jmps Gmfloop

;----- finished, not end of line

Gmfdone Mov Ax,Mac_Buff ;storage
 Sub Di,Ax
 Xchg Ax,Di
 Dec Ax
 Mov [Di],Al            ;store length
 Clc
 Ret

;----- end of line

Gmfldone Stc
 Ret

;----- data

Mfspace Db ?            ;flag for inserting a space
 Endp                   ;Get_Mfield

;===============================================;
;                   Get_Oprnd                   ;
; Get the next operand field from the source    ;
; line. The field is put in TEMPBUFF. The       ;
; first byte is the field length. ZF=1 if no    ;
; field returned. If OPRND_END=true, then a nul ;
; field is automatically returned. If the end   ;
; the line is reached, OPRND_END is             ;
; automatically set to true.                    ;
;                                               ;
; Strings (any characters enclosed by single    ;
; quotes) are returned with the first quote as  ;
; part of the field (including length).         ;
;                                               ;
; Spaces and all control characters are always  ;
; skipped.                                      ;
;                                               ;
; Special delimiters (operators) are: + - * /   ;
; \ = ( ) [ ] < > ,  If the carry is set, no    ;
; field is returned, but one of these operators ;
; are returned in AL. All delimiters terminate  ;
; the present field.                            ;
;===============================================;

Get_Oprnd Proc Near
 Test Oprnd_Stat,Oprnd_End ;check if at end of operand
 Jnz Goautonul          ;jump if so

Getoprnd Mov Cx,Line_Rem ;remaining line
 Mov Temp_Rem,Cx        ;save for parameter check
 Mov Si,Line_Point      ;line pointer
 Mov Di,Tempbuff        ;location to store
 Inc Di                 ;room for length

;----- skip all preceding delimiters

 Call Skip_Space        ;skip spaces and control chars
 Jz Gonulfiel           ;jump if done, nul field

 Mov Fe_Start,Si        ;save start of field
 Mov Bx,Cx              ;save number in BX
 Cmp Al,','             ;check if comma
 Je Gospeccha           ;jump if so
 Call Delim_Char        ;check if special delimiter
 Je Gospeccha           ;jump if so
 Cmp Al,Str_Delim       ;check if string
 Je Gostring            ;jump if so

 Mov Dh,','             ;comma
 Mov Dl,' '             ;space or control
 Jmps Goskista          ;skip over delimiter check (just checked)

;----- end of operand, automatically return nul

Goautonul Mov Di,Tempbuff ;location to store
 Sub Al,Al              ;clear AL, and set zero flag
 Mov [Di],Al            ;zero field length

 Mov Ax,Fe_Start
 Mov Fe_Stop,Ax         ;nul field
 Clc
 Ret

;----- field not found, end of line

Gonulfiel
 Or Oprnd_Stat,Oprnd_End ;end of operand
 Mov Line_Rem,Cx        ;no line remaining
 Mov Di,Tempbuff        ;location to store
 Sub Al,Al              ;clear AL, and set zero flag
 Mov [Di],Al            ;zero field length

 Mov Ax,Fe_Start
 Mov Fe_Stop,Ax         ;nul field
 Clc
 Ret

;----- return special character

Gospeccha Dec Cx        ;bytes remaining
 Mov Line_Rem,Cx        ;save
 Inc Si                 ;line pointer
 Mov Line_Point,Si      ;save
 Mov Fe_Stop,Si         ;save end of field
 Stc
 Ret

;----- load normal field, loop until end of line or delimiter

Gonorloop Mov Al,[Si]   ;load byte
 Cmp Al,Dh              ;check if comma
 Je Gosetflen
 Cmp Al,Dl              ;check if space
 Jbe Gosetflen
 Call Delim_Char        ;check if special delimiter
 Je Gosetflen
 Cmp Al,Str_Delim       ;check if string delimiter
 Je Gosetflen

Goskista Inc Si         ;increment source pointer
 Stosb                  ;store character
 Loop Gonorloop         ;loop for next character
 Jmps Gosetflen

;----- load string field, loop until end of line or single quote

Gostring Movsb          ;store string character
 Dec Cx                 ;one less character
 Jz Gostrerr            ;jump if isolated quote
 Mov Dl,Str_Delim       ;string delimiter

Gostrloop Mov Al,[Si]   ;load character
 Cmp Al,Dl              ;check if string delimiter
 Je Goskipdel
 Inc Si                 ;increment source
 Stosb                  ;store character
 Loop Gostrloop         ;loop for next character

;----- string not closed, error

Gostrerr Mov Ax,0063h   ;error 99
 Call Error             ;error routine
 Jmps Gosetflen

;----- skip end of string delimiter

Goskipdel Dec Bx        ;adjust field length count
 Dec Cx                 ;bytes remaining
 Inc Si                 ;skip delimiter

;----- set field length

Gosetflen Sub Bx,Cx     ;field length
 Mov Di,Tempbuff        ;beginning of buffer
 Mov [Di],Bl            ;store field length

;----- finished

 Mov Line_Rem,Cx        ;save remaining line
 Mov Line_Point,Si      ;save line pointer
 Mov Fe_Stop,Si         ;save end of operand
 Test Mac_Stat,Mac_Flag ;check if in macro
 Jnz Gocheckmac         ;jump if so

Godone Or Bl,Bl         ;set ZF
 Clc
 Ret

;----- check if macro parameter

Gocheckmac Mov Ax,Temp_Rem ;get original amount remaining
 Cmp Ax,Mlin_Rem        ;check if past previous substitution
 Ja Godone              ;jump if not

 Push Bx
 Call Mpara_Look
 Pop Bx
 Jnc Godone             ;jump if not macro parameter
 Jmp Getoprnd           ;get operand now

;----- data

Temp_Rem Dw ?           ;storage for parameter pointer
 Endp                   ;Get_Oprnd

;===============================================;
;                   Skip_Space                  ;
; Skip all spaces and control characters up to  ;
; CX bytes starting at SI. SI returns pointing  ;
; to the first non-space or control character   ;
; and CX returns bytes remaining. ZF=1 if not   ;
; found (zero bytes remaining). AL returns the  ;
; character found (if one is found).            ;
;===============================================;

Skip_Space Proc Near
 Or Cx,Cx               ;check if done
 Jz Skipnon             ;jump if so

;----- loop through all characters until non-space/control

Sknext Cmp Byte [Si],' ' ;check if greater than space
 Ja Skipnon2            ;jump if so (non delimiter, and ZF<>1)
 Inc Si                 ;increment source
 Dec Cx                 ;one less byte
 Jnz Sknext             ;jump if some remaining
Skipnon Ret

;----- something other than a space or control character

Skipnon2 Mov Al,[Si]    ;load byte
 Ret
 Endp                   ;Skip_Space

;===============================================;
;                  Delim_Char                   ;
; Check if character in AL is a special         ;
; delimiter. ZF=1 if so. Note that the comma    ;
; is not checked for. Is checked for            ;
; externally due to its frequency.              ;
;===============================================;

Delim_Char Proc Near
 Cmp Al,'['             ;check if left bracket
 Je Delimfound
 Cmp Al,']'             ;check if right bracket
 Je Delimfound
 Cmp Al,'+'             ;check if plus
 Je Delimfound
 Cmp Al,'-'             ;check if minus
 Je Delimfound
 Cmp Al,'*'             ;check if times
 Je Delimfound
 Cmp Al,'/'             ;check if divide
 Je Delimfound
 Cmp Al,'\'             ;check if mod
 Je Delimfound
 Cmp Al,'('             ;check if left parenthesis
 Je Delimfound
 Cmp Al,')'             ;check if right parenthesis
 Je Delimfound
 Cmp Al,'='             ;check if equal
 Je Delimfound
 Cmp Al,'<'             ;check if less than
 Je Delimfound
 Cmp Al,'>'             ;check if greater than
 Je Delimfound
Delimfound Ret
 Endp                   ;Delim_Char

;===============================================;
;                  Mpara_Look                   ;
; Check if field in TEMPBUFF is a macro         ;
; parameter. If so the field is replaced in     ;
; the source line and the carry is set.         ;
;===============================================;

Mpara_Look Proc Near
 Mov Si,Tempbuff        ;field location
 Call Mac_Plabel        ;make parameter label
 Call Get_Sym           ;look up symbol
 Jnc Nompfou            ;jump if not found
 Test Ax,Marg           ;test if symbol is parameter
 Jnz Mplpara            ;jump if so

;----- not macro parameter

Nompfou Mov Si,Tempbuff ;field location
 Call Mac_Uplabel       ;fix
 Clc
 Ret

;----- macro parameter

Mplpara Push Bx
 Call Rem_Field         ;remove field
 Pop Ax

 Mov Bx,Ax
 Inc Ax                 ;minimum number of required parameters
 Cmp Ax,Omac_Num        ;compare to defined number
 Ja Mplnul              ;jump if none defined for it

 Shl Bx                 ;relative offset
 Add Bx,Omac_Table      ;absolute offset
 Mov Si,[Bx]            ;get parameter data location
 Call Ins_Field         ;insert source
 Jc Mparaerr            ;jump if line too long

Mplnul Stc
 Ret

;----- line too long

Mparaerr Mov Bx,Dx
 Mov Ax,0207h           ;error 7
 Call Error             ;error routine
 Stc
 Ret
 Endp                   ;Mpara_Look

;===============================================;
;                    Rem_Field                  ;
; Remove the last field from the source line.   ;
;===============================================;

Rem_Field Proc Near
 Mov Di,Fe_Start        ;start of operand
 Mov Line_Point,Di      ;new line pointer
 Mov Si,Fe_Stop         ;end of operand
 Mov Ax,Si
 Sub Ax,Di              ;number of bytes to remove
 Mov Dx,Src_Size        ;original size
 Sub Dx,Line_Size       ;extra remaining bytes
 Sub Line_Size,Ax       ;reduce source line length
 Sub Src_Size,Ax        ;reduce total line length
 Mov Cx,Line_Rem        ;remaining bytes in line
 Mov Mlin_Rem,Cx        ;set new parameter check pointer
 Add Cx,Dx              ;add in extra

 Rep
 Movsb                  ;remove field
 Ret
 Endp                   ;Rem_Field

;===============================================;
;                    Ins_Field                  ;
; Insert the field at SI into the source line   ;
; at LINE_POINT. Carry is set if resulting      ;
; line would be too long and DX returns the     ;
; amount its too long by.                       ;
;===============================================;

Ins_Field Proc Near
 Mov Al,[Si]            ;length
 Sub Ah,Ah
 Mov Dx,Ax

 Add Dx,Src_Size        ;new total bytes in line
 Cmp Dx,String_Siz-1    ;compare to approximate max length
 Ja Insferr             ;jump if line too long

;----- update line data

 Mov Cx,Src_Size        ;original size
 Sub Cx,Line_Size       ;extra remaining bytes

 Add Line_Size,Ax       ;update source line length
 Add Src_Size,Ax        ;update total line length
 Add Line_Rem,Ax        ;update remaining bytes

;----- shift remaining line to right

 Add Cx,Line_Rem        ;bytes to shift
 Add Ax,Cx

 Push Si
 Mov Di,Line_Point
 Push Di
 Mov Si,Di

 Add Di,Ax              ;byte past new end
 Dec Di                 ;new end byte
 Add Si,Cx              ;byte past present end
 Dec Si                 ;present end byte

 Pushf
 Std                    ;reverse direction
 Rep
 Movsb                  ;create space
 Popf

;----- insert string

 Pop Di
 Pop Si
 Store_Str              ;move string to insert
 Clc
 Ret

;----- line too long

Insferr Sub Dx,String_Siz-1 ;get size difference
 Stc
 Ret
 Endp                   ;Ins_Field

;===============================================;
;                   Read_Line                   ;
; Reads a complete line from the source file    ;
; or the macro data table into LINE. Line       ;
; feeds are used to delimit lines. The length   ;
; of the line is put into LINE_SIZE. Normal     ;
; source lines are converted to uppercase and   ;
; truncated after the semi-colon. Macro lines   ;
; are only uncompressed. Carry is set if file   ;
; is done and no line is returned.              ;
;===============================================;

Read_Line Proc Near
 Test Mac_Stat,Mac_Flag ;check if macro in progress
 Jnz Readmacl           ;jump if so, read macro line
 Test Input_Stat, Fil_Done ;check if end of file
 Jnz Rfiledone          ;jump if so
 Jmps Readnlin

;----- try to read macro line

Readmacl
 Call Uncompress        ;extract macro line
 Jc Rlmacoff            ;jump if done with macro
 Mov Ax,Line_Size
 Mov Line_Rem,Ax        ;set remaining line
 Mov Mlin_Rem,Ax        ;set bytes to check for macro parameters
 Mov Ax,Line
 Mov Line_Point,Ax      ;set line pointer
 Inc Line_Tot           ;total lines processed
 Clc
 Ret

;----- end of macro

Rlmacoff Call Pop_Mac   ;pop macro level
 Jmps Read_Line         ;get next line

;----- end of file

Rfiledone
 Test Input_Stat, Inc_Flag ;might be include
 Jnz Readlips           ;jump if is
 And Input_Stat, Not Fil_Done ;reset flag
 Stc
 Ret

Readlips
 Call Pop_Source        ;pop source level
 Jmps Read_Line

;----- read line from source file

Readnlin
 Push Ds
 Mov Di,Line            ;beginning of line
 Mov Si,Src_Point       ;location to start in buffer
 Mov Bx,Src_End         ;end of file or buffer
 Mov Cl,Line_Feed       ;line feed, ^J
 Mov Ch,File_Mark       ;eof, ^Z
 Mov Ds,Src_Seg         ;buffer segment

;----- loop until end of line or file

Lineloop Cmp Si,Bx      ;check if buffer end
 Je Readmore            ;end of buffer, try to read more

 Lodsb                  ;load buffer character
 Cmp Al,Cl              ;look for line feed
 Je Linedone            ;if LF line is done
 Cmp Al,Ch              ;check for ^Z
 Je Readdone            ;jump if file done
 Stosb                  ;put into line storage area
 Jmps Lineloop          ;loop until LF

;----- end of line found

Linedone
 Pop Ds
 Mov Src_Point,Si       ;save source buffer pointer

 Cmp Byte [Di-1], C_Return ;check if last character is carriage return, ^M
 Mov Ax, Di
 Sub Ax, Line           ;line length
 Jz Emplin              ;empty line if zero length

 Cmp Byte [Di-1], C_Return ;check if last character is carriage return, ^M
 Jne Linmiscr           ;jump if not
 Dec Ax                 ;remove CR
 Jz Emplin              ;jump if empty line

Linmiscr
 Mov Line_Size,Ax       ;store length
 Mov Src_Size,Ax        ;store length for line output

;----- line extracted, fix it

 Call Uppercase         ;make all upper case and cut off comment
 Mov Ax,Line_Size
 Mov Line_Rem,Ax        ;set remaining line
 Mov Ax,Line
 Mov Line_Point,Ax      ;set line pointer
 Inc Line_Num           ;increment number of source lines
 Inc Line_Tot           ;total lines processed
 Clc
 Ret

;----- empty line

Emplin
 Test Input_Stat, Fil_Done ;check if end of file
 Jnz Emnulline          ;jump if so

 Mov Line_Size,Ax       ;zero length
 Mov Src_Size,Ax        ;zero source
 Inc Line_Num           ;increment number of source lines
 Inc Line_Tot           ;total lines processed
 Clc
 Ret

;----- final empty line, not a real line

Emnulline
 Jmp Rfiledone          ;branch to finish routine

;----- read more into buffer

Readmore
 Seg Cs
 Test Input_Stat,Src_Flag ;does file have any left
 Jz Readdone            ;jump if end of file

 Pop Ds
 Push Bx
 Push Cx
 Call Read              ;read from source
 Mov Si,Src_Point       ;new source pointer
 Pop Cx
 Pop Bx

 Push Ds
 Mov Ds,Src_Seg         ;reset buffer segment
 Jmps Lineloop          ;continue line

;----- end of file while in line

Readdone
 Seg Cs
 Or Input_Stat,Fil_Done ;set done flag
 Jmps Linedone          ;finish line
 Endp                   ;Read_Line

;===============================================;
;                   Uppercase                   ;
; Makes all letters in LINE upper-case and      ;
; looks for comment. The line is truncated if   ;
; a comment is found. Strings are skipped.      ;
;===============================================;

Uppercase Proc Near
 Mov Dl,Com_Delim       ;comment delimiter
 Mov Dh,Str_Delim       ;string delimiter
 Mov Bl,'a'             ;lower limit
 Mov Bh,'z'             ;upper limit
 Mov Ah,'a'-'A'         ;conversion number
 Mov Bp,Line_Size       ;line size
 Mov Cx,Bp
 Mov Di,Line            ;line location
 Mov Si,Di

;----- line character loop, skips over non-lower case

Unextchar Lodsb         ;load character
 Cmp Al,Dl              ;check for comment delimiter
 Je Upccomm             ;jump if so
 Cmp Al,Dh              ;check for string delimiter
 Je Ustr                ;goto string loop
 Cmp Al,Bl              ;check if too small
 Jb Notlower            ;skip
 Cmp Al,Bh              ;check if too big
 Ja Notlower            ;skip
 Sub Al,Ah              ;must be lower, make upper

Notlower Stosb          ;put back into line
 Loop Unextchar         ;loop for next character
 Ret

;----- string skip, exit loop when matching quote is found

Usnextc Lodsb           ;load character
 Cmp Al,Dh              ;single quote?
 Je Notlower            ;return to character loop
Ustr Stosb              ;part of string, put back
 Loop Usnextc           ;loop for next char.
 Ret                    ;remaining line was string

;----- comment found, truncate line

Upccomm Sub Bp,Cx       ;calculate remaining characters
 Mov Line_Size,Bp       ;save bytes in line
 Ret
 Endp                   ;Uppercase

