;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   Code_Asm                    ;
; Code assembly. Updates location counter on    ;
; pass one and builds object code on pass two.  ;
; If the instruction is a pseudo-op, then the   ;
; pseudo-op is processed.                       ;
;===============================================;

Code_Asm Proc Near

;----- check for reverse operands

 Test Optype2,Rev_Ops   ;test reverse flag
 Jz Norops              ;jump if not set

;----- reverse type

 Mov Ax,Dtype
 Xchg Ax,Stype
 Mov Dtype,Ax

;----- reverse value

 Mov Ax,Dval
 Xchg Ax,Sval
 Mov Dval,Ax

;----- reverse size

 Mov Ax,Dsize
 Xchg Ax,Ssize
 Mov Dsize,Ax

;----- operation type

Norops Test Optype2,Pseuop ;compare to pseudo-op flag
 Jnz Pop                ;jump if psuedo op

;----- machine operation

 Cmp Pass,1             ;which pass
 Jne P2op               ;other routine on pass two
 Call Update_Lct        ;update location counter
 Ret

;----- update location counter and generation obj code

P2op Mov Di,Obj_Buffer  ;place to put obj code
 Call Build_Obj         ;update and generate
 Ret

;----- psuedo operation, check for LOC suppression

Pop Test Optype2,Loc_Sup ;check if suppress LOC
 Jz Nolocsupp           ;jump if not
 Test Line_Stat,Label_Flag ;check if label
 Jnz Nolocsupp          ;jump if so
 And Line_Stat,Not Loc_Flag ;clear location display

Nolocsupp Call Call_Pseu ;pseudo-op routine
 Ret
 Endp                   ;Code_Asm

;===============================================;
;                  Update_Lct                   ;
; Update location counter based on the          ;
; particular instruction.                       ;
;===============================================;

Update_Lct Proc Near
 Sub Cx,Cx              ;CX holds size

;----- op-code

 Inc Cx                 ;one byte for sure

;----- two byte op-code

 Mov Ax,Opval           ;operation value
 Or Ah,Ah               ;check second byte
 Jz Updat4              ;no extra
 Inc Cx

;----- preceding wait instruction

Updat4 Mov Ax,Optype2   ;operation flag
 Test Ax,Addwait        ;wait flag
 Jz Updat1              ;skip if not
 Inc Cx

;----- branch for addressing mode

Updat1 Test Ax,Bit1     ;test bit 1
 Jz Updat5              ;##0 on jump
 Test Ax,Bit2           ;test bit 2
 Jz Updat12             ;#01 on jump
 Jmps Updat7            ;#11 mode byte address

;----- #01 is known

Updat12 Test Ax,Bit3    ;test bit 3
 Jz Updat9              ;001 reg field
 Jmps Updat11           ;101 direct address

;----- ##0 is known

Updat5 Test Ax,Bit2     ;test bit 2
 Jz Updat6              ;#00 on jump
 Jmps Updat7            ;#10 extension byte address

;----- #00 is known

Updat6 Test Ax,Bit3     ;test bit 3
 Jz Updat9              ;000 no addressing

;----- displacement address

 Inc Cx                 ;inc for one byte atleast
 Test Opsize,S16bit     ;check if one or two byte disp
 Jz Updis8              ;only one byte
 Inc Cx                 ;inc for second byte

Updis8 Add Loctr,Cx
 Add Counter_Num,Cx     ;byte counter
 Add Obj_Count,Cx       ;total byte count
 Ret

;----- extension byte and mode byte

Updat7 Inc Cx
 Mov Dx,Dtype
 Or Dx,Stype            ;combine source and destination types
 Test Dx,Addr           ;check if either is direct address
 Jz Updat2              ;jump if not

;----- direct memory reference

Updat11 Inc Cx
 Inc Cx
 Jmps Updat9

;----- possible offset

Updat2 Test Line_Stat,Off_Flag ;check if offset
 Jz Updat9              ;jump if not
 Test Line_Stat, Off_Cons ;check if constant
 Jz Udat216             ;jump if not, always 16 bit offset

 Cmp Off_Val,127        ;check if above 127
 Jg Udat216             ;jump if so
 Cmp Off_Val,-128       ;check if below 128
 Jl Udat216             ;jump if so

 Inc Cx                 ;one 8 bit offset
 Jmps Updat9

Udat216 Inc Cx
 Inc Cx                 ;16 bit offset

;----- immediate data

Updat9 Test Optype2,Typedata ;test for special data (port)
 Jnz Tydatup            ;jump if is

;----- destination data

 Test Dtype,Immed       ;is destination immed?
 Jz Updsi               ;jump if not
 Mov Ax,Dval            ;value
 Mov Dx,Dtype           ;type
 Call Updat_Immed       ;update CX

;----- source data

Updsi Test Stype,Immed  ;is source immed?
 Jz Updat10             ;jump if not
 Mov Ax,Sval            ;value
 Mov Dx,Stype           ;type
 Call Updat_Immed       ;update CX

Updat10 Add Loctr,Cx    ;update location counter
 Add Counter_Num,Cx     ;byte counter
 Add Obj_Count,Cx       ;total byte count
 Ret

;----- special type data (for port type)

Tydatup Mov Ax,Dtype
 Or Ax,Stype            ;combine source and destination types
 Test Ax,Immed          ;check if either is immediate data
 Jz Notdup              ;jump if not
 Inc Cx                 ;increment for one data byte

Notdup Add Loctr,Cx     ;update location counter
 Add Counter_Num,Cx     ;byte counter
 Add Obj_Count,Cx       ;total byte count
 Ret

;===============================================;
;                  Updat_Immed                  ;
; Update the location counter based on the      ;
; immediate data in AX and type in DX. CX is    ;
; incremented appropriately.                    ;
;===============================================;

Updat_Immed Proc Near
 Test Opsize,S8bit      ;check if 8 bit instruction
 Jnz Updat8             ;jump if so
 Test Dx,True_Const     ;check if true constant (stable)
 Jz Updat16             ;jump if so, no sign extend
 Test Optype2,Dataext   ;test for possible sign extend
 Jz Updat16             ;jump if not set, word data

 Cmp Ax,127             ;check if greater than 127
 Jg Updat16             ;jump if so, 16 bit
 Cmp Ax,-128            ;check if less than -128
 Jl Updat16             ;jump if so, 16 bit
 Jmps Updat8            ;8 bit sign extend data

;----- 16 bit data

Updat16 Inc Cx
 Inc Cx                 ;CX + 2
 Ret

;----- 8 bit data

Updat8 Inc Cx           ;CX + 1
 Ret
 Endp                   ;Updat_Immed

 Endp                   ;Update_Lct

;===============================================;
;                   Build_Obj                   ;
; Generate the object code for a particular     ;
; instruction.                                  ;
;===============================================;

Build_Obj Proc Near

;----- check if a wait should precede instruction

 Test Optype2,Addwait   ;test for wait
 Jz Bdobj1              ;jump if none
 Mov Al,Wait            ;load code
 Stosb                  ;store wait

;----- op-code

Bdobj1 Mov Ax,Opval     ;op code
 Or Ah,Ah               ;check if zero
 Jz Bdobj2              ;jump if so, one byte op-code

;----- two byte op-code

 Xchg Al,Ah             ;switch
 Stosw                  ;store
 Jmps Bdobj4

;----- one byte op-code

Bdobj2 Stosb            ;store byte

;----- save op-code location for op-code flags

Bdobj4 Mov Si,Di        ;save in SI
 Dec Si                 ;back up to beginning

;----- branch for addressing mode

 Mov Ax,Optype2
 Test Ax,Bit1           ;test bit 1
 Jz Bdobj6              ;##0 on jump
 Test Ax,Bit2           ;test bit 2
 Jz Bdobj5              ;#01 on jump
 Jmps Bdobj10           ;#11 mode byte address

;----- #01 is known

Bdobj5 Test Ax,Bit3     ;test bit 3
 Jz Bdobj8              ;001 reg field
 Jmps Bdobj12           ;101 direct address

;----- ##0 is known

Bdobj6 Test Ax,Bit2     ;test bit 2
 Jz Bdobj7              ;#00 on jump
 Jmps Bdobj9            ;#10 extension byte

;----- #00 is known

Bdobj7 Test Ax,Bit3     ;test bit 3
 Jz Bdobj13             ;000 no addressing
 Jmps Bdobj11           ;100 displacement

;----- register field

Bdobj8 Mov Al,Byte Dval ;register value
 Test Dtype,Seg         ;test if segment register
 Jnz Bdose              ;jump if is, don't shift it
 Shr Al
 Shr Al
 Shr Al                 ;shift so reg field is first three bits
Bdose Or [Si],Al        ;add it to op-code
 Jmps Bdobj13

;----- extension byte

Bdobj9 Call Build_Ext   ;build extension byte
 Jmps Bdobj13

;----- mode byte

Bdobj10 Call Build_Mode ;build mode byte
 Jmps Bdobj13

;----- displacement

Bdobj11 Mov Cx,Di       ;present location in OBJ_BUFFER
 Sub Cx,Obj_Buffer      ;number of bytes for present instruction
 Test Opsize,S8bit      ;see if 8 bit displacement
 Jz Bdobjd16            ;jump if not

 Inc Cx                 ;one more byte for displacement
 Call Build_Dis8        ;build 8 bit displacement
 Jmps Bdobj14

Bdobjd16 Inc Cx
 Inc Cx                 ;two more bytes for displacement
 Call Build_Dis16       ;build 16 bit displacement
 Jmps Bdobj14

;----- direct address

Bdobj12 Test Stype,Addr ;is source the address?
 Jz Bdsme               ;jump if not

 Mov Ax,Sval
 Stosw
 Jmps Bdobj13

Bdsme Mov Ax,Dval
 Stosw

;----- data

Bdobj13 Test Optype2,Typedata ;test for special immediate data (port)
 Jnz Tydat              ;jump if is

;----- destination data

 Test Dtype,Immed       ;is destination immediate?
 Jz Bdosi               ;skip to source if not
 Mov Ax,Dval            ;immediate value
 Mov Dx, Dtype          ;type
 Call Build_Immed       ;make it object code

;----- source data

Bdosi Test Stype,Immed  ;is source immediate?
 Jz Bdobj14             ;jump if not
 Mov Ax,Sval            ;immediate value
 Mov Dx, Stype          ;type
 Call Build_Immed       ;make it object code
 Jmps Bdobj14

;----- immediate source byte data (for port type)

Tydat Test Dtype,Immed  ;test if destination is data
 Jz Stydat              ;jump if not
 Mov Al,Byte Dval       ;value
 Stosb                  ;store it
 Jmps Bdobj14

Stydat Test Stype,Immed ;test if source is data
 Jz Bdobj14             ;jump if not
 Mov Al,Byte Sval       ;value
 Stosb                  ;store it

;----- object length

Bdobj14 Mov Cx,Di       ;present location in OBJ_BUFFER
 Sub Cx,Obj_Buffer      ;CX gets number of bytes
 Mov Obj_Length,Cx      ;store
 Add Loctr,Cx           ;update location counter
 Add Counter_Num,Cx     ;byte counter
 Add Obj_Count,Cx       ;total byte count
 Call Build_Op          ;set flags
 Call New_Chksum        ;evaluate checksum
 Ret

;===============================================;
;                  Build_Immed                  ;
; Build an immediate word or byte based on the  ;
; immediate data in AX and the type in DX.      ;
;===============================================;

Build_Immed Proc Near
 Test Opsize,S8bit      ;check size
 Jnz Build8             ;jump if byte size
 Test Dx,True_Const     ;check if true constant (stable)
 Jz Build16             ;jump if so, no sign extend

 Test Optype2,Dataext   ;test if sign extend
 Jz Build16             ;jump if not set, word data

 Cmp Ax,127             ;check if greater than 127
 Jg Build16             ;jump if so, 16 bit
 Cmp Ax,-128            ;check if less than -128
 Jl Build16             ;jump if so, 16 bit
 Or Opflag,Dataext      ;set sign extend flag
 Jmps Build8

;----- 16 bit data

Build16 Stosw           ;store word
 Ret

;----- eight bit data

Build8 Stosb            ;store byte
 Ret
 Endp                   ;Build_Immed

;===============================================;
;                   Build_Op                    ;
; Build the op-code for a particular            ;
; instruction. Sets all appropriate flags (if   ;
; any) in the  op-code. SI must have location   ;
; of the op-code.                               ;
;===============================================;

Build_Op Proc Near
 Mov Ax,Opflag          ;load any previously set flags
 Sub Dl,Dl              ;DL will hold bits to set op-code

;----- direction (d bit)

 Test Ax,Direction      ;test for direction
 Jz Bop1                ;jump if not set
 Or Dl,Dir_Flag         ;save bit to set

;----- variable immediate data size (w bit)

Bop1 Test Optype2,Varsize ;test instruction type for variable size
 Jz Bop4                ;jump if not set
 Test Opsize,S8bit      ;is data 8 bit?
 Jnz Bop4               ;jump if so, bit already zero
 Mov Bx,Optype2         ;get instruction type
 And Bx,Mask2           ;isolate addressing bits
 Cmp Bl,Regfield        ;check if register field addressing
 Jne Bop3               ;jump if not
 Or Dl,Sizer_Flag       ;reg. field var. size set
 Jmps Bop4
Bop3 Or Dl,Size_Flag    ;normal var. size set

;----- data extend (s bit)

Bop4 Test Opflag,Dataext ;test for data extend flag
 Jz Bop2                ;jump if not set
 Or Dl,Data_Flag        ;set bit

Bop2 Or [Si],Dl         ;set bits in op-code
 Ret
 Endp                   ;Build_Op

;===============================================;
;                   Build_Ext                   ;
; Build extension byte based on the operation   ;
; flag and the operand information. The code    ;
; is put at DI and the length is incremented.   ;
; Form: MOD xxx R/M, xxx bits are extracted     ;
; from the operation flag.                      ;
;===============================================;

Build_Ext Proc Near
 Push Sval
 Mov Ax,Optype2         ;op flag
 And Ax,Mask            ;extract bits 3-5
 Mov Sval,Ax            ;does not extend into upper byte
 Call Build_Mode        ;build mode byte
 Pop Sval
 Ret
 Endp                   ;Build_Ext

;===============================================;
;                  Build_Mode                   ;
; Build mode byte based on the operation flag   ;
; and the the operand information. The code is  ;
; put at DI and the length is incremented.      ;
; Form: MOD REG R/M.                            ;
;===============================================;

Build_Mode Proc Near
 Sub Dl,Dl              ;DL holds addressing mode byte

;----- check for direct addressing

 Test Dtype,Addr        ;check if destination is direct address
 Jnz Bmbdad             ;jump if is
 Test Stype,Addr        ;check if destination is direct address
 Jnz Bmbdas             ;jump if is

;----- normal addressing, check direction

 Test Opflag,Direction  ;test direction
 Jnz Bmomr              ;jump if reversed

;----- destination= MOD xxx R/M, source= xx REG xxx

 Mov Al,Byte Dval       ;destination value
 Test Dtype,Reg         ;test if destination is register
 Jz Bmorrm              ;jump if not
 Shr Al
 Shr Al
 Shr Al                 ;shift reg. bits to position
 Or Dl,Mod_Reg          ;make R/M a register
Bmorrm Or Dl,Al         ;put destination in
 Or Dl,Byte Sval        ;put source in
 Jmps Bmocho

;----- destination= xx REG xxx, source= MOD xxx R/M

Bmomr Mov Al,Byte Sval  ;source value
 Test Stype,Reg         ;test if source is register
 Jz Bmormr              ;jump if not
 Shr Al
 Shr Al
 Shr Al                 ;shift reg. bits to position
 Or Dl,Mod_Reg          ;make R/M a register
Bmormr Or Dl,Al         ;put source in
 Or Dl,Byte Dval        ;put destination in

Bmocho Mov Al,Dl
 Stosb                  ;store mode byte
 Test Line_Stat,Off_Flag ;check if offset
 Jnz Modboff            ;jump if offset needed
 Ret

;----- destination= 00 xxx 110 addr-low addr-high, source= xx REG xxx xx xx

Bmbdad Or Dl,Mod_Ref    ;set MOD and R/M
 Or Dl,Byte Sval        ;set REG field
 Mov Al,Dl
 Stosb                  ;store mode byte
 Mov Ax,Dval
 Stosw
 Ret

;----- destination= xx REG xxx xx xx, source= 00 xxx 110 addr-low addr-high

Bmbdas Or Dl,Mod_Ref    ;set MOD and R/M
 Or Dl,Byte Dval        ;set REG field
 Mov Al,Dl
 Stosb                  ;store mode byte
 Mov Ax,Sval
 Stosw
 Ret

;----- indirect addressing offset

Modboff Test Line_Stat, Off_Cons ;check if constant
 Jz Bmoff16             ;jump if not, always 16 bit offset

 Cmp Off_Val,127        ;check if above 127
 Jg Bmoff16             ;jump if so
 Cmp Off_Val,-128       ;check if below 128
 Jl Bmoff16             ;jump if so

;----- 8 bit offset

 Or Byte [Di-1],B_Disp  ;set MOD field
 Mov Ax,Off_Val         ;offset
 Stosb                  ;store displacement
 Ret

;----- 16 bit offset

Bmoff16 Or Byte [Di-1],W_Disp ;set MOD field
 Mov Ax,Off_Val         ;offset
 Stosw                  ;store displacement
 Ret
 Endp                   ;Build_Mode

;===============================================;
;                  Build_Dis8                   ;
; Build 8 bit displacement based on operand     ;
; information. CX must contain the length of    ;
; the present machine code to add to the        ;
; location counter. Put code at DI and          ;
; increment obj length.                         ;
;===============================================;

Build_Dis8 Proc Near
 Mov Ax,Dval            ;offset
 Sub Ax,Loctr           ;displacement
 Sub Ax,Cx              ;include disp for present instruction

;----- check if valid range

 Cmp Ax,127             ;how big
 Jg Bd8err              ;jump if too big
 Cmp Ax,-127            ;how small
 Jl Bd8err              ;jump if too small
 Stosb                  ;store it
 Ret

;----- out of range error

Bd8err Test Dtype,Undef ;check if destination undefined
 Jnz Bd8                ;jump if so
 Mov Bx,Ax              ;displacement
 Mov Ax,0833h           ;error 51
 Call Error             ;error routine
Bd8 Sub Al,Al           ;zero displacement
 Stosb                  ;store it
 Ret
 Endp                   ;Build_Dis8

;===============================================;
;                  Build_Dis16                  ;
; Build 16 bit displacement based on operand    ;
; information. CX must contain the length of    ;
; the present machine code to add to the        ;
; location counter. Put code at DI and          ;
; increment obj length.                         ;
;===============================================;

Build_Dis16 Proc Near
 Mov Ax,Dval            ;offset
 Sub Ax,Loctr           ;displacement
 Sub Ax,Cx              ;include disp for present instruction
 Cmp Op_Number,Jump     ;check if long jump
 Jne Bd16               ;jump if not JMP
 Test Opt_Stat,Jmp_Flag ;see if checking for possible short jump
 Jz  Bd16               ;jump if not

 Cmp Ax,-128            ;lower limit of short jump
 Jl Bd16                ;jump if less
 Cmp Ax,127             ;upper limit of short jump
 Jg Bd16                ;jump if greater

;----- -128 <= disp <= 127 long jump, could use short jump diagnostic

 Test Dtype,Undef       ;check if destination undefined
 Jnz Bd16               ;jump if so
 Push Ax
 Mov Bx,Ax              ;displacement
 Mov Ax,4832h           ;error 50
 Call Error             ;error routine
 Pop Ax

;----- store displacement

Bd16 Stosw              ;store it
 Ret
 Endp                   ;Build_Dis16

 Endp                   ;Build_Obj

;===============================================;
;                  New_Chksum                   ;
; Calculate new checksum. Expects CX to         ;
; contain the number of bytes of code.          ;
;===============================================;

New_Chksum Proc Near
 Or Cx, Cx              ;check if none
 Jz Newczero            ;jump if so

 Mov Si,Obj_Buffer      ;start of code
 Sub Al, Al             ;clear

Newchksl
 Add Al,[Si]            ;add next byte
 Inc Si                 ;advance pointer
 Loop Newchksl          ;loop for each byte

 Add Counter_Chk, Al    ;add in counter checksum
 Add Program_Chk, Al    ;add in program checksum

Newczero
 Ret
 Endp                   ;New_Chksum
