;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

 Jmp Begin

;===============================================;
;                    Equates                    ;
;===============================================;

;----- all purpose bit settings

Bit1 Equ 0000000000000001b
Bit2 Equ 0000000000000010b
Bit3 Equ 0000000000000100b
Bit4 Equ 0000000000001000b
Bit5 Equ 0000000000010000b
Bit6 Equ 0000000000100000b
Bit7 Equ 0000000001000000b
Bit8 Equ 0000000010000000b
Bit9 Equ 0000000100000000b
Bit10 Equ 0000001000000000b
Bit11 Equ 0000010000000000b
Bit12 Equ 0000100000000000b
Bit13 Equ 0001000000000000b
Bit14 Equ 0010000000000000b
Bit15 Equ 0100000000000000b
Bit16 Equ 1000000000000000b

False Equ 0             ;false flag
True Equ -1             ;true flag

;----- operand types

None Equ Bit1           ;no operand
Reg Equ Bit2            ;normal register
Acum Equ Bit3           ;acumulator
Seg Equ Bit4            ;segment register
Mem Equ Bit5            ;indirect memory reference
Immed Equ Bit6          ;immediate data
String Equ Bit7         ;string
Neart Equ Bit8          ;NEAR
Fart Equ Bit9           ;FAR
Addr Equ Bit10          ;direct memory reference
Stack Equ Bit11         ;8087 stack, ST i
Stacktop Equ Bit12      ;8087 stack top, ST (= ST 0)
Signed Equ Bit13        ;signed operand
Undef Equ Bit14         ;undefined symbol
Defined_Sym Equ Bit15   ;symbol has been defined
True_Const Equ Bit16    ;a literal number

;----- symbol bits, bits 6, 8 to 10, and 13 to 16 are used as operand types

Dupdef Equ Bit1         ;duplicate definition
Badsym Equ Bit2         ;invalid character in symbol
Spec_Sym Equ Bit3       ;special symbol, do not reset loc on pass one
Mlabel Equ Bit4         ;symbol inside of a macro
Used_Sym Equ Bit5       ;symbol has been accessed
Marg Equ Bit7           ;macro parameter
Macrot Equ Bit11        ;symbol is macro, cleared at oprnd lookup level
Cfalse_Sym Equ Bit12    ;symbol within false conditional code

Cond_Mac Equ Bit5       ;conditional (hidden) macro, valid if MACROT set

;----- symbol bits to clear when returning symbol operand type, MACROTC 
;----- is tested for separately

Non_Sym_A Equ Dupdef Or Badsym Or Spec_Sym Or Mlabel
Non_Sym_B Equ Defined_Sym Or Marg Or Cfalse_Sym Or Used_Sym

Non_Sym Equ Non_Sym_A Or Non_Sym_B ;total bits to clear

;---- operand sizes (lower byte of size word), used in DSIZE and SSIZE

S8bit Equ Bit1          ;byte
S16bit Equ Bit2         ;word
S32bit Equ Bit3         ;double word
S64bit Equ Bit4         ;quadruple word
S80bit Equ Bit5         ;size for BCD and temporary real
Allsize Equ 00ffh       ;any size

;----- special size flags (upper byte of size word), used in OPSIZE

Dmatch Equ Bit9         ;auto destination size match
Smatch Equ Bit10        ;auto source size match
Des_Sdef Equ Bit11      ;size defined by destination
Sou_Sdef Equ Bit12      ;size defined by source

;----- pre-process flag set, OPTYPE1 bits 1 to 4

Reset Equ 000fh         ;mask for flag reset bits (bits 1 to 4)

;----- pre-process flags, OPTYPE1 bits 5 to 12

Spec_Assm Equ Bit5      ;execute a special assembly
Cond_Inst Equ Bit6      ;conditional instruction
Start_Cmac Equ Bit7     ;start of conditional macro, set when invoked

;----- special instruction bit patterns/256, OPTYPE1 bits 13 to 16, these bits
;----- are masked out of the upper byte of OPTYPE1 and placed in OP_NUMBER

Def_Inum Equ 0*16       ;non-special instructions (implicit)
Equate Equ 1*16         ;EQU
Return Equ 2*16         ;RET
Jump Equ 3*16           ;JMP
Proc Equ 4*16           ;PROC
Endp Equ 5*16           ;Endp
Endm Equ 6*16           ;ENDM
Macro Equ 7*16          ;MACRO
Onum_Mask Equ 0f0h      ;mask to extract bits

;----- addressing modes, OPTYPE2 bits 1 to 3

;Noadd Equ 000b         ;no addressing
Regfield Equ 001b       ;register field
;Extbyte Equ 010b       ;extension byte (MOD xxx R/M)
;Modebyte Equ 011b      ;mode byte (MOD REG R/M)
;Disp Equ 100b          ;displacement
;Daddr Equ 101b         ;direct address

Mask2 Equ 111b          ;used to get addressing bits of OPTYPE2

Mask Equ 00111000b      ;used to get bits 4-6 of OPTYPE2, extension addr

;----- operation flags, OPTYPE2 bits 7 to 16

Chksize Equ Bit7        ;check operand size
Pseuop Equ Bit8         ;pseudo-op
Addwait Equ Bit9        ;add a wait before instruction
Direction Equ Bit10     ;direction (d)
Varsize Equ Bit11       ;variable operand size (w)
Dataext Equ Bit12       ;data extend (s)
Rev_Ops Equ Bit13       ;reverse operands
Typedata Equ Bit14      ;special byte data (port or 186/286 shift)
Loc_Sup Equ Bit15       ;suppress LOC display in list if no label

;----- opcode settings

Size_Flag Equ 00000001b ;word/byte operation flag
Sizer_Flag Equ 00001000b ;word/byte operation flag if reg
Dir_Flag Equ 00000010b  ;direction flag
Data_Flag Equ 00000010b ;data extend flag
Mod_Reg Equ 11000000b   ;r/m = reg setting
Mod_Ref Equ 00000110b   ;mod..r/m = direct address setting
B_Disp Equ 01000000b    ;8 bit displacement for mod..r/m
W_Disp Equ 10000000b    ;16 bit displacement for mod..r/m

;----- miscellaneous constants

Std_Device Equ 1        ;standard redirectable output device 
Prn_Device Equ 4        ;standard printer device

Wait Equ 9bh            ;an encoded WAIT (for coprocessor)
Spc_Mark Equ 0          ;macro storage control mask
Size_Loc Equ 2          ;free memory (next allocatable segment)
Nul_Cod Equ 0fffeh      ;nul mnemonic (in code table)
Undef_Cod Equ 0ffffh    ;undefined mnemonic (in code table)

Line_Feed Equ 10        ;line feed
C_Return Equ 13         ;carriage return
Line_Mark Equ 0a0dh     ;line marker, LF & CR
Page_Mark Equ 12        ;page marker
File_Mark Equ 26        ;end of file marker, ^Z
Str_Delim Equ 39        ;string delimiter (single quote)
Com_Delim Equ ';'       ;comment delimiter
Const_Mark Equ '$'      ;constant identifier

;----- execution parameters

String_Siz Equ 160      ;max line length (more or less)
Max_Mnest Equ 10        ;maximum macro nest level
Max_Mpara Equ 10        ;maximum macro parameters
Max_Plev Equ 10         ;maximum (more or less) parenthesis nest level
Max_Proc Equ 10         ;maximum PROC nesting
Def_Offset Equ 100h     ;default beginning offset
Def_Emax Equ 0ffffh     ;default maximum errors
Max_Sdispl Equ 10       ;max displayed characters for symbols in sym tab

And_Op Equ 'A'          ;operator to substitute for AND
Or_Op Equ 'O'           ;operator to substitute for OR
Xor_Op Equ 'X'          ;operator to substitute for XOR
Inc_Char Equ '-'        ;character used to indicate an include
Mac_Char Equ '+'        ;character used to indicate a macro

Def_Width Equ 79        ;default output width
Min_Width Equ 50        ;minimum width, >= [Loc..Src.] + [Was.]= 45
Max_Width Equ String_Siz - 2 ;maximum width, <= [max storage] + CR + LF

Def_Page Equ 60         ;default page size
Min_Page Equ 15         ;minimum page size, >= TOP_LINES + 7
Max_Page Equ 255        ;maximum page size, biggest byte value
Top_Lines Equ 1         ;blank lines at top of (console) pages

Asym_Len Equ 10         ;standard sym length, used to calc. table size
Max_Sym Equ 2000        ;standard number of symbols
Max_Instr Equ 10800     ;max allowed instructions (source lines, no macros)
Macro_Size Equ 0ffffh   ;max macro storage size (reduced if unavailable)
Read_Size Equ 4096      ;source input buffer size
Write_Size Equ 512      ;object code and list output buffer size

Pth_Size Equ 60         ;max path length
Nam_Size Equ 8          ;max namelength
Ext_Size Equ 3          ;max extension length
Name_Size Equ Pth_Size+Nam_Size+1+Ext_Size ;max characters for name

;----- error codes returned by program

Suc_Err_Code Equ 0      ;successful assembly (no errors or comments)
Com_Err_Code Equ 1      ;successful assembly with comment(s)
Err_Err_Code Equ 2      ;successful assembly with error(s)
Crt_Err_Code Equ 3      ;critical error
Sta_Err_Code Equ 3      ;program ID display, no assembly
Mem_Err_Code Equ 4      ;insufficient memory for execution
Chk_Err_Code Equ 4      ;checksum error

;----- stack, size is 300H for WASM and 80H for function calls

Stack_Size Equ 300h + 80h ;bytes allowed for stack

;===============================================;
;                  Program Data                 ;
;===============================================; 

;----- general information

Pass Db 0               ;pass
Loctr Dw 0              ;location counter
Lostor Dw ?             ;location counter storage for list
Endloc Dw ?             ;last location of last pass
Phase_Off Dw 0          ;phase offset

;----- destination storage

Dval Dw ?               ;value
Dsize Dw ?              ;size
Dtype Dw ?              ;destination type

;----- source storage

Sval Dw ?               ;value
Ssize Dw ?              ;size
Stype Dw ?              ;source type

;----- operand status

Mem_Flag Equ Bit1       ;memory operand flag
Oprnd_End Equ Bit2      ;end of operand flag
Nest_Err Equ Bit3       ;parenthesis nested too deep

Reset_Oprnd Equ 0       ;initialize bits

Oprnd_Stat Db ?         ;operand flags

;----- memory operands

Off_Val Dw ?            ;offset value for mode byte
Mem_Store Db ?          ;storage for addressing operator (MEM_LOOK)

;----- general operand data

Pres_Si Db ?            ;present sign
Pres_Op Db ?            ;present operator
Para_Lev Dw ?           ;present parenthesis level
Oprnd_Flg Dw ?          ;parenthesis flag (to check for nest errors)
Oprnd_Lev Dw ?          ;present parenthesis nest level
Oprnd_Max Dw Max_Plev+2 ;max nest level (is max parenthesis level + 2)
Oprnd_Poi Dw ?          ;table pointer
Oprnd_Tab Dw ?          ;table location (must be init)

;----- symbol table

Sym_Num Dw 0            ;number of symbols
Sym_Point Dw 0          ;table pointer, new entry
Osym_Point Dw 0         ;table pointer, old entry
Last_Sym Dw 0           ;start of last symbol into table
Last_Dat Dw 0           ;start of last symbol data into table
Sym_Entry Equ String_Siz+7 ;maximum single entry size
Sym_Size Dw ?           ;max symbol table size
Sym_Seg Dw ?            ;symbol table segment

;----- code table

Cod_Num Dw 0            ;number of stored instructions
Cod_Point Dw 0          ;table pointer
Cod_Seg Dw ?            ;table segment

;----- operation storage

Opval Dw ?              ;op-code
Opsize Dw ?             ;instruction size
Optype1 Dw ?            ;pre-instruction flags, from OPTABLE1
Optype2 Dw ?            ;instruction flags, from data table
Opflag Dw ?             ;operation flags
Op_Loc Dw ?             ;location of identified mneumonic
Op_Number Db ?          ;instruction number
Oprnd_Num Db ?          ;number of instruction variations

;----- PROC stack

Stack_Base Dw ?         ;stack base
Stack_Top Db ?          ;stack top

;----- line assembly status

Label_Flag Equ Bit1     ;label flag
Bad_Opsize Equ Bit2     ;flag for operation size mismatch (CODE_LOOK)
Loc_Flag Equ Bit3       ;display LOC when listing line
Err_Flag Equ Bit4       ;set if error has occured
Mac_Line Equ Bit5       ;macro line flag
Inc_Line Equ Bit6       ;include line flag
Off_Flag Equ Bit7       ;memory offset needed
Off_Cons Equ Bit8       ;memory offset is true constant value

Reset_Line Equ 0        ;initialize bit pattern

Line_Stat Db ?          ;line status

;----- misc storage

Tempbuff Dw ?           ;general storage (for just about everything)
Str_Buff Dw ?           ;string operand
Num_Buff Dw ?           ;number string
Date_Buff Dw ?          ;date/time string
Mac_Buff Dw ?           ;macro parameter storage
Fe_Start Dw ?           ;start of field or expression (for error disp)
Fe_Stop Dw ?            ;end of field or expression (for error display)

Def_Pth Dw ?            ;path
Def_Nam Dw ?            ;name
Def_Ext Dw ?            ;extension
Name_Buff Dw ?          ;general file name (for display)

;----- macro status

Mac_Def Equ Bit1        ;macro presently being defined
Mac_Flag Equ Bit2       ;macro presently in progress

Mac_Stat Db ?           ;macro status

;----- macro table

Mac_Number1 Dw 0        ;macro definition number
Mac_Number2 Dw 0        ;present expansion number
Mac_Number3 Dw 0        ;macro expansion number

Mac_Entry Equ String_Siz+2 ;maximum single entry (line) size
Mac_Point Dw 0          ;location of macro data being written
Mac_Loc Dw ?            ;location of macro in progress
Mac_End Dw ?            ;end of present macro
Mac_Size Dw ?           ;max macro table size
Mac_Seg Dw ?            ;macro table segment

Macro_Sta Dw ?          ;start of macro data
Macro_Num Dw ?          ;macro definition number

;----- macro stack data

Nmac_Num Dw 0           ;present nest level
Nmac_Max Dw Max_Mnest   ;maximum nest level
Nmac_Loc Dw ?           ;macro stack pointer

;----- macro operand data

Mlin_Rem Dw ?           ;line pointer to check for parameters
Omac_Num Dw 0           ;number of defined parameters
Omac_Max Dw Max_Mpara   ;max passed parameters
Omac_Loc Dw ?           ;paramater area pointer
Omac_Table Dw ?         ;present parameter table

;----- conditional assembly data

Ifnum Dw ?              ;number of nested IF statements
Ifmax Dw 10             ;maximum number of nested IF statements
Iftab Dw ?              ;location of IF nest table

If_None Equ 0           ;not in an IF structure
If_True Equ 1           ;true IF
If_False Equ 2          ;false IF
If_Skip Equ 3           ;a false IF within a false IF

If_Stat Db ?            ;present IF status

;----- general assembly status

Com_Exist Equ Bit1      ;comment occurred
Err_Exist Equ bit2      ;error occurred

Asm_Stat Db 0           ;initial status

;----- general i/o status

Src_Open Equ Bit1       ;source file open
Lst_Open Equ Bit2       ;list file open
Lst_Data Equ Bit3       ;list buffer in use
Obj_Open Equ Bit5       ;object file open
Obj_Data Equ Bit6       ;object buffer in use
Disk_Full Equ Bit7      ;disk is full (no flush)

Io_Stat Db 0            ;no bits initially set

;----- input status

Src_First Equ Bit1      ;first file read
Src_Whole Equ Bit2      ;entire file read into single buffer
Src_Flag Equ Bit3       ;all of source file has been read
Inc_Flag Equ Bit4       ;include flag
Fil_Done Equ Bit5       ;done with file but line returned

Input_Stat Db Src_First ;initial input status

;----- line info

Line_Num Dw ?           ;line number
Line_Tot Dw 0           ;total lines processed

Line Dw ?               ;line buffer pointer
Line_Size Dw ?          ;length of line
Line_Rem Dw ?           ;remaining line
Line_Point Dw ?         ;line pointer

;----- input

Src_Size Dw ?           ;source line length
Src_Point Dw ?          ;source buffer pointer
Src_Seg Dw ?            ;source read segement
Src_End Dw ?            ;end of source buffer

Src_Handle Dw ?         ;source handle
Src_Name Dw ?           ;source file name

;----- include

Inctor Dw ?             ;include storage location
Inc_Seg Dw ?            ;include read segement
Inc_Name Dw ?           ;include file name

;----- code output

Obj_Buffer Dw ?         ;object buffer location
Obj_Length Dw ?         ;present line object length
Obj_Outlen Dw 0         ;object output length
Obj_Seg Dw ?            ;object write segment

Obj_Handle Dw ?         ;object handle
Obj_Name Dw ?           ;object file name

Counter_Num Dw ?        ;byte counter
Counter_Chk Db ?        ;byte counter checksum
Obj_Count Dw ?          ;object code counter
Obj_Total Dw ?          ;total bytes of object code
Program_Chk Db ?        ;program checksum

;----- options

Jmp_Flag Equ Bit1       ;flag possible short jumps
Symtab_Flag Equ Bit2    ;symbol table dump
Used_Flag Equ Bit3      ;display unused symbols
All_Undef Equ Bit4      ;flag all occurences of an undefined symbol
List_Flag Equ Bit5      ;assembly listing
Page_Flag Equ Bit6      ;paging flag
Exp_Flag Equ Bit7       ;macro expansion flag

Inc_Preserve Equ List_Flag ;bits to save through include
Mac_Preserve Equ Exp_Flag ;bits to save through macro

Opt_Stat Db Exp_flag    ;initial options set

;----- more options

Break_Flag Equ Bit1     ;set break upon execution
Check_Flag Equ Bit2     ;check checksum during startup

Opt_Stat2 Db Break_Flag Or Check_Flag ;initial options set

;----- special listing status

First_Head Equ Bit1     ;first header, set false after first header
Head_Line Equ Bit2      ;header in progress
Opt_Line6 Equ Bit3      ;optional line, suppressed if first line of page
Last_Line Equ Bit4      ;last list line, suppresses final CR + LF

List_Stat Db First_head ;listing status

;----- general list output

Width Db Def_Width      ;listing width
Lst_Buffer Dw ?         ;list buffer location
Lst_Outlen Dw ?         ;list output length
Lst_Seg Dw ?            ;list write segment

Lst_Handle Dw ?         ;list handle
Lst_Name Dw ?           ;list file name

Clear Equ 0             ;normal line
Show Equ 1              ;display line
Hide Equ 2              ;hidden line

Prt_Flag Db Clear       ;special print status

;----- listing type (device)

Nul_File Equ 0          ;nul
Con_File Equ 1          ;console (screen)
Prn_File Equ 2          ;printer
Alt_File Equ 0ffh       ;normal file
List_Type Db ?          ;list type

;----- paging information

Page_Line Db 0          ;line within page
Page_Num Dw 1           ;page number
Page_Size Db Def_Page   ;page size

;----- page header

Head_Buff Dw ?          ;line storage for the header
Title_Buff Dw ?         ;title storage location
Subt_Buff Dw ?          ;subtitle storage location

Norm_Head Equ 0         ;normal list header
Bra_Head Equ 1          ;branch header
Mem_Head Equ 2          ;memory reference header
Equ_Head Equ 3          ;immediate data header
Mac_Head Equ 4          ;macro header
Und_Head Equ 5          ;undefined symbol header
Head_Type Db Norm_Head  ;type of list header

;----- error info

Flag_Num Dw 0           ;number errors and comments (combined) detected
Error_Num Dw 0          ;number errors detected
Error_Max Dw Def_Emax   ;maximum number of errors
Error_Tabl Dw ?         ;error table location

;----- storage for original interrupt 0 vector

Int0_Off Dw ?           ;offset
Int0_Seg Dw ?           ;segment

;----- storage for original break state

Break_State Db ?        ;break state

;----- nul string, for passing to error routine if string not known

Nul_Str Db 0            ;nul

;----- patch area

  Db 'PATCH***************************'
  Db '********************************'
  Db '***************************PATCH'

;===============================================;
;              Macro Definitions                ;
;===============================================;

;===============================================;
;                   Copy_Str                    ;
; Move full string at DS:SI to ES:DI.           ;
;===============================================;

Copy_Str Macro
 Mov Cl,[Si]            ;length
 Sub Ch,Ch
 Inc Cx                 ;include length byte
 Rep
 Movsb                  ;move string
 Endm

;===============================================;
;                    Store_Str                  ;
; Move string at DS:SI to ES:DI. The length     ;
; byte at source is not moved.                  ;
;===============================================;

Store_Str Macro
 Mov Cl,[Si]            ;length
 Sub Ch,Ch
 Inc Si
 Rep
 Movsb                  ;move string
 Endm

;===============================================;
;                   Comp_Str                    ;
; Compares the string at SI to the string at    ;
; DI. Each location must have a length as the   ;
; first byte. The ZF=1 if equal.                ;
;===============================================;

Comp_Str Macro
 Mov Cl,[Si]            ;length
 Cmp Cl,[Di]            ;compare sizes
 Jne A
 Sub Ch,Ch              ;clear high byte of size
 Inc Di                 ;skip length
 Inc Si                 ;ditto
 Repe
 Cmpsb                  ;compare the two strings
A
 Endm

;===============================================;
;                   Char_Lower                  ;
; Convert character in CHAR to lower-case. CHAR ;
; must be a register or memory.                 ;
;===============================================;

Char_Lower Macro Char
 Cmp Char,'A'           ;lower limit
 Jb A
 Cmp Char,'Z'           ;upper limit
 Ja A
 Add Char,'a'-'A'       ;make lower
A
 Endm

;===============================================;
;                   Char_Upper                  ;
; Convert character in CHAR to upper-case. CHAR ;
; must be a register or memory.                 ;
;===============================================;

Char_Upper Macro Char
 Cmp Char,'a'           ;lower limit
 Jb A
 Cmp Char,'z'           ;upper limit
 Ja A
 Sub Char,'a'-'A'       ;make upper
A
 Endm

;===============================================;
;                   Store_Spc                   ;
;Store to DI the number of spaces in CL.        ;
;===============================================;

Store_Spc Macro
 Mov Al,' '             ;space
 Sub Ch,Ch              ;CX has number of spaces
 Rep
 Stosb                  ;store
 Endm

;===============================================;
;                Dos_Function                   ;
; Execute DOS function call number with a       ;
; subfunction. FUNCTION and SUBFUNCTION must be ;
; a register, memory, or immediate data.        ;
;===============================================;

Dos_Function Macro Function, Subfunction
 Mov Ah, Function       ;set function number
 Ifn Type(Subfunction) = Type()
  Mov Al, Subfunction    ;set subfunction
 Endif
 Int 21h                ;execute
 Endm

;===============================================;
;                  Main Program                 ;
;===============================================;

;----- initialization

Begin
 Call Initialize        ;initialize
 Call Start             ;opening messages and input

;----- create symbol table

 Call Pass_Zero         ;symbol table read

;----- pass one

 Mov Pass,1             ;set to pass one
 Call Pass_Main         ;process file

;----- pass two

 Mov Osym_Point,0       ;reset symbol table pointer
 Mov Ax,Obj_Count
 Mov Obj_Total,Ax       ;save bytes counted
 Mov Pass,2             ;set to pass two

 Test Opt_Stat,List_Flag ;check if list
 Jz Nohead              ;skip header if no list
 Call Header            ;output header

Nohead Call Pass_Main   ;process file

;----- all done, exit with appropriate error code

 Call Finish            ;final routine
 Test Asm_Stat, Err_Exist ;test for errors
 Jnz Errfinish
 Test Asm_Stat, Com_Exist ;test for comments
 Jnz Comfinish

 Dos_Function 4ch, Suc_Err_Code ;terminate without errors or comments
Errfinish
 Dos_Function 4ch, Err_Err_Code ;terminate with normal error
Comfinish
 Dos_Function 4ch, Com_Err_Code ;terminate with comments

