/************************************************************************
 CRC Generator

 This routine updates a CRC value by one byte.  The machine code (i.e.
 the arguments for __emit__) was created from the file CRC_TC.ASM.  To
 use this routine, first compile this file and link the resulting OBJ
 file with with the program using crc16.  A routine to generate an 
 xmodem CRC value for a sequence of bytes could be written as:

    unsigned crc_of_block (char block[], unsigned blocksize)
    {
      unsigned i, crcval = 0;
      for (i = 0; i < blocksize; i++)
        crc16 (&crcval, block[i]);
      crc16 (&crcval, 0);
      crc16 (&crcval, 0);
      return crcval;
    }
************************************************************************/

#include <dos.h>
#include "crc.h"

#pragma warn -par
void far crc16 (unsigned int far *crc, char data)
{
  __emit__ (
    0x1E,0x8A,0x46,0x0A,0xC5,0x5E,0x06,0x8B,0x17,0xB9,
    0x08,0x00,0xD0,0xE0,0xD1,0xD2,0x73,0x04,0x81,0xF2,
    0x21,0x10,0xE2,0xF4,0x89,0x17,0x1F
  );
}
#pragma warn .par
