;***************************************;
; WASM Video Module, Attribute Routines ;
; By Eric Tauck                         ;
;                                       ;
; Defines:                              ;
;                                       ;
;   AtrSet  set the current attribute   ;
;   AtrGet  get the current attribute   ;
;   AtrFor  set the current foreground  ;
;   AtrBac  set the current background  ;
;                                       ;
; Requires:                             ;
;                                       ;
;   VIDEO1.ASM                          ;
;***************************************;

        jmps    _video3_end

;========================================
; Global constants.

;--- text attributes

BLACK           EQU     0
BLUE            EQU     1
GREEN           EQU     2
CYAN            EQU     3
RED             EQU     4
MAGENTA         EQU     5
BROWN           EQU     6
WHITE           EQU     7
BOLD            EQU     8
BLINK           EQU     128

;========================================
; Set the current attribute.
;
; In: AL= attribute.
;
; Out: AL= old attribute.

AtrSet  PROC    NEAR
        xchg    al, _vid_attr   ;exchange attributes
        ret
        ENDP

;========================================
; Return the current attribute.
;
; Out: AL= attribute.

AtrGet  PROC    NEAR
        mov     al, _vid_attr   ;return attribute
        ret
        ENDP

;========================================
; Set the foreground color.
;
; In: AL= color (attribute).

AtrFor  PROC    NEAR
        and     al, 8FH         ;mask foreground bits
        and     _vid_attr, 70H  ;mask background bits
        or      _vid_attr, al   ;set foreground color
        ret
        ENDP

;========================================
; Set the background color.
;
; In: AL= color (attribute).

AtrBac  PROC    NEAR
        mov     cl, 4           ;bits to shift
        shl     al, cl          ;shift color to background bits
        and     al, 70H         ;mask background color
        and     _vid_attr, 8FH  ;mask foreground color
        or      _vid_attr, al   ;set background color
        ret
        ENDP

_video3_end
