;***********************************;
; WASM String Right Justify         ;
; By Eric Tauck                     ;
;                                   ;
; Defines:                          ;
;                                   ;
;   StrJusR  right justify a string ;
;                                   ;
; Requires:                         ;
;                                   ;
;    STRING.ASM                     ;
;***********************************;

        jmps    _justify1_end

;========================================
; Right justify a string.
;
; In: AX= string; CX= final length of
;     string; DL= pad character.

StrJusR PROC    NEAR
        push    di
        push    si

        push    cx
        push    dx
        mov     si, ax
        call    StrLen          ;get length
        pop     dx
        pop     cx
        sub     cx, ax          ;characters to pad
        jbe     _stjur1         ;exit if no padding

        push    cx
        add     si, ax          ;point to last byte
        mov     di, si
        add     di, cx          ;new end of string
        mov     cx, ax
        inc     cx              ;include NUL
        std
        rep
        movsb                   ;shift string
        pop     cx

        mov     al, dl
        rep
        stosb                   ;store padding

_stjur1 pop     si
        pop     di
        ret
        ENDP

_justify1_end
